DECLARE SUB Sierpinski ()
DECLARE SUB GenFrac ()
DECLARE SUB SizeGrid ()
DECLARE SUB SelectPoint ()
DECLARE SUB Load ()
SCREEN 12
VIEW PRINT
CLS
LOCATE 5, 38, 0
PRINT "The"
LOCATE 15, 40
PRINT "ractalizer"
LOCATE 20, 25
PRINT "(Press any key to continue.)"
DATA 115,195,115,226,115,257,115,288,146,195
DATA 177,195,177,226,177,257,208,195,239,195
DIM CX(1 TO 10), CY(1 TO 10)
FOR X = 1 TO 10
READ CY(X), CX(X)
NEXT X
SY = 115
SX = 195
DO
PSET (SX, SY)
RANDOMIZE TIMER
X = INT(RND * 10) + 1
SX = (SX + 4 * CX(X)) / 5
SY = (SY + 4 * CY(X)) / 5
LOOP WHILE INKEY$ = ""
DIM SHARED CornerArray(1 TO 10, 1 TO 10) AS INTEGER
DIM SHARED ArrayLim
ArrayLim = 3
CLS
' columns 62-80 for text
' 71 is middle column
LINE (480, 0)-(480, 479)
COLOR 7
LOCATE 1, 66
PRINT "Main Menu"
LOCATE 3, 64
PRINT "Generate Fractal"
LOCATE 4, 65
PRINT "Set Grid Size"
LOCATE 5, 65
PRINT "Select Points"
LOCATE 6, 65
PRINT "Load Fractal"
LOCATE 7, 70
PRINT "Quit"
Spot = 1
LOCATE Spot + 2, 62
COLOR 4
FOR X = 1 TO 19
PRINT CHR$(SCREEN(CSRLIN, POS(1)));
NEXT X
DO
KB$ = INKEY$
SELECT CASE KB$
CASE CHR$(0) + "H"
     LOCATE Spot + 2, 62
     COLOR 7
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
     Spot = Spot - 1
     IF Spot = 0 THEN Spot = 5
     LOCATE Spot + 2, 62
     COLOR 4
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
CASE CHR$(0) + "P"
     LOCATE Spot + 2, 62
     COLOR 7
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
     Spot = Spot + 1
     IF Spot = 6 THEN Spot = 1
     LOCATE Spot + 2, 62
     COLOR 4
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
CASE CHR$(13)
     SELECT CASE Spot
     CASE 1: GenFrac
     CASE 2: SizeGrid
     CASE 3: SelectPoint
     CASE 4: Load
     CASE 5: CLS : COLOR 7: END
     END SELECT
END SELECT
LOOP
Cross: DATA 0,1,0,1,1,1,0,1,0
Carpet: DATA 1,1,1,1,0,1,1,1,1
Fringe: DATA 1,1,1,1,1,1,0,1,0
Building: DATA 1,1,1,1,1,1,1,0,1
Arch: DATA 1,1,1,1,0,1,1,0,1
Smile: DATA 0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0
Heart: DATA 0,1,0,1,0,1,0,1,0,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,0
Hat: DATA 0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0

SUB GenFrac
COLOR 7
LOCATE 14, 65
PRINT "Press any key"
LOCATE 15, 68
PRINT "to stop."
Z = 0
FOR X = 1 TO ArrayLim
FOR Y = 1 TO ArrayLim
IF CornerArray(X, Y) = 1 THEN Z = Z + 1
NEXT Y
NEXT X
IF Z = 0 THEN
     LOCATE 14, 62
     PRINT SPACE$(19)
     LOCATE 13, 66
     PRINT "There is no"
     LOCATE 14, 69
     PRINT "fractal"
     LOCATE 15, 66
     PRINT "to generate."
     LOCATE 16, 65
     PRINT "Press any key"
     LOCATE 17, 68
     PRINT "to exit."
     DO: LOOP WHILE INKEY$ = ""
     FOR X = 13 TO 17
     LOCATE X, 62
     PRINT SPACE$(19)
     NEXT X
     EXIT SUB
END IF
DIM CornerX(1 TO Z)
DIM CornerY(1 TO Z)
DIM CornerC(1 TO Z)
Z = 1
W = 1
FOR X = 1 TO ArrayLim
FOR Y = 1 TO ArrayLim
IF CornerArray(X, Y) = 1 THEN
     CornerX(Z) = (480 / (ArrayLim - 1)) * (X - 1)
     IF CornerX(Z) = 480 THEN CornerX(Z) = 479
     CornerY(Z) = (480 / (ArrayLim - 1)) * (Y - 1)
     IF CornerY(Z) = 480 THEN CornerY(Z) = 479
     CornerC(Z) = W
     W = W + 1
     IF W = 14 THEN W = 1
     Z = Z + 1
END IF
NEXT Y
NEXT X
FOR X = 1 TO UBOUND(CornerX)
PSET (CornerY(X), CornerX(X)), 15
NEXT X
RANDOMIZE TIMER
StarterX = INT(RND * 480)
StarterY = INT(RND * 480)
StarterC = 14
DO
PSET (StarterY, StarterX), StarterC
RANDOMIZE TIMER
Z = INT(RND * UBOUND(CornerX)) + 1
StarterX = (StarterX + (ArrayLim - 1) * CornerX(Z)) / ArrayLim
StarterY = (StarterY + (ArrayLim - 1) * CornerY(Z)) / ArrayLim
StarterC = CornerC(Z)
LOOP WHILE INKEY$ = ""
LINE (0, 0)-(479, 479), 0, BF
FOR X = 14 TO 15
LOCATE X, 62
PRINT SPACE$(19)
NEXT X
END SUB

SUB Load
COLOR 7
LOCATE 13, 62
PRINT "Sierpinski Triangle"
LOCATE 14, 65
PRINT "Fractal Cross"
LOCATE 15, 65
PRINT "Fractal Carpet"
LOCATE 16, 65
PRINT "Fractal Fringe"
LOCATE 17, 64
PRINT "Fractal Building"
LOCATE 18, 66
PRINT "Fractal Arch"
LOCATE 19, 64
PRINT "Kopczenski Smile"
LOCATE 20, 64
PRINT "Kopczenski Heart"
LOCATE 21, 66
PRINT "Stickman Hat"
Spt = 1
LOCATE Spt + 12, 62
COLOR 4
FOR X = 1 TO 19
PRINT CHR$(SCREEN(CSRLIN, POS(1)));
NEXT X
DO
     KB$ = INKEY$
     SELECT CASE KB$
     CASE CHR$(0) + "P"
	  COLOR 7
	  LOCATE Spt + 12, 62
	  FOR X = 1 TO 19
	  PRINT CHR$(SCREEN(CSRLIN, POS(1)));
	  NEXT X
	  Spt = Spt + 1
	  IF Spt = 10 THEN Spt = 1
	  COLOR 4
	  LOCATE Spt + 12, 62
	  FOR X = 1 TO 19
	  PRINT CHR$(SCREEN(CSRLIN, POS(1)));
	  NEXT X
     CASE CHR$(0) + "H"
	  COLOR 7
	  LOCATE Spt + 12, 62
	  FOR X = 1 TO 19
	  PRINT CHR$(SCREEN(CSRLIN, POS(1)));
	  NEXT X
	  Spt = Spt - 1
	  IF Spt = 0 THEN Spt = 9
	  COLOR 4
	  LOCATE Spt + 12, 62
	  FOR X = 1 TO 19
	  PRINT CHR$(SCREEN(CSRLIN, POS(1)));
	  NEXT X
     CASE CHR$(13)
	  SELECT CASE Spt
	  CASE 1: Sierpinski: EXIT SUB
	  CASE 2: ArrayLim = 3
	       RESTORE Cross
	       GOTO FinishIt
	  CASE 3: ArrayLim = 3
	       RESTORE Carpet
	       GOTO FinishIt
	  CASE 4: ArrayLim = 3
	       RESTORE Fringe
	       GOTO FinishIt
	  CASE 5: ArrayLim = 3
	       RESTORE Building
	       GOTO FinishIt
	  CASE 6: ArrayLim = 3
	       RESTORE Arch
	       GOTO FinishIt
	  CASE 7: ArrayLim = 5
	       RESTORE Smile
	       GOTO FinishIt
	  CASE 8: ArrayLim = 5
	       RESTORE Heart
	       GOTO FinishIt
	  CASE 9: ArrayLim = 7
	       RESTORE Hat
	       GOTO FinishIt
	  END SELECT
     END SELECT
LOOP
FinishIt:
FOR X = 1 TO ArrayLim
FOR Y = 1 TO ArrayLim
READ CornerArray(X, Y)
NEXT Y
NEXT X
FOR X = 13 TO 21
LOCATE X, 62
PRINT SPACE$(19)
NEXT X
END SUB

SUB SelectPoint
COLOR 7
LOCATE 17, 65
PRINT "Arrow Keys --"
LOCATE 18, 66
PRINT "Move Cursor"
LOCATE 20, 66
PRINT "Spacebar --"
LOCATE 21, 65
PRINT "Toggle Point"
LOCATE 23, 65
PRINT "Enter -- Done"
FOR X = 1 TO ArrayLim - 1
Y = ((480 / ArrayLim) * X) - 1
     LINE (0, Y)-(479, Y)
     LINE (Y, 0)-(Y, 479)
NEXT X
Multiple = 480 / ArrayLim
Right = Multiple - 2
Left = 0
Bottom = Right
Top = Left
DotHor = Right / 2
DotVert = DotHor
FOR X = 1 TO ArrayLim
FOR Y = 1 TO ArrayLim
IF CornerArray(Y, X) = 1 THEN
     LINE (X * Multiple - Multiple, Y * Multiple - Multiple)-(X * Multiple - 2, Y * Multiple - 2), 6, BF
END IF
NEXT Y
NEXT X
CIRCLE (DotHor, DotVert), 5, 3
PAINT (DotHor, DotVert), 3, 3
DO
     KB$ = INKEY$
     SELECT CASE KB$
     CASE CHR$(0) + "H"
	  PAINT (DotHor, DotVert), POINT(Left, Top), POINT(Left, Top)
	  DotVert = DotVert - Multiple
	  Top = Top - Multiple
	  Bottom = Bottom - Multiple
	  IF Top < 0 THEN
	       Top = Top + 480
	       Bottom = Bottom + 480
	       DotVert = DotVert + 480
	  END IF
	  CIRCLE (DotHor, DotVert), 5, 3
	  PAINT (DotHor, DotVert), 3, 3
     CASE CHR$(0) + "P"
	  PAINT (DotHor, DotVert), POINT(Left, Top), POINT(Left, Top)
	  DotVert = DotVert + Multiple
	  Top = Top + Multiple
	  Bottom = Bottom + Multiple
	  IF Top > 479 THEN
	       Top = Top - 480
	       Bottom = Bottom - 480
	       DotVert = DotVert - 480
	  END IF
	  CIRCLE (DotHor, DotVert), 5, 3
	  PAINT (DotHor, DotVert), 3, 3
     CASE CHR$(0) + "K"
	  PAINT (DotHor, DotVert), POINT(Left, Top), POINT(Left, Top)
	  DotHor = DotHor - Multiple
	  Left = Left - Multiple
	  Right = Right - Multiple
	  IF Left < 0 THEN
	       Left = Left + 480
	       Right = Right + 480
	       DotHor = DotHor + 480
	  END IF
	  CIRCLE (DotHor, DotVert), 5, 3
	  PAINT (DotHor, DotVert), 3, 3
     CASE CHR$(0) + "M"
	  PAINT (DotHor, DotVert), POINT(Left, Top), POINT(Left, Top)
	  DotHor = DotHor + Multiple
	  Left = Left + Multiple
	  Right = Right + Multiple
	  IF Right > 480 THEN
	       Left = Left - 480
	       Right = Right - 480
	       DotHor = DotHor - 480
	  END IF
	  CIRCLE (DotHor, DotVert), 5, 3
	  PAINT (DotHor, DotVert), 3, 3
     CASE " "
	  LINE (Left, Top)-(Right, Bottom), ABS(POINT(Left, Top) - 6), BF
	  CIRCLE (DotHor, DotVert), 5, 3
	  PAINT (DotHor, DotVert), 3, 3
	  X = (Top + Multiple) / Multiple
	  Y = (Left + Multiple) / Multiple
	  CornerArray(X, Y) = ABS(CornerArray(X, Y) - 1)
     CASE CHR$(13)
	  LINE (0, 0)-(479, 479), 0, BF
	  FOR X = 1 TO 7
	  LOCATE X + 16, 62
	  PRINT SPACE$(16)
	  NEXT X
	  EXIT SUB
     END SELECT
LOOP
END SUB

SUB Sierpinski
FOR X = 13 TO 22
LOCATE X, 62
PRINT SPACE$(19)
NEXT X
COLOR 7
LOCATE 14, 65
PRINT "Press any key"
LOCATE 15, 68
PRINT "to stop."
DIM CX(3), CY(3)
CX(1) = 240
CY(1) = 0
CY(2) = 479
CX(2) = 0
CX(3) = 479
CY(3) = 479
FOR X = 1 TO 3
PSET (CX(X), CY(X)), 15
NEXT X
X = 14
RANDOMIZE TIMER
SX = INT(RND * 480)
SY = INT(RND * 480)
DO
PSET (SX, SY), X
RANDOMIZE TIMER
X = INT(RND * 3) + 1
SX = (SX + CX(X)) / 2
SY = (SY + CY(X)) / 2
LOOP WHILE INKEY$ = ""
FOR X = 14 TO 15
LOCATE X, 62
PRINT SPACE$(19)
NEXT X
LINE (0, 0)-(479, 479), 0, BF
END SUB

SUB SizeGrid
COLOR 7
FOR X = 3 TO 9
LOCATE X + 17, 68
PRINT X; "X"; X
NEXT X
LOCATE 27, 68
PRINT "10 X 10"
Spt = 1
COLOR 4
LOCATE Spt + 19, 68
FOR X = 1 TO 7
PRINT CHR$(SCREEN(CSRLIN, POS(1)));
NEXT X
DO
KB$ = INKEY$
SELECT CASE KB$
CASE CHR$(0) + "H"
     LOCATE Spt + 19, 68
     COLOR 7
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
     Spt = Spt - 1
     IF Spt = 0 THEN Spt = 8
     LOCATE Spt + 19, 68
     COLOR 4
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
CASE CHR$(0) + "P"
     LOCATE Spt + 19, 68
     COLOR 7
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
     Spt = Spt + 1
     IF Spt = 9 THEN Spt = 1
     LOCATE Spt + 19, 68
     COLOR 4
     FOR X = 1 TO 19
     PRINT CHR$(SCREEN(CSRLIN, POS(1)));
     NEXT X
CASE CHR$(13)
     FOR X = 1 TO 10
     FOR Y = 1 TO 10
     CornerArray(X, Y) = 0
     NEXT Y
     NEXT X
     ArrayLim = Spt + 2
     FOR X = 20 TO 29
     LOCATE X, 68
     PRINT SPACE$(7)
     NEXT X
     EXIT SUB
END SELECT
LOOP
END SUB

