'********************************************
' NeoLib v1.6
' Demonstation Program
'********************************************

DECLARE SUB StartUp ()
DECLARE SUB ShutDown ()

DECLARE SUB Intro ()
DECLARE SUB Outro ()

DECLARE SUB DrawMod ()
DECLARE SUB ExtractFiles ()

DECLARE FUNCTION OverLoader.ProgName$ ()
DECLARE FUNCTION OverLoader.FileSeek& (Filename$, FileHandle%)

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'NeoLib.bi'
'$LIB: 'NeoLib.lib'
'$HUGE
'$NEAR
'$HI
'$SMALL_ERR

TYPE OverLoaderHeader
  Filename AS STRING * 12
  FileLoc AS LONG
  FileSize AS LONG
END TYPE

TYPE OverLoaderEnd
  ID AS STRING * 10
  Entries AS STRING * 1
  Location AS LONG
END TYPE

DIM SHARED StdPal AS STRING, FONT AS INTEGER

CALL ExtractFiles
CALL StartUp
CALL Intro
CALL DrawMod
CALL Outro
CALL ShutDown

SUB ExtractFiles
	'extract HarSoft.bmp and QBCPC.bmp and Standard.fnt
	PRN$ = Overloader.Progname$
	FF = FREEFILE
	OPEN PRN$ FOR BINARY AS #FF
		DIM PACKED(2) AS STRING
		PACKED(0) = "STANDARD.FNT"
		PACKED(1) = "HARSOFT.BMP"
		PACKED(2) = "QBCPC.BMP"
		FOR I = 0 TO 2
			FLEN& = Overloader.FileSeek&(PACKED(I), FF)

			GOT& = 0
			BSIZE& = 4096
			FE = FREEFILE
			OPEN PACKED(I) FOR BINARY AS #FE
				DO UNTIL GOT& = FLEN&
					IF GOT& + BSIZE& > FLEN& THEN BSIZE& = FLEN& - GOT&
					Buffer$ = SPACE$(BSIZE&)
					GET #FF, , Buffer$
					PUT #FE, , Buffer$
					GOT& = GOT& + BSIZE&
				LOOP
			CLOSE #FE
		NEXT I
	CLOSE #FF

END SUB

SUB DrawMod
	neoLayerClear VIDEO, 0
	neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... Pixels", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoDrawPixel VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 256)
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... Lines (also gouraud)", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoDrawLine VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 256)
        	neoDrawLineGouraud VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 256), INT(RND * 256)
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... Boxes (also filled)", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoDrawBox VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 256)
        	neoDrawBoxF VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 256)
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... Circles (also filled)", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoDrawCircle VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 100), INT(RND * 256)
        	neoDrawCircleF VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 100), INT(RND * 256)
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... Ellipses (filled)", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoDrawEllipse VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 100), INT(RND * 100), INT(RND * 256)
        	neoDrawEllipseF VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 100), INT(RND * 100), INT(RND * 256)
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... TransBox", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoDrawBoxTrans VIDEO, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 320), INT(RND * 190) + 10, INT(RND * 256), StdPal, 0
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear 1, 0
       	neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, 1, "NeoLib supports... Polygons (+gouraud!)", 0, 0, 45, FALSE
	neoDrawSetClipBox 0, 10, 319, 199

        T! = TIMER
	DIM Pts(20) AS PolyStruct
	DO
		neoLayerCopy 1, 2
		FOR I = 0 TO 20
			Pts(I).X = INT(RND * 320)
			Pts(I).Y = INT(RND * 200)
		NEXT I
        	neoDrawPolygon 2, Pts(), INT(RND * 256)
        	FOR I = 0 TO 20
			Pts(I).X = INT(RND * 320)
			Pts(I).Y = INT(RND * 200)
			Pts(I).C = INT(RND * 256)
		NEXT I
        	neoDrawPolygonGouraud 2, Pts()
        	neoLayerCopy 2, VIDEO
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

	'initialize cdroms
	IF neoCdromInit = 0 THEN
		a$ = neoCdromGetDriveLetters$
        	neoLayerClear VIDEO, 0
        	neoFontSetClipBox 0, 0, 319, 199
		neoFontPrintG FONT, VIDEO, "And as well...", 0, 0, 45, FALSE
		neoDrawSetClipBox 0, 10, 319, 199
		T! = TIMER
		DO
		LOOP UNTIL TIMER - T! > 1
		FOR b = 1 TO LEN(a$)
			IF neoCdromDriveExist(MID$(a$, b, 1)) THEN
				neoCdromUnlock MID$(a$, b, 1)
				neoCdromOpen MID$(a$, b, 1)
			END IF
		NEXT b
		neoFontPrintG FONT, VIDEO, "CDrom routines!", 0, 10, 45, FALSE
		T! = TIMER
		DO
		LOOP UNTIL TIMER - T! > 1
		FOR b = 1 TO LEN(a$)
			IF neoCdromDriveExist(MID$(a$, b, 1)) THEN
				neoCdromClose MID$(a$, b, 1)
			END IF
		NEXT b
	END IF

	'mouse?
	IF neoMouseInit THEN
		neoLayerClear VIDEO, 0
        	neoFontSetClipBox 0, 0, 319, 199
		neoFontPrintG FONT, VIDEO, "And as well...", 0, 0, 45, FALSE
		neoDrawSetClipBox 0, 10, 319, 199
		neoFontPrintG FONT, VIDEO, "the mouse!", 0, 10, 45, FALSE
		neoMouseShow
		T! = TIMER
		DO
		LOOP UNTIL TIMER - T! > 5
		neoMouseHide
	END IF

	'joystick?
	IF neoJoyDetected THEN
		neoLayerClear VIDEO, 0
        	neoFontSetClipBox 0, 0, 319, 199
		neoFontPrintG FONT, VIDEO, "And as well...", 0, 0, 45, FALSE
		neoDrawSetClipBox 0, 10, 319, 199
		neoFontPrintG FONT, VIDEO, "the joystick!", 0, 10, 45, FALSE
		T! = TIMER
		DO
			neoJoyXY X%, Y%
			neoDrawPixel VIDEO, X%, Y%, INT(RND * 256)
		LOOP UNTIL TIMER - T! > 5
	END IF

	'sprites
	DIM Sprite(neoSpriteSize(0,0,15,15)) AS INTEGER
	neoLayerClear VIDEO, 0
	neoLayerClear 1, 0
	neoDrawSetClipBox 0,0, 319,199
	FOR I = 0 TO 7
		neoDrawCircle 1, 7, 7, I, I + 40
	NEXT I
	neoSpriteGet 1, 0, 0, 15, 15, VARSEG(Sprite(0)), VARPTR(Sprite(0))
        neoFontSetClipBox 0, 0, 319, 199
	neoFontPrintG FONT, VIDEO, "NeoLib supports... Sprites (all kinds)", 0, 0, 45, FALSE
	neoSpriteSetClipBox 0, 10, 319, 199
	T! = TIMER
	DO
        	neoSpritePutTrans VIDEO, INT(RND * 320), INT(RND * 200), VARSEG(Sprite(0)), VARPTR(Sprite(0)), 0
        	neoSpriteScale Sprite(), 2
        	neoSpritePutTrans VIDEO, INT(RND * 320), INT(RND * 200), VARSEG(Sprite(0)), VARPTR(Sprite(0)), 0
        	neoSpritePutColor VIDEO, INT(RND * 320), INT(RND * 200), VARSEG(Sprite(0)), VARPTR(Sprite(0)), 0, INT(RND * 255) + 1
        	neoSpriteScale Sprite(), .5
        	neoSpritePutColor VIDEO, INT(RND * 320), INT(RND * 200), VARSEG(Sprite(0)), VARPTR(Sprite(0)), 0, INT(RND * 255) + 1
        LOOP UNTIL ((neoKeybInkeyScan <> 0) AND (TIMER - T! > .25)) OR (TIMER - T! > 4)

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199
        neoFontPrintG FONT, VIDEO, "And finally...", 0, 0, 45, FALSE
	T! = TIMER: WHILE TIMER - T! < 1: WEND
	neoFontPrintG FONT, VIDEO, "-> Virtual XMS Routines", 0, 10, 45, FALSE
	T! = TIMER: WHILE TIMER - T! < 1: WEND
	neoFontPrintG FONT, VIDEO, "-> Win32 Long Filename Routines", 0, 20, 45, FALSE
	T! = TIMER: WHILE TIMER - T! < 1: WEND
	neoFontPrintG FONT, VIDEO, "-> Keyboard Routines", 0, 30, 45, FALSE
	T! = TIMER: WHILE TIMER - T! < 1: WEND
	neoFontPrintG FONT, VIDEO, "-> DOS Routines", 0, 40, 45, FALSE
	T! = TIMER: WHILE TIMER - T! < 2: WEND
END SUB

SUB StartUp
	IF NOT neoInit(2) THEN
		PRINT "Error during NeoLib v1.6 initialization"
		SYSTEM
	END IF
	FONT = neoFontOpen("STANDARD.FNT")
	T! = TIMER
END SUB

SUB ShutDown
	neoFontClose FONT
	neoClose
END SUB

SUB Intro
	neoPalGet StdPal
	neoPalOff

        neoLayerClear VIDEO, 0
        neoFontSetClipBox 0, 0, 319, 199

	neoFontPrintS FONT, VIDEO, "NeoLib v1.6", 160 - neoFontLen("NeoLib v1.6"), 90, 2, 2, 39, FALSE, FALSE, TRUE
        FOR I = 0 TO 63
        	neoPalFadeStepIn StdPal
        	neoVSync 4
        NEXT I
        neoPalFadeX 48, 55, 0, 0, 0
        neoFontPrintG FONT, VIDEO, "The biggest Pure-QB Mode 13h", 160 - neoFontLen("The biggest Pure-QB Mode 13h") \ 2, 110, 48, FALSE
        neoFontPrintG FONT, VIDEO, "Open Source Library for QB ever", 160 - neoFontLen("Open Source Library for QB ever") \ 2, 119, 48, FALSE
        FOR I = 0 TO 63
        	neoPalFadeStepIn StdPal
        	neoVSync 4
        NEXT I

        FOR deplace% = 0 TO 300
        	neoLayerClear 1, 0
        	neoFontPrintG FONT, 1, "The biggest Pure-QB Mode 13h", 160 - neoFontLen("The biggest Pure-QB Mode 13h") \ 2 - deplace%, 110, 48, FALSE
        	neoFontPrintG FONT, 1, "Open Source Library for QB ever", 160 - neoFontLen("Open Source Library for QB ever") \ 2 - deplace%, 119, 48, FALSE
        	neoFontPrintS FONT, 1, "NeoLib v1.6", 160 - neoFontLen("NeoLib v1.6") + deplace%, 90, 2, 2, 39, FALSE, FALSE, TRUE
        	neoVSync 1
        	neoLayerCopy 1, VIDEO
        NEXT deplace%

	DIM Pal AS STRING
	Pal = STRING$(768, 0)
        neoImageLoadBMP "QBCPC.BMP", 1, 0, 0, Pal
        neoPalOff
        neoLayerCopy 1, VIDEO

        FOR I = 0 TO 63
        	neoPalFadeStepIn Pal
        	neoVSync 3
        NEXT I
        Pal = ""

        FOR I = 0 TO 63
        	neoPalFadeStepTo 0, 0, 0
        	neoVSync 3
        NEXT I

        neoPalSet StdPal
END SUB

SUB Outro
        'scrolling text
        neoLayerClear 1, 0
        neoLayerClear VIDEO, 0

        RESTORE OutroText
        READ Lines%
        REDIM Text(1 TO Lines%) AS STRING
        FOR I = 1 TO Lines%
        	READ Text(I)
        	IF INSTR(Text(I), "%") > 0 THEN MID$(Text(I), INSTR(Text(I), "%"), 1) = CHR$(169)
        NEXT I

        textup% = 200
        textnow% = 1
        xcoord% = 0
        DO
        	neoLayerClear 1, 0
        	FOR I = textnow% TO textnow% + 20
        		IF I <= Lines% THEN
        			IF LEN(Text(I)) > 0 THEN
        				IF MID$(Text(I), 1, 1) = "#" THEN
        					neoFontPrintG FONT, 1, MID$(Text(I), 2, LEN(Text(I)) - 1), xcoord%, textup% + (I - textnow%) * 10, 48, FALSE
        				ELSEIF MID$(Text(I), 1, 1) = "!" THEN
        					neoFontPrintS FONT, 1, MID$(Text(I), 2, LEN(Text(I)) - 1), xcoord%, textup% + (I - textnow%) * 10, 2, 2, 40, FALSE, FALSE, TRUE
        				ELSE
        					neoFontPrintG FONT, 1, Text(I), xcoord%, textup% + (I - textnow%) * 10, 22, FALSE
        				END IF
        			END IF
        		END IF
        	NEXT I
        	IF neoKeybInkeyScan = 0 THEN neoVSync 1
        	neoLayerCopy 1, VIDEO

        	textup% = textup% - 1
        	IF textup% = -10 THEN textup% = 0: textnow% = textnow% + 1
        LOOP UNTIL (textnow% >= Lines%) OR (neoKeybInkeyScan = 1)
        ERASE Text

        DIM MyBuffer(32002) AS INTEGER
        Palet$ = ""
        neoImageLoadArrayBMP "HARSOFT.BMP", MyBuffer(), Palet$
        neoLayerClear VIDEO, 0
        neoLayerClear 1, 0
        neoPalSet Palet$
        neoPalOldSkool
        GPalet$ = ""
        neoPalGet GPalet$
        neoPalSet StdPal
        neoPalNegative
        NPalet$ = ""
        neoPalGet NPalet$
        neoSpriteSetClipBox 0, 0, 319, 199
        neoPalOff
        neoSpritePut 1, 0, 0, VARSEG(MyBuffer(0)), VARPTR(MyBuffer(0))
        neoLayerCopy 1, VIDEO

        'fade in
        FOR I = 0 TO 63
        	neoVSync 3
        	neoPalFadeStepIn Palet$
        NEXT I

        'fade to
        FOR I = 0 TO 63
        	neoVSync 1
        	neoPalFadeStepIn GPalet$
        NEXT I

        'fade in
        FOR I = 0 TO 63
        	neoVSync 1
        	neoPalFadeStepIn Palet$
        NEXT I

        'fade to
        FOR I = 0 TO 63
        	neoVSync 1
        	neoPalFadeStepIn NPalet$
        NEXT I

        'fade in
        FOR I = 0 TO 63
        	neoVSync 1
        	neoPalFadeStepIn Palet$
        NEXT I

        'fade to
        FOR I = 0 TO 63
        	neoVSync 1
        	neoPalFadeStepIn GPalet$
        NEXT I

        'fade in
        FOR I = 0 TO 63
        	neoVSync 1
        	neoPalFadeStepIn Palet$
        NEXT I

        'fade out
        FOR I = 0 TO 63
        	neoVSync 3
        	neoPalFadeStepTo 0, 0, 0
        NEXT I
        neoLayerClear VIDEO, 0
        neoPalSet StdPal
END SUB

FUNCTION OverLoader.FileSeek& (Filename$, FileHandle)

  'Ŀ
  ' Sets the read/write position of the specified file handle to the      
  ' start of the OverLoaded file contained in Filename$. The function     
  ' returns the length of the OverLoaded file.                            
  '                                                                       
  ' Filename$  = Name of the OverLoaded file which is tacked onto the end 
  '              of a EXE file.                                           
  ' FileHandle = The file handle that is assigned to the EXE file. The    
  '              EXE file must already be open in BINARY mode. Use        
  '              OverLoader.ProgName$ to find the filename of the         
  '              currently running EXE.                                   
  '                                                                       
  '    Returns:  The length of the OverLoaded file in bytes. Maximum file 
  '              size is 2 MB.                                            
  '                                                               <MORE>  
  ' Or, if an error occurs, one of the following error codes is returned: 
  '                                                                       
  '         -1 = Couldn't find OverLoader ID header                       
  '         -2 = OverLoaded file request not found                        
  '

  DIM Header AS OverLoaderHeader
  DIM EndHeader AS OverLoaderEnd

  OverLoad$ = Filename$ + STRING$(12 - LEN(Filename$), 0)

  SEEK #FileHandle, LOF(FileHandle) - 14
  GET #FileHandle, , EndHeader

  IF EndHeader.ID <> "OverLoader" THEN
    OverLoader.FileSeek& = -1
    EXIT FUNCTION
  END IF

  SEEK #FileHandle, EndHeader.Location

  FOR Search = 1 TO ASC(EndHeader.Entries)
    GET #FileHandle, , Header
    IF Header.Filename = OverLoad$ THEN EXIT FOR
  NEXT

  IF Search = ASC(EndHeader.Entries) + 1 THEN
    OverLoader.FileSeek& = -2
    EXIT FUNCTION
  END IF

  SEEK #FileHandle, Header.FileLoc
  OverLoader.FileSeek& = Header.FileSize

END FUNCTION

FUNCTION OverLoader.ProgName$

  'Ŀ
  ' Returns the full filename (including drive and path) of the currently 
  ' running EXE program. If you are in the QB IDE, this will always       
  ' return QB.EXE, not the name of your QB source code.                   
  '                                                                       
  ' Returns: String of variable length containing EXE filename of the     
  '          currently running program.                                   
  '

  DIM Regss AS RegType

  Regss.ax = &H6200
  CALL INTERRUPT(&H21, Regss, Regss)

  DEF SEG = Regss.bx
  DEF SEG = PEEK(44) + 256& * PEEK(45)

  Offset = 0
  DO UNTIL PEEK(Offset) = 0 AND PEEK(Offset + 1) = 0
    Offset = Offset + 1
  LOOP

  Offset = Offset + 4
  DO UNTIL PEEK(Offset) = 0
    Filename$ = Filename$ + CHR$(PEEK(Offset))
    Offset = Offset + 1
  LOOP

  DEF SEG
  OverLoader.ProgName$ = Filename$

END FUNCTION

'ATA 01234567890123456789012345678901234567890
OutroText:
DATA 480
DATA "!NeoLib v1.6"
DATA ""
DATA "#The biggest Pure-QB Mode 13h"
DATA "#Open Source Library for QB"
DATA ""
DATA "I'm sorry that I couldn't make"
DATA "a larger demo, but I really"
DATA "don't have that much time. Hope"
DATA "you're satisfied with this"
DATA "anyway. If you like to do more"
DATA "with NeoLib I advice you reading"
DATA "the manual thoroughly!"
DATA ""
DATA "Signing off,"
DATA ""
DATA "Neo"
DATA "a.k.a. Neo Deus Ex Machina"
DATA ""
DATA ""
DATA ""
DATA "!NeoLib"
DATA ""
DATA "!203 ROUTINES"
DATA ""
DATA "!5700 LINES OF CODE"
DATA ""
DATA ""
DATA "Counting 203 routines:"
DATA "Equal to 5700 lines of code:"
DATA "#Main Module (4 routines)
DATA "- neoInit FUNCTION
DATA "- neoClose SUB
DATA "- neoFFix SUB
DATA "- neoVSync SUB
DATA "#EMS Module (15 routines)
DATA "- neoEMSalloc FUNCTION
DATA "- neoEMSexist FUNCTION
DATA "- neoEMSfreeHandles FUNCTION
DATA "- neoEMSfreePages FUNCTION
DATA "- neoEMSgetErrorMsg FUNCTION
DATA "- neoEMSisError FUNCTION
DATA "- neoEMSpageFrame FUNCTION
DATA "- neoEMStotalPages FUNCTION
DATA "- neoEMSversion FUNCTION
DATA "- neoEMSdealloc SUB
DATA "- neoEMSexchange SUB
DATA "- neoEMSmap SUB
DATA "- neoEMSmapX SUB
DATA "- neoEMSmove SUB
DATA "- neoEMSrealloc SUB
DATA "#EMS Layer Module (16 routines)
DATA "- neoLayerCreate FUNCTION
DATA "- neoLayerFreeLayers FUNCTION
DATA "- neoLayerGetHandle FUNCTION
DATA "- neoLayerClear SUB
DATA "- neoLayerCopy SUB
DATA "- neoLayerCopyBlend SUB
DATA "- neoLayerCopyColor SUB
DATA "- neoLayerCopyForward SUB
DATA "- neoLayerCopyTrans SUB
DATA "- neoLayerExchange SUB
DATA "- neoLayerFilter SUB
DATA "- neoLayerLighting SUB
DATA "- neoLayerLoad SUB
DATA "- neoLayerMirror SUB
DATA "- neoLayerRemove SUB
DATA "- neoLayerSave SUB
DATA "#Drawing Module (17 routines)
DATA "- neoDrawPoint FUNCTION
DATA "- neoDrawBox SUB
DATA "- neoDrawBoxF SUB
DATA "- neoDrawBoxTrans SUB
DATA "- neoDrawCircle SUB
DATA "- neoDrawCircleF SUB
DATA "- neoDrawEllipse SUB
DATA "- neoDrawEllipseF SUB
DATA "- neoDrawHLine SUB
DATA "- neoDrawInitLayers SUB
DATA "- neoDrawLine SUB
DATA "- neoDrawLineGouraud SUB
DATA "- neoDrawPixel SUB
DATA "- neoDrawPolygon SUB
DATA "- neoDrawPolygonGouraud SUB
DATA "- neoDrawSetClipBox SUB
DATA "- neoDrawVLine SUB
DATA "#Palette Module (30 routines)
DATA "- neoPalGetRelativeCol FUNCTION
DATA "- neoPalSearch FUNCTION
DATA "- neoPalSearchIn FUNCTION
DATA "- neoPalExtractFromBMP SUB
DATA "- neoPalFadeIn SUB
DATA "- neoPalFadePalX SUB
DATA "- neoPalFadePalStepX SUB
DATA "- neoPalFadeStepIn SUB
DATA "- neoPalFadeStepTo SUB
DATA "- neoPalFadeStepX SUB
DATA "- neoPalFadeTo SUB
DATA "- neoPalFadeX SUB
DATA "- neoPalGet SUB
DATA "- neoPalGetCol SUB
DATA "- neoPalGradient SUB
DATA "- neoPalGrey SUB
DATA "- neoPalLoad SUB
DATA "- neoPalLoadPP256Pal SUB
DATA "- neoPalNegative SUB
DATA "- neoPalOff SUB
DATA "- neoPalOldSkool SUB
DATA "- neoPalRotateFull SUB
DATA "- neoPalRotatePart SUB
DATA "- neoPalSave SUB
DATA "- neoPalSavePP256Pal SUB
DATA "- neoPalSet SUB
DATA "- neoPalSetCol SUB
DATA "- neoPalStringGetCol SUB
DATA "- neoPalStringOff SUB
DATA "- neoPalStringSetCol SUB
DATA "#Keyboard Module (10 routines)
DATA "- neoKeybInkeyScan FUNCTION
DATA "- neoKeybGetLeds SUB
DATA "- neoKeybGetShift SUB
DATA "- neoKeybGetShiftEnhanced SUB
DATA "- neoKeybOn SUB
DATA "- neoKeybOff SUB
DATA "- neoKeybSetKey SUB
DATA "- neoKeybSetLeds SUB
DATA "- neoKeybSetSpeed SUB
DATA "- neoKeybWaitKey SUB
DATA "#Mouse Module (13 routines)
DATA "- neoMouseGetButtons FUNCTION
DATA "- neoMouseInit FUNCTION
DATA "- neoMouseLB FUNCTION
DATA "- neoMouseMB FUNCTION
DATA "- neoMouseRB FUNCTION
DATA "- neoMouseX FUNCTION
DATA "- neoMouseY FUNCTION
DATA "- neoMouseHide SUB
DATA "- neoMouseSetPos SUB
DATA "- neoMouseSetRange SUB
DATA "- neoMouseSetSensitivity SUB
DATA "- neoMouseSetShape SUB
DATA "- neoMouseShow SUB
DATA "#CDROM Module (24 routines)
DATA "- neoCdromChanged FUNCTION
DATA "- neoCdromDriveExist FUNCTION
DATA "- neoCdromGetDriveLetters FUNCTION
DATA "- neoCdromGetErrorMsg FUNCTION
DATA "- neoCdromGetVersion FUNCTION
DATA "- neoCdromHeadPosition FUNCTION
DATA "- neoCdromInit FUNCTION
DATA "- neoCdromIsError FUNCTION
DATA "- neoCdromRB2HSG FUNCTION
DATA "- neoCdromSize FUNCTION
DATA "- neoCdromClose SUB
DATA "- neoCdromDiskInfo SUB
DATA "- neoCdromGetInfo SUB
DATA "- neoCdromHSG2RB SUB
DATA "- neoCdromLock SUB
DATA "- neoCdromOpen SUB
DATA "- neoCdromPlay SUB
DATA "- neoCdromPlayRaw SUB
DATA "- neoCdromRead SUB
DATA "- neoCdromResume SUB
DATA "- neoCdromStop SUB
DATA "- neoCdromTrackInfo SUB
DATA "- neoCdromUnlock SUB
DATA "- neoCdromWrite SUB
DATA "#VXMS Module (9 routines)
DATA "- neoVXMSalloc FUNCTION
DATA "- neoVXMSfree FUNCTION
DATA "- neoVXMSinit FUNCTION
DATA "- neoVXMSdealloc SUB
DATA "- neoVXMSexchange SUB
DATA "- neoVXMSmove SUB
DATA "- neoVXMSread SUB
DATA "- neoVXMSrealloc SUB
DATA "- neoVXMSwrite SUB
DATA "#Sprite Module (17 routines)
DATA "- neoSpriteCollide FUNCTION
DATA "- neoSpriteCollideOnLayer FUNCTION
DATA "- neoSpriteSize FUNCTION
DATA "- neoSpriteConvert SUB
DATA "- neoSpriteGet SUB
DATA "- neoSpriteInitLayers SUB
DATA "- neoSpriteLighting SUB
DATA "- neoSpriteMirror SUB
DATA "- neoSpritePut SUB
DATA "- neoSpritePutBit SUB
DATA "- neoSpritePutBlend SUB
DATA "- neoSpritePutColor SUB
DATA "- neoSpritePutForward SUB
DATA "- neoSpritePutRotate SUB
DATA "- neoSpritePutTrans SUB
DATA "- neoSpriteScale SUB
DATA "- neoSpriteSetClipBox SUB
DATA "#Long FileName Module (11 routines)
DATA "- neoLFNgetCurrDir FUNCTION
DATA "- neoLFNgetFileSystem FUNCTION
DATA "- neoLFNgetFullPath FUNCTION
DATA "- neoLFNgetShortPath FUNCTION
DATA "- neoLFNshortFileName FUNCTION
DATA "- neoLFNchangeDir SUB
DATA "- neoLFNdeleteFile SUB
DATA "- neoLFNmakeDir SUB
DATA "- neoLFNrenameDir SUB
DATA "- neoLFNrenameFile SUB
DATA "- neoLFNremoveDir SUB
DATA "#DOS Module (15 routines)
DATA "- neoDOSgetCurrentDir FUNCTION
DATA "- neoDOSgetCurrentDrive FUNCTION
DATA "- neoDOSgetCurrentEXE FUNCTION
DATA "- neoDOSgetFileAttributes FUNCTION
DATA "- neoDOSgetFullPath FUNCTION
DATA "- neoDOSgetOpenedDateTime FUNCTION
DATA "- neoDOSgetTime FUNCTION
DATA "- neoDOSisDir FUNCTION
DATA "- neoDOSisFile FUNCTION
DATA "- neoDOSsearchDir FUNCTION
DATA "- neoDOSsearchFile FUNCTION
DATA "- neoDOSdisableDrive SUB
DATA "- neoDOSenableDrive SUB
DATA "- neoDOSsearchFileThrough SUB
DATA "- neoDOSsetFileAttributes SUB
DATA "#Font Module (14 routines)
DATA "- neoFontLen FUNCTION
DATA "- neoFontOpen FUNCTION
DATA "- neoFontClose SUB
DATA "- neoFontInitLayers SUB
DATA "- neoFontPrint SUB
DATA "- neoFontPrintB SUB
DATA "- neoFontPrintG SUB
DATA "- neoFontPrintN SUB
DATA "- neoFontPrintS SUB
DATA "- neoFontPrintSB SUB
DATA "- neoFontPrintSN SUB
DATA "- neoFontPrintT SUB
DATA "- neoFontSetClipBox SUB
DATA "- neoFontSetTexture SUB
DATA "#Image Module (5 routines)
DATA "- neoImageLoadArrayBMP SUB
DATA "- neoImageLoadBMP SUB
DATA "- neoImageLoadPP256Put SUB
DATA "- neoImageSaveArrayBMP SUB
DATA "- neoImageSaveBMP SUB
DATA "#Joystick Module (3 routines)
DATA "- neoJoyDetected FUNCTION
DATA "- neoJoyButton SUB
DATA "- neoJoyXY SUB
DATA ""
DATA ""
DATA ""
DATA "#Credits fly out to:"
DATA "#Competition Manager:
DATA "- Adigun Azikiwe Polack
DATA "#Coder:
DATA "- Neo Deus Ex Machina
DATA "#Betatesters:
DATA "- The Oracle
DATA "- akOOma
DATA "- TurboFX
DATA "- Dav
DATA "- elcalen
DATA "- Nekrophidius
DATA "- Dr_Davenstein
DATA "- Plasma
DATA "- and everyone else whom I forgot,
DATA "  who will be added on notice :)
DATA ""
DATA "!Greets to:"
DATA ""
DATA "#- Adigun Azikiwe Polack"
DATA "   Next time get more contestants ;)"
DATA ""
DATA "#- The Oracle"
DATA "   Thanks for everything ;)"
DATA ""
DATA "#- Zack
DATA "   Yes, and you too my friend ;)"
DATA ""
DATA "#- akOOma"
DATA "   Q-Tech is cool ;)"
DATA ""
DATA "#- Agravein"
DATA "   Please get a faster server ;)"
DATA ""
DATA "#- Fro Moe"
DATA "   Where are you? ;)"
DATA ""
DATA "#- muratelic"
DATA "   QB Turkey is alive! ;)"
DATA ""
DATA "#- wildcard"
DATA "   You wrote history with QBnews ;)"
DATA ""
DATA "#- FlingMaster"
DATA "   How's QBRPGS doing? ;)"
DATA ""
DATA "#- Marcade"
DATA "   And what about NeoZones? ;)"
DATA ""
DATA "#- Plasma (357)"
DATA "   Thanks for teaching me ;)"
DATA ""
DATA "#- relsoft"
DATA "   I like your GFX Demos! ;)"
DATA ""
DATA "#- L_O_J"
DATA "   ;)"
DATA ""
DATA "#- TheBigBasicQ"
DATA "   Get yourself a Hansol ;)"
DATA ""
DATA "#- Nekrophidius"
DATA "   TBN is coming along ;)"
DATA ""
DATA "#- Rhiannon"
DATA "   Greets to the happy couple in PR ;)"
DATA ""
DATA "#- Hexadecimal Disaster"
DATA "   Glad you're back ;)"
DATA ""
DATA "#- Jocke The Beast"
DATA "   Your games are so cool ;)"
DATA ""
DATA "#- Piptol"
DATA "   How was your holiday? ;)"
DATA ""
DATA "#- Josiah"
DATA "   UltimateQB is cool! ;)"
DATA ""
DATA "#- Dav"
DATA "   Keep your code post alive! ;)"
DATA ""
DATA "#- TurboFX"
DATA "   We'll definitely finish it ;)"
DATA ""
DATA "#- ScrapYard"
DATA "   Haven't seen you lately... ;)"
DATA ""
DATA "#- aetherFox"
DATA "   Still making the best website? ;)"
DATA ""
DATA "#- BlueKeyboard"
DATA "   Where art thou? ;)"
DATA ""
DATA "#- Mofu"
DATA "   And where are you too? ;)"
DATA ""
DATA "#- WizardLife"
DATA "   ;)"
DATA ""
DATA "#- Na_Th_An"
DATA "   Finish that cool game will you? ;)"
DATA ""
DATA "#- Toonski"
DATA "   ;)"
DATA ""
DATA "#- Vance"
DATA "   How's V-Planet? ;)"
DATA ""
DATA "#- Jark"
DATA "   I like your M-Set ;)"
DATA ""
DATA "#- Antoni Gual"
DATA "   You've got much knowledge ;)"
DATA ""
DATA "#- Toshi"
DATA "   Phew, how long was that ago? ;)"
DATA ""
DATA "#- Sumo Jo"
DATA "   Sumo Wrestlers look cool ;)"
DATA ""
DATA "#- Zap"
DATA "   I would like being a magician ;)"
DATA ""
DATA "#- Webberboy"
DATA "   Just met you ;)"
DATA ""
DATA "#- Blitz"
DATA "   Please upgrade UGL ;)"
DATA ""
DATA "#- R@dioman"
DATA "   Seeing you here and there ;)"
DATA ""
DATA "#- Joakim"
DATA "   ;)"
DATA ""
DATA "#- The Glenn"
DATA "   Sorry, I forgot the '%' ;)"
DATA ""
DATA "#- Hard Rock"
DATA "   I haven't seen you lately... ;)"
DATA ""
DATA "#- Lithium"
DATA "   Finish YGMAE ;)"
DATA ""
DATA "#- Sterling Christensen"
DATA "   You're the wise guy ;)"
DATA ""
DATA "#- Agamemnus"
DATA "   No GOTOs anymore please ;)"
DATA ""
DATA "#- Ninkazu"
DATA "   ;)"
DATA ""
DATA "#- Megaman"
DATA "   ;)"
DATA ""
DATA "#- Rockuman"
DATA "   GameColony will grow large ;)"
DATA ""
DATA "#- Moneo"
DATA "   Our living knowledge base ;)"
DATA ""
DATA "#- Mango"
DATA "   ;)"
DATA ""
DATA "#- Meg"
DATA "   ;)"
DATA ""
DATA "#- Mech"
DATA "   ;)"
DATA ""
DATA "#- Lachie Dazdarian"
DATA "   Your games are so cool! ;)"
DATA ""
DATA "#- and anyone else I forgot...
DATA ""
DATA "#Resources:"
DATA "Ralf Brown's Interrupt and Ports List"
DATA "Angelo Mottela's DirectQB"
DATA "Bobby's CosmoX"
DATA "Relsoft's RelLib"
DATA "AAP's Game Pad Library"
DATA "Plasma's CDROM Code"
DATA "FFix from Dav's Code Post"
DATA "OverLoad Library"
DATA "My own massive amount of knowledge ;)"
DATA ""
DATA ""
DATA "Beta version (203 routines,"
DATA "              5700 lines of code)"
DATA "!NeoLib v1.6"
DATA ""
DATA "THE BIGGEST PURE-QB MODE 13h"
DATA "OPEN SOURCE LIBRARY FOR QB EVER"
DATA ""
DATA "Official Library of the QuickBasic
DATA "Caliber Programming Compo
DATA "Summer & Autumn 2003
DATA ""
DATA "#Have fun using NeoLib v1.6!
DATA ""
DATA "!OPEN SOURCE"
DATA ""
DATA ""
DATA "Neo"
DATA "hendrikantoniorecinos@hotmail.com
DATA "arecinos@gmx.net
DATA "http://www.qbasicnews.com
DATA "http://www.qbnz.com
DATA "http://www.harsoftware.cjb.net
DATA "http://www.qbasic.tk
DATA ""
DATA "#And here's my last note... I'd like"
DATA "#to see any NeoLib creation you made!"
DATA "#Especially cool games! ;)"
DATA ""
DATA "#P.S.:"
DATA "NeoLib v2.0 will have a better"
DATA "construction and will be faster!"
DATA "Plus... more routines!"
DATA ""
DATA "[EOF - End Of File]"
DATA "Last updated 16th of March 2004"
DATA ""
DATA "Official Library of the QuickBasic"
DATA "Caliber Programming Compo"
DATA "Summer & Autumn 2003"
DATA ""
DATA "PS: Only the FFix ISR is in ASM... ;)"




