DECLARE SUB Init ()
DECLARE SUB MainInterface ()
DECLARE SUB Quit ()
DECLARE SUB ExtractFont ()

DECLARE FUNCTION AWT.Button% (Layer%, X1%, Y1%, X2%, Y2%, Style%, Text$)
DECLARE SUB AWT.Label (Layer%, X1%, Y1%, X2%, Y2%, Style%, Text$)
DECLARE SUB AWT.Window (Layer%, X1%, Y1%, X2%, Y2%, Style%, Text$)
DECLARE FUNCTION AWT.MessageBox$ (Layer%, X1%, Y1%, X2%, Y2%, Style%, Title$, Text$, Buttons$)

TYPE OverLoaderHeader
  Filename AS STRING * 12
  FileLoc AS LONG
  FileSize AS LONG
END TYPE

TYPE OverLoaderEnd
  ID AS STRING * 10
  Entries AS STRING * 1
  Location AS LONG
END TYPE

DECLARE FUNCTION OverLoader.ProgName$ ()
DECLARE FUNCTION OverLoader.FileSeek& (Filename$, FileHandle%)

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'NeoLib.bi'
'$LIB: 'NeoLib.lib'
'$HIGH
'$HUGE
'$NEAR

TYPE TType
	Playing 	AS INTEGER
	StartSector	AS LONG
	DataType	AS INTEGER
	Number		AS INTEGER
END TYPE

DIM SHARED StdDrive AS STRING * 1, Drives AS STRING, DriveNo AS INTEGER
DIM SHARED FONT AS INTEGER
DIM SHARED MOUSE(130) AS INTEGER, EXITANDRESTART AS INTEGER

DO
	Init
	MainInterface
	Quit
LOOP UNTIL NOT EXITANDRESTART


SUB Init
	'initialize CDrom drives
	Result = neoCdromInit
	SELECT CASE Result
		CASE -1
			PRINT "MSCDEX doesn't exist. Exiting..."
			END
		CASE -2
			PRINT "You have no CDROM drives. Exiting..."
			END
		CASE -3
			PRINT "You have no supported CDROM Drives. Exiting..."
			END
	END SELECT

	Drv$ = neoCdromGetDriveLetters$
	Drives = ""
	FOR I = 1 TO LEN(Drv$)
		IF neoCdromDriveExist(MID$(Drv$, I, 1)) THEN
			neoCdromGetInfo MID$(Drv$, I, 1), bits&
			IF bits& AND 16 > 0 THEN
				Drives = Drives + MID$(Drv$, I, 1)
				'make sure it IS unlocked
				FOR J = 1 TO 10
					neoCdromUnlock MID$(Drv$, I, 1)
				NEXT J
				neoCdromLock MID$(Drv$, I, 1)
				'all stop playing
				neoCdromStop MID$(Drv$, I, 1)
			END IF
		END IF
	NEXT I

	IF LEN(Drives) = 0 THEN
		PRINT "None of your CDROM Drives can play audio. Exiting..."
		END
	END IF

	PRINT "Following drives found: " + Drives
	DriveNo = LEN(Drives)
	StdDrive = LEFT$(Drives, 1)

	IF NOT EXITANDRESTART THEN
		'initialize NeoLib with 2 layers
		Result = neoInit(2)
		IF Result <> -1 THEN
			PRINT "NeoLib couldn't be initialized. Exiting..."
			END
		END IF
	END IF

	'initialize mouse
	IF NOT neoMouseInit THEN
		neoClose
		PRINT "Mouse couldn't be found. Exiting..."
		END
	END IF

	IF NOT EXITANDRESTART THEN
		'open font
		ExtractFont
		FONT = neoFontOpen("STANDARD.FNT")
	END IF

	'get mouse pointer
	neoLayerClear VIDEO, 1
	neoMouseShow
	neoMouseSetRange 0, 0, 0, 0
	neoMouseSetPos 0, 0
	neoSpriteGet VIDEO, 0, 0, 15, 15, VARSEG(MOUSE(0)), VARPTR(MOUSE(0))
	neoMouseHide
	neoMouseSetRange 0, 0, 319, 199
	neoLayerClear VIDEO, 0
END SUB

SUB Quit
	'unlock cdrom drives :) (very handy if you want to open them ;))
	IF NOT EXITANDRESTART THEN
		FOR J = 0 TO 4
			FOR I = 1 TO DriveNo
				neoCdromUnlock MID$(Drives, I, 1)
			NEXT I
		NEXT J

		neoFontClose FONT
		neoClose
	END IF
END SUB

SUB ExtractFont
	NowEXE$ = OverLoader.Progname$
	FF = FREEFILE
	OPEN NowEXE$ FOR BINARY AS #FF
		ln& = OverLoader.Fileseek&("STANDARD.FNT", FF)
		TMP$ = SPACE$(ln&)
		GET #FF, , TMP$
	CLOSE #FF
	OPEN "STANDARD.FNT" FOR BINARY AS #FF
		PUT #FF, , TMP$
	CLOSE #FF
END SUB

SUB MainInterface
        'build up the main interface

	'initialize cd
        DIM BEGTRACK AS INTEGER, ENDTRACK AS INTEGER, NOAUDIO AS INTEGER
        neoCdromDiskInfo StdDrive, BEGTRACK, ENDTRACK
        IF ENDTRACK > 45 THEN ENDTRACK = 45
        REDIM TRACKS(ENDTRACK) AS TType
        NOAUDIO = 0
        IF BEGTRACK <> 0 THEN
        	FOR I = BEGTRACK TO ENDTRACK
	        	neoCdromTrackInfo StdDrive, I, SS&, TYP%
	        	TRACKS(I).StartSector = SS&
	        	TRACKS(I).Playing = FALSE
	        	TRACKS(I).DataType = TYP%
	        	TRACKS(I).Number = I
	        	NOAUDIO = NOAUDIO + 1
	        NEXT I
	END IF

	QUITTING = 0
	DIM REQUEST AS INTEGER, REQUESTDATA AS STRING, MUSTDODATA AS STRING
	DIM CANCELAUDIO AS INTEGER, PLAYSTARTED AS SINGLE
	REQUEST = 0
	CANCELAUDIO = 0
	REQUESTDATA = ""
	MUSTDODATA = ""
	STARTEDPLAYING = 0
	PLAYING = 0
	PLAYTRACK = 0
	PLAYTRACKLEN& = 0
	PLAYTRACKSTART& = 0
	PLAYSTARTED = 0
	PLAYTIME = 0
	PAUSED = 0
	DIFFERENCE! = 0
	NOWSECTOR& = 0
	MAXPLAYTIME = 0
	PLAYMODE = 0
	EXITANDRESTART = 0
	VIA$ = ""
	CONST CONTINUOUS = 0
	CONST REPEATALL = 1
	CONST REPEAT1 = 2
	DO

		neoLayerClear 1, 0
                'draw some stuff
                AWT.Window 1, 0, 0, 319, 199, 0, "CD Player v1.0"
                AWT.Label 1, 2, 13, 317, 23, 1, "Current Cdrom Drive: " + StdDrive
                'draw buttons
                IF NOAUDIO > 0 THEN
                	FOR I = BEGTRACK TO ENDTRACK
	                	x = (I - 1) MOD 5
                		y = (I - 1) \ 5
                		IF TRACKS(I).DataType = CDA THEN
                			IF AWT.Button(1, x * 31 + 2, y * 13 + 30, x * 31 + 2 + 29, y * 13 + 30 + 11, ABS(TRACKS(I).Playing), LTRIM$(STR$(I))) THEN
                				REQUEST = TRUE
                				REQUESTDATA = "T" + LTRIM$(STR$(I))
                			END IF
                		END IF
                	NEXT I

                	'draw some command buttons
                	IF AWT.Button(1, 2, 187, 155, 197, ABS(PLAYMODE = REPEAT1), "Repeat 1") THEN PLAYMODE = REPEAT1
                	IF AWT.Button(1, 2, 175, 155, 185, ABS(PLAYMODE = REPEATALL), "Repeat All") THEN PLAYMODE = REPEATALL
                	IF AWT.Button(1, 2, 163, 155, 173, ABS(PLAYMODE = CONTINUOUS), "Continuous") THEN PLAYMODE = CONTINUOUS
                	AWT.Label 1, 2, 151, 155, 161, 0, "Play Mode"
                ELSE
                	AWT.Label 1, 2, 30, 123, 40, 1, "No audio tracks"
                	REQUEST = TRUE
                	REQUESTDATA = "EJ2"
                END IF
                'draw separation wall
                AWT.Label 1, 157, 30, 159, 197, 1, ""

                'command buttons
                IF AWT.Button(1, 161, 30, 260, 40, 0, "Eject") THEN
                	REQUEST = TRUE
                	REQUESTDATA = "EJ"
                END IF
                IF AWT.Button(1, 161, 42, 260, 52, 0, "Refresh") THEN
                	REQUEST = TRUE
                	REQUESTDATA = "RF"
                END IF
                IF AWT.Button(1, 161, 54, 260, 64, 0, "Change Drive") THEN
                	REQUEST = TRUE
                	REQUESTDATA = "CD"
                END IF

                IF AWT.Button(1, 161, 187, 260, 197, 0, "Quit") THEN
                	REQUEST = TRUE
                	REQUESTDATA = "QT"
                END IF
                neoFontPrint FONT, 1, "Using NeoLib v1.6", 161, 177, 8, FALSE
                neoFontPrint FONT, 1, "HarSoft 2004-03-13", 161, 167, 8, FALSE
                neoFontPrint FONT, 1, "By Neo", 161, 157, 8, FALSE

                'draw stuff when playing
                IF PLAYING THEN
                	AWT.Label 1, 161, 70, 317, 80, 0, "Playing Audio"
			neoCdromHSG2RB neoCdromSize&(StdDrive), Mins%, Secs%, Frames%
			Hours% = Mins% \ 60
			Mins% = Mins% - Hours% * 60
			CDLEN$ = STR$(Hours%) + ":" + LTRIM$(STR$(Mins%)) + ":" + LTRIM$(STR$(Secs%))
                	AWT.Label 1, 161, 82, 317, 92, 1, "CD Length:" + CDLEN$
                	AWT.Label 1, 161, 94, 317, 104, 1, "Track" + STR$(PLAYTRACK)
                	neoCdromHSG2RB PLAYTRACKLEN&, Mins%, Secs%, Frames%
                	Hours% = Mins% \ 60
                	Mins% = Mins% - Hours% * 60
                	ThingLen$ = STR$(Hours%) + ":" + LTRIM$(STR$(Mins%)) + ":" + LTRIM$(STR$(Secs%))
                	AWT.Label 1, 161, 106, 317, 116, 1, "Length:" + ThingLen$
                	IF (TIMER - PLAYSTARTED >= 1) AND NOT(PAUSED) THEN
                		PLAYSTARTED = TIMER
                		PLAYTIME = PLAYTIME + 1
                	END IF
                	Secs% = INT(PLAYTIME)
                	Mins% = Secs% \ 60
                	Secs% = Secs% - Mins% * 60
                	Hours% = Mins% \ 60
                	Mins% = Mins% - Hours% * 60
                	Now$ = STR$(Hours%) + ":" + LTRIM$(STR$(Mins%)) + ":" + LTRIM$(STR$(Secs%))
                	AWT.Label 1, 161, 118, 317, 128, 1, "Now:" + Now$
                	'174,175
                	IF NOT PAUSED THEN
                		IF AWT.Button(1, 161, 130, 173, 141, 0, CHR$(174)) THEN
	                		REQUEST = TRUE
                			REQUESTDATA = "FRW"
                		END IF
                	END IF
                	IF AWT.Button(1, 175, 130, 187, 141, ABS(NOT PAUSED), CHR$(16)) THEN
                		REQUEST = TRUE
                		REQUESTDATA = "RESUME"
                	END IF
                	IF AWT.Button(1, 189, 130, 201, 141, ABS(PAUSED), CHR$(186)) THEN
                		REQUEST = TRUE
                		REQUESTDATA = "PAUSE"
                	END IF
                	IF AWT.Button(1, 203, 130, 215, 141, 0, CHR$(254)) THEN
                		REQUEST = TRUE
                		REQUESTDATA = "STOP"
                	END IF
                	IF NOT PAUSED THEN
                		IF AWT.Button(1, 217, 130, 229, 141, 0, CHR$(175)) THEN
	                		REQUEST = TRUE
                			REQUESTDATA = "FFW"
                		END IF
                	END IF
                END IF

                neoSpritePutTrans 1, neoMouseX, neoMouseY, VARSEG(MOUSE(0)), VARPTR(MOUSE(0)), 1

                neoVSync 1
                neoLayerCopy 1, VIDEO

                IF MUSTDODATA <> "" THEN
                	REQUESTDATA = MUSTDODATA
                	REQUEST = TRUE
                	MUSTDODATA = ""
                END IF

                IF NOT PLAYING THEN PAUSED = FALSE: PLAYTIME = 0

                IF PLAYING THEN
                	IF PLAYTIME >= MAXPLAYTIME THEN
                		IF PLAYMODE = CONTINUOUS OR PLAYMODE = REPEATALL THEN
                			IF PLAYTRACK <> ENDTRACK THEN
	                			FOR I = PLAYTRACK + 1 TO ENDTRACK
                					IF TRACKS(I).DataType = CDA THEN
	                					neoCdromStop StdDrive
                						REQUEST = TRUE
                						REQUESTDATA = "T" + LTRIM$(STR$(I))
                						EXIT FOR
                					END IF
                					IF I = ENDTRACK AND PLAYMODE = REPEATALL THEN
                						IF PLAYTRACK <> BEGTRACK THEN
                							FOR J = BEGTRACK TO PLAYTRACK - 1
                								IF TRACKS(J).DataType = CDA THEN
                									neoCdromStop StdDrive
                									REQUEST = TRUE
                									REQUESTDATA = "T" + LTRIM$(STR$(J))
                									EXIT FOR
                								END IF
                								IF J = PLAYTRACK - 1 THEN
                									neoCdromStop StdDrive
                									REQUEST = TRUE
                									REQUESTDATA = "T" + LTRIM$(STR$(PLAYTRACK))
                								END IF
                							NEXT J
                						ELSE
	                						neoCdromStop StdDrive
                							REQUEST = TRUE
                							REQUESTDATA = "T" + LTRIM$(STR$(PLAYTRACK))
                						END IF
                					ELSE
                						neoCdromStop StdDrive
                						REQUEST = TRUE
                						REQUESTDATA = "STOP"
                					END IF
                				NEXT I
                			ELSE
                				IF PLAYMODE = CONTINUOUS THEN
	                				neoCdromStop StdDrive
                					PLAYING = 0
                					PLAYTIME = 0
                					REQUEST = TRUE
                					REQUESTDATA = "STOP"
                				ELSE
                					neoCdromStop StdDrive
                					FOR I = BEGTRACK TO ENDTRACK
                						IF TRACKS(I).DataType = CDA THEN
                							REQUEST = TRUE
                							REQUESTDATA = "T" + LTRIM$(STR$(I))
                							EXIT FOR
                						END IF
                					NEXT I
                				END IF
                			END IF
                		ELSEIF PLAYMODE = REPEAT1 THEN
					neoCdromStop StdDrive
					PLAYING = 0
					PLAYTIME = 0
					REQUEST = TRUE
					REQUESTDATA = "T" + LTRIM$(STR$(PLAYTRACK))
                		END IF
                	END IF
                END IF

                IF REQUEST THEN
                	REQUEST = FALSE
			IF REQUESTDATA = "EJ" THEN
				neoCdromStop StdDrive
				PLAYING = 0
				PLAYTRACK = 0
				neoCdromUnlock StdDrive
				neoCdromOpen StdDrive
				'display message
				DO
					neoLayerCopy 1, 2
					Ret$ = AWT.MessageBox$(2, 80, 50, 240, 140, 0, "Insert CD", "Please insert a  cd. Click OK whenready or Cancel  to abort. Close  the hatch as well", "OK")
					neoSpritePutTrans 2, neoMouseX, neoMouseY, VARSEG(MOUSE(0)), VARPTR(MOUSE(0)), 1
					neoVSync 1
					neoLayerCopy 2, VIDEO
				LOOP UNTIL Ret$ <> ""
				neoCdromClose StdDrive
				neoCdromLock StdDrive
				REQUEST = TRUE
				MUSTDODATA = "RF"
				VIA$ = "EJ"
			ELSEIF REQUESTDATA = "EJ2" THEN
				neoCdromStop StdDrive
				PLAYING = 0
				PLAYTRACK = 0
				neoCdromUnlock StdDrive
				neoCdromOpen StdDrive
				'display message
				DO
					neoLayerCopy 1, 2
					Ret$ = AWT.MessageBox$(2, 60, 50, 260, 140, 0, "Insert CD", "Click OK when ready.  Close the hatch as    well", "OK|Change Drive|Quit")
					neoSpritePutTrans 2, neoMouseX, neoMouseY, VARSEG(MOUSE(0)), VARPTR(MOUSE(0)), 1
					neoVSync 1
					neoLayerCopy 2, VIDEO
				LOOP UNTIL Ret$ <> ""
				neoCdromClose StdDrive
				neoCdromLock StdDrive
				IF Ret$ = "OK" THEN
					REQUEST = TRUE
					MUSTDODATA = "RF"
					VIA$ = "EJ"
				ELSEIF Ret$ = "Change Drive" THEN
					REQUEST = TRUE
					MUSTDODATA = "CD"
				ELSEIF Ret$ = "Quit" THEN
					REQUEST = TRUE
					MUSTDODATA = "QT"
				END IF
			ELSEIF REQUESTDATA = "QT" THEN
				neoCdromStop StdDrive
				PLAYING = 0
				PLAYTRACK = 0
				QUITTING = TRUE
			ELSEIF REQUESTDATA = "RF" THEN
				'CANCELAUDIO = FALSE
				IF VIA$ = "EJ" THEN EXITANDRESTART = TRUE: QUITTING = TRUE
				VIA$ = ""
				neoCdromDiskInfo StdDrive, BEGTRACK, ENDTRACK
				'PRINT BEGTRACK, ENDTRACK, neoCdromChanged(StdDrive): SLEEP
				IF ENDTRACK > 45 THEN ENDTRACK = 45
				ERASE TRACKS
        			REDIM TRACKS(ENDTRACK) AS TType
        			NOAUDIO = 0
        			IF BEGTRACK <> 0 THEN
        				FOR I = BEGTRACK TO ENDTRACK
	        				neoCdromTrackInfo StdDrive, I, SS&, TYP%
	        				TRACKS(I).StartSector = SS&
	        				'TRACKS(I).Playing = FALSE
	        				TRACKS(I).DataType = TYP%
	        				TRACKS(I).Number = I
	        				NOAUDIO = NOAUDIO + 1
	        			NEXT I
				END IF

				'lock all drives
				FOR J = 1 TO LEN(Drives)
					FOR K = 1 TO 20
						neoCdromUnlock MID$(Drives, J, 1)
					NEXT K
					neoCdromLock MID$(Drives, J, 1)
				NEXT J
			ELSEIF LEFT$(REQUESTDATA, 1) = "T" THEN
				neoCdromStop StdDrive
				PLAYING = 0
				PLAYTRACK = 0
				PLAYTIME = 0
				PAUSED = 0
				Nr% = VAL(MID$(REQUESTDATA, 2, LEN(REQUESTDATA) - 1))
				'first set off everything
				FOR I = BEGTRACK TO ENDTRACK
					TRACKS(I).Playing = FALSE
				NEXT I
				'play the track
				TRACKS(Nr%).Playing = TRUE
				PLAYING = TRUE
				PLAYTRACK = Nr%
				neoCdromPlay StdDrive, Nr%, PLAYTRACKSTART&, PLAYTRACKLEN&
				PLAYSTARTED = TIMER
				neoCdromHSG2RB PLAYTRACKLEN&, Mins%, Secs%, Frames%
				MAXPLAYTIME = Mins% * 60 + Secs% + Frames% \ 60 + 4
			ELSEIF REQUESTDATA = "CD" THEN
				'display message
				neoCdromStop StdDrive
				PLAYING = 0
				PLAYTRACK = 0
				ThaDrives$ = ""
				FOR I = 1 TO LEN(Drives)
					IF I > 1 THEN
						ThaDrives$ = ThaDrives$ + "|" + MID$(Drives, I, 1)
					ELSE
						ThaDrives$ = MID$(Drives, I, 1)
					END IF
				NEXT I
				DO
					neoLayerCopy 1, 2
					Ret$ = AWT.MessageBox$(2, 80, 50, 240, 140, 0, "Change Drive", "Please click the drive you want to play audio on.", ThaDrives$)
					neoSpritePutTrans 2, neoMouseX, neoMouseY, VARSEG(MOUSE(0)), VARPTR(MOUSE(0)), 1
					neoVSync 1
					neoLayerCopy 2, VIDEO
				LOOP UNTIL Ret$ <> ""
				StdDrive = Ret$
				REQUEST = TRUE
				MUSTDODATA = "RF"
			ELSEIF REQUESTDATA = "STOP" THEN
				neoCdromStop StdDrive
				PLAYING = 0
				PLAYTRACK = 0
				FOR I = BEGTRACK TO ENDTRACK
					TRACKS(I).Playing = 0
				NEXT I
			ELSEIF REQUESTDATA = "PAUSE" THEN
                                PAUSED = TRUE
                                neoCdromStop StdDrive
                                DIFFERENCE! = TIMER
			ELSEIF REQUESTDATA = "RESUME" THEN
				PAUSED = FALSE
				Secs% = INT(PLAYTIME)
                		Mins% = Secs% \ 60
                		Secs% = Secs% - Mins% * 60
                		'Hours% = Mins% \ 60
                		'Mins% = Mins% - Hours% * 60
                		NOWSECTOR& = PLAYTRACKSTART& + neoCdromRB2HSG(Mins%, Secs%, 0)
                		LEFTSECTOR& = PLAYTRACKLEN& - neoCdromRB2HSG(Mins%, Secs%, 0)
                		neoCdromPlayRaw StdDrive, NOWSECTOR&, LEFTSECTOR&
                		PLAYSTART = TIMER - (DIFFERENCE! - PLAYSTART)
                	ELSEIF REQUESTDATA = "FRW" THEN
                		neoCdromStop StdDrive
                        	Secs% = INT(PLAYTIME - 2) * ABS(INT(PLAYTIME - 2) > 0)
                		Mins% = Secs% \ 60
                		Secs% = Secs% - Mins% * 60
                		'Hours% = Mins% \ 60
                		'Mins% = Mins% - Hours% * 60
                		NOWSECTOR& = PLAYTRACKSTART& + neoCdromRB2HSG(Mins%, Secs%, 0)
                		LEFTSECTOR& = PLAYTRACKLEN& - neoCdromRB2HSG(Mins%, Secs%, 0)
				neoCdromPlayRaw StdDrive, NOWSECTOR&, LEFTSECTOR&
				PLAYTIME = (PLAYTIME - 2) * ABS(PLAYTIME - 2 > 0)
                	ELSEIF REQUESTDATA = "FFW" THEN
                		neoCdromStop StdDrive
                		Secs% = INT(PLAYTIME + 2)
                		IF Secs% >= MAXPLAYTIME THEN Secs% = MAXPLAYTIME
                		Mins% = Secs% \ 60
                		Secs% = Secs% - Mins% * 60
                		'Hours% = Mins% \ 60
                		'Mins% = Mins% - Hours% * 60
                		NOWSECTOR& = PLAYTRACKSTART& + neoCdromRB2HSG(Mins%, Secs%, 0)
                		LEFTSECTOR& = PLAYTRACKLEN& - neoCdromRB2HSG(Mins%, Secs%, 0)
				neoCdromPlayRaw StdDrive, NOWSECTOR&, LEFTSECTOR&
				PLAYTIME = PLAYTIME + 2
				IF PLAYTIME >= MAXPLAYTIME THEN PLAYTIME = MAXPLAYTIME
			END IF
                END IF
	LOOP UNTIL QUITTING OR (LCASE$(neoCdromGetErrorMsg$) <> "no error" AND LCASE$(neoCdromGetErrorMsg$) <> "no or undefined error")
	IF neoCdromIsError AND LCASE$(neoCdromGetErrorMsg$) <> "no or undefined error" THEN
		neoLayerCopy VIDEO, 1
		DO
			neoLayerCopy 1, 2
			res$ = AWT.MessageBox$(2, 80, 50, 240, 120, 0, "CD Error Occured!", "Error message:   " + neoCdromGetErrorMsg$, "Quit|Restart")
			neoSpritePutTrans 2, neoMouseX, neoMouseY, VARSEG(MOUSE(0)), VARPTR(MOUSE(0)), 1
			neoVSync 1
			neoLayerCopy 2, VIDEO
		LOOP UNTIL res$ <> ""
		EXITANDRESTART = FALSE
		IF res$ = "Restart" THEN EXITANDRESTART = TRUE
	END IF
END SUB


'/////////////////////
' AWT
'/////////////////////
SUB AWT.Label (Layer%, X1%, Y1%, X2%, Y2%, Style%, Text$)
	IF Style% = 0 THEN
		neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 8
		neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 8
		neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 15
		neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 15
		neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 1
		neoFontPrint FONT, Layer%, Text$, (X2% + X1% + 1) \ 2 - neoFontLen(Text$) \ 2, Y1% + 2, 7, FALSE
	ELSEIF Style% = 1 THEN
		neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 8
		neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 8
		neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 15
		neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 15
		neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 7
		neoFontPrint FONT, Layer%, Text$, X1% + 2, Y1% + 2, 8, FALSE
	END IF
END SUB

SUB AWT.Window (Layer%, X1%, Y1%, X2%, Y2%, Style%, Text$)
	IF Style% = 0 THEN
		neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 15
		neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 15
		neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 8
		neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 8
		neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 7

		AWT.Label Layer%, X1% + 1, Y1% + 1, X2% - 1, Y1% + 11, Style%, Text$
	END IF
END SUB

FUNCTION AWT.Button% (Layer%, X1%, Y1%, X2%, Y2%, Style%, Text$)
	IF (Style% = 0 OR Style% = 2) THEN
		IF (neoMouseX >= X1% AND neoMouseX <= X2% AND neoMouseY >= Y1% AND neoMouseY <= Y2%) AND (neoMouseLB) THEN
			neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 8
			neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 8
			neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 15
			neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 15
			neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 7
			IF Style% = 0 THEN
				neoFontPrint FONT, Layer%, Text$, (X2% + X1% + 1) \ 2 - neoFontLen(Text$) \ 2, Y1% + 2, 8, FALSE
			ELSE
				neoFontPrint FONT, Layer%, Text$, X1% + 2, Y1% + 2, 8, FALSE
			END IF
			AWT.Button% = TRUE
		ELSE
			neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 15
			neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 15
			neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 8
			neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 8
			neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 7
			IF Style% = 0 THEN
				neoFontPrint FONT, Layer%, Text$, (X2% + X1% + 1) \ 2 - neoFontLen(Text$) \ 2, Y1% + 2, 8, FALSE
			ELSE
				neoFontPrint FONT, Layer%, Text$, X1% + 2, Y1% + 2, 8, FALSE
			END IF
			AWT.Button% = FALSE
		END IF
	ELSEIF Style% = 1 THEN
		neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 8
		neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 8
		neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 15
		neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 15
		neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 7
		neoFontPrint FONT, Layer%, Text$, (X2% + X1% + 1) \ 2 - neoFontLen(Text$) \ 2, Y1% + 2, 15, FALSE
		AWT.Button% = FALSE
	END IF
END FUNCTION

FUNCTION AWT.MessageBox$ (Layer%, X1%, Y1%, X2%, Y2%, Style%, Title$, Text$, Buttons$)
	IF Style% = 0 THEN
		neoDrawLine Layer%, X1%, Y1%, X2%, Y1%, 15
		neoDrawLine Layer%, X1%, Y1%, X1%, Y2%, 15
		neoDrawLine Layer%, X2%, Y1% + 1, X2%, Y2%, 8
		neoDrawLine Layer%, X1% + 1, Y2%, X2%, Y2%, 8
		neoDrawBoxF Layer%, X1% + 1, Y1% + 1, X2% - 1, Y2% - 1, 7

		AWT.Label Layer%, X1% + 1, Y1% + 1, X2% - 1, Y1% + 11, Style%, Title$
		NowX = X1% + 2
		NowY = Y1% + 13
		FOR I = 1 TO LEN(Text$)
			neoFontPrint FONT, Layer%, MID$(Text$, I, 1), NowX, NowY, 8, FALSE
			NowX = NowX + 9
			IF NowX > X2% - 8 THEN
				NowX = X1% + 2
				NowY = NowY + 9
			END IF
		NEXT I

		ButtonH = NowY + 10
		Butts = 1
                FOR I = 1 TO LEN(Buttons$)
                	IF MID$(Buttons$, I, 1) = "|" THEN Butts = Butts + 1
                NEXT I

       		REDIM Buttons(Butts) AS STRING
       		TmpCap$ = ""
       		Btnow = 1
       		FOR I = 1 TO LEN(Buttons$)
       			IF MID$(Buttons$, I, 1) = "|" THEN
                                Buttons(Btnow) = TmpCap$
                                Btnow = Btnow + 1
                                TmpCap$ = ""
       			ELSE
       				TmpCap$ = TmpCap$ + MID$(Buttons$, I, 1)
       			END IF
       		NEXT I
       		Buttons(Btnow) = TmpCap$

       		'count length of buttons in a row
       		leng% = 0
       		FOR I = 1 TO Butts
       			leng% = leng% + LEN(Buttons(I)) * 8 + 5
       		NEXT I

       		NowX = (X2% + X1% + 1) \ 2 - leng% \ 2
       		'display buttons
       		Ret$ = ""
       		FOR I = 1 TO Butts
			pressed% = AWT.Button%(Layer%, NowX, ButtonH, NowX + LEN(Buttons(I)) * 8 + 3, ButtonH + 10, 0, Buttons(I))
			IF pressed% THEN Ret$ = Buttons(I)
			NowX = NowX + LEN(Buttons(I)) * 8 + 5
       		NEXT I
       		AWT.MessageBox$ = Ret$
	END IF
END FUNCTION

'///////////////////////
'Overloader
'///////////////////////
FUNCTION OverLoader.FileSeek& (Filename$, FileHandle)

  'Ŀ
  ' Sets the read/write position of the specified file handle to the      
  ' start of the OverLoaded file contained in Filename$. The function     
  ' returns the length of the OverLoaded file.                            
  '                                                                       
  ' Filename$  = Name of the OverLoaded file which is tacked onto the end 
  '              of a EXE file.                                           
  ' FileHandle = The file handle that is assigned to the EXE file. The    
  '              EXE file must already be open in BINARY mode. Use        
  '              OverLoader.ProgName$ to find the filename of the         
  '              currently running EXE.                                   
  '                                                                       
  '    Returns:  The length of the OverLoaded file in bytes. Maximum file 
  '              size is 2 MB.                                            
  '                                                               <MORE>  
  ' Or, if an error occurs, one of the following error codes is returned: 
  '                                                                       
  '         -1 = Couldn't find OverLoader ID header                       
  '         -2 = OverLoaded file request not found                        
  '

  DIM Header AS OverLoaderHeader
  DIM EndHeader AS OverLoaderEnd

  OverLoad$ = Filename$ + STRING$(12 - LEN(Filename$), 0)

  SEEK #FileHandle, LOF(FileHandle) - 14
  GET #FileHandle, , EndHeader

  IF EndHeader.ID <> "OverLoader" THEN
    OverLoader.FileSeek& = -1
    EXIT FUNCTION
  END IF

  SEEK #FileHandle, EndHeader.Location

  FOR Search = 1 TO ASC(EndHeader.Entries)
    GET #FileHandle, , Header
    IF Header.Filename = OverLoad$ THEN EXIT FOR
  NEXT

  IF Search = ASC(EndHeader.Entries) + 1 THEN
    OverLoader.FileSeek& = -2
    EXIT FUNCTION
  END IF

  SEEK #FileHandle, Header.FileLoc
  OverLoader.FileSeek& = Header.FileSize

END FUNCTION

FUNCTION OverLoader.ProgName$

  'Ŀ
  ' Returns the full filename (including drive and path) of the currently 
  ' running EXE program. If you are in the QB IDE, this will always       
  ' return QB.EXE, not the name of your QB source code.                   
  '                                                                       
  ' Returns: String of variable length containing EXE filename of the     
  '          currently running program.                                   
  '

  DIM Regss AS RegType

  Regss.ax = &H6200
  CALL INTERRUPT(&H21, Regss, Regss)

  DEF SEG = Regss.bx
  DEF SEG = PEEK(44) + 256& * PEEK(45)

  Offset = 0
  DO UNTIL PEEK(Offset) = 0 AND PEEK(Offset + 1) = 0
    Offset = Offset + 1
  LOOP

  Offset = Offset + 4
  DO UNTIL PEEK(Offset) = 0
    Filename$ = Filename$ + CHR$(PEEK(Offset))
    Offset = Offset + 1
  LOOP

  DEF SEG
  OverLoader.ProgName$ = Filename$

END FUNCTION

