Attribute VB_Name = "Module2"
Option Explicit

'-------------------------------------------------------
' JOYSTICK.BAS - Joystick support routines for
'                Visual Basic 4.0.
'-------------------------------------------------------
' Joystick Device ID

Global Const JOYSTICK1 = 0
Global Const JOYSTICK2 = 1
' Joystick error return values
Global Const JOYERR_NOERROR = 0
Global Const JOYERR_PARMS = 165
Global Const MMSYSERR_NODRIVER = 6
Global Const JOYERR_UNPLUGGED = 167
' Joystick button bit-flags used by tJoyInfo.ButtonStates
Global Const JOY_BUTTON1 = &H1
Global Const JOY_BUTTON2 = &H2
Global Const JOY_BUTTON3 = &H4
Global Const JOY_BUTTON4 = &H8
Global x1
Global y1
Global JH
Global JV
Global b1$
Global b2$
Global b3$
Global b4$
Global jhm, xsp, xsp1
Global jvm, ysp, ysp1
Global hh1
Global vv1
Global but$
' Joystick Position
Type tJoyInfo
    X As Long
    Y As Long
    Z As Long
    ButtonStates As Long
    ' This is determined by the fields above.
    ButtonDown(1 To 4) As Integer
End Type
' Joystick Capabilities
Const MAXPNAMELEN = 32
Const MAXOEMVXD = 128
Type tJoyCaps
    Mid As Integer
    Pid As Integer
    Pname As String * MAXPNAMELEN
    Xmin As Long
    Xmax As Long
    Ymin As Long
    Ymax As Long
    Zmin As Long
    Zmax As Long
    NumButtons As Long
    PeriodMin As Long
    PeriodMax As Long
    wRmin As Long
    wRmax As Long
    wUmin As Long
    wUmax As Long
    wVmin As Long
    wVmax As Long
    wCaps As Long
    wMaxAxes As Long
    wNumAxes As Long
    wMaxButtons As Long
    szRegKey As String * MAXPNAMELEN
    szOEMVxD As String * MAXOEMVXD
End Type
Global JoyCaps As tJoyCaps
' Joystick API Calls
Declare Function joyGetDevCaps Lib "winmm.dll" Alias "joyGetDevCapsA" (ByVal IDDevice As Integer, JCaps As tJoyCaps, ByVal CapSize As Integer) As Integer
Declare Function joyGetPos Lib "winmm.dll" (ByVal IDDevice As Integer, JPos As tJoyInfo) As Integer


Function GetJoystickPos(IDDevice As Long, JoyInfo As tJoyInfo) As Integer
'-------------------------------------------------------
' This function is a wrapper around the joyGetPos API
' call.  That call returns coordinates as unsigned
' long integers, which VB doesn't support.  We move
' these coordinates into long values so that they
' can be easily evaluated.
'-------------------------------------------------------
Dim rc As Integer
Static NotFirstTime As Integer
    If Not NotFirstTime Then
        NotFirstTime = False
        rc = joyGetDevCaps(IDDevice, JoyCaps, Len(JoyCaps))
        If rc <> 0 Then
            GetJoystickPos = rc
            Exit Function
        End If
    End If
    rc = joyGetPos(IDDevice, JoyInfo)
    GetJoystickPos = rc
    If rc <> 0 Then Exit Function
    JoyInfo.ButtonDown(1) = (JoyInfo.ButtonStates And JOY_BUTTON1) = JOY_BUTTON1
    JoyInfo.ButtonDown(2) = (JoyInfo.ButtonStates And JOY_BUTTON2) = JOY_BUTTON2
    JoyInfo.ButtonDown(3) = (JoyInfo.ButtonStates And JOY_BUTTON3) = JOY_BUTTON3
    JoyInfo.ButtonDown(4) = (JoyInfo.ButtonStates And JOY_BUTTON4) = JOY_BUTTON4
End Function

