Attribute VB_Name = "Module1"
'
' BIGINT
'
' A small library having support for so-called 'big integers',
' which are unsigned data types consisting of a maximum of
' 262144 bits = 32768 bytes.
' Compare this with a normal integer: 16 bits = 2 bytes!
'
' Actually, this version of BIGINT has support for:
' - String integers (max value = 32768x a 9)

' Have fun!
'
' -Neo Deus Ex Machina
'
'       X
'      XXX
'     X   X
'    XXX XXX
'
' HAR-SoftWare
'
' PS: Due to the fact that this is a pure-qb big integer
' library, I think you will get out of string space when
' using large big integers (like 10000!)

'DECLARE FUNCTION siadd$ (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SISubtract$ (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIMultiply$ (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIDivide$ (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIMod$ (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SISmallDivide$ (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIShiftLeft$ (StrInt AS STRING, Positions AS INTEGER)
'DECLARE FUNCTION SIShiftRight$ (StrInt AS STRING, Positions AS INTEGER)
'DECLARE FUNCTION SIPower$ (StrInt AS STRING, StrInt2 AS STRING)

'DECLARE FUNCTION SIIsGreater% (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIIsSmaller% (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIIsZero% (StrInt AS STRING)
'DECLARE FUNCTION SIIsEqual% (StrInt AS STRING, StrInt2 AS STRING)
'DECLARE FUNCTION SIIsEven% (StrInt AS STRING)
'DECLARE FUNCTION SIIsUnEven% (StrInt AS STRING)
'DECLARE FUNCTION SILog10% (StrInt AS STRING)
Global Const varvarFALSE = 0
Global Const varTRUE = Not False
Global Const varLNE = 2.718281828
Global fontsttext$
'DefInt A-Z
'$DYNAMIC
'$END_META
'INPUT "n1 (", n1$
'INPUT "n2 (", n2$


Public Sub getleftdec(n$, lnz$)
l = Len(n$)
For t = 1 To (l)
ch$ = Mid$(n$, t, 1)

If ch$ = "." Then zt = t
Next t
lnz$ = Left$(n$, l - zt)

End Sub

Public Sub getrightdec(n$, rnz$)
l = Len(n$)
For t = 1 To (l)
ch$ = Mid$(n$, t, 1)

If ch$ = "." Then zt = t
Next t
lnz$ = Right$(n$, l - (zt + 1))

End Sub


'http://my.netzero.net/s/sp?r=al&cf=sp&mem=gates_scott&login=7ea228961b2b18b185b7d3971a45d2d9/gates_scott:netzero.net/1174938557/30/sss.0.41190/&ts=460823bd&A=588243160001249&B=1141718400000&C=1141718400000&D=1154674800000&I=8.NQ4&N=PL&O=A&UT=companion
Function SIDivide$(StrInt As String, StrInt2 As String)
        '
        ' This functions divides two String ints to eachother and
        ' returns the answer in a string int
        '

        'declare stuff
                                Dim len1 As Long, len2 As Long, maxlen As Long
                                Dim StrAns As String, C As Long, char1 As String, char2 As String
                                Dim TempD As String, TempAns As String, TempA As String
                                len1 = Len(StrInt)
                                len2 = Len(StrInt2)

                                'check if the division will be good
                                If SIIsGreater%(StrInt2, StrInt) Then SIDivide$ = "0": Exit Function
                                If SIIsZero(StrInt2) Then
                                        SIDivide$ = "0"
                                        Exit Function
                                End If

                                'pick out maximum length of the strings
                                If len1 < len2 Then
                                        maxlen = len2
                                        ' StrAns = SPACE$(len2 + 1)
                                Else
                                        maxlen = len1
                                        ' StrAns = SPACE$(len1 + 1)
                                End If
                                StrAns = ""

        'calculate StrInt / StrInt2
        over$ = ""
        charlen = len2 - 1
        ' PRINT maxlen
        'endofloop = len1
        TempD = Left$(StrInt, charlen)
        inhowmuch$ = ""
        TempAns = ""
                                For C = charlen + 1 To len1
                                                                TempD = TempD + Mid$(StrInt, C, 1)
                                                                inhowmuch$ = "0"
                                                                inhowmuch$ = SISmallDivide$(TempD, StrInt2)
                                                                TempAns = TempAns + inhowmuch$
                                                                TempA = SIMultiply$(inhowmuch$, StrInt2)
                                                                TempD = SISubtract$(TempD, TempA)
                                                                If SIIsZero(TempD) Then TempD = ""
                                Next C
                                'StrAns = TempAns
                                While (Len(TempAns) > 1) And (Left$(TempAns, 1) = "0")
                                        TempAns = Right$(TempAns, Len(TempAns) - 1)
                                Wend
                                StrAns = TempAns
                                SIDivide$ = StrAns
End Function

Function SIIsEqual%(StrInt As String, StrInt2 As String)
                                If StrInt = StrInt2 Then SIIsEqual% = varTRUE Else SIIsEqual% = varFALSE
End Function

Function SIIsEven%(StrInt As String)
        a% = Len(StrInt)
        If a% = 0 Then SIIsEven% = varFALSE: Exit Function
                                Char$ = Mid$(StrInt, a%, 1)
                                vals% = Val(Char$)
                                If vals% And 1 Then SIIsEven% = varFALSE Else SIIsEven% = True
End Function

Function SIIsGreater%(StrInt As String, StrInt2 As String)
        If Len(StrInt) > Len(StrInt2) Then
                SIIsGreater% = varTRUE
                Exit Function
        ElseIf (Len(StrInt) < Len(StrInt2)) Or (StrInt = StrInt2) Then
                SIIsGreater% = varFALSE
                Exit Function
        End If
        leng% = Len(StrInt)
        val1% = 0
        val2% = 0
        posi% = 1
                                Do
                val1% = Val(Mid$(StrInt, posi%, 1))
                val2% = Val(Mid$(StrInt2, posi%, 1))
                posi% = posi% + 1
        Loop Until val1% <> val2%
                                If val1% > val2% Then
                                        SIIsGreater = varTRUE
                                        Exit Function
                                Else
                                        SIIsGreater = varFALSE
                                End If
End Function

Function SIIsSmaller%(StrInt As String, StrInt2 As String)
        If Len(StrInt) < Len(StrInt2) Then
                SIIsSmaller% = varTRUE
                Exit Function
        ElseIf (Len(StrInt) > Len(StrInt2)) Or (StrInt = StrInt2) Then
                SIIsSmaller% = varFALSE
                Exit Function
        End If
        leng% = Len(StrInt)
        val1% = 0
        val2% = 0
        posi% = 1
                                Do
                val1% = Val(Mid$(StrInt, posi%, 1))
                val2% = Val(Mid$(StrInt2, posi%, 1))
                posi% = posi% + 1
        Loop Until val1% <> val2%
                                If val1% < val2% Then
                                        SIIsSmaller% = varTRUE
                                        Exit Function
                                Else
                                        SIIsSmaller% = varFALSE
                                End If
End Function

Function SIIsUnEven%(StrInt As String)
        a% = Len(StrInt)
        If a% = 0 Then SIIsUnEven% = varFALSE: Exit Function
                                Char$ = Mid$(StrInt, a%, 1)
                                vals% = Val(Char$)
                                If vals% And 1 Then SIIsUnEven% = varTRUE Else SIIsUnEven% = False
End Function

Function SIIsZero%(StrInt As String)
        len1 = Len(StrInt)
        For C = 1 To len1
                If Mid$(StrInt, C, 1) <> "0" Then
                        SIIsZero% = varFALSE
                        Exit Function
                End If
        Next C
        SIIsZero% = varTRUE
End Function

Function SILog10%(StrInt As String)
        SILog10% = Len(StrInt) - 1
End Function

Function SIMod$(StrInt As String, StrInt2 As String)
        'calculates StrInt MOD StrInt2
                                SIMod$ = SISubtract$(StrInt, SIMultiply$(SIDivide$(StrInt, StrInt2), StrInt2))
End Function

Function SIMultiply$(StrInt As String, StrInt2 As String)
        '
        ' This functions multiplies two String ints to eachother and
        ' returns the answer in a string int
        '

        'declare stuff
                                Dim len1 As Long, len2 As Long, maxlen As Long
                                Dim StrAns As String, C As Long, char1 As String, char2 As String
                                Dim TempAns As String
                                len1 = Len(StrInt)
                                len2 = Len(StrInt2)

                                'pick out maximum length of the strings
                                If len1 < len2 Then
                                        maxlen = len2
                                        ' StrAns = SPACE$(len2 + 1)
                                Else
                                        maxlen = len1
                                        ' StrAns = SPACE$(len1 + 1)
                                End If
                                StrAns = "0"

        'calculate StrInt + StrInt2
        over% = 0
        ' PRINT maxlen
                                For d = 1 To len2
                                        If d > 1 Then
                                                TempAns = String$(d - 1, "0")
                                        Else
                                                TempAns = ""
                                        End If
                                        over% = 0
                                        char2 = Mid$(StrInt2, len2 - d + 1, 1)
                val2 = Val(char2)
                                        For C = 1 To len1
                                                char1 = Mid$(StrInt, len1 - C + 1, 1)
                                                'print char1;" ";char2
                        val1 = Val(char1)
                                                                                                ans$ = LTrim$(Str$(val1 * val2 + over%))
                                                                                                'print ans$
                        TempAns = Right$(ans$, 1) + TempAns
                        'print TempAns
                        If Len(ans$) > 1 Then
                                over% = Val(Left$(ans$, 1))
                        Else
                                over% = 0
                        End If
                Next C
                If over% > 0 Then TempAns = LTrim$(Str$(over%)) + TempAns
                StrAns = siadd$(StrAns, TempAns)
                'PRINT StrAns
                                Next d
                                StrAns = LTrim$(StrAns)
                                If SIIsZero(StrAns) Then StrAns = "0"
                                SIMultiply$ = StrAns
End Function

Function SIPower$(StrInt As String, StrInt2 As String)
        ' calculates StrInt ^ StrInt2
        Dim Remind As String
        Dim Pow As String
        Dim BaseN As String

        'some criteria
        If SI.IsZero(StrInt2) Then SIPower$ = "1": Exit Function
        If StrInt2 = "1" Then SIPower$ = StrInt: Exit Function

        Pow = StrInt2
        BaseN = StrInt
        Remind = "1"
        Do
                If SI.IsUnEven(Pow) Then    'uneven
                        Remind = SIMultiply$(Remind, BaseN)
                        Pow = SISubtract$(Pow, "1")
                End If
                Pow = SIDivide$(Pow, "2")
                BaseN = SIMultiply$(BaseN, BaseN)
        Loop Until Pow = "1"
        SIPower$ = SIMultiply$(Remind, BaseN)
End Function

Function SIShiftLeft$(StrInt As String, Positions As Integer)
        If Not (SI.IsZero(StrInt)) Then SIShiftLeft$ = StrInt + String$(Positions, "0") Else SIShiftLeft$ = "0"
End Function

Function SIShiftRight$(StrInt As String, Positions As Integer)
        If Len(StrInt) <= Positions Then
                SIShiftRight$ = "0"
                Exit Function
        End If
                                SIShiftRight$ = Left$(StrInt, Len(StrInt) - Positions)
End Function

Function SISmallDivide$(StrInt As String, StrInt2 As String)
                                ' first check if the division is ok
                                If SIIsGreater%(StrInt2, StrInt) = varTRUE Then
                                        SISmallDivide$ = "0"
                                        Exit Function
                                End If
                                If StrInt = StrInt2 Then
                                        SISmallDivide$ = "1"
                                        Exit Function
                                End If

                                over$ = StrInt
                                times$ = "0"
                                Do
                                        over$ = SISubtract$(over$, StrInt2)
                                        times$ = siadd$(times$, "1")
                                Loop Until over$ = "0"
                                If SIMultiply$(times$, StrInt2) <> StrInt Then
                                        SISmallDivide$ = SISubtract$(times$, "1")
                                Else
                                        SISmallDivide$ = times$
                                End If
End Function

Function SISubtract$(StrInt As String, StrInt2 As String)
        '
        ' This functions subtracts two String ints to eachother and
        ' returns the answer in a string int
        '

        'declare stuff
        Dim len1 As Long, len2 As Long, maxlen As Long
                                Dim StrAns As String, C As Long, char1 As String, char2 As String
                                len1 = Len(StrInt)
                                len2 = Len(StrInt2)

                                'if the length of StrInt2 > StrInt then the answer is negative -> not allowed
                                If SIIsGreater%(StrInt2, StrInt) Then SISubtract$ = "0": Exit Function

                                'pick out maximum length of the strings
                                If len1 < len2 Then
                                        maxlen = len2
                                        StrAns = Space$(len2 + 1)
                                Else
                                        maxlen = len1
                                        StrAns = Space$(len1 + 1)
                                End If

        'calculate StrInt - StrInt2
        over% = 0
        ' PRINT maxlen
                                For C = 1 To maxlen
                                        If C <= Len(StrInt) Then char1 = Mid$(StrInt, len1 - C + 1, 1) Else char1 = "0"
                If C <= Len(StrInt2) Then char2 = Mid$(StrInt2, len2 - C + 1, 1) Else char2 = "0"
                val1 = Val(char1)
                val2 = Val(char2)
                ' print val1,val2
                ans$ = LTrim$(Str$(10 + val1 - val2 + over%))
                Mid$(StrAns, Len(StrAns) - C + 1, 1) = Right$(ans$, 1)
                If Len(ans$) > 1 Then
                        over% = 0
                Else
                        over% = -1
                End If
                                Next C
                                StrAns = LTrim$(StrAns)
                                'IF (over% = 0) AND (LEN(StrAns) > 1) THEN StrAns = RIGHT$(StrAns, LEN(StrAns) - 1)
                                While (Left$(StrAns, 1) = "0") And (Len(StrAns) > 1)
                                        StrAns = Right$(StrAns, Len(StrAns) - 1)
                                Wend
                                SISubtract$ = StrAns
End Function

Function siadd$(StrInt As String, StrInt2 As String)
        '
        ' This functions adds two String ints to eachother and
        ' returns the answer in a string int
        '

        'declare stuff
                                Dim len1 As Long, len2 As Long, maxlen As Long
                                Dim StrAns As String, C As Long, char1 As String, char2 As String
                                len1 = Len(StrInt)
                                len2 = Len(StrInt2)

                                'pick out maximum length of the strings
                                If len1 < len2 Then
                                        maxlen = len2
                                        StrAns = Space$(len2 + 1)
                                Else
                                        maxlen = len1
                                        StrAns = Space$(len1 + 1)
                                End If

        'calculate StrInt + StrInt2
        over% = 0
        ' PRINT maxlen
                                For C = 1 To maxlen
                                        If C <= Len(StrInt) Then char1 = Mid$(StrInt, len1 - C + 1, 1) Else char1 = "0"
                If C <= Len(StrInt2) Then char2 = Mid$(StrInt2, len2 - C + 1, 1) Else char2 = "0"
                val1 = Val(char1)
                val2 = Val(char2)
                ' print val1,val2
                ans$ = LTrim$(Str$(val1 + val2 + over%))
                Mid$(StrAns, Len(StrAns) - C + 1, 1) = Right$(ans$, 1)
                If Len(ans$) > 1 Then
                        over% = Val(Left$(ans$, 1))
                Else
                        over% = 0
                End If
                                Next C
                                StrAns = LTrim$(StrAns)
                                If over% > 0 Then StrAns = LTrim$(Str$(over%)) + StrAns
                                If SIIsZero(StrAns) Then StrAns = "0"
                                siadd$ = StrAns
End Function

Public Function ConvertToBinary(ByVal Number As Long, ByVal Bits As Byte) As String
    Dim intCount As Byte
    ConvertToBinary = String$(Bits, "0")


    For intCount = 1 To Bits
        If Number And 1 Then Mid$(ConvertToBinary, Bits + 1 - intCount, 1) = "1"
        Number = Number \ 2
    Next intCount
End Function


Public Function ConvertFromBinary(ByVal Binary As String) As Long
    Dim intCount As Integer


    For intCount = Len(Binary) To 1 Step -1
        If Mid$(Binary, intCount, 1) = "1" Then ConvertFromBinary = ConvertFromBinary + (&H2 ^ (Len(Binary) - intCount))
    Next intCount
End Function
