' The MK Font v2.0 (*.MKF)
' written by Molnar \ Kucalaba Productions

'  We realized how wasteful and screwed up our old font was, so now
' instead of the data file taking up 10k, it takes up 1k.  It also
' loads nearly as fast.  The reason behind this is that we use
' each bit as we used to use each byte.  This version does not save any memory.
' The data file is inflated into memory where it can be accessed much easier
' and faster.  Also, we were stupid enough to include both a horizontal
' and vertical row of, well, nothing.  So the old font was really a 9x9 font,
' which made things a lot bigger than they needed to be.

' Also, this does not contain a ready to go font file generator.  If you
' can make some sense out of the unused MakeMKFont routine, than you, well,
' I guess you just have a better understanding of how this works.

' The font data file is no longer just raw 90% zero data.  Of course, I
' already said that.  But, in addition to being smaller, the file has
' a small header that is basically there to tell us the font width and
' height.  (And, in the next version, which characters are supported, which
' means if you only want capital letters than you only include capital
' letters)

'  Use this freely, but give credit where credit is due.

DEFINT A-Z
DECLARE FUNCTION LoadMKFont% (FileName$)
DECLARE SUB MakeMKFont ()
DECLARE SUB GetPress ()
DECLARE SUB Border ()
DECLARE SUB Font (text$, XStart%, YStart%, XScale%, YScale%, Style%, Clr%)
DECLARE SUB SetPal ()
DECLARE SUB FindFont ()

'$DYNAMIC

'---Begin : Font Data Types and buffers---
TYPE FontHeader
  Ident AS STRING * 6        ' "MKFont"
  with AS INTEGER            ' Font width
  Hite AS INTEGER            ' Font height
  Descriptor AS STRING * 20  ' Font name, also bytes reserved for future use
END TYPE

DIM SHARED BitTable(0 TO 15) AS LONG
DIM SHARED fontbuf(0) AS STRING * 16384
DIM SHARED FontHdr AS FontHeader
'---End : Font Data Types and buffers---

CLS
PRINT "Font file to load : (*.MKF, enter for default)"
INPUT "", FileName$
IF FileName$ = "" THEN FileName$ = "standard.mkf"
IF INSTR(FileName$, ".MKF") <> 0 THEN FileName$ = FileName$ + ".mkf"


'---Begin : Font loading & error sorting---
RetVal% = LoadMKFont(FileName$)

  SELECT CASE RetVal%
    CASE -1: PRINT "The specified font file was not located."
             SYSTEM
  END SELECT


'---End : Font loading & error sorting---


CLS
SCREEN 13

SetPal



Font "The M \ K Font v2.0", 80, 2, 1, 2, 1, 0
Font "Font : " + FontHdr.Descriptor, 0, 30, 1, 1, 5, 65
Font "Style #1 ABCDEFGHIJKLM", 0, 45, 1, 2, 1, 130
Font "Style #2 ABCDEFGHIJKLM", 0, 70, 1, 1, 2, 130
Font "Style #3 ABCDEFGHIJ", 0, 85, 2, 2, 3, 130
Font "Style #4 ABCDEFGHIJ", -50, 115, 2, 2, 4, 130
Font "Style #5 ABCDEFGHIJKLM", 0, 145, 1, 1, 5, 130
Font "Style #6 ABCDEFGHIJKLM", 0, 165, 1, 1, 6, 0
Font "Style #7 ABCDEFGHIJKLM", 0, 185, 1, 1, 7, 113


DO
 aa$ = INKEY$
 IF aa$ <> "" THEN TheyPressedAKey = 1
LOOP UNTIL TheyPressedAKey


' For those interested, here is how the Font routine works:

' Font Text$, xstart, ystart, xscale, yscale, style, color

' For color, 0 is red, 64 is green, 130 is blue, 195 is purple
' Of course, that is dependant on how your palette is set up, and you
' can tailor the font routine to use any amount of colors, this one just
' happens to use 64, except for #7 which uses only one color.

'--- Style descriptions ---
'
' 1 = standard.  Best with 1 scale factor for x and y.  Like normal text, but
' with a calculated blend of 63 shades of a color.

' 2 = circular.  Looks bubbly, kind of hard to read but still better than
' boring text.  Drawn with Circles, play around with the aspect for cool
' fonts.  The bigger it gets the worse it looks.

' 3 = revised 1.  Filled 1 style, slower but better with big letters.  Notice
' how this font always uses the maximum amount of colors for better appearance,
' there's absolutely no "blockiness" at all.  Also has kind of a "3D" appearance.

' 4 = Italic 3.  Pretty impressive.

' 5 = Totally different, not fancy but looks pretty good.

' 6 = Fire-type effect, I was just screwing around for something to add to
'     Fury when I made this.

' 7 = Normal, one color font.

REM $STATIC
DEFSNG A-Z
SUB Border
FOR X% = 0 TO 32
 Font "$", X% * 10, 0, 1, 1, 1, 0
 Font "$", X% * 10, 190, 1, 1, 1, 0
NEXT
FOR X% = 1 TO 19
 Font "$", 0, X% * 10, 1, 1, 1, 0
 Font "$", 310, X% * 10, 1, 1, 1, 0
NEXT
END SUB

SUB Font (text$, XStart%, YStart%, XScale%, YScale%, Style%, Clr%)
px% = XStart%  ' physical x and physical y
py% = YStart%


LHeight% = YScale% * (FontHdr.Hite + 1)
Float! = 63 / LHeight%

' For some reason, this doesn't shade properly with the 8x8 font,
' so I inserted a quick bug fix that makes it work but will probably
' have to be changed for future fonts.
IF FontHdr.Hite <> 8 THEN Optimize% = Float! + .5 ELSE Optimize% = Float! - .5


DEF SEG = VARSEG(fontbuf(0))

 FOR h% = 1 TO LEN(text$)
  FPtr% = FontHdr.with * FontHdr.Hite * (ASC(MID$(text$, h%, 1)) - 1)
  FOR X% = 0 TO FontHdr.with - 1
   FOR y% = 0 TO FontHdr.Hite - 1
    py% = py% + YScale%
    Col% = PEEK(VARPTR(fontbuf(0)) + FPtr%)
    FPtr% = FPtr% + 1

    IF Col% THEN
     SELECT CASE Style%
      CASE 1: PSET (px%, py%), Optimize% * (py% - YStart%) + Clr% - 1
              LINE (px%, py%)-(px%, py% + YScale%), Optimize% * (py% - YStart%) + Clr% - 1
      CASE 2: CIRCLE (px%, py%), YScale%, (54 \ LHeight%) * (py% - YStart%) + Clr% + 9, , , 4
      CASE 3:  FOR sty% = px% TO px% + XScale%
                FOR sty2% = py% TO py% + YScale%
                 PSET (sty%, sty2%), Optimize% * (sty2% - YStart%) + Clr% - 1
                 IF POINT(sty% - 1, sty2%) = 0 THEN PSET (sty% - 1, sty2%), 63 + Clr% - 1
                 IF POINT(sty%, sty2% - 1) = 0 THEN PSET (sty%, sty2% - 1), 63 + Clr% - 1
                NEXT
               NEXT
       CASE 4: FOR sty% = px% TO px% + XScale%
                FOR sty2% = py% TO py% + YScale%
                 PSET (sty% + .4 * sty2%, sty2%), Optimize% * (sty2% - YStart%) + Clr% - 1
                 IF POINT((sty% - 1) + .4 * sty2%, sty2%) = 0 THEN PSET ((sty% - 1) + .4 * sty2%, sty2%), 63 + Clr% - 1
                NEXT
               NEXT
       CASE 5: IF px% MOD 2 = 0 THEN CIRCLE (px%, py%), YScale%, (54 \ LHeight%) * (py% - YStart%) + Clr% + 9, , , .1
       CASE 6: PSET (px%, py%), (Clr% - Optimize% * (py% - YStart%)) + 64
                 IF py% - YScale% = YStart% THEN
                    Dist% = INT(RND * 6) + 1
                    CVal% = Clr% + 64: CSlope% = 55 \ Dist%
                      FOR y1% = py% - Dist% TO py% - 1
                        PSET (px%, y1%), CVal% + Clr%
                        CVal% = CVal% + CSlope%
                      NEXT
                  END IF
      
       CASE 7:
               IF XScale% = 1 AND YScale% = 1 THEN
                PSET (px%, py%), Clr%
               ELSE
                FOR sty% = px% TO px% + XScale%
                 FOR sty2% = py% TO py% + YScale%
                  PSET (sty%, sty2%), Clr%
                 NEXT
                NEXT
               END IF
               
     END SELECT
    END IF
   NEXT
   px% = px% + XScale%
   py% = YStart%
  NEXT
 NEXT h%
DEF SEG
END SUB

SUB GetPress
DO
aa$ = INKEY$
LOOP UNTIL aa$ <> ""
END SUB

FUNCTION LoadMKFont% (FileName$)

' Built an exponential table for use with extracting bits
FOR X% = 0 TO 15
   BitTable(X%) = 2 ^ X%
NEXT


OPEN FileName$ FOR BINARY AS #1
  IF LOF(1) < 2 THEN
    CLOSE #1
    KILL FileName$
    LoadMKFont% = -1
    EXIT FUNCTION
  END IF
PRINT "Loading...";

GET #1, , FontHdr
Offs% = 1
  FOR y% = 1 TO (FontHdr.with * FontHdr.Hite * 128) \ 16
    GET #1, , In%
     FOR X% = 0 TO 15
      IF ((In% AND BitTable(X%)) \ BitTable(X%)) = 1 THEN
       MID$(fontbuf(0), Offs%, 1) = CHR$(1)
      END IF
      Offs% = Offs% + 1
     NEXT
    PRINT ".";
   NEXT
CLOSE #1

LoadMKFont% = 1
END FUNCTION

SUB MakeMKFont

EXIT SUB
GOTO skip

OPEN "font8x16.mkf" FOR BINARY AS #1
 File$ = INPUT$(LOF(1), #1)
CLOSE
KILL "font8x16.mkf"
FontHdr.Ident = "MKFont"
FontHdr.with = 8
FontHdr.Hite = 16
FontHdr.Descriptor = "Standard 8x16 Font"
OPEN "font8x16.mkf" FOR BINARY AS #1
 PUT #1, , FontHdr
 PUT #1, , File$
CLOSE

EXIT SUB

skip:
FontHdr.Ident = "MKFont"
FontHdr.with = 8
FontHdr.Hite = 16
FontHdr.Descriptor = "Standard 8x16 Font"

FOR X% = 0 TO 15
   BitTable(X%) = 2 ^ X%
NEXT

FPtr% = 1
OPEN "font8x12.dat" FOR BINARY AS #1
 GET #1, , fontbuf(0)
CLOSE
OPEN "font8x16.mkf" FOR BINARY AS #1
 Offs% = 1
 FOR y% = 1 TO (FontHdr.with * FontHdr.Hite * 128) \ 16
  FOR X% = 0 TO 15
   IF ASC(MID$(fontbuf(0), Offs%, 1)) = 1 THEN
    OutData& = OutData& + BitTable(X%)
   END IF
   Offs% = Offs% + 1
  NEXT
   PUT #1, FPtr%, OutData&
   FPtr% = FPtr% + 2
   OutData& = 0
   LOCATE 1, 1: PRINT y%
 NEXT
CLOSE #1
END SUB

SUB SetPal
FOR X% = 1 TO 64
 OUT &H3C8, X%
 OUT &H3C9, X%
 OUT &H3C9, 0
 OUT &H3C9, 0
NEXT
FOR X% = 65 TO 129
 OUT &H3C8, X%
 OUT &H3C9, 0
 OUT &H3C9, X% - 65
 OUT &H3C9, 0
NEXT
FOR X% = 130 TO 193
 OUT &H3C8, X%
 OUT &H3C9, 0
 OUT &H3C9, 0
 OUT &H3C9, X% - 130
NEXT
END SUB

