' -----------------------------
' 3D Bouncer, written by Luke Molnar
' Another program from
' http://members.aol.com/mkwebsite/index.html

' Play around with this program for a while.
' There's some kinda fun stuff you can do
' that very clearly illustrates 3D graphics,
' like pausing all pixel bouncing but still
' keeping the cube rotating.  You can also
' toggle which axes should have bouncing
' pixels, and all other sorts of fun
' crap.  The complete instructions can be
' viewed during the program.
' -----------------------------

DECLARE SUB Controls ()
DECLARE SUB LoadArena ()
DECLARE SUB AssembleArena ()
DECLARE SUB BuildTables ()

RANDOMIZE TIMER
'$DYNAMIC

TYPE type3d
        x AS INTEGER
        y AS INTEGER
        z AS INTEGER
END TYPE

TYPE Connect
        a AS INTEGER
        B AS INTEGER
END TYPE

TYPE move3d
        x AS INTEGER
        y AS INTEGER
        z AS INTEGER
        xdir AS INTEGER
        ydir AS INTEGER
        zdir AS INTEGER
        Col AS INTEGER
END TYPE

CONST pi = 3.141592
DEFINT A-Z


CLS
PRINT "How many dots should I calculate along each axis?"
INPUT Max%
Max% = Max% * 3
PRINT
PRINT ""
PRINT "  Remember this :  Hit the ? key for instructions once the program begins. "
PRINT ""
LOCATE 20, 1
PRINT "To begin, hit the key for instructions.  ;-)"
DO: LOOP UNTIL INKEY$ = "?"

CLS
SCREEN 7


DIM SHARED p(0 TO Max%) AS move3d
DIM SHARED Arena(0 TO 7) AS type3d
DIM SHARED Drawlist(12) AS Connect
DIM SHARED WorldAngle%, speed%

WorldAngle% = 0
speed% = 2

' Initialize the points.
FOR x% = 0 TO Max%
        p(x%).x = INT(RND * 99) + 1 + 110
        p(x%).y = INT(RND * 99) + 1 + 50
        p(x%).z = INT(RND * 49) + 1 - INT(RND * 49) + 1
        
        IF x% MOD 3 = 0 THEN
                IF INT(RND * 2) + 1 = 1 THEN p(x%).xdir = 1 * (INT(RND * 3) + 1) ELSE p(x%).xdir = -1 * (INT(RND * 3) + 1)
                p(x%).Col = 1
        END IF
        IF x% MOD 3 = 1 THEN
                IF INT(RND * 2) + 1 = 1 THEN p(x%).ydir = 1 * (INT(RND * 3) + 1) ELSE p(x%).ydir = -1 * (INT(RND * 3) + 1)
                p(x%).Col = 5
        END IF
        IF x% MOD 3 = 2 THEN
                IF INT(RND * 2) + 1 = 1 THEN p(x%).zdir = 1 * (INT(RND * 3) + 1) ELSE p(x%).zdir = -1 * (INT(RND * 3) + 1)
                p(x%).Col = 4
        END IF
       
NEXT

DIM SHARED cost(360) AS SINGLE
DIM SHARED sint(360) AS SINGLE

BuildTables


' The Arena routines basically load up a cube and draw it.
' The box encompasses every point, in 3 dimensions.
' The cube is 50x50x50
LoadArena
AssembleArena


SCREEN , , 2, 0
' Main routine
DO

        PCOPY 3, 2

        FOR x% = 0 TO Max%
                IF Pause% <> 1 THEN
                        p(x%).x = p(x%).x + p(x%).xdir
                        p(x%).y = p(x%).y + p(x%).ydir
                        p(x%).z = p(x%).z + p(x%).zdir
                END IF

                SELECT CASE p(x%).x
                        CASE IS >= 210, IS <= 110: p(x%).xdir = -1 * p(x%).xdir
                END SELECT
                SELECT CASE p(x%).y
                        CASE IS >= 150, IS <= 50: p(x%).ydir = -1 * p(x%).ydir
                END SELECT
                SELECT CASE p(x%).z
                        CASE IS <= -50, IS >= 50: p(x%).zdir = -1 * p(x%).zdir
                END SELECT
               
                nx% = p(x%).x + cost(WorldAngle%) * p(x%).z
                ny% = p(x%).y + sint(WorldAngle%) * p(x%).z
               
                SELECT CASE p(x%).Col
                        CASE 1: IF XTog% = 0 THEN ok% = 1
                        CASE 5: IF YTog% = 0 THEN ok% = 1
                        CASE 4: IF ZTog% = 0 THEN ok% = 1
                END SELECT
                IF ok% = 1 THEN
                        IF POINT(nx%, ny%) = 0 THEN PSET (nx%, ny%), p(x%).Col
                END IF
                ok% = 0
        NEXT

        AssembleArena

        a$ = INKEY$
        SELECT CASE UCASE$(a$)
                CASE "+": speed% = speed% + 1
                CASE "-": speed% = speed% - 1
                CASE "P": Pause% = Pause% XOR 1
                CASE "X": XTog% = XTog% XOR 1
                CASE "Y": YTog% = YTog% XOR 1
                CASE "Z": ZTog% = ZTog% XOR 1
                CASE "?": Controls
                CASE CHR$(27): EXIT DO
        END SELECT
      
        PCOPY 2, 0

        WorldAngle% = WorldAngle% + speed%
        SELECT CASE WorldAngle%
                CASE IS >= 360: WorldAngle% = 0
                CASE IS < 0: WorldAngle% = 360
        END SELECT
       

LOOP

CLS
SCREEN 0
WIDTH 80
PRINT
PRINT "http://members.aol.com/mkwebsite/index.html"
SYSTEM

BoxData:
DATA 110,50,50, 210,50,50, 110,150,50, 210,150,50
DATA 110,50,-50, 210,50,-50, 110,150,-50, 210,150,-50

ConnectData:

' front face connects
DATA 1,2, 3,4, 1,3, 2,4

'back face connects
DATA 5,6, 7,8, 5,7, 6,8

'interplane connects
DATA 1,5, 2,6, 3,7, 4,8

REM $STATIC
DEFSNG A-Z
SUB AssembleArena
FOR x% = 0 TO 11
        ptr1% = Drawlist(x%).a
        ptr2% = Drawlist(x%).B
        LINE (Arena(ptr1%).x + cost(WorldAngle%) * Arena(ptr1%).z, Arena(ptr1%).y + sint(WorldAngle%) * Arena(ptr1%).z)-(Arena(ptr2%).x + cost(WorldAngle%) * Arena(ptr2%).z, Arena(ptr2%).y + sint(WorldAngle%) * Arena(ptr2%).z), 31
NEXT
END SUB

SUB BuildTables
        FOR Angle% = 0 TO 360
                sint(Angle%) = SIN(Angle% * pi / 180)
                cost(Angle%) = COS(Angle% * pi / 180)
        NEXT
END SUB

DEFINT A-Z
SUB Controls
LOCATE 6, 2
LINE (10, 30)-(280, 130), 0, BF
COLOR 4
PRINT "   Key            Effect"
COLOR 15
PRINT
PRINT "  + or -  : Increase/Decrease"
PRINT "            cube rotation speed"
PRINT
PRINT "     P    : Toggle paused pixels."
PRINT "     X    : Toggle X-Axis bouncing"
PRINT "     Y    : Toggle Y-Axix bouncing"
PRINT "     Z    : Toggle Z-Axis bouncing"
LINE (10, 30)-(280, 130), 15, B
PCOPY 2, 0
DO: LOOP UNTIL INKEY$ <> ""
END SUB

DEFSNG A-Z
SUB LoadArena

        RESTORE BoxData
        FOR x% = 0 TO 7
                READ Arena(x%).x, Arena(x%).y, Arena(x%).z
        NEXT

        RESTORE ConnectData
        FOR x% = 0 TO 11
                READ Drawlist(x%).a, Drawlist(x%).B
                Drawlist(x%).a = Drawlist(x%).a - 1
                Drawlist(x%).B = Drawlist(x%).B - 1
        NEXT
END SUB

