/*
 * File: FTRIV.H                    Copyright (c) 1992-1995 by Farwest BBS
 * Date: February 27, 1995                     All Rights Reserved
 * Author: Aaron Sundberg
 *
 * Comments: Routines exported by Farwest Trivia for use by other developers.
 *
 * Each routine has the following form:
 *
 *   FW_ftriv_xx...xx(int usrno, int othusrno);
 *
 *   where "usrno" is the user number doing the forgetting/ignoring/etc.
 *         "othusrno" is user number being forgotten/ignored/etc.
 *
 */

#ifndef _FTRIV_H
#define _FTRIV_H

#ifdef __cplusplus
extern "C" {
#endif

void FW_ftriv_forget(int usrno, int othusrno);
void FW_ftriv_remember(int usrno, int othusrno);
int FW_ftriv_forgotten(int usrno, int othusrno);

void FW_ftriv_ignore(int usrno, int othusrno);
void FW_ftriv_notice(int usrno, int othusrno);
int FW_ftriv_ignored(int usrno, int othusrno);

#ifdef __cplusplus
};
#endif

#endif

