Imports System.Net.Sockets
Imports System.Threading

Public Class telnet
    Dim NetStream As NetworkStream()
    Public active As Boolean
    Dim MainLoop As Thread
    Dim CleanupLoop As Thread
    Public Activated As Short
    Private CitCollection As Collection
    Public SystemStatus As String
    Private CitadelStatus As String
    Private ErrCatch As Boolean
    Const cr As String = Chr(13) & Chr(10)
    Dim UpTime As Date
    Dim LoginCounter As Integer
    Private LastLogIn As String
    Private ErrMsg As String
    Private ConnectionCount As Integer

    Sub New()
        'Default constructor.
        Dim i As Short
        ErrCatch = False
        LastLogIn = " "
        LoginCounter = 0
        CitCollection = New Collection()
        Activated = 0
        MainLoop = New Thread(AddressOf Init)
        CleanupLoop = New Thread(AddressOf CleanCollection)
        MainLoop.Start()
        CleanupLoop.Start()
    End Sub

    Sub Init()
        '02Mar16 - DRB  
        'Init - Main loop for accepting new connections and starting a new instance of citadel
        '02Mar16 - DRB
        '   Cleaned up code a little bit.

        UpTime = Now()
        active = True
        ConnectionCount = 0
        Dim myListener As New TcpListener(23)
        myListener.Start()
        Dim MySocket As Socket
        Dim Cit As Citadel
        While active
            Try
                MySocket = myListener.AcceptSocket()
                Cit = New Citadel(MySocket)
                Cit.InitCitadel()
                CitCollection.Add(Cit)
                ConnectionCount += 1
                Thread.Sleep(1000)        'in case we're being bombarded with connections...  -DRB 02Mar21
                While CitCollection.Count > MaxConnections
                    Thread.Sleep(100)
                End While
            Catch e As Exception
                ErrCatch = True
                ErrMsg = e.ToString & Now & cr
            End Try
        End While

        myListener.Stop()
    End Sub
    Private Sub CleanCollection()
        'CleanCollection
        '   This sub passes information between various instances of Citadel and scavanges old instances
        '02Mar16 - DRB
        '   Cleaned up code.
        Dim a, i, ii As Integer
        'Dim t As Single
        Dim x, y As Citadel
        Dim ut As String
        While True
            Thread.Sleep(50)            'pause at the start of the loop, not the bottom -DRB 02Mar21
            ut = "Uptime : " & DateDiff(Microsoft.VisualBasic.DateInterval.Day, UpTime, Now) & " Days, " _
                & DateDiff(Microsoft.VisualBasic.DateInterval.Hour, UpTime, Now) Mod 24 & " Hours, " _
                & DateDiff(Microsoft.VisualBasic.DateInterval.Minute, UpTime, Now) Mod 60 & " Minutes" & cr
            ut &= "Current Connection Count:  " & CitCollection.Count & cr  'Try to figure out the excess CPU ussage.  Rogue connections?  -DRB 02Mar21
            ut &= "Total Connection Count: " & ConnectionCount & cr
            ut &= "Login Count : " & LoginCounter & cr & "Last Login : " & LastLogIn & cr
            CitadelStatus = ut & "Users:" & CRLF
            SystemStatus = ut & cr & ErrMsg


            Try
                If CitCollection.Count > 0 Then
                    For i = CitCollection.Count To 1 Step -1
                        x = CitCollection.Item(i)
                        If x.active Then
                            If x.User.LoggedIn Then
                                SystemStatus &= "User : " & x.User.aliasclean & "      Idle : " & DateDiff(Microsoft.VisualBasic.DateInterval.Minute, x.Idle, Now)
                                CitadelStatus &= "User : " & x.User.aliasclean & "      Idle : " & DateDiff(Microsoft.VisualBasic.DateInterval.Minute, x.Idle, Now)
                                LoginCounter = LoginCounter + x.LoginCount
                                If x.LoginCount = 1 Then LastLogIn = x.User.aliasclean & " @ " & CitDateFormat(Now)
                                x.LoginCount = 0
                                'Pass chat messages between instances of Citadel.
                                If x.ChatOut <> "" Then
                                    For Each y In CitCollection
                                        If y.InChat Then
                                            y.ChatIn = y.ChatIn & "<" & x.User.aliasclean & "> " & x.ChatOut & CRLF
                                        End If
                                    Next
                                    x.ChatOut = ""
                                End If
                                If x.InChat Then
                                    SystemStatus &= " In Chat"
                                    CitadelStatus &= " In Chat"
                                End If
                                SystemStatus &= cr
                                CitadelStatus &= CRLF
                            End If
                        End If
                        If x.CitSocket.Connected = False Then  'Or x.CitadelThread.IsAlive = False Then
                            x.ShutDown()                    'terminate threads before closing citadel.
                            CitCollection.Remove(i)
                        End If
                    Next
                    ' Now that we have the status of everyone, relay it to each instance
                    For Each x In CitCollection
                        x.SystemStatus = CitadelStatus
                    Next
                End If
            Catch e As Exception
                ErrMsg = e.ToString
            End Try

        End While

    End Sub
End Class
