Imports System.Data.SqlClient
Imports System.Data.OleDb

Public Class CitadelRoom
    Dim RoomCmd As OleDbDataAdapter
    Private oUser As CitadelUser
    Private UserRoomSet As Collection
    Private Index As Integer
    Private HighestMsg As Integer
    Private myOleDbConnection As OleDbConnection
    Private History As Collection
    Private CurrentRoom As Integer

    Sub SetUser(ByRef su As CitadelUser)
        oUser = su
    End Sub
    Sub New()
        Index = 0
        UserRoomSet = New Collection()
        History = New Collection()
        myOleDbConnection = New OleDbConnection(CitadelConnString)
        myOleDbConnection.Open()
    End Sub
    Public Sub CreateRoom(ByVal NewRoomName As String, ByVal NewRoomInfo As String)
        'create room
        NewRoomInfo = Replace(NewRoomInfo, "<", "&lt")
        NewRoomInfo = Replace(NewRoomInfo, ">", "&gt")
        NewRoomInfo = Replace(NewRoomInfo, Chr(13), "<BR>")
        NewRoomInfo = Replace(NewRoomInfo, Chr(10), "")
        NewRoomInfo = QuickEdit(MakeSafeForDOM(NewRoomInfo))
        NewRoomName = Replace(NewRoomName, Chr(13), "")
        NewRoomName = Replace(NewRoomName, Chr(10), "")
        NewRoomName = QuickEdit(MakeSafeForDOM(NewRoomName))

        Dim CreateRoomCmd As New OleDbCommand("INSERT INTO room (name, nameclean, info) VALUES ('" & NewRoomName & "', '" & NewRoomName & "', '" & NewRoomInfo & "')", myOleDbConnection)
        CreateRoomCmd.ExecuteNonQuery()
        Dim myOleDbCommand As New OleDbDataAdapter("Select roomID FROM room where nameClean = '" & NewRoomName & "'", myOleDbConnection)
        Dim dtSet As DataSet
        Dim oRecords As DataTable
        Dim roomID As Integer

        dtSet = New DataSet()
        Try
            myOleDbCommand.Fill(dtSet)
            oRecords = New DataTable()
            oRecords = dtSet.Tables(0)
            roomID = oRecords.Rows(0).Item("roomID")
            oRecords.Clear()
            myOleDbCommand = New OleDbDataAdapter("Select userID from [User]", myOleDbConnection)
            dtSet.Clear()
            myOleDbCommand.Fill(dtSet)
            oRecords = New DataTable()
            oRecords = dtSet.Tables(0)
            Dim i As Integer
            For i = 0 To oRecords.Rows.Count - 1
                CreateRoomCmd.CommandText = "INSERT INTO UserRoom (userID, roomID, hasAccess) VALUES (" & oRecords.Rows(i).Item("userID") & "," & roomID & ", true)"
                Debug.WriteLine("INSERT INTO UserRoom (userID, roomID, hasAccess) VALUES (" & oRecords.Rows(i).Item("userID") & "," & roomID & ", true)")
                CreateRoomCmd.ExecuteNonQuery()
            Next
        Catch e As Exception
            Debug.WriteLine(e)
        End Try
        Dim NewRoom As New UserRoomList(NewRoomName, RoomID, 0, 0)
        UserRoomSet.Add(NewRoom)
        CurrentRoom = UserRoomSet.Count
    End Sub
    Public Sub GotoNext(ByVal skip As Boolean, ByVal LoggedIn As Boolean)
        Dim myCommand As OleDbCommand
        Dim squery As String

        If LoggedIn Then
            If Not skip Then
                'update pointer\
                UserRoomSet.Item(CurrentRoom).pointer = Highest()
            End If
            CurrentRoom = NextEmpty()
            UpdateHistory()
            HighestMsg = Highest()
        Else
            '    'do nothing at this point...
        End If
    End Sub
    Public Sub LoadRooms(ByVal UserID As Integer, ByVal LoggedIn As Boolean)
        Dim myDataReader As OleDbDataReader
        Dim myOleDbCommand As OleDbCommand
        If LoggedIn Then
            myOleDbCommand = New OleDbCommand("SELECT roomId, Pointer, lastpointer, nameClean as name, isForgotten AS Forgotten FROM Query_UserRoom WHERE roomId = Room.roomId AND userId=" & oUser.UserID & " AND (hasAccess OR cosysop) ORDER BY roomID", myOleDbConnection)
            UserRoomSet = New Collection()
            'myOleDbConnection.Open()
            myDataReader = myOleDbCommand.ExecuteReader()

            Do While myDataReader.Read()
                Dim uRoom As New UserRoomList(myDataReader.Item("name"), myDataReader.Item("roomID"), _
                         myDataReader.Item("pointer"), myDataReader.Item("lastPointer"))
                UserRoomSet.Add(uRoom)
            Loop
            myDataReader.Close()
        Else
            myOleDbCommand = New OleDbCommand("Select * from Room where private = false", myOleDbConnection)
            UserRoomSet = New Collection()
            '            .Open()
            myDataReader = myOleDbCommand.ExecuteReader()

            Do While myDataReader.Read()
                Dim uRoom As New UserRoomList(myDataReader.Item("nameClean"), myDataReader.Item("roomID"), 0, 0)
                UserRoomSet.Add(uRoom)
            Loop
            myDataReader.Close()
        End If

        If UserRoomSet.Count > 0 Then CurrentRoom = 1 Else CurrentRoom = 0
        History = New Collection()
        UpdateHistory()
    End Sub
    Public Sub SaveMessage(ByVal userid As Integer, ByVal message As String, ByVal html As Boolean, ByVal recipID As Integer)
        Dim cleanmessage As String
        Dim nRecipientId As Integer
        Dim a As String

        While Right(message, 1) = Chr(13)
            message = Left(message, Len(message) - 1)
        End While

        If html = False Then
            message = Replace(message, "<", "&lt")
            message = Replace(message, ">", "&gt")
        End If

        message = Replace(message, Chr(13), "<BR>")
        message = Replace(message, Chr(10), "")
        cleanmessage = QuickEdit(MakeSafeForDOM(message))
        nRecipientId = Nothing
        '        If HighestRead < oRoom.HighestMessage(ctc) Then d = True
        If Len(cleanmessage) > 0 Then
            If recipID > 0 Then
                a = "INSERT INTO message (userId, dateStamp, msg, roomId, toUserID) VALUES (" & oUser.UserID & ", '" & Now() & "', '" & MakeSafeForDB(cleanmessage) & "', " & UserRoomSet.Item(CurrentRoom).roomId & " , " & recipID & " )"
            Else
                a = "INSERT INTO message (userId, dateStamp, msg, roomId) VALUES (" & oUser.UserID & ", '" & Now() & "', '" & MakeSafeForDB(cleanmessage) & "', " & UserRoomSet.Item(CurrentRoom).roomId & ")"
            End If
            Debug.WriteLine(a)
            Dim myOleDbCommand As New OleDbCommand(a, myOleDbConnection)
            myOleDbCommand.ExecuteNonQuery()
        End If
        'If d Then oRoom.HighestRead = oRoom.HighestMessage(ctc)

    End Sub
    Public Function GetRoomID()
        GetRoomID = UserRoomSet.Item(CurrentRoom).roomID
    End Function
    Public Sub LogToAide(ByVal message As String, ByVal sysopID As Integer, ByVal aideID As Integer)
        Dim cleanmessage As String
        Dim nRecipientId As Integer
        Dim a As String

        While Right(message, 1) = Chr(13)
            message = Left(message, Len(message) - 1)
        End While


        message = Replace(message, Chr(13), "<BR>")
        message = Replace(message, Chr(10), "")
        cleanmessage = QuickEdit(MakeSafeForDOM(message))
        nRecipientId = Nothing
        '        If HighestRead < oRoom.HighestMessage(ctc) Then d = True
        If Len(cleanmessage) > 0 Then
            a = "INSERT INTO message (userId, dateStamp, msg, roomId) VALUES (" & sysopID & ", '" & Now() & "', '" & MakeSafeForDB(cleanmessage) & "', " & aideID & ")"
            Debug.WriteLine(a)
            Dim myOleDbCommand As New OleDbCommand(a, myOleDbConnection)
            myOleDbCommand.ExecuteNonQuery()
        End If
        'If d Then oRoom.HighestRead = oRoom.HighestMessage(ctc)

    End Sub

    Public Sub UpdateMsgPointers()
        Dim myDataReader As OleDbDataReader
        'Dim myOleDbConnection As OleDbConnection
        Dim myOleDbCommand As OleDbCommand
        Dim x As UserRoomList
        'myOleDbConnection = New OleDbConnection(CitadelConnString)
        '      myOleDbConnection.Open()
        For Each x In UserRoomSet
            myOleDbCommand = New OleDbCommand("UPDATE UserRoom set pointer= " & x.Pointer & " , lastpointer=" & x.lastPointer & " where UserID=" & oUser.UserID & " and RoomID=" & x.roomID, myOleDbConnection)
            myOleDbCommand.ExecuteNonQuery()
        Next
    End Sub
    Public Sub Ungoto()
        If History.Count > 1 Then
            History.Remove(History.Count)
            CurrentRoom = History.Item(History.Count).room
            UserRoomSet.Item(CurrentRoom).pointer = History.Item(History.Count).pointer
            UserRoomSet.Item(CurrentRoom).lastpointer = History.Item(History.Count).lastpointer
        End If
    End Sub
    Public Function GetName() As String
        Dim cRoom As UserRoomList
        If CurrentRoom > 0 And CurrentRoom < UserRoomSet.Count Then
            cRoom = UserRoomSet.Item(CurrentRoom)
            GetName = cRoom.roomName
        Else
            GetName = "Room Not Found!"
        End If
    End Function
    Public Function GetMessages(ByRef rang As Short, ByRef ord As Short, ByRef LastOld As Boolean, ByRef Mail As Short, ByRef uID As Object) As String
        Dim dtCmd As OleDbDataAdapter
        Dim dtConn As New OleDbConnection(CitadelConnString)
        dtConn.Open()
        Dim dtSet As DataSet
        Dim dtTable As DataTable
        Dim iLoop, iNumRows As Integer
        Dim squery, tmp As String
        Dim MsgList As String

        'dtConn.Open()
        squery = "SELECT * FROM Query_Message WHERE roomID = " & UserRoomSet.Item(CurrentRoom).roomID

        If rang = 0 Then
            If LastOld = True Then
                squery = squery & " AND msgId >= " & "(select pointer from UserRoom where userid=" & oUser.UserID & " and roomid=" & UserRoomSet.Item(CurrentRoom).roomID & ")"
            Else
                squery = squery & " AND msgId > " & "(select pointer from UserRoom where userid=" & oUser.UserID & " and roomid=" & UserRoomSet.Item(CurrentRoom).roomID & ")"
            End If
        End If
        squery = squery & " AND ( AuthorID=" & uID & " OR RecipientID=" & uID & " OR RecipientID IS NULL)"
        squery = squery & " ORDER BY dateStamp"

        If ord = 1 Then
            squery = squery + " DESC"
        End If
        Debug.WriteLine(squery)
        ' Create a Command object with the SQL statement.

        dtCmd = New OleDbDataAdapter(squery, dtConn)

        ' Fill a DataSet with data returned from the database.
        dtSet = New DataSet()

        Try
            dtCmd.Fill(dtSet)

            ' Create a new DataTable object and assign to it
            ' the new table in the Tables collection.
            dtTable = New DataTable()
            dtTable = dtSet.Tables(0)
            ' Find how many rows are in the Rows Collection 
            ' of the new DataTable object.
            iNumRows = dtTable.Rows.Count
            System.Threading.Thread.Sleep(1)

            If iNumRows = 0 Then
            Else
                For iLoop = 0 To iNumRows - 1
                    ' Print the values of the two columns in the Columns
                    ' Collection for each row.
                    If Mail = UserRoomSet.Item(CurrentRoom).RoomId Then
                        If IsDBNull(dtTable.Rows(iLoop).Item("recipient")) Then
                            MsgList = MsgList & "  " & CitDateFormat(dtTable.Rows(iLoop).Item("dateStamp")) & " from " & dtTable.Rows(iLoop).Item("Author") & " to Citadel" & CRLF & dtTable.Rows(iLoop).Item("msg") & CRLF & CRLF
                        Else
                            MsgList = MsgList & "  " & CitDateFormat(dtTable.Rows(iLoop).Item("dateStamp")) & " from " & dtTable.Rows(iLoop).Item("Author") & " to " & dtTable.Rows(iLoop).Item("recipient") & CRLF & dtTable.Rows(iLoop).Item("msg") & CRLF & CRLF
                        End If
                    Else
                        MsgList = MsgList & "  " & CitDateFormat(dtTable.Rows(iLoop).Item("dateStamp")) & " from " & dtTable.Rows(iLoop).Item("Author")
                        MsgList = MsgList & CRLF & dtTable.Rows(iLoop).Item("msg") & CRLF & CRLF
                    End If
                Next iLoop
            End If
            GetMessages = MsgList
        Catch e As Exception
            GetMessages = MsgList & CRLF & "The system encountered an error" & CRLF & e.ToString & CRLF
        End Try
    End Function
    Public Function GotoRoom(ByVal RoomName As String, ByVal skip As Boolean) As Boolean
        Dim i As Integer
        Dim x As UserRoomList
        Dim continue, result As Boolean
        continue = True
        i = CurrentRoom
        While continue
            i = i + 1
            If i > UserRoomSet.Count Then i = 1
            x = UserRoomSet.Item(i)
            If UCase(x.roomName) Like UCase("*" & RoomName & "*") Then
                continue = False
                result = True
            End If

            If i = CurrentRoom Then
                continue = False
                result = False
            End If

        End While

        If result = True And skip = False Then
            'update pointer
            UserRoomSet.Item(CurrentRoom).pointer = Highest()
        End If
        If result = True Then
            CurrentRoom = i
            UpdateHistory()
        End If
        GotoRoom = result

    End Function
    Public Function Highest() As Integer
        Dim myOleDbCommand As New OleDbDataAdapter("Select msgid from Query_Message where roomID = " & UserRoomSet.Item(CurrentRoom).roomID & " ORDER BY msgId DESC", myOleDbConnection)
        Dim dtSet As DataSet
        Dim oRecords As DataTable

        dtSet = New DataSet()

        Try
            myOleDbCommand.Fill(dtSet)
            oRecords = New DataTable()
            oRecords = dtSet.Tables(0)
            Highest = oRecords.Rows(0).Item("msgid")
            oRecords.Clear()
        Catch e As Exception
            Debug.WriteLine(e)
            Highest = 0
        End Try

        dtSet.Clear()
        myOleDbCommand.Dispose()
    End Function
    Public Function Info() As String
        Dim dtCmd As OleDbDataAdapter
        Dim dtSet As DataSet
        Dim oConn As OleDbConnection
        Dim oRecords As DataTable
        Dim x, i As Integer


        oConn = New OleDbConnection(CitadelConnString)
        dtSet = New DataSet()

        Try
            oConn.Open()
            dtCmd = New OleDbDataAdapter("SELECT info FROM [room] WHERE roomID = " & UserRoomSet.Item(CurrentRoom).roomID, oConn)
            dtCmd.Fill(dtSet)
            oRecords = New DataTable()
            oRecords = dtSet.Tables(0)
            Info = oRecords.Rows(0).Item("info") & CRLF
            oRecords.Clear()
        Catch e As Exception
            Debug.WriteLine(e)
            Info = "Room info not found for " & UserRoomSet.Item(CurrentRoom).roomname & CRLF
        End Try
        ' dtSet.Clear()
        ' dtCmd.Dispose()
        oConn.Close()
    End Function
    Public Function KnownRooms() As String
        Dim knew, knot As String
        Dim i, ii As Integer
        knew = "Rooms with new messages: " & CRLF
        knot = CRLF & CRLF & "Rooms with no new messages: " & CRLF

        i = CurrentRoom
        For CurrentRoom = 1 To UserRoomSet.Count
            If NewMessageCount() > 0 Then
                knew = knew & UserRoomSet.Item(CurrentRoom).roomName & "> "
            Else
                knot = knot & UserRoomSet.Item(CurrentRoom).roomName & "> "
            End If
        Next
        KnownRooms = knew & knot
        CurrentRoom = i
    End Function
    Public Function MessageCount() As Short
        Dim myOleDbCommand As New OleDbDataAdapter("SELECT count(msgid) as c FROM message INNER JOIN UserRoom ON message.roomId = UserRoom.roomid WHERE message.roomId=" & UserRoomSet.Item(CurrentRoom).roomID & " AND UserRoom.userid=" & oUser.UserID & " AND message.userId NOT IN (SELECT plonkUserId FROM Plonk WHERE userId=" & oUser.UserID & ") AND (message.userId=" & oUser.UserID & " OR message.toUserId=" & oUser.UserID & " OR message.toUserId = 0)", myOleDbConnection)
        Dim dtSet As DataSet
        Dim oRecords As DataTable

        dtSet = New DataSet()

        Try
            myOleDbCommand.Fill(dtSet)
            oRecords = New DataTable()
            oRecords = dtSet.Tables(0)
            MessageCount = oRecords.Rows(0).Item("c")
            oRecords.Clear()
        Catch e As Exception
            Debug.WriteLine(e)
            MessageCount = -1
        End Try

        dtSet.Clear()
        myOleDbCommand.Dispose()
    End Function
    Public Function NewMessageCount() As Short
        Dim myOleDbCommand As New OleDbDataAdapter("SELECT count(msgid) as c FROM message INNER JOIN UserRoom ON message.roomId = UserRoom.roomid WHERE message.roomId=" & UserRoomSet.Item(CurrentRoom).roomID & " AND UserRoom.userid=" & oUser.UserID & " AND message.msgid > " & UserRoomSet.Item(CurrentRoom).pointer & " AND message.userId NOT IN (SELECT plonkUserId FROM Plonk WHERE userId=" & oUser.UserID & ") AND (message.userId=" & oUser.UserID & " OR message.toUserId=" & oUser.UserID & " OR message.toUserId = 0)", myOleDbConnection)
        Dim dtSet As DataSet
        Dim oRecords As DataTable

        dtSet = New DataSet()

        Try
            myOleDbCommand.Fill(dtSet)
            oRecords = New DataTable()
            oRecords = dtSet.Tables(0)
            NewMessageCount = oRecords.Rows(0).Item("c")
            oRecords.Clear()
        Catch e As Exception
            Debug.WriteLine(e)
            NewMessageCount = -1
        End Try

        dtSet.Clear()
        myOleDbCommand.Dispose()

    End Function
    Public Function RoomPrompt()
        Dim cRoom As UserRoomList
        If CurrentRoom > 0 And CurrentRoom <= UserRoomSet.Count Then
            cRoom = UserRoomSet.Item(CurrentRoom)
            RoomPrompt = cRoom.roomName & "> "
        Else
            RoomPrompt = "Room Not Found!"
        End If
    End Function
    Private Sub UpdateHistory()
        'history
        Dim a As New RoomHistory(CurrentRoom, UserRoomSet.Item(CurrentRoom).roomID, _
            UserRoomSet.Item(CurrentRoom).pointer, UserRoomSet.Item(CurrentRoom).lastpointer)
        History.Add(a)
    End Sub
    Private Function NextEmpty() As Integer
        Dim a, i, ii As Integer
        Dim continue As Boolean
        continue = True
        i = CurrentRoom
        While continue
            CurrentRoom = CurrentRoom + 1
            If CurrentRoom > UserRoomSet.Count Then
                CurrentRoom = 1
                continue = False
                NextEmpty = CurrentRoom
            End If
            a = NewMessageCount()
            If a > 0 Then
                continue = False
                NextEmpty = CurrentRoom
            End If
        End While
        CurrentRoom = i
    End Function
    Sub Shutdown()
        oUser = Nothing
        UserRoomSet = Nothing
        If myOleDbConnection.State = ConnectionState.Open Then myOleDbConnection.Close()
        History = Nothing
        myOleDbConnection.Dispose()
    End Sub
End Class
