Imports System.IO

Module CitadelGeneral

    Public Const CitadelConnString As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=C:\webadel\db\webadel.mdb"
    Public Const VER As String = "Citadel.NET 1.04"
  Public Const CRLF As String = Chr(13) & Chr(10)
  Public Const BKSP As String = Chr(8) & Chr(32) & Chr(8)
    Public Const MaxConnections As Integer = 30
    Public Sub LogToAide(ByVal message As String)
        'write this latter.
        MsgBox("Write LogToAide function in CitadelGeneral.vb", MsgBoxStyle.Information)
    End Sub
    Public Function Banner(ByVal FileName As String) As String
        '01Oct21  Function created  - DRB
        '   need to add error checking...
        Dim fs As New FileStream(FileName, FileMode.Open, FileAccess.Read)
        Dim r As New StreamReader(fs)
        Banner = r.ReadToEnd
    End Function
    Public Function CitDateFormat(ByVal sdate As Date) As Object
        Dim m As String  '00Nov28 2:53 pm
        'Function imported from Webadel, modified by DRB.
        If Val(CStr(DatePart(Microsoft.VisualBasic.DateInterval.Day, sdate))) < 10 Then
            m = "0"
        Else
            m = ""
        End If
        CitDateFormat = Right(CStr(DatePart(Microsoft.VisualBasic.DateInterval.Year, sdate)), 2) & Mid("JanFebMarAprMayJunJulAugSepOctNovDec", 3 * (DatePart(Microsoft.VisualBasic.DateInterval.Month, sdate) - 1) + 1, 3) & m & DatePart(Microsoft.VisualBasic.DateInterval.Day, sdate) & " " & ((DatePart(Microsoft.VisualBasic.DateInterval.Hour, sdate) + 11) Mod 12) + 1 & ":" & Right("0" & DatePart(Microsoft.VisualBasic.DateInterval.Minute, sdate), 2) & " " & Mid("ampm", 1 + 2 * Int(DatePart(Microsoft.VisualBasic.DateInterval.Hour, sdate) / 12), 2)
    End Function
    Function QuickEdit(ByVal sSource)
        Dim sTextIn, sTextOut, I, sLine, c

        sTextIn = sSource
        For I = 1 To Len(sTextIn)
            c = Mid(sTextIn, I, 1)
            If c = Chr(10) Or c = Chr(13) Or I = Len(sTextIn) Then
                'look at the first character of the line
                Select Case Mid(sLine, 1, 1)
                    Case ">" : sLine = "&gt;<i>" & Mid(sLine, 2) & "</i>"
                    Case Else : sLine = sLine
                End Select
                sTextOut = sTextOut & sLine & c
                sLine = ""
            Else
                sLine = sLine & c
            End If
        Next
        'compensation for the DHTML edit control
        If sTextOut = "<P>&nbsp;</P>" Then sTextOut = ""
        If Left(sTextOut, 3) = "<P>" Then sTextOut = Mid(sTextOut, 4)
        sTextOut = Replace(sTextOut, vbNewLine, "<BR>")
        sTextOut = Replace(sTextOut, "<BR><P>", "<P>")
        QuickEdit = CloseTags(ActiveLinks(sTextOut))

    End Function
    Function CloseTags(ByVal sInputString)
        Dim sTags
        Dim sTemp, sInput, c, I, j
        Dim bInsideTag, bInsideQuotes

        'identify situations where unmatched quotes cause a string tag to fail (the "thaadd" fix)
        bInsideTag = False
        bInsideQuotes = False
        For I = 1 To Len(sInputString)
            c = Mid(sInputString, I, 1)
            If bInsideTag Then
                If bInsideQuotes Then
                    If c = """" Then bInsideQuotes = False
                Else
                    If c = """" Then
                        bInsideQuotes = True
                    ElseIf c = ">" Then
                        bInsideTag = False
                    End If
                End If
            Else
                If c = "<" Then bInsideTag = True
            End If
            sInput = sInput & c
        Next
        If bInsideQuotes Then sInput = sInput & """>"

        'convert string to array, strip excessive chars
        sTags = Split(sInput, "<")  'xxxx <xx xx="xx">xxx</xx> xxx'
        For I = 1 To UBound(sTags)
            sTemp = sTags(I) & " "
            sTemp = Left(sTemp, InStr(sTemp, " ") - 1) & ">"
            sTemp = Left(sTemp, InStr(sTemp, ">") - 1)
            sTags(I) = UCase(sTemp)
        Next

        'cancel tags that are already closed
        For I = 1 To UBound(sTags)
            If sTags(I) <> Nothing Then
                For j = I + 1 To UBound(sTags)
                    If sTags(I) = Mid(sTags(j), 2) And Mid(sTags(j), 1, 1) = "/" Then   'added second condition [jj 01May21]
                        sTags(I) = Nothing
                        sTags(j) = Nothing
                        Exit For    'added [jj 99Dec26]
                    End If
                Next
            End If
        Next

        'close remaining tags that are not already closed
        sTemp = Nothing
        For I = UBound(sTags) To 1 Step -1
            If Left(sTags(I), 1) <> "/" And sTags(I) <> Nothing Then
                If sTags(I) <> "BR" And sTags(I) <> "P" And sTags(I) <> "HR" Then 'ignore <hr>, <br> and <p>
                    sTemp = sTemp & "</" & sTags(I) & ">"
                End If
            End If
        Next

        sTemp = sInput & sTemp
        sTemp = Replace(sTemp, "<plaintext", "<!plaintext") 'remove "plaintext" tag
        sTemp = Replace(sTemp, "<noscript", "<!noscript") 'remove "noscript" tag

        'catch tags left open at end of string
        If InStrRev(sTemp, ">") < InStrRev(sTemp, "<") Then sTemp = sTemp & ">"

        CloseTags = sTemp
    End Function
    Function MakeSafeForDB(ByVal sSource)
        If sSource = Nothing Then Exit Function
        MakeSafeForDB = Replace(Replace(sSource, "|", "&#124;"), "'", "''")
    End Function

    Function MakeSafeForDOM(ByVal sSource)
        Dim I, c, sOutput
        For I = 1 To Len(sSource)
            c = Mid(sSource, I, 1)
            If Asc(c) < 32 And Asc(c) <> 13 And Asc(c) <> 10 Then
                sOutput = sOutput & " "
            Else
                sOutput = sOutput & c
            End If
        Next
        MakeSafeForDOM = sOutput
    End Function



    Private Function ActiveLinks(ByVal sInput)
        Dim sText, sOutput, sInputPrime
        Dim bInHTML, bInQuotes
        Dim I, j, cOrig, cNew, nStart, nEnd
        Dim vEndString, sLink
        Dim sEndStrings() As String = {" ", Chr(13), Chr(10), Chr(8), ", ", ". ", "? ", "! "}

        'sInvalidURLChars = " `!@$^*()\|[]{};'"",<>" & Chr(13) & Chr(10) & Chr(8) 'removed underscore [jj 00Oct15]

        'obliterate existing anchor tags and their contents
        sInputPrime = sInput & " "
        nEnd = 1
        Do
            nStart = InStr(nEnd, LCase(sInput), "<a ")
            If nStart > 0 Then
                nEnd = InStr(nStart, LCase(sInput), "</a")
                sInputPrime = Mid(sInputPrime, 1, nStart + 1) & Space(nEnd - nStart - 1) & Mid(sInputPrime, nEnd + 1)
            End If
        Loop While nStart > 0
        'obfuscate remaining HTML (but maintaining string length for ordinal reference reasons)
        bInHTML = False
        bInQuotes = False
        For I = 1 To Len(sInputPrime)
            cOrig = Mid(sInputPrime, I, 1)
            If bInHTML And bInQuotes Then
                cNew = " "
                If cOrig = """" Then
                    bInQuotes = False
                End If
            ElseIf bInHTML And Not bInQuotes Then
                cNew = " "
                If cOrig = """" Then
                    bInQuotes = True
                ElseIf cOrig = ">" Then
                    bInHTML = False
                End If
            ElseIf Not bInHTML And Not bInQuotes Then
                cNew = cOrig
                If cOrig = "<" Then
                    cNew = " "
                    bInHTML = True
                End If
            End If
            sText = sText & cNew
        Next

        'iteratively search for http://
        For I = 1 To Len(sText)
            If LCase(Mid(sText, I, 7)) = "http://" Then
                nStart = I
                j = nStart + 7
                nEnd = 0
                Do
                    For Each vEndString In sEndStrings
                        If Mid(sText, j, Len(vEndString)) = vEndString Then nEnd = j - 1
                    Next
                    j = j + 1
                Loop While j < Len(sText) And nEnd = 0
                If nEnd = 0 Then nEnd = j
                sLink = Mid(sText, nStart, nEnd - nStart + 1)
                sOutput = sOutput & "<a href=""" & sLink & """>" & sLink & "</a>"
                I = nEnd
            Else
                sOutput = sOutput & Mid(sInput, I, 1)
            End If
        Next
        sOutput = Replace(sOutput, "<A ", "<a ")
        ActiveLinks = Replace(sOutput, "<a ", "<a target=""_blank"" ")
    End Function
    Public Function back(ByVal count As Integer) As String
        Dim i As Integer
        If count < 1 Then
            back = ""
        Else
            For i = 1 To count
                back = back & BKSP
            Next
        End If
    End Function

End Module