Imports System.Data.SqlClient
Imports System.Threading
Imports System.Net.Sockets
Imports System.IO

Public Class Citadel
    Public active As Boolean
    Public Idle As Date
    Public CitSocket As Socket
    Public CitadelThread As Thread
    Private LiveThread As Thread
    Public LoginCount As Integer
    Private DataIn As String
    Private DataOut As String
    Private DataStream As NetworkStream
    Private TerminateQuit As Boolean
    Private CitSystem As CitadelSystem
    Public User As CitadelUser
    Private Room As CitadelRoom
    Public Uptime As Date
    Public SystemStatus As String
    Public prompt, messages As Boolean
    Public InChat As Boolean
    Public ChatIn As String
    Public ChatOut As String

    Sub New()
        active = False
        User = New CitadelUser()
        Room = New CitadelRoom()
        SystemStatus = ""
        CitadelThread = New Thread(New ThreadStart(AddressOf CitadelMain))
        LiveThread = New Thread(New ThreadStart(AddressOf Alive))
    End Sub
    Sub New(ByVal NewSocket As Socket)
        MyBase.new()
        active = False
        User = New CitadelUser()
        Room = New CitadelRoom()
        SystemStatus = ""
        CitSocket = NewSocket
        CitadelThread = New Thread(New ThreadStart(AddressOf CitadelMain))
        LiveThread = New Thread(New ThreadStart(AddressOf Alive))
    End Sub
    Private Sub Alive()
        'check for difference in time... more than timeout and we abort...
        Idle = Now
        Dim continue As Boolean = True
        While continue
            If DateDiff(Microsoft.VisualBasic.DateInterval.Minute, Idle, Now) > User.timeOut Then
                CitSocket.Shutdown(SocketShutdown.Both)
                CitSocket.Close()
                CitadelThread.Abort()
                continue = False
            End If
            Thread.Sleep(10000)
        End While
    End Sub
    Private Sub CitadelMain()
        Dim CitConnectionString As String
        CitConnectionString = Chr(255) & Chr(252) & Chr(24)  ' Won't negotiate Terminal Type
        CitConnectionString = CitConnectionString & Chr(255) & Chr(252) & Chr(31)   ' Won't negotiate Terminal size
        CitConnectionString = CitConnectionString & Chr(255) & Chr(251) & Chr(1)   ' Will echo
        Say(CitConnectionString)
        User.init()
        Dim x As String
        Say(Banner("banner.txt") & CRLF & CitSystem.SystemName & CRLF & "Running: " & VER & CRLF & "  " & CitDateFormat(Now()) & CRLF & CRLF)
        TerminateQuit = False
        RoomPrompt()
        Say(Banner("LogOut.txt") & CRLF)
        Thread.Sleep(2000)
        CitSocket.Shutdown(SocketShutdown.Both)
        CitSocket.Close()
        active = False
    End Sub
    Public Sub Close()
        If CitadelThread.IsAlive = True Then
            CitadelThread.Abort()
        End If
        active = False
    End Sub
    Private Sub CreateNewUser()
        Dim complete As Boolean = False
        'get user name, password...
        While complete = False
            Say(CRLF & "User Name : ")
            User.aliasclean = GetString()
            Say("Password : ")
            User.Password = GetString()
            'validate alias, password...
            If User.Check() = False Then
                Say(CRLF & "Bad User Name or Password" & CRLF & "Abort? [Y/n] ")
                complete = GetBool(True)
            Else
                Say("Are you an experianced Citadel user? [y/N] ")
                User.expert = GetBool(False)
                Say("Pause after each full screen of text? [Y/n] ")
                If GetBool(True) Then User.PageLength = 24 Else User.PageLength = 0

                Say(CRLF & "Create new user?  [Y/n]")
                If GetBool(True) Then
                    complete = True
                    User.Add()
                    Room.LogToAide("Citadel.NET:  New User account created for " & User.aliasclean, CitSystem.SysopID, CitSystem.AideID)
                Else
                    complete = False
                    User.aliasclean = ""
                    User.Password = ""
                End If
            End If
        End While
    End Sub
    Private Function DotCommand() As Boolean
        Dim x As String
        Dim continue As Boolean = True
        While continue
            x = GetCh()
            If Asc(x) > 0 Then
                Select Case UCase(x)
                    Case "G"
                        Say("Goto ")
                        Room.GotoRoom(GetString(), False)
                        DotCommand = True
                        continue = False
                        messages = True

                    Case "S"
                        Say("Skip ")
                        Room.GotoRoom(GetString(), True)
                        DotCommand = True
                        continue = False
                        messages = True
                    Case "E"
                        Say("Enter ")
                        continue = Not (DotEnter())
                        If continue = False Then
                            DotCommand = True
                        End If
                    Case "R"
                        Say("Read ")
                        continue = Not (DotRead())
                        If continue = False Then
                            DotCommand = True
                        End If
                    Case Chr(8)
                        Say(BKSP & BKSP)
                        DotCommand = False
                        continue = False
                    Case Else
                        Say(" ")
                        DotCommand = True
                End Select
            Else
                DotCommand = False
            End If
        End While
    End Function
    Private Function DotRead() As Boolean
        Dim x As String
        Dim continue As Boolean = True
        While continue
            x = GetCh()
            If Asc(x) > 0 Then
                Select Case UCase(x)
                    Case Chr(8)
                        Say(BKSP & BKSP & BKSP & BKSP & BKSP)
                        DotRead = False
                        continue = False
                    Case "N"    'read new messages
                        If User.LoggedIn Then
                            Say(BKSP & BKSP & BKSP & BKSP & BKSP)
                            ReadMsg(1)
                            DotRead = True
                            continue = False
                        End If
                    Case "X"
                        If User.LoggedIn Then
                            'read HTML in new messages
                            Say(BKSP & BKSP & BKSP & BKSP & BKSP)
                            ReadMsg(4)
                            DotRead = True
                            continue = False
                        End If
                    Case "R"
                        If User.LoggedIn Then
                            'read Reverse
                            Say(BKSP & BKSP & BKSP & BKSP & BKSP)
                            ReadMsg(3)
                            DotRead = True
                            continue = False
                        End If
                    Case "F"
                        If User.LoggedIn Then
                            'read Forward
                            Say(BKSP & BKSP & BKSP & BKSP & BKSP)
                            ReadMsg(2)
                            DotRead = True
                            continue = False
                        End If
                    Case "S"
                        If User.LoggedIn Then
                            'read Forward
                            Say("System Status" & CRLF & CRLF & CitSystem.SystemName & CRLF)
                            Say("Running : " & VER & CRLF)
                            Say(SystemStatus & CRLF)
                            DotRead = True
                            continue = False
                        End If

                End Select
            Else
            End If
        End While

    End Function
    Private Function DotEnter() As Boolean
        Dim x As String
        Dim continue As Boolean = True
        While continue
            x = GetCh()
            If Asc(x) > 0 Then
                Select Case UCase(x)
                    Case Chr(8)
                        Say(BKSP & BKSP & BKSP & BKSP & BKSP & BKSP)
                        DotEnter = False
                        continue = False
                    Case "C"
                        Say("Configuration ")
                        If DotEnterConfiguration() Then
                            DotEnter = True
                            continue = False
                        End If
                    Case "M"
                        DotEnter = True
                        continue = False
                        If User.LoggedIn Then
                            Say("Message" & CRLF)
                            EnterMessage()
                        End If
                    Case "R"
                        DotEnter = True
                        continue = False
                        If User.LoggedIn Then
                            Say("Room" & CRLF)
                            EnterRoom()
                        End If

                    Case Else
                End Select
            Else
            End If
        End While
    End Function
    Private Function DotEnterConfiguration() As Boolean
        Dim x As String
        Dim continue As Boolean = True
        While continue
            x = GetCh()
            If Asc(x) > 0 Then
                Select Case UCase(x)
                    Case Chr(8)
                        Say(BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP & BKSP)
                        DotEnterConfiguration = False
                        continue = False
                    Case "?"
                        Say("Help" & CRLF & Banner("DotEnterConfiguration.txt") & CRLF)
                        DotEnterConfiguration = True
                        continue = False
                    Case "E"
                        Say("Expert" & CRLF)
                        If User.expert Then
                            User.expert = False
                            Say("Expert now OFF" & CRLF)
                            DotEnterConfiguration = True
                            continue = False
                        Else
                            User.expert = True
                            Say("Expert now ON" & CRLF)
                            DotEnterConfiguration = True
                            continue = False
                        End If
                    Case "P"
                        Say("PageLength" & CRLF & "Enter New Pagelength (0 to disable) : ")
                        Dim pl As String
                        pl = GetString()
                        If IsNumeric(pl) Then
                            User.PageLength = Val(pl)
                            User.update()
                        Else
                            Say("Invalid amount" & CRLF)
                        End If
                        continue = False
                        DotEnterConfiguration = True
                    Case "T"
                        Say("TimeOut" & CRLF & "Enter New timeout duration in minutes : ")
                        Dim pl As String
                        pl = GetString()
                        If IsNumeric(pl) Then
                            If Val(pl) < 200 Then
                                User.timeOut = Val(pl)
                                User.update()
                            Else
                                Say("200 Minutes maximum!" & CRLF)
                            End If
                        Else
                            Say("Invalid amount" & CRLF)
                        End If
                        continue = False
                        DotEnterConfiguration = True
                    Case Else
                End Select
            Else
            End If
        End While
    End Function
    Public Sub InitCitadel()
        'prepare everything...

        active = True
        TerminateQuit = False
        CitSystem = New CitadelSystem()
        CitSystem.InitSystem()
        '        CitadelThread = New Thread(New ThreadStart(AddressOf CitadelMain))
        CitadelThread.Name = "CitThread started at " & Now()
        CitadelThread.Start()
        '        LiveThread = New Thread(New ThreadStart(AddressOf Alive))
        LiveThread.Name = "CitLiveThread started at " & Now()
        LiveThread.Start()
        DataStream = New NetworkStream(CitSocket)
    End Sub
    Private Sub EnterMessage()
        Dim complete As Boolean
        Dim mail As Boolean
        Dim recip As String
        Dim recipID As Integer
        Dim message As String = ""
        If Room.GetRoomID = CitSystem.MailID Then mail = True
        complete = False
        If mail Then
            Say("Enter recipient :")
            recip = GetString()
            If UCase(recip) = "CITADEL" And User.aide Then
                recipID = -1
            Else
                recipID = User.CheckRecip(recip)
                Debug.WriteLine(recip & "  " & recipID)
                If recipID < 0 Then
                    Say("User not found." & CRLF)
                    Exit Sub
                End If
            End If

            Say(CRLF & "   " & CitDateFormat(Now()) & " from " & User.aliasclean & " to " & recip & CRLF)
        Else
            recipID = 0
            Say(CRLF & "   " & CitDateFormat(Now()) & " from " & User.aliasclean & CRLF)
        End If
        While complete = False
            message = GetMessage(message)
            If Len(message) = 2 And message = CRLF Then complete = True
            If Len(message) >= 4 Then
                If Right(message, 4) = CRLF & CRLF Then
                    'Save Message menu...
                    message = SaveMessageMenu(message, recipID, recip)
                    If Len(message) = 0 Then complete = True
                    If complete = False Then message = Left(message, Len(message) - 4)
                End If
            End If
        End While
    End Sub
    Private Sub EnterRoom()
        Say("New Room Name: ")
        Dim NewRoomName As String = GetString()
        If Len(NewRoomName) > 0 Then
            Say("Enter info for new room: ")
            Dim NewRoomInfo As String = GetString()
            Room.CreateRoom(NewRoomName, NewRoomInfo)
        End If
    End Sub
    Private Function SaveMessageMenu(ByVal message As String, ByVal recipid As Integer, ByVal recip As String) As String
        Dim EnterPrompt As String
        If User.expert Then
            EnterPrompt = "Enter Message : "
        Else
            EnterPrompt = "<S>ave, <C>ontinue, <A>bort, <H>elp" & CRLF & "Enter Message : "
        End If
        Say("Enter Message : ")
        Dim continue As Boolean = True
        While continue
            Select Case UCase(GetCh())
                Case "H", "?"
                    Say("Help!" & CRLF & Banner("savemenu.txt"))
                    Say(CRLF & EnterPrompt)
                Case "S"
                    Say("Save Message" & CRLF)
                    'Save Message...
                    Room.SaveMessage(User.UserID, message, False, recipid)
                    SaveMessageMenu = ""
                    continue = False
                Case "C"
                    Say("Continue" & CRLF & Left(message, Len(message) - 4))
                    SaveMessageMenu = message
                    continue = False
                Case "P"
                    Say("Print Formatted" & CRLF)
                    If recip <> "" Then
                        Say(CRLF & "   " & CitDateFormat(Now()) & " from " & User.aliasclean & " to " & recip & CRLF)
                    Else
                        Say("   " & CitDateFormat(Now()) & " from " & User.aliasclean & CRLF)
                    End If

                    Say(Left(message, Len(message) - 2) & CRLF & EnterPrompt)

                Case "R"
                    Say("Replace" & CRLF)
                    Say("Text to replace : ")
                    Dim txt As String = GetString()
                    If Len(txt) > 0 Then
                        Say("Text to insert : ")
                        message = Replace(message, txt, GetString(), , , CompareMethod.Text)
                    End If
                Case "A"
                    Say("Abort!" & CRLF & "Confirm (y/N) : ")
                    If GetBool(False) Then
                        continue = False
                        SaveMessageMenu = ""
                    Else
                        Say(CRLF & EnterPrompt)
                    End If
                Case Else
            End Select
        End While
    End Function
    Private Function GetBool(ByVal def As Boolean) As Boolean
        Dim continue As Boolean
        Dim x As String
        continue = True

        While continue
            x = UCase(GetCh())
            If x = "Y" Then
                GetBool = True
                Say("Yes" & CRLF)
                continue = False
            End If

            If x = "N" Then
                GetBool = False
                Say("No" & CRLF)
                continue = False
            End If
            If x = Chr(13) Then
                GetBool = def
                continue = False
                If def = True Then Say("Yes") Else Say("No")
            End If
        End While
    End Function
    Private Function GetCh() As String
        Dim temp(2000) As Byte
        Dim continue As Boolean
        Dim cmd, i, l As Integer
        continue = True
        Idle = Now()
        While continue
            If Len(DataIn) = 0 Then
                l = CitSocket.Receive(temp)
                For i = 0 To l - 1
                    If temp(i) > 0 Then DataIn = DataIn & Chr(temp(i))
                Next
            Else
                If CitSocket.Available > 0 Then
                    l = CitSocket.Receive(temp)
                    For i = 0 To l - 1
                        If temp(i) > 0 Then DataIn = DataIn & Chr(temp(i))
                    Next
                End If

                If Len(DataIn) > 0 Then
                    cmd = Asc(Left(DataIn, 1))
                    If cmd = 255 Then         ' Telnet control code.  generally 3 bytes... if I cared, I'd do more with it.
                        If Len(DataIn) >= 3 Then
                            cmd = 0
                            DataIn = Right(DataIn, Len(DataIn) - 3)
                        End If
                    Else
                        If Len(DataIn) > 0 Then
                            continue = False
                            GetCh = Left(DataIn, 1)
                            DataIn = Right(DataIn, Len(DataIn) - 1)
                        End If
                    End If
                End If
            End If

        End While
    End Function
    Private Function GetChX() As String
        Dim temp(2000) As Byte
        Dim cmd, i, l As Integer
        If CitSocket.Available > 0 Then
            Idle = Now()
            l = CitSocket.Receive(temp)
            For i = 0 To l - 1
                If temp(i) > 0 Then DataIn = DataIn & Chr(temp(i))
            Next
        End If

        If Len(DataIn) > 0 Then
            cmd = Asc(Left(DataIn, 1))
            If cmd = 255 Then         ' Telnet control code.  generally 3 bytes... if I cared, I'd do more with it.
                If Len(DataIn) >= 3 Then
                    cmd = 0
                    DataIn = Right(DataIn, Len(DataIn) - 3)
                    GetChX = ""
                End If
            Else
                GetChX = Left(DataIn, 1)
                DataIn = Right(DataIn, Len(DataIn) - 1)
            End If
        Else
            GetChX = ""
        End If
        Thread.Sleep(1)
    End Function
    Private Function GetMessage(ByVal Message As String) As String
        Dim continue As Boolean
        Dim PW, tmp As String
        Dim i As Integer
        PW = Message
        continue = True
        While continue
            tmp = GetCh()
            Select Case Asc(tmp)
                Case 13
                    Say(CRLF)
                    continue = False
                    PW = PW & CRLF
                Case 8, 127
                    If Len(PW) > 0 Then
                        Say(BKSP)
                        PW = Left(PW, Len(PW) - 1)
                    End If
                Case 10
                    'Do nothing...
                Case Else
                    Say(tmp)
                    PW = PW & tmp
            End Select
        End While
        GetMessage = PW
    End Function
    Private Function GetString() As String
        Dim continue As Boolean
        Dim PW, tmp As String
        continue = True
        While continue
            tmp = GetCh()
            Select Case Asc(tmp)
                Case 13
                    Say(CRLF)
                    continue = False
                Case 10
                    'do nothing...
                Case 8, 127
                    If Len(PW) > 0 Then
                        Say(BKSP)
                        PW = Left(PW, Len(PW) - 1)
                    End If
                Case Else
                    Say(tmp)
                    PW = PW & tmp
            End Select
        End While
        GetString = PW
    End Function
    Private Function GetPassword() As String
        Dim continue As Boolean
        Dim PW, tmp As String
        continue = True
        While continue
            tmp = GetCh()
            Select Case Asc(tmp)
                Case 13
                    Say(CRLF)
                    continue = False
                Case 8, 127
                    If Len(PW) > 0 Then
                        Say(BKSP)
                        PW = Left(PW, Len(PW) - 1)
                    End If
                Case Else
                    Say("*")
                    PW = PW & tmp
            End Select
        End While
        GetPassword = PW
    End Function
    'Sub ReadMsg
    '02Mar16 - DRB
    '  For screen pageing users, "S" stops 
    Private Sub ReadMsg(ByRef MsgOrder As Object)
        Dim pos As Object
        Dim cword As Object
        Dim I As Object
        Dim x As Object
        'Get New Messages
        Dim MsgTemp As String
        Dim MsgClean As String
        Dim rang As Short
        Dim ord As Short
        Dim html As Boolean
        html = False
        Select Case MsgOrder
            Case 1
                Say("Read New Messages" & CRLF & CRLF)
                rang = 0
                ord = 0
            Case 2
                Say("Read Forward" & CRLF & CRLF)
                rang = 1
                ord = 0

            Case 3
                Say("Read Reverse" & CRLF & CRLF)
                rang = 1
                ord = 1
            Case 4
                Say("Read HTML New" & CRLF & CRLF)
                rang = 0
                ord = 0
                html = True
        End Select

        MsgTemp = Room.GetMessages(rang, ord, (User.LastOld), (CitSystem.MailID), (User.UserID))


        MsgClean = Replace(MsgTemp, "<br>", CRLF, , , CompareMethod.Text)
        If html = False Then
            MsgClean = Replace(MsgTemp, "<b>", "*", , , CompareMethod.Text)
            MsgClean = Replace(MsgTemp, "</b>", "*", , , CompareMethod.Text)
            MsgClean = Replace(MsgTemp, "<i>", "_", , , CompareMethod.Text)
            MsgClean = Replace(MsgTemp, "</i>", "_", , , CompareMethod.Text)
        End If
        x = True
        MsgTemp = ""

        If html = False Then
            For I = 1 To Len(MsgClean)
                If Mid(MsgClean, I, 1) = "<" Then
                    x = False
                End If
                If x = True Then
                    MsgTemp = MsgTemp & Mid(MsgClean, I, 1)
                End If
                If x = False Then
                    If Mid(MsgClean, I, 1) = ">" Then
                        x = True
                    End If
                End If
            Next I
            MsgTemp = Replace(Replace(MsgTemp, "&lt", "<", , , CompareMethod.Text), "&gt", ">", , , CompareMethod.Text)
        Else
            MsgTemp = MsgClean
        End If


        cword = ""
        MsgClean = ""
        For I = 1 To Len(MsgTemp)
            If Mid(MsgTemp, I, 1) = Chr(10) Then
                pos = 0
            End If
            If Mid(MsgTemp, I, 1) <> " " Then
                cword = cword & Mid(MsgTemp, I, 1)
            Else
                If pos + Len(cword) > 78 Then
                    MsgClean = MsgClean & CRLF
                    pos = 0
                End If
                MsgClean = MsgClean & cword & " "
                pos = pos + Len(cword) + 1
                cword = ""
            End If

        Next I
        MsgClean = MsgClean & cword
        'screen paging...
        Dim msgPage As String = ""
        Dim linecount As Integer = 0
        If User.PageLength > 0 Then
            For I = 1 To Len(MsgClean)
                msgPage = msgPage & Mid(MsgClean, I, 1)
                If Right(msgPage, 1) = Chr(10) Then
                    linecount = linecount + 1
                    If linecount >= User.PageLength Then
                        Say(msgPage)
                        msgPage = ""
                        If I < Len(MsgClean) Then
                            linecount = 0
                            Say("<Pause>")
                            If UCase(GetCh()) = "S" Then
                                I = Len(MsgClean)
                                msgPage = ""
                            End If
                            Say(back(7))
                        End If
                    End If
                End If
            Next
            Say(msgPage)
        Else
            Say(MsgClean)
        End If

    End Sub
    Private Sub RoomPrompt()
        Try
            Dim x As String
            Room.LoadRooms(0, False)
            prompt = True
            messages = False

            While TerminateQuit = False
                ' Say basic room prompt info...

                If messages Then
                    Say("   " & Room.MessageCount() & " Messages" & CRLF & "   " & Room.NewMessageCount() & " New Messages" & CRLF)
                    messages = False
                End If


                If prompt Then
                    If User.LoggedIn = False Then
                        Say("<L>ogin <G>oto <U>ngoto <H>elp" & CRLF)
                    Else
                        If User.expert = False Then Say("<N>ew messages <E>nter <G>oto <U>ngoto <H>elp" & CRLF)
                    End If
                    Say(Room.RoomPrompt())
                    prompt = False
                End If

                x = GetCh()
                If Asc(x) > 0 Then
                    Select Case UCase(x)
                        Case "L"
                            If User.LoggedIn = False Then
                                Say("Login" & CRLF & "Enter  password (just carriage return if new)" & CRLF & " :")
                                User.Password = GetPassword()
                                If User.TryLogin Then
                                    Say(CRLF & "Welcome " & User.aliasclean & CRLF)
                                    Room.SetUser(User)
                                    Room.LoadRooms(User.UserID, User.LoggedIn)
                                    messages = True
                                    LoginCount = 1
                                Else
                                    Say(CRLF & " Invalid Password.  New User?")
                                    If GetBool(True) Then
                                        CreateNewUser()
                                        If User.LoggedIn Then
                                            Say(CRLF & "Welcome " & User.aliasclean & CRLF)
                                            Room.SetUser(User)
                                            Room.LoadRooms(User.UserID, User.LoggedIn)
                                            messages = True
                                            LoginCount = 1
                                        End If
                                    End If
                                End If
                                prompt = True
                            Else
                                Say("Log In" & CRLF & " Already logged in!" & CRLF)
                                prompt = True
                            End If
                        Case "G"
                            If User.LoggedIn Then
                                Say("Goto ")
                                Room.GotoNext(False, User.LoggedIn)
                                Say(Room.GetName() & CRLF)
                                prompt = True
                                messages = True
                            End If
                        Case "C"
                            If User.LoggedIn Then
                                chat()
                                prompt = True
                                messages = False
                            End If
                        Case "S"
                            If User.LoggedIn Then
                                Say("Skip ")
                                Room.GotoNext(True, User.LoggedIn)
                                Say(Room.GetName() & CRLF)
                                prompt = True
                                messages = True
                            End If
                        Case "U"
                            If User.LoggedIn Then
                                Say("Ungoto ")
                                Room.Ungoto()
                                Say(Room.GetName() & CRLF)
                                prompt = True
                                messages = True
                            End If
                        Case "K"
                            If User.LoggedIn Then
                                Say("Known Rooms" & CRLF & Room.KnownRooms() & CRLF)
                                prompt = True
                            End If
                        Case "N"    'read new messages
                            If User.LoggedIn Then
                                ReadMsg(1)
                                prompt = True
                            End If
                        Case "X"
                            If User.LoggedIn Then
                                'read HTML in new messages
                                ReadMsg(4)
                                prompt = True
                            End If
                        Case "R"
                            If User.LoggedIn Then
                                'read Reverse
                                ReadMsg(3)
                                prompt = True
                            End If
                        Case "F"
                            If User.LoggedIn Then
                                'read Forward
                                ReadMsg(2)
                                prompt = True
                            End If
                        Case "Z"
                            If User.LoggedIn Then
                                'read Forward
                                Say("System Status" & CRLF & CRLF & CitSystem.SystemName & CRLF)
                                Say("Running : " & VER & CRLF)
                                Say(SystemStatus & CRLF)
                                prompt = True
                            End If
                        Case "I"
                            If User.LoggedIn Then
                                'Room Info
                                Say("Info" & CRLF)
                                Say(Room.Info())
                                prompt = True
                                messages = False
                            End If
                        Case "E"
                            If User.LoggedIn Then

                                Say("Enter Message" & CRLF)
                                EnterMessage()
                                prompt = True
                                messages = False
                            End If
                        Case "T"
                            Say("Terminate Quit-also" & CRLF & CRLF & "Confirm? (Y/n): ")
                            If GetBool(True) Then
                                'update rooms...
                                If User.LoggedIn Then Room.UpdateMsgPointers()
                                TerminateQuit = True 'go bye bye!
                            Else
                                Say(CRLF)
                                prompt = True
                            End If
                            'Add logoff banner...
                        Case "H", "?"
                            'Help Menu
                            Say(Banner("MainHelp.txt") & CRLF)
                            prompt = True
                            messages = False
                        Case ".", ",", " ", "'"         'dot commands...
                            messages = False
                            If User.LoggedIn Then
                                Say(x & " ")
                                If DotCommand() Then
                                    prompt = True
                                Else
                                    prompt = False
                                    messages = False
                                End If
                            End If
                        Case Else
                            'Say(CRLF)
                    End Select
                End If
            End While
        Catch e As Exception
            Say(e.ToString)
        End Try
        Thread.Sleep(1000)
    End Sub
    Sub chat()
        Try
            Dim ch, line As String
            Dim continue As Boolean
            Dim PW, tmp As String
            Say("Chat" & CRLF & "[Escape] to cancel your message or exit chat" & CRLF)
            InChat = True
            ChatOut = "<has entered chat>"
            While InChat
                If ChatIn <> "" Then
                    Say(ChatIn)
                    ChatIn = ""
                End If
                ch = GetChX()
                If ch <> "" Then
                    Select Case Asc(ch)
                        Case 27
                            InChat = False
                        Case Asc("~")
                            Say(SystemStatus)
                        Case Is >= 32
                            'start typing a message...
                            Say(ch)
                            continue = True
                            PW = ch
                            While continue
                                tmp = GetChX()
                                If Len(tmp) > 0 Then
                                    Select Case Asc(tmp)
                                        Case 13
                                            'Say(CRLF)
                                            continue = False
                                        Case 10
                                            'do nothing...
                                        Case 8, 127
                                            If Len(PW) > 0 Then
                                                Say(BKSP)
                                                PW = Left(PW, Len(PW) - 1)
                                            End If
                                        Case 27
                                            If Len(PW) > 0 Then Say(back(Len(PW)))
                                            PW = ""
                                            continue = False
                                        Case Else
                                            Say(tmp)
                                            PW = PW & tmp
                                    End Select
                                    If Len(PW) = 0 Then
                                        continue = False
                                    End If
                                End If
                            End While
                            If Len(PW) > 0 Then
                                Say(back(Len(PW)))
                                ChatOut = ChatOut & PW
                            End If
                        Case Else
                            ch = ""
                            'do nothing?
                    End Select
                End If
                Thread.Sleep(10)
            End While
            ChatIn = ""
            InChat = False
            ChatOut = "<has left chat>"
            Say(CRLF)
        Catch e As Exception
            Debug.WriteLine(e)
        End Try
    End Sub
    Private Sub Say(ByVal Text As String)
        Dim i, ii As Integer
        '        DataOut = DataOut & Text
        For i = 1 To Len(Text)
            DataStream.WriteByte(Asc(Mid(Text, i, 1)))
        Next
        'DataStream.Flush()
        '       DataOut = ""
    End Sub
    Public Sub ShutDown()
        If Not (CitadelThread Is Nothing) Then
            If CitadelThread.IsAlive Then CitadelThread.Abort()
            Thread.Sleep(5)
            CitadelThread = Nothing
        End If
        If Not (LiveThread Is Nothing) Then
            If LiveThread.IsAlive Then LiveThread.Abort()
            Thread.Sleep(5)
            LiveThread = Nothing
        End If
        Room.Shutdown()
        User = Nothing
        Room = Nothing
        CitSystem = Nothing
        If Not (CitSocket Is Nothing) Then
            If CitSocket.Connected Then CitSocket.Close()
            CitSocket = Nothing
        End If
    End Sub
End Class
