#define INCL_WIN

#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <io.h>
#include <fcntl.h>
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "nodelist.h"
#include "xsendpm.h"

MRESULT EXPENTRY SendFilesDlgBoxProc    (HWND,USHORT,MPARAM,MPARAM);
MRESULT EXPENTRY AboutDlgBoxProc        (HWND,USHORT,MPARAM,MPARAM);
SHORT _fastcall  ParseFileName          (CHAR *,CHAR *);

extern int _fastcall load_addresses     (void);

extern ADDR *addresses;

CHAR  szFileName[1027];
char  szOutBound[1027];
char  d_nodelist[1025];
HAB   hab;
BBS   bbsdummy;
BBS  *bbs;


int main (int argc,char *argv[]) {

    HMQ     hmq;
    char   *p;

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab,0);

    p = getenv("XOUTBOUND");
    if(!p || (argc > 1 && (!strcmp(argv[1],"?") || !strcmp(argv[1],"-?") ||
       !strcmp(argv[1],"/?")))) {
        WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                      "Set environment variable XOUTBOUND to your outbound path.\r\r"
                      "Optionally set XNODELIST to your v7 nodelist path."
                      "\r\rCommand line may include a filename (or directory into"
                      " which to \"move\" if ended with backslash).\r\rXSENDPM -? for"
                      " this help.",
                      "XSENDPM",0,
                      MB_CANCEL | MB_MOVEABLE | ((p) ? MB_ICONASTERISK : MB_ICONHAND));
        WinDestroyMsgQueue(hmq);
        WinTerminate(hab);
        return 1;
    }
    strncpy(szOutBound,p,1026);
    szOutBound[1026] = 0;

    memset(&bbsdummy,0,sizeof(BBS));
    bbsdummy.attribs2 |= B2_USEVER7;
    bbs = &bbsdummy;

    p = getenv("XNODELIST");
    if(!p || !*p)
      p = "./NODELIST";
    strcpy(d_nodelist,p);

    load_addresses();

    /* check for filename parameter and copy to szFileName */

    if(argc > 1)
      ParseFileName(szFileName,argv[1]);

    WinDlgBox(HWND_DESKTOP, HWND_DESKTOP,
              SendFilesDlgBoxProc,0,SF_OPEN,NULL);

    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
    return 0;
}



VOID FillDirListBox (HWND hwnd,CHAR *pcCurrentPath) {

    static CHAR szDrive[] = "  :";
    FILEFINDBUF findbuf;
    HDIR        hDir = 1;
    SHORT       sDrive;
    USHORT      usDriveNum,usCurPathLen,usSearchCount = 1;
    ULONG       ulDriveMap;

    DosQCurDisk(&usDriveNum,&ulDriveMap);
    pcCurrentPath[0] = (CHAR)(usDriveNum + '@');
    pcCurrentPath[1] = ':';
    pcCurrentPath[2] = '\\';
    usCurPathLen = 1023;
    DosQCurDir(0,pcCurrentPath + 3,&usCurPathLen);

    WinSetDlgItemText(hwnd,SF_PATH,pcCurrentPath);
    WinSendDlgItemMsg(hwnd,SF_DIRLIST,LM_DELETEALL,NULL,NULL);

    for(sDrive = 0;sDrive < 26;sDrive++) {
      if(ulDriveMap & 1L << sDrive) {
        szDrive[1] = (CHAR)(sDrive + 'A');

        WinSendDlgItemMsg(hwnd,SF_DIRLIST,LM_INSERTITEM,
                          MPFROM2SHORT(LIT_END,0),
                          MPFROMP(szDrive));
      }
    }

    if(!DosFindFirst("*",&hDir,FILE_DIRECTORY | FILE_ARCHIVED | FILE_READONLY |
                 FILE_SYSTEM | FILE_HIDDEN,
                 &findbuf,sizeof findbuf,&usSearchCount,0L)) {
//      WinShowWindow(WinWindowFromID(hwnd,SF_DIRLIST),FALSE);
      while(usSearchCount) {
        if((findbuf.attrFile & FILE_DIRECTORY) &&
           (findbuf.achName[0] != '.' || findbuf.achName[1]))
            WinSendDlgItemMsg(hwnd,SF_DIRLIST,LM_INSERTITEM,
                              MPFROM2SHORT(LIT_SORTASCENDING,0),
            MPFROMP(findbuf.achName));
        if(DosFindNext(hDir,&findbuf,sizeof findbuf,&usSearchCount))
          break;
      }
//      WinShowWindow(WinWindowFromID(hwnd,SF_DIRLIST),TRUE);
      DosFindClose(hDir);
    }
}



VOID FillFileListBox (HWND hwnd) {

    FILEFINDBUF findbuf;
    HDIR        hDir = 1;
    USHORT      usSearchCount = 1;

    WinSendDlgItemMsg(hwnd,SF_FILELIST,LM_DELETEALL,NULL,NULL);

    if(!DosFindFirst("*",&hDir,FILE_NORMAL | FILE_ARCHIVED | FILE_READONLY |
                    FILE_SYSTEM | FILE_HIDDEN,
                    &findbuf,sizeof findbuf,&usSearchCount,0L)) {
//      WinShowWindow(WinWindowFromID(hwnd,SF_FILELIST),FALSE);
      while(usSearchCount) {
        WinSendDlgItemMsg(hwnd,SF_FILELIST,LM_INSERTITEM,
                          MPFROM2SHORT(LIT_SORTASCENDING,0),
                          MPFROMP(findbuf.achName));
        if(DosFindNext(hDir,&findbuf,sizeof findbuf,&usSearchCount))
          break;
      }
//      WinShowWindow(WinWindowFromID(hwnd,SF_FILELIST),TRUE);
      DosFindClose(hDir);
    }
}



MRESULT EXPENTRY SendFilesDlgBoxProc (HWND hwnd,USHORT msg,MPARAM mp1,
                                      MPARAM mp2) {

    static char     szCurrentPath[257],szBuffer[520],szAddrBuff[257];
    static HWND     hwndSysMenu, hwndSysSubMenu;
    static SHORT    sItem, idSysMenu;
    static MENUITEM miSysMenu;
    static HPOINTER hwndIcon;
    static ADDR     taddr;
    static MENUITEM mi[2] = {MIT_END, MIS_SEPARATOR, 0, 0, NULL, 0L,
                             MIT_END, MIS_TEXT, 0, SF_ABOUT, NULL, 0L};
    int             sSelect,rc;

    switch(msg) {
        case WM_INITDLG:
            hwndSysMenu = WinWindowFromID(hwnd,FID_SYSMENU);
            idSysMenu = SHORT1FROMMR(WinSendMsg(hwndSysMenu,
                                                MM_ITEMIDFROMPOSITION,
                                                NULL, NULL));
            WinSendMsg(hwndSysMenu, MM_QUERYITEM,MPFROM2SHORT(idSysMenu, 0),
                       MPFROMP(&miSysMenu));
            hwndSysSubMenu = miSysMenu.hwndSubMenu;
            for (sItem = 0; sItem < 2; sItem++)
               WinSendMsg(hwndSysSubMenu, MM_INSERTITEM, MPFROMP(mi + sItem),
                          MPFROMP("~About..."));
            hwndIcon = WinLoadPointer(HWND_DESKTOP,0,SF_PROGICON);
            WinDefDlgProc(hwnd,WM_SETICON,MPFROMP(hwndIcon),MPFROMLONG(0L));
            WinSendDlgItemMsg(hwnd,SF_FILEEDIT,EM_SETTEXTLIMIT,
                              MPFROM2SHORT(256,0),NULL);
            WinSendDlgItemMsg(hwnd,SF_ADDR,EM_SETTEXTLIMIT,
                              MPFROM2SHORT(81,0),NULL);
            WinSendDlgItemMsg(hwnd,SF_SENDAS,EM_SETTEXTLIMIT,
                              MPFROM2SHORT(80,0),NULL);
            WinSendDlgItemMsg(hwnd,SF_NORMAL,BM_SETCHECK,
                              MPFROM2SHORT(1,0),NULL);
            WinSendDlgItemMsg(hwnd,SF_NONE,BM_SETCHECK,
                              MPFROM2SHORT(1,0),NULL);
            {
              struct stat st;

              if(*szFileName && !stat(szFileName,&st) &&
                 !(st.st_mode & S_IFCHR) && !(st.st_mode & S_IFDIR)) {

                CHAR *p;

                p = strrchr(szFileName,'\\');
                if(p) {
                  p++;
                  WinSetDlgItemText(hwnd,SF_FILEEDIT,p);
                }
              }
            }
            FillDirListBox(hwnd,szCurrentPath);
            FillFileListBox(hwnd);
            return WinDefDlgProc(hwnd,msg,mp1,mp2);

        case WM_ADJUSTWINDOWPOS :     /* This keeps controls from overriding icon */
            if (((PSWP)mp1)->fs & SWP_RESTORE) {
                WinShowWindow(WinWindowFromID(hwnd,SF_OK),1);
                WinShowWindow(WinWindowFromID(hwnd, SF_DIRLIST), 1);
            }
            else if (((PSWP)mp1)->fs & SWP_MINIMIZE) {
                WinShowWindow(WinWindowFromID(hwnd, SF_DIRLIST), 0);
                WinShowWindow(WinWindowFromID(hwnd,SF_OK),0);
            }
            return(WinDefDlgProc(hwnd, msg, mp1, mp2));

        case WM_CONTROL:
            if(SHORT1FROMMP(mp1) == SF_DIRLIST ||
               SHORT1FROMMP(mp1) == SF_FILELIST) {
                sSelect = (USHORT)((ULONG)WinSendDlgItemMsg(hwnd,SHORT1FROMMP(mp1),
                                               LM_QUERYSELECTION,0L,0L));
                WinSendDlgItemMsg(hwnd,SHORT1FROMMP(mp1),LM_QUERYITEMTEXT,
                                  MPFROM2SHORT(sSelect,256),
                                  MPFROMP(szBuffer));
            }
            switch(SHORT1FROMMP(mp1)) { /* control ID */
                case SF_DIRLIST:
                    switch(SHORT2FROMMP(mp1)) { /* notification code */
                        case LN_ENTER:
                            WinSetDlgItemText(hwnd,SF_FILEINFO,"");
                            if(szBuffer[0] == ' ') {
                                DosSelectDisk(szBuffer[1] - '@');
                            }
                            else {
                                DosChDir(szBuffer,0L);
                            }
                            FillDirListBox(hwnd,szCurrentPath);
                            FillFileListBox(hwnd);
                            WinSetDlgItemText(hwnd,SF_FILEEDIT,"");
                            return MRFROMSHORT(0);
                    }
                    break;

                case SF_FILELIST:
                    switch(SHORT2FROMMP(mp1)) {
                        case LN_SELECT:
                            WinSetDlgItemText(hwnd,SF_FILEEDIT,szBuffer);
                            {
                              struct stat st;

                              if(!stat(szBuffer,&st)) {
                                sprintf(szBuffer,"%lu  %0.24s",st.st_size,
                                        ctime(&st.st_mtime));
                                WinSetDlgItemText(hwnd,SF_FILEINFO,szBuffer);
                              }
                              else
                                WinSetDlgItemText(hwnd,SF_FILEINFO,"");
                            }
                            return MRFROMSHORT(0);

                        case LN_ENTER:
                          WinPostMsg(hwnd,WM_COMMAND,MPFROM2SHORT(SF_OK,0),0L);
                          return MRFROMSHORT(0);
                    }
                    break;
            }
            return MRFROMSHORT(0);

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case SF_ABOUT:
                    WinDlgBox(HWND_DESKTOP,hwnd,AboutDlgBoxProc,
                              0,SFB_ABOUT,NULL);
                    return MRFROMSHORT(0);

                case SF_INFO:
                    *szAddrBuff = 0;
                    rc = WinQueryDlgItemText(hwnd,SF_ADDR,81,szAddrBuff);
                    if (rc > 0) {

                        char *p;

                        p = lstrip(rstrip(szAddrBuff));
                        memset(&taddr,0,sizeof(ADDR));
                        if(parse_addr(&p,&taddr,addresses)) {
                          *szAddrBuff = 0;
                          WinQueryDlgItemText(hwnd,SF_ADDR,81,szAddrBuff);
                          lstrip(rstrip(szAddrBuff));
                          memset(&taddr,0,sizeof(ADDR));
                          if(!find_in_sysopndx(0,0,szAddrBuff,&taddr) ||
                             taddr.zone == 65535U ||
                             taddr.net == 65535U) {
                            memset(&taddr,0,sizeof(ADDR));
                            WinMessageBox(HWND_DESKTOP,hwnd,
                                          "To: address isn't valid; unknown sysop name, no nodelist, "
                                          "or a typo?  Is XNODELIST environment variable set right?",
                                          "XSENDPM",0,
                                          MB_CANCEL | MB_APPLMODAL | MB_MOVEABLE | MB_ICONEXCLAMATION);
                            return MRFROMSHORT(0);
                          }
                          else
                            guess_rest(&taddr,addresses);
                        }
                        if(taddr.zone && *taddr.domain) {

                          NODEINFO nif;

                          sprintf(szBuffer,"%s#%u:%u/%u.%u",taddr.domain,
                                  taddr.zone,taddr.net,taddr.node,
                                  taddr.point);
                          WinSetDlgItemText(hwnd,SF_ADDR,szBuffer);
                          memset(&nif,0,sizeof(NODEINFO));
                          nif.net = taddr.net;
                          nif.node = taddr.node;
                          if(ver7find(&nif,taddr.zone,taddr.point,taddr.domain)) {
                            sprintf(&szBuffer[strlen(szBuffer)],
                                    "\r%s\r%s\r%s\r%s\rCosts: %d, %d\rHub: %d"
                                    "\rBaud: %lu\rModem: %hu\rFlags: %hu",
                                    nif.name,nif.phone,nif.city,nif.password,
                                    nif.cost,nif.realcost,nif.hubnode,
                                    (long)nif.rate * 300L,
                                    nif.modem,nif.flags);
                            WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                                          szBuffer,
                                          "XSENDPM",0,
                                          MB_ENTER | MB_MOVEABLE | MB_ICONASTERISK);
                          }
                        }
                    }
                    else
                      DosBeep(100,100);
                    return MRFROMSHORT(0);

                case SF_DELETEFILE:
                case SF_OK:
                    WinSetDlgItemText(hwnd,SF_FILEINFO,"");
                    WinQueryDlgItemText(hwnd,SF_FILEEDIT,256,szBuffer);
                    lstrip(rstrip(szBuffer));
                    switch(ParseFileName(szCurrentPath,szBuffer)) {
                        case 0:
                            WinAlarm(HWND_DESKTOP,WA_ERROR);
                            FillDirListBox(hwnd,szCurrentPath);
                            FillFileListBox(hwnd);
                            WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwnd,SF_FILEEDIT));
                            return MRFROMSHORT(0);

                        case 1:
                            FillDirListBox(hwnd,szCurrentPath);
                            FillFileListBox(hwnd);
                            WinSetDlgItemText(hwnd,SF_FILEEDIT,"");
                            WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwnd,SF_FILEEDIT));
                            return MRFROMSHORT(0);

                        case 2:
                            strcpy(szFileName,lstrip(rstrip(szCurrentPath)));
                            {
                                struct stat st;

                                if(stat(szCurrentPath,&st) ||
                                   (st.st_mode & S_IFCHR) ||
                                   (st.st_mode & S_IFDIR)) {
                                    *szFileName = 0;
                                    WinMessageBox(HWND_DESKTOP,hwnd,
                                                  "Invalid filename.",
                                                  "XSENDPM",0,
                                                  MB_CANCEL | MB_APPLMODAL | MB_MOVEABLE | MB_ICONEXCLAMATION);
                                }
                            }
                            if(!*szFileName)
                              return MRFROMSHORT(0);
                            if(SHORT1FROMMP(mp1) == SF_DELETEFILE) {

                              char *p;

                              unlink(szFileName);
                              WinSetDlgItemText(hwnd,SF_FILEEDIT,"");
                              p = strrchr(szFileName,'\\');
                              if(!p) {
                                p = strrchr(szFileName,':');
                                if(!p)
                                  p = szFileName;
                                else
                                  p++;
                              }
                              else
                                p++;

                              rc = (int)WinSendDlgItemMsg(hwnd,SF_FILELIST,
                                                          LM_SEARCHSTRING,
                                                          MPFROM2SHORT(0,LIT_FIRST),
                                                          MPFROMP(p));
                              if(rc >= 0)
                                WinSendDlgItemMsg(hwnd,SF_FILELIST,
                                                  LM_DELETEITEM,
                                                  MPFROM2SHORT(rc,0),
                                                  MPFROMLONG(0L));
                              WinSendDlgItemMsg(hwnd,SF_FILELIST,
                                                LM_SELECTITEM,
                                                MPFROM2SHORT(LIT_NONE,0),
                                                MPFROMSHORT(FALSE));
                              return 0;
                            }
                            *szAddrBuff = 0;
                            rc = WinQueryDlgItemText(hwnd,SF_ADDR,81,szAddrBuff);
                            if (rc > 0) {

                                char *p,type = 'N',trunc = 0,del = 0;
                                int  handle;

                                p = lstrip(rstrip(szAddrBuff));
                                memset(&taddr,0,sizeof(ADDR));
                                if(parse_addr(&p,&taddr,addresses)) {
                                  *szAddrBuff = 0;
                                  WinQueryDlgItemText(hwnd,SF_ADDR,81,szAddrBuff);
                                  lstrip(rstrip(szAddrBuff));
                                  memset(&taddr,0,sizeof(ADDR));
                                  if(!find_in_sysopndx(0,0,szAddrBuff,&taddr) ||
                                     taddr.zone == 65535U ||
                                     taddr.net == 65535U) {
                                    memset(&taddr,0,sizeof(ADDR));
                                    WinMessageBox(HWND_DESKTOP,hwnd,
                                                  "To: address isn't valid; unknown sysop name, no nodelist, or a typo?",
                                                  "XSENDPM",0,
                                                  MB_CANCEL | MB_APPLMODAL | MB_MOVEABLE | MB_ICONEXCLAMATION);
                                    return MRFROMSHORT(0);
                                  }
                                  else
                                    guess_rest(&taddr,addresses);
                                }
                                if(taddr.zone && *taddr.domain) {
                                  sprintf(szBuffer,"%s#%u:%u/%u.%u",taddr.domain,
                                          taddr.zone,taddr.net,taddr.node,
                                          taddr.point);
                                  WinSetDlgItemText(hwnd,SF_ADDR,szBuffer);

                                  if(!(USHORT)WinSendDlgItemMsg(hwnd,
                                              SF_NONE,BM_QUERYCHECK,0,NULL)) {
                                    trunc = (USHORT)WinSendDlgItemMsg(hwnd,
                                                    SF_TRUNCATE,
                                                    BM_QUERYCHECK,0L,0L);
                                    if(!trunc) {
                                        del = (USHORT)WinSendDlgItemMsg(hwnd,
                                                  SF_DELETE,
                                                  BM_QUERYCHECK,0L,0L);
                                    }
                                  }

                                  if((USHORT)WinSendDlgItemMsg(hwnd,
                                                SF_CRASH,BM_QUERYCHECK,
                                                0,NULL)) type = 'C';
                                  else if((USHORT)WinSendDlgItemMsg(hwnd,
                                                  SF_DIRECT,BM_QUERYCHECK,
                                                  0,NULL)) type = 'D';
                                  else if((USHORT)WinSendDlgItemMsg(hwnd,
                                                  SF_NORMAL,BM_QUERYCHECK,
                                                  0,NULL)) type = 'N';
                                  else if((USHORT)WinSendDlgItemMsg(hwnd,
                                                  SF_HOLD,BM_QUERYCHECK,
                                                  0,NULL)) type = 'H';
                                  else if((USHORT)WinSendDlgItemMsg(hwnd,
                                                  SF_MANUAL,BM_QUERYCHECK,
                                                  0,NULL)) type = 'M';

                                  sprintf(szBuffer,"%s/%c.%u.%u.%u.%u.%s",szOutBound,
                                          type,taddr.zone,taddr.net,taddr.node,
                                          taddr.point,taddr.domain);
                                  handle = sopen(szBuffer,O_RDWR | O_BINARY |
                                                 O_CREAT,SH_DENYWR,S_IWRITE |
                                                 S_IREAD);
                                  if(handle != -1) {
                                      lseek(handle,0L,SEEK_END);
                                      if(trunc)
                                        ffprintf(handle,"~");
                                      else if(del)
                                        ffprintf(handle,"^");
                                      ffprintf(handle,"%s",szFileName);
                                      *szBuffer = 0;
                                      rc = WinQueryDlgItemText(hwnd, SF_SENDAS, 80, szBuffer);
                                      if(rc > 0) {
                                        lstrip(rstrip(szBuffer));
                                        if(*szBuffer)
                                          ffprintf(handle," %s",lstrip(rstrip(szBuffer)));
                                      }
                                      ffprintf(handle,"\r\n");
                                      close(handle);
                                      WinSetDlgItemText(hwnd,SF_FILEEDIT,"");
                                      WinSetDlgItemText(hwnd,SF_SENDAS,"");
                                      WinSetFocus(HWND_DESKTOP,
                                                  WinWindowFromID(hwnd,SF_FILEEDIT));
                                      DosBeep(2000,10);
                                  }
                                  else {
                                    WinMessageBox(HWND_DESKTOP,hwnd,
                                                  "Couldn't open file!",
                                                  "XSENDPM",0,
                                                  MB_CANCEL | MB_APPLMODAL | MB_MOVEABLE | MB_ICONEXCLAMATION);
                                  }
                              }
                        }
                        else {
                          WinMessageBox(HWND_DESKTOP,hwnd,
                                        "Need a To: address.",
                                        "XSENDPM",0,
                                        MB_CANCEL | MB_APPLMODAL | MB_MOVEABLE | MB_ICONEXCLAMATION);
                          WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwnd,SF_ADDR));
                        }
                    }
                    return MRFROMSHORT(0);

                case DID_CANCEL:
                case SF_CANCEL:
                    WinDismissDlg(hwnd,0);
                    return MRFROMSHORT(0);

                case SF_HELP:
                    WinMessageBox(HWND_DESKTOP,hwnd,
                                  "To:      The address or sysop name to receive the file(s).\r\r"
                                  "As:      A different name to give the receiving end; not required.\r\r"
                                  "File:    The file to send; type in or select from listbox.\r\r"
                                  "Styles:  How the file is to be sent.\r\r"
                                  "Actions: What happens after the file is sent.\r\r"
                                  "Click Send to \"send\" the file, Kill to delete it, "
                                  "Info for info on address, or "
                                  "Quit to end XSendPM.\r\r"
                                  "Dropping files on XSendPM WPS objects is supported.",
                                  "XSENDPM",0,
                                  MB_ENTER | MB_MOVEABLE | MB_ICONASTERISK);
                    return MRFROMSHORT(0);

            }
            return MRFROMSHORT(0);

        case WM_CLOSE:
            WinDestroyPointer(hwndIcon);
            WinDismissDlg(hwnd, 0);
            return MRFROMSHORT(0);
    }

    return WinDefDlgProc(hwnd,msg,mp1,mp2);
}



SHORT _fastcall ParseFileName (CHAR *pcOut,CHAR *pcIn) {

    CHAR *pcLastSlash,*pcFileOnly;
    ULONG ulDriveMap;
    USHORT usDriveNum,usDirLen = 512;

    /* if input string empty return 1 */

    if(pcIn[0] == '\0')
      return 1;

    {
      register CHAR *p;

      p = pcIn;
      while(*p) {
        if(*p == '/')
          *p = '\\';
        p++;
      }
    }

    /* get drive from input string or current drive */

    if(pcIn[1] == ':') {
        if(DosSelectDisk(toupper(pcIn[0]) - '@'))
          return 0;
        pcIn += 2;
    }
    DosQCurDisk(&usDriveNum,&ulDriveMap);

    *pcOut++ = (CHAR) (usDriveNum + '@');
    *pcOut++ = ':';
    *pcOut++ = '\\';

    /* if rest of string is empty, return 1 */

    if(pcIn[0] == '\0')
      return 1;

    /* search for last backslash.  If none, could be directory */

    if(NULL == (pcLastSlash = strrchr(pcIn,'\\'))) {
        if(!DosChDir(pcIn,0L))
          return 1;

        /* otherwise, get current dir & attach input filename */

        DosQCurDir(0,pcOut,&usDirLen);

        if(*(pcOut + strlen(pcOut) - 1) != '\\')
          strcat(pcOut++,"\\");

        strcat(pcOut,pcIn);
        return 2;
    }

    /* if only backslash is at beginning, change to root */

    if(pcIn == pcLastSlash) {
        DosChDir("\\",0L);
        if(pcIn[1] == '\0')
          return 1;
        strcpy(pcOut,pcIn + 1);
        return 2;
    }

    /* attempt to change directory -- get current dir if ok */

    *pcLastSlash = '\0';

    if(DosChDir(pcIn,0L))
      return 0;

    DosQCurDir(0,pcOut,&usDirLen);

    /* append input filename, if any */

    pcFileOnly = pcLastSlash + 1;

    if(*pcFileOnly == '\0')
      return 1;

    if(*(pcOut + strlen(pcOut) - 1) != '\\')
      strcat(pcOut++,"\\");

    strcat(pcOut,pcFileOnly);
    return 2;
}


MRESULT EXPENTRY AboutDlgBoxProc(HWND hwndDlg, USHORT msg, MPARAM mp1,
                                 MPARAM mp2) {

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}


/*
 * this code lifted sorta sideways from Bink -- original author Vince
 * Perriello (he'll note below where he stole it :-).
 */

typedef struct _OADDRESS
{
   word  Zone;
   word  Net;
   word  Node;
   word  Point;
   char  *Domain;
} OADDR, *OADDRP;

/*--------------------------------------------------------------------------*/
/* nodex.ndx                                                                */
/*                                                                          */
/* Version 7 Nodelist Index structure.  This is a 512-byte record, which    */
/* is defined by three structures:  Record 0 is the Control Record, then    */
/* some number of Leaf Node (LNode) Records, then the Index Node (INode)    */
/* Records.  This defines an unbalanced binary tree.                        */
/*                                                                          */
/* This description is based on Scott Samet's CBTREE.PAS program.           */
/*                                                                          */
/*--------------------------------------------------------------------------*/

struct _ndx {
    union
    {
        struct _CtlBlk {
            word    CtlBlkSize; /* Blocksize of Index Blocks   */
            long    CtlRoot;    /* Block number of Root        */
            long    CtlHiBlk;   /* Block number of last block  */
            long    CtlLoLeaf;  /* Block number of first leaf  */
            long    CtlHiLeaf;  /* Block number of last leaf   */
            long    CtlFree;    /* Head of freelist            */
            word    CtlLvls;    /* Number of index levels      */
            word    CtlParity;  /* XOR of above fields         */
        } CtlBlk;

        struct _INodeBlk {
            long    IndxFirst;  /* Pointer to next lower level */
            long    IndxBLink;  /* Pointer to previous link    */
            long    IndxFLink;  /* Pointer to next link        */
            int     IndxCnt;    /* Count of Items in block     */
            word    IndxStr;    /* Offset in block of 1st str  */
            /* If IndxFirst is NOT -1, this is INode:          */
            struct _IndxRef {
                word   IndxOfs; /* Offset of string into block */
                word   IndxLen; /* Length of string            */
                long   IndxData;/* Record number of string     */
                long   IndxPtr; /* Block number of lower index */
            } IndxRef[20];
        } INodeBlk;

        struct _LNodeBlk {
                                /* IndxFirst is -1 in LNodes   */
            long    IndxFirst;  /* Pointer to next lower level */
            long    IndxBLink;  /* Pointer to previous link    */
            long    IndxFLink;  /* Pointer to next link        */
            int     IndxCnt;    /* Count of Items in block     */
            word    IndxStr;    /* Offset in block of 1st str  */
            struct _LeafRef {
                word   KeyOfs;  /* Offset of string into block */
                word   KeyLen;  /* Length of string            */
                long   KeyVal;  /* Pointer to data block       */
            } LeafRef[30];
        } LNodeBlk;

        char RawNdx[512];

    } ndx;
};

/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.20 Version 7 Nodelist structure. Copyright 1991 Wynn Wagner III   */
/* and Doug Boone. Used without permission.                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/

struct _vers7 {
        int    Zone;
        int    Net;
        int    Node;
        int    HubNode;        /* If node is a point, this is point number. */
        word CallCost;         /* phone company's charge */
        word MsgFee;           /* Amount charged to user for a message */
        word NodeFlags;        /* set of flags (see below) */
        char ModemType;        /* RESERVED for modem type */
        char Phone_len;
        char Password_len;
        char Bname_len;
        char Sname_len;
        char Cname_len;
        char pack_len;
        char BaudRate;         /* baud rate divided by 300 */
};

/* This table has been modified to minimize searches */
char unwrk[] = " EANROSTILCHBDMUGPKYWFVJXZQ-'0123456789";

long btree (char *, void *, int (*)(void *, void *, int, int), int);
int get_ver7_info (unsigned long, OADDRP,NODEINFO *,char *);
struct _ndx *get7node(int, unsigned long, struct _ndx *);
void unpk(char *instr,char *outp,int many);
int addr_compare (void *, void *, int, int);
int name_compare (void *, void *, int, int);



NODEINFO * _fastcall ver7find (NODEINFO *nif,unsigned int zone,
                               unsigned int point,char *domain) {

    OADDR         opus_addr;
    long         record;
    OADDR         found_addr;
    char         idxname[256],*which;

    opus_addr.Zone = zone;
    opus_addr.Net = nif->net;
    opus_addr.Node = nif->node;
    opus_addr.Point = point;
    opus_addr.Domain = domain;

    if(domain && *domain && stricmp(domain,addresses->domain))
      which = domain;
    else which = "NODEX";

    sprintf(idxname,"%s/%s.NDX",d_nodelist,which);

    record = btree (idxname, (void *)&opus_addr, addr_compare,0);

    if (record == -1L) {
       if(try_for_points(nif,zone,point,domain,idxname)) return nif;
       return NULL;
    }
    else
       get_ver7_info((unsigned long)record, &found_addr, nif, domain);

    return nif;
}

int addr_compare (void *key, void *desired, int len, int unused) {

   int k;

   k = ((OADDRP)key)->Zone - ((OADDRP)desired)->Zone;
   if (k)
      return (k);

   k = ((OADDRP)key)->Net - ((OADDRP)desired)->Net;
   if (k)
      return (k);

   k = ((OADDRP)key)->Node - ((OADDRP)desired)->Node;
   if (k)
      return (k);
/*
 * Node matches.
 *
 * The rule for points:
 *  1) If len == 6, treat key value for Point as Zero.
 *  2) Return comparison of key Point and desired Point.
 */
   if (len == 6)
      ((OADDRP)key)->Point = 0;

   return ((OADDRP)key)->Point - ((OADDRP)desired)->Point;
} 


ADDR * _fastcall find_in_sysopndx (int mode, USHORT cp, char *name,
                                   ADDR *addr) {

   NODEINFO     nif;
   OADDR        faddr;
   char         last_name_first[80];
   char         midname[80];
   char        *c, *p, *m;
   long         record;
   int          name_len;
   char         idxname[128];


   if(!name || !*name) return NULL;
   faddr.Zone = faddr.Net = faddr.Node = faddr.Point = (unsigned int) -1;
   faddr.Domain = NULL;
   c = midname;                           /* Start of temp name buff   */
   p = name;                              /* Point to start of name    */
   m = NULL;                              /* Init pointer to space     */

   *c = *p++;
   while (*c) {                           /* Go entire length of name  */
      if (*c == ' ')                      /* Look for space            */
         m = c;                           /* Save location             */
      c++;
      *c = *p++;
   }

   if (m != NULL) {                       /* If we have a pointer,     */
      *m++ = '\0';                        /* Terminate the first half  */
      strcpy (last_name_first, m);        /* Now copy the last name    */
      strcat (last_name_first, ", ");     /* Insert a comma and space  */
      strcat (last_name_first, midname);  /* Finally copy first half   */
   }
   else strcpy (last_name_first, midname);       /* Use whole name otherwise */

   capitalize_name (last_name_first);            /* Get caps in where needed  */
   name_len = (int) strlen (last_name_first);    /* Calc length now */

   sprintf(idxname,"%s/SYSOP.NDX",d_nodelist);

   record = btree (idxname, (void *)last_name_first, name_compare, name_len);

   if (record == -1)
      return NULL;

   get_ver7_info((unsigned long)record, &faddr, &nif, NULL);
   addr->zone = faddr.Zone;
   addr->net = faddr.Net;
   addr->node = faddr.Node;
   addr->point = faddr.Point;
   if(faddr.Domain && (*faddr.Domain)) {

     char *p;

     strncpy(addr->domain,faddr.Domain,8);
     addr->domain[8] = 0;
     if((p = strchr(addr->domain,'.')) != NULL) *p = 0;
   }
   else *addr->domain = 0;

   return addr;
}


int name_compare (void *key, void *desired, int len, int name_len) {

   return (strnicmp((char *)key,(char *)desired,
                     (unsigned int)min (name_len,len)));
}


/*
 * General V7 nodelist engine. Used by both the by-node and by-sysop
 * lookups.
 *
 * Thanks to Phil Becker for showing me how nice it looks in assembler.
 * It helped me see how nice it could be in C.
 *
 * (I know, Phil, it's still nicer in assembler!)
 *
 */

long btree (char *filename, void *desired, int (*compare)(void *key,
            void *desired, int len, int nlen), int name_len) {

    int j, k, l;
    struct _IndxRef *ip = NULL;
    struct _LeafRef *lp = NULL;
    char aline[160];
    char *tp;
    char *np;
    struct _ndx *node_index;         /* index file             */
    struct _ndx *nodeidx;            /* index file             */
    struct _ndx *noderef;            /* index file             */
    long record, foundrec = -1L;
    int count;
    int stream;

    if ((stream = sopen(filename, O_RDONLY | O_BINARY, SH_DENYWR)) == -1)
        return (-1L);                        /* no file, no work to do */

    node_index = malloc ( sizeof (struct _ndx));
    nodeidx = malloc ( sizeof (struct _ndx));
    noderef = malloc ( sizeof (struct _ndx));

    if (node_index == NULL || nodeidx == NULL || noderef == NULL) {
        if(node_index) free(node_index);
        if(nodeidx) free(nodeidx);
        if(noderef) free(noderef);
        close (stream);
        return (-1L);
    }

    /* Get CtlRec */
    if (get7node (stream, 0L, noderef) != noderef) {
        close (stream);
        free(node_index);
        free(nodeidx);
        free(noderef);
        return (-1L);
    }

    /* The guts of the matter -- walk from CtlRec to Leaf */

    record = noderef->ndx.CtlBlk.CtlRoot;

/*
 * Read the first Index node.
 */
    if (get7node(stream, (unsigned long) (record * noderef->ndx.CtlBlk.CtlBlkSize), nodeidx) != nodeidx) {
        close (stream);
        free(node_index);
        free(nodeidx);
        free(noderef);
        return (-1L);
    }
/*
 * Follow the node tree until we either match a key right in the index
 * node, or locate the leaf node which must contain the entry.
 */
    while (nodeidx->ndx.INodeBlk.IndxFirst != -1) {
       if ((count = nodeidx->ndx.INodeBlk.IndxCnt) == 0) {
          close (stream);
          free(node_index);
          free(nodeidx);
          free(noderef);
          return (-1L);
       }

       for (j = 0; j < count; j++) { /* check 20 or less */
          ip = &(nodeidx->ndx.INodeBlk.IndxRef[j]);
          tp = (char *) nodeidx + ip->IndxOfs;

          k = l = ip->IndxLen;

          for (np = aline; k > 0; k--)
              *np++ = *tp++;

          k = (*compare) ((void *)aline, desired, l, name_len);

          if (k > 0)
             break;

          if (k == 0) {

/* Key matches in the index node. Since we're just doing lookup, we
 * can assume its pointer is valid. If we were doing updates, that
 * assumption would not work, because leaf nodes update first. So in
 * an update environment, the entire code segment relating to k == 0
 * should not execute, and we should walk the tree all the way down.
 */
             close (stream);
             free(node_index);
             free(nodeidx);
             free(noderef);
             return (nodeidx->ndx.INodeBlk.IndxRef[j].IndxData);
          }
       }

       if (j == 0)
          record = nodeidx->ndx.INodeBlk.IndxFirst;
       else
          record = (nodeidx->ndx.INodeBlk.IndxRef[--j]).IndxPtr;

       if (get7node(stream, (unsigned long) (record * noderef->ndx.CtlBlk.CtlBlkSize), nodeidx) != nodeidx) {
          close (stream);
          free(node_index);
          free(nodeidx);
          free(noderef);
          return (-1L);
       }

    }
/*
 * We can only get here if we've found the leafnode which must
 * contain our entry.
 *
 * Find our guy here or die trying.
 */

    if ((count = nodeidx->ndx.LNodeBlk.IndxCnt) != 0) {

       /* Search for a higher key */

       for (j = 0; j < count; j++) {      /* check 30 or less */
          lp = &(nodeidx->ndx.LNodeBlk.LeafRef[j]);
          tp = (char *) nodeidx + lp->KeyOfs;

          k = l = lp->KeyLen;

          for (np = aline; k > 0; k--)
              *np++ = *tp++;

          k = (*compare) ((void *)aline, desired, l,name_len);

          if (k > 0)
             break;
          if (k == 0) {
             foundrec = (nodeidx->ndx.LNodeBlk.LeafRef[j]).KeyVal;
             break;
          }
       }
    }

    close (stream);
    free(node_index);
    free(nodeidx);
    free(noderef);
    return (foundrec);
}


int get_ver7_info (unsigned long pos, OADDRP faddr,NODEINFO *nif,char *domain) {

    struct _vers7 vers7;
    char my_phone[40];
    char my_pwd[9];
    char aline[160];
    char aline2[160];
    char *fst,*which;
    char temp[80];                                  /* we build filenames here*/
    int stream;


    if(domain && *domain && stricmp(domain,addresses->domain))
      which = domain;
    else which = "NODEX";
    sprintf(temp,"%s/%s.DAT",d_nodelist,which);
    if ((stream = sopen (temp, O_BINARY | O_RDONLY, SH_DENYWR)) == -1) { /* open it*/
        return (0);
    }

    if (lseek (stream,(long int) pos, SEEK_SET) == -1L) {   /* point at record */
        close (stream);
        return (0);
    }

    if (read (stream, &vers7,sizeof (struct _vers7)) == -1) {
        close (stream);
        return (0);
    }

    memset(my_phone,'\0',40);
    read (stream,my_phone, vers7.Phone_len);

    memset(my_pwd,'\0',9);
    read (stream,my_pwd, vers7.Password_len);

    memset(aline,'\0',160);
    memset(aline2,'\0',160);
    if (read (stream,aline2, vers7.pack_len) == -1) {
        close (stream);
        return (0);
    }

    close (stream);

    unpk(aline2,aline,vers7.pack_len);

    memset (nif, 0, sizeof (NODEINFO));

    nif->net = vers7.Net;
    nif->node = vers7.Node;
    nif->cost = nif->realcost = vers7.CallCost;
    memcpy (nif->name, aline, min(33, vers7.Bname_len));
    nif->name[min(33, vers7.Bname_len)] = '\0';
    capitalize_name (nif->name);

    fst = &aline[0] + vers7.Bname_len + vers7.Sname_len;
    memcpy (nif->phone, my_phone, min(39,vers7.Phone_len));
    nif->phone[min(39,vers7.Phone_len)] = '\0';
    memcpy (nif->city, fst, min(29, vers7.Cname_len));
    nif->city[min(29, vers7.Cname_len)] = '\0';
    capitalize_name( nif->city );

    memcpy (nif->password, my_pwd, min(8, vers7.Password_len));
    nif->password[min(8,vers7.Password_len)] = 0;
    nif->hubnode = vers7.HubNode;
    nif->rate = vers7.BaudRate;
    nif->modem = vers7.ModemType;
    nif->flags = vers7.NodeFlags;

    faddr->Zone  = vers7.Zone;
    faddr->Net   = vers7.Net;
    faddr->Node  = vers7.Node;
    if (vers7.NodeFlags & B_point)
        faddr->Point = vers7.HubNode;
    else faddr->Point = 0;
    faddr->Domain = NULL;

    return (1);
}


struct _ndx *get7node (int stream, unsigned long pos, struct _ndx *ndx) {

    lseek (stream, (long) pos, SEEK_SET);

    if (read (stream, ndx,(unsigned int) sizeof (struct _ndx)) == -1) {
      close (stream);
      return (NULL);
    }
    return (ndx);
}


/* ====================================================================
 * unpack a dense version of a symbol (base 40 polynomial)
 * ====================================================================
 */
void unpk (char *instr,char *outp,int count) {

    struct chars {
      unsigned char c1;
      unsigned char c2;
    };

    union {
      unsigned w1;
      struct chars d;
    } u;

   register int i, j;
   char obuf[4];

   outp[0] = '\0';

   while (count) {
     u.d.c1 = *instr++;
     u.d.c2 = *instr++;
     count -= 2;
     for(j=2;j>=0;j--) {
       i = u.w1 % 40;
       u.w1 /= 40;
       obuf[j] = unwrk[i];
     }
     obuf[3] = '\0';
     strcat (outp, obuf);
   }
}

