#define INCL_WIN

#include "mailer.h"
#include "xmisc.h"
#include "xbbs.h"
#include "transfer.h"

  extern USHORT focusline;
  extern HWND   hwndTransfer[MAXINSTANCES];
  extern MDM   *modems[MAXINSTANCES];

  extern MRESULT EXPENTRY ChildFrameProc (HWND,USHORT,MPARAM,MPARAM);


MRESULT EXPENTRY TransferBoxProc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  SHORT fline = WinQueryWindowUShort(hwnd,0);
  SHORT frameup;
  HWND  hwndSysmenu,hwndTitlebar,hwndMinmax;

  switch(msg) {
    case WM_CREATE:
      WinSetWindowUShort(hwnd,0,-1);
      WinSetPresParam(hwnd,PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv.Bold") + 1L,
                      (PVOID)"8.Helv.Bold");
      WinCreateWindow(hwnd,WC_STATIC,"File:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_FILEHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_FILEHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"Time:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANSTIMEHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_TRANSTIMEHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"Bytes:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANSHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_TRANSHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"Err:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LERRHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_LERRHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,"CPS:",WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANSCPSHDR,
                      NULL,NULL);
      WinSetPresParam(WinWindowFromID(hwnd,IDM_TRANSCPSHDR),PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv") + 1L,
                      (PVOID)"8.Helv");
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_FILE,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANSTIME,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANS,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LERR,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANSMISC,
                      NULL,NULL);
      WinCreateWindow(hwnd,WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                      DT_LEFT | DT_VCENTER,
                      0,0,0,0,hwnd,HWND_TOP,IDM_TRANSCPS,
                      NULL,NULL);
      hwndSysmenu = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                    FID_SYSMENU);
      hwndTitlebar = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                     FID_TITLEBAR);
      hwndMinmax = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                   FID_MINMAX);
      WinSetWindowULong(hwnd,8,(ULONG)hwndSysmenu);
      WinSetWindowULong(hwnd,12,(ULONG)hwndTitlebar);
      WinSetWindowULong(hwnd,16,(ULONG)hwndMinmax);
      WinSetWindowUShort(hwnd,2,1);
      WinDefWindowProc(hwnd,msg,mp1,mp2);
      if(!set_saved_position(hwnd,"TransSizePos"))
        WinSendMsg(hwnd,WM_TILE,MPFROMLONG(0L),MPFROMLONG(0L));
      return 0;

    case WM_BUTTON2DBLCLK:
      WinPostMsg(hwnd,WM_HIDEME,MPFROMLONG(0L),MPFROMLONG(0L));
      break;

    case WM_HIDEME:
      frameup = WinQueryWindowUShort(hwnd,2);
      frameup = (frameup) ? 0 : 1;
      WinSetWindowUShort(hwnd,2,frameup);
      hwndSysmenu = (HWND)WinQueryWindowULong(hwnd,8);
      hwndTitlebar = (HWND)WinQueryWindowULong(hwnd,12);
      hwndMinmax = (HWND)WinQueryWindowULong(hwnd,16);
      if(!frameup) {
        WinSetParent(hwndSysmenu,HWND_OBJECT,FALSE);
        WinSetParent(hwndTitlebar,HWND_OBJECT,FALSE);
        WinSetParent(hwndMinmax,HWND_OBJECT,FALSE);
      }
      else {
        WinSetParent(hwndSysmenu,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndTitlebar,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndMinmax,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
      }
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_UPDATEFRAME,
                 MPFROMSHORT(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINBUTTON),0L) ;
      return 0;

    case WM_TILE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        swp.cx / 2,(swp.cy / 2) + 12,swp.cx / 2,
                        (swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_CASCADE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        48,48,swp.cx - 72,swp.cy - 96,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_LOGWIDE:
      WinSendMsg(hwnd,WM_TILE,MPFROMLONG(0L),MPFROMLONG(0L));
      return 0;

    case WM_STATWIDE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        swp.cx / 2,24,swp.cx / 2,(swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_SETCP:
      {
        char s[81];

        sprintf(s,"Transfer: %d",SHORT1FROMMP(mp1));
        WinSetWindowText(WinQueryWindow(hwnd,QW_PARENT,0),s);
        WinSetWindowUShort(hwnd,0,SHORT1FROMMP(mp1));
        WinSendMsg(hwnd,WM_HIDEME,MPFROMLONG(0L),MPFROMLONG(0L));
        {
          PFNWP oldproc;

          oldproc = WinSubclassWindow(ParentOf(hwnd),(PFNWP)ChildFrameProc);
          WinSendMsg(ParentOf(hwnd),WM_SETCP,MPFROMP(oldproc),MPVOID);
        }
      }
      return 0;

    case WM_SIZE:
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_FILEHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 16,42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_FILE),HWND_TOP,
                      42,SHORT2FROMMP(mp2) - 16,SHORT1FROMMP(mp2) - 42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANSTIMEHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 32,42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANSTIME),HWND_TOP,
                      42,SHORT2FROMMP(mp2) - 32,(SHORT1FROMMP(mp2) / 2) - 42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANSCPSHDR),HWND_TOP,
                      SHORT1FROMMP(mp2) / 2,SHORT2FROMMP(mp2) - 32,42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANSCPS),HWND_TOP,
                      (SHORT1FROMMP(mp2) / 2) + 42,SHORT2FROMMP(mp2) - 32,
                      (SHORT1FROMMP(mp2) / 2) - 42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANSHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 48,42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANS),HWND_TOP,
                      42,SHORT2FROMMP(mp2) - 48,SHORT1FROMMP(mp2) - 42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LERRHDR),HWND_TOP,
                      0,SHORT2FROMMP(mp2) - 64,42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LERR),HWND_TOP,
                      42,SHORT2FROMMP(mp2) - 64,SHORT1FROMMP(mp2) - 42,16,
                      SWP_MOVE | SWP_SIZE);
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_TRANSMISC),HWND_TOP,
                      12,SHORT2FROMMP(mp2) - 80,SHORT1FROMMP(mp2) - 12,16,
                      SWP_MOVE | SWP_SIZE);
      break;

    case WM_PAINT:
      {
        RECTL rclUpdate;
        HPS hps;

        hps = WinBeginPaint(hwnd,0L,(PRECTL)&rclUpdate);
        WinFillRect(hps,(PRECTL)&rclUpdate,SYSCLR_DIALOGBACKGROUND);
        WinEndPaint(hps);
      }
      break;

    case WM_CONTROL:
      return 0;

    case WM_TRANSFER:
      if(fline != -1 && mp2) {

        TRANSBUF *t;
        char      s[132];
        long      secs,tosend,cps;

        t = (TRANSBUF *)mp2;

        switch(t->type) {
          case TB_NAME:
          case TB_NCHNG:
            if(t->filename)
              WinSetDlgItemText(hwnd,IDM_FILE,t->filename);
            if(t->filesize) {
              tosend = t->filesize - t->bytessent;
              secs = ((tosend + (tosend * 8L)) / 10L /
                     (long)(modems[fline]->curbaud / 10));
              secs += (secs / 6L);
              sprintf(s,"%ld:%02ld",secs / 60L,secs % 60L);
              WinSetDlgItemText(hwnd,IDM_TRANSTIME,s);
              if(t->type == TB_NAME)
                logfunc(0,fline,"%ld bytes apx. %ld mins %ld secs",
                        t->filesize,secs / 60L,secs % 60L);
            }
            else
              WinSetDlgItemText(hwnd,IDM_TRANSTIME,"???");
            break;

          case TB_TICK:
            cps = time(NULL) - t->started;
            if(!cps)
              cps = 1L;
            cps = (((t->bytessent - t->resyncedto) * 8L) / 10L) / cps;
            sprintf(s,"%ld",cps);
            WinSetDlgItemText(hwnd,IDM_TRANSCPS,s);
            if(t->filesize) {
              tosend = t->filesize - t->bytessent;
              if(cps < 2L) {
                secs = (((tosend + (tosend * 8L)) / 10L) /
                       (long)(modems[fline]->curbaud / 10));
                secs += (secs / 6L);
              }
              else
                secs = ((tosend + (tosend * 8L)) / 10L) / cps;
              if(!secs)
                secs = 1L;
              sprintf(s,"%ld:%02ld",secs / 60L,secs % 60L);
              WinSetDlgItemText(hwnd,IDM_TRANSTIME,s);
              sprintf(s,"%ld  %ld",t->filesize,tosend);
              WinSetDlgItemText(hwnd,IDM_TRANS,s);
            }
            else {
              WinSetDlgItemText(hwnd,IDM_TRANSTIME,"???");
              WinSetDlgItemText(hwnd,IDM_TRANS,"??? ???");
            }
            break;

          case TB_ERR:
            if(t->err) {
              sprintf(s,"%s %ld",t->err,t->errcount);
              WinSetDlgItemText(hwnd,IDM_LERR,s);
            }
            break;

          case TB_FIN:
            if(modems[fline]->curbaud) {
              secs = time(NULL) - t->started;
              if(!secs)
                secs = 1L;
              cps = (((t->bytessent - t->resyncedto) * 8L) / 10L) / secs;
              if(!cps)
                cps = 1L;
              logfunc(0,fline,"FIN: %ld bytes %ld min %ld sec  %ld cps  %ld%%  %ld error%s",
                      (t->bytessent - t->resyncedto),secs / 60L,secs % 60L,
                      cps,(cps * 100L) / (long)(modems[fline]->curbaud / 10),
                      t->errcount,&"s"[t->errcount == 1]);
              WinPostMsg(hwnd,WM_CLEARUD,MPFROM2SHORT(fline,0),s);
            }
            break;

          case TB_ABORT:
          case TB_MISC:
            if(t->misc)
              WinSetDlgItemText(hwnd,IDM_TRANSMISC,t->misc);
            else if(t->err) {
              WinSetDlgItemText(hwnd,IDM_LERR,t->err);
              WinSetDlgItemText(hwnd,IDM_TRANSMISC,"Aborted");
            }
            else
              WinSetDlgItemText(hwnd,IDM_TRANSMISC,"Aborted");
            break;

          default:
            break;
        }
      }
      if(mp2)
        free(mp2);
      return 0;

    case WM_CLEARUD:
      WinSetDlgItemText(hwnd,IDM_TRANSMISC,"");
      WinSetDlgItemText(hwnd,IDM_TRANS,"");
      WinSetDlgItemText(hwnd,IDM_TRANSTIME,"");
      WinSetDlgItemText(hwnd,IDM_TRANSCPS,"");
      WinSetDlgItemText(hwnd,IDM_FILE,"");
      WinSetDlgItemText(hwnd,IDM_LERR,"");
      return 0;

    case WM_CLOSE:
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_SYSCOMMAND,
                 MPFROM2SHORT(SC_MINIMIZE,0),MPFROMLONG(0L));
      return 0;
  }

  return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

