#define INCL_DOSERRORS
#define USE_TIME_MACROS

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "mailer.h"
#include "transfer.h"
#include "modem.h"
#include "timers.h"
#include "keys.h"
#include "xmisc.h"
#include "window.h"
#include "xbbs.h"

  #define D_LOCAL           0x0002

  char *progname = "XBBS PM 0.00"; /* goes into sealink/telink headers */

  extern MDM         *modems[MAXINSTANCES];
  extern HWND         xdhwnd;
  extern int         *_threadid;
  extern unsigned int crctab[];
  extern DCBINFO     *F53Info[MAXINSTANCES];

  long _fastcall get_resync (USHORT cp);

/* Functions for implementing XModem & SEAlink send per FTS-0007
   This code should be completely reentrant and capable of running
   under multiple threads simultaneously.  The fact that it's also
   ugly as hell is secondary. :-)  Many thanks to Phil Becker for
   writing FTS-0007.  This was coded directly from those specs. */


long _fastcall send_file (USHORT cp,char *filename,int altentry,
                         int chktec,int justxmodem,int overdriveok,
                         char *fakename) {

  /* sealink sender implemented per FTS-0007.  use state tables
   * to read source (states are labels & comments within code) cp is
   * modem port. chktec is 0 for checksum, non-zero for CRC (adjusts
   * dynamically).  modems[cp]->curbaud is used to set/reset SLO flag.
   */

  char     send,s[21],*p,arblk8 = 0,gotack = 0,oldpri[2];
  FILE    *fp;
  int      temp,slo,window,numnak,ackst,header,sealink,c = 0,
           lastsealink = -1,lastslo = -1,numresyncs = 0,
           blksent = 0,firstlast = 0;
  clock_t  t1,t2;
  long     lastblk,sendblk,prevblk = -1L,ackblk,acksrcvd,arblk = -1L,
           toterr = -1L,lastresync = 0L,tester;
  SEABLK   sl;                /* sealink header */
  TELBLK   tl;                /* telink header */
  XMOBLK   xmblk;             /* data blocks */
  TRANSBUF tbuf,*dupebuf;

  memset(&tbuf,0,sizeof(tbuf));
  modems[cp]->checkcd = 1;
  set_devctlblk(cp,0,1,1);
  if(!modems[cp]->curbaud)
    modems[cp]->curbaud = 2400;
  tester = (6L * (1L + (4L * (modems[cp]->curbaud > 4800))));
  DosGetPrty(2,(PUSHORT)oldpri,*_threadid);
  DosSetPrty(2,modems[cp]->comm[0],modems[cp]->comm[1],*_threadid);

  { /* Set up header blocks */
    struct _file_buffer *f;
    HDIR                 search_handle;
    USHORT               num_matches;

    f = (struct _file_buffer *)malloc(sizeof(struct _file_buffer));
    if(!f) {
      DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
      return 0L;
    }

    search_handle = HDIR_CREATE;
    num_matches = 1;

    if(!DosFindFirst(filename,&search_handle,0,(FILEFINDBUF *)f,
       sizeof(struct _file_buffer),&num_matches,0L)) {

      /* Set up telink block */

      memset(&tl,0,sizeof(TELBLK));
      tl.syn = SYN;
      tl.blk = 0;
      tl.blkcmp = 255;
      tl.size = f->size;
      tl.time = f->wt.x;
      tl.date = f->wd.x;
      tl.crcmode=0x01;
      sprintf(tl.sender,"%-0.16s",progname);
      if(fakename && *fakename)
        sprintf(s,"%-16.16s",fakename);
      else
        sprintf(s,"%-16.16s",f->filename);
      strncpy(tl.filename,s,16);
      p = (char *)&tl.size;          /* calc checksum */
      for(temp = 0;temp < sizeof(TELBLK) - 4;temp++) {
        tl.checksum += *p;
        p++;
      }

      /* Set up sealink block */

      memset(&sl,0,sizeof(SEABLK));
      sl.soh = SOH;
      sl.blk = 0;
      sl.blkcmp = 255;
      sl.flen = f->size;
      if(fakename && *fakename)
       strncpy(sl.fnam,fakename,17);
      else
       strncpy(sl.fnam,f->filename,17);
      sl.fnam[16] = 0;
      strncpy(sl.prog,progname,15);
      sl.prog[14] = 0;
      sl.fstamp = secs_since_1970((FDATE *)&f->wd.x,(FTIME *)&f->wt.x);
      if(modems[cp]->curbaud > 2400 && !justxmodem &&
         !altentry && !modems[cp]->noslo && overdriveok) {
        slo = 1;
        sl.slo = 1;
      }
      else {
        slo = 0;
        sl.slo = 0;
      }
      sl.macflow = 1;
      sl.resync = 1;
      DosFindClose(search_handle);
    }
    else {
      logfunc(0,cp,"Can't find \"%s\"",filename);
      free(f);
      DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
      return -1L;
    }
    lastblk = ((f->size + 127L) / 128L);
    free(f);
  }

  xmblk.soh = SOH;           /* no need to set repeatedly */

  if(!fakename || !stristr(fakename,".PKT"))
    fp = _fsopen(filename,"rb",SH_DENYWR);
  else
    fp = _fsopen(filename,"rb",SH_DENYNO);
  if(!fp) {
    logfunc(0,cp,"Can't open \"%s\"",filename);
    com_putc(cp,EOT);
    DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
    return -1L;
  }
  else
    setvbuf(fp,NULL,_IOFBF,BUFSIZ * 12);

  DosSetFHandState(fileno(fp),OPEN_ACCESS_READONLY | OPEN_SHARE_DENYWRITE |
                   OPEN_FLAGS_NOINHERIT | OPEN_FLAGS_SEQUENTIAL |
                   OPEN_FLAGS_FAIL_ON_ERROR);

  sl.fstamp = unixgetftime(fileno(fp));
  sl.crc = figurecrc((char *)&sl.flen,sizeof(SEABLK) - 5,1);

  logfunc(0,cp,"%s%s-sending \"%s\"",
          (!altentry && !modems[cp]->nosealink && !justxmodem) ?
          "SEAlink" : "XModem",(slo) ? "/Overdrive" : "",sl.fnam);
  tbuf.filename = sl.fnam;
  tbuf.err = NULL;
  tbuf.errcount = 0L;
  tbuf.filesize = sl.flen;
  tbuf.bytessent = 0L;
  tbuf.misc = NULL;
  tbuf.type = TB_NAME;
  tbuf.started = time(NULL);
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);
  if(!DosSemWait(&modems[cp]->bbsrunningSEM,0L))
    t1 = timerset(30000L);
  else
    t1 = timerset(120000L);

  if(!altentry && !modems[cp]->nosealink && !justxmodem) {
/* XS0 */
    header = 1;   /* marker var--sending sealink header */
    sealink = 0;
    sendblk = 1L;
    ackst = 0;
    window = 1;
    ackblk = -1L;
    acksrcvd = 0L;
    numnak = 0;
    t2 = timerset(5000L);
    if(chktec > 1) {
      chktec = (chktec - 2 != 0);
      c = 'C';
      goto Interruptus;
    }
  }
  else {
XS0T:
    header = 0;
    sealink = 0;
    slo = 0;
    ackst = 0;
    sendblk = 1L;
    ackblk = -1L;
    window = 1;
    acksrcvd = 0L;
    numnak = 0;
    t2 = timerset(5000L);
    if(chktec > 1) {    /* skip first nak */
      chktec = (chktec - 2 != 0);
      c = 'C';
      goto Interruptus;
    }
  }

XS1:

  /* Screw pretty, this is more efficient inline...had to pass too
   * damn many variables since it has to be reentrant.  Checks
   * ACK/NAKs.
   */

  /* AC0 */

  c = get_modem_byte(cp,(sealink) ? 0L : 500L);

  if(c == LOSTCARRIER)
    goto Abort;
  else if (c == TIMEOUT)
    goto XS2;

    /* AC1 */

  if(ackst <= 2)
    goto AC6;

    /* AC2 */

  if(arblk8 == (char)(c ^ 255))
    arblk = (sendblk - ((sendblk - (long)arblk8) & 255L));
  else {
    sealink = 0;
    window = 1;
    ackst = 0;
    goto AC6;
  }

  /* AC3 */

  if((arblk >= 0L) && (arblk <= sendblk) && (arblk > (sendblk - 128L))) {
    if(ackst == 3) {
      if(!modems[cp]->nosealink) {
        sealink = 1;
        window = 6 + (modems[cp]->dietIFNA * (modems[cp]->curbaud / 400));
        window = min(window,24);
      }
      ackblk = arblk;
      acksrcvd++;
      ackst = 0;
      goto AC5;
    }
    else if(ackst == 4) {
      tbuf.err = "NAKblk               ";
      sprintf(&tbuf.err[7],"%d",arblk);
      tbuf.errcount++;
      tbuf.type = TB_ERR;
      toterr++;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      sendblk = arblk;
      ackst = 0;
    }
    else
      logfunc(0,cp,"Software error @ AC3");
  }
  else
    goto XS2;

  /* AC4 */

  if(numnak < 4 && !modems[cp]->nosealink) {
    sealink = 1;
    window = 6 +(modems[cp]->dietIFNA * (modems[cp]->curbaud / 400));
    window = min(window,24);
    goto XS2;
  }
  else {
    sealink = 0;
    window = 1;
    goto XS2;
  }

AC5:

  if(!slo)
    goto XS2;

  if(acksrcvd < 10)
    goto XS2;
  else {
    slo = 0;
    goto XS2;
  }

AC6:

  if(ackst == 1 || ackst == 2) {
    arblk8 = (char)c;
    ackst += 2;
    goto AC6;
  }

  if(sealink && ackst) {
    if(ackst > 2)
      goto XS2;
  }

  /* AC7 */

  switch(c) {
    case CAN:
      if(peek_at_byte(cp,500L) == CAN) {
        get_modem_byte(cp,0L);
        tbuf.misc = "Remote aborted send (2 CANs)";
        tbuf.type = TB_ABORT;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        fclose(fp);
        DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
        Clear_UD();
        return -1L;
      }
      goto XS1;

    case ACK:
      gotack = 1;
      ackst = 1;
      numnak = 0;
      break;

    case 'C':
    case NAK:

Interruptus:

      if(!com_online(cp) && checkcarrier(cp))
        goto Abort;
      if(c == NAK)
        purge_out(cp);
      if(sendblk <= 1L) {
        if(c == 'C')
          chktec = 1;
        else if(numnak > 4 && !header)
          chktec = 0;
      }
      ackst = 2;
      numnak++;
      tbuf.err = "NAK";
      tbuf.errcount++;
      tbuf.type = TB_ERR;
      toterr++;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      goto AC9;

    case SYN:
      if(modems[cp]->nosealink)
        break;
      else {

        long res;

        purge_out(cp);
        res = get_resync(cp);
        ackst = 0;
/* AC10 */
        if(res) {
          if(lastresync == res) {
            if(modems[cp]->maxresyncs) {
              if(numresyncs > modems[cp]->maxresyncs) {
                tbuf.misc = "Too many resyncs";
                tbuf.type = TB_ABORT;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
                logfunc(0,cp,"Too many (%d) resyncs to offset %ld",
                        numresyncs,res);
                fclose(fp);
                DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
                Clear_UD();
                return -1L;
              }
            }
            numresyncs++;
          }
          else {
            numresyncs = 0;
            lastresync = res;
          }
          chktec = 1;
          sendblk = res;
          ackblk = sendblk - 1L;
          window = 6 +(modems[cp]->dietIFNA * (modems[cp]->curbaud / 400));
          window = min(window,24);
          sealink = 1;
          send = ACK;
          tbuf.type = TB_ERR;
          tbuf.err = "Resync to                                  ";
          sprintf(&tbuf.err[10],"%ld",sendblk);
          tbuf.errcount++;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          toterr++;
        }
        else {
          tbuf.type = TB_ERR;
          tbuf.err = "Resync failed";
          tbuf.errcount++;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          send = NAK;
        }
        com_putc(cp,send);
        DosSleep(250L + ((long)(send == ACK) * 250L));
        goto XS2;
      }

    case 0x13:
      if(sealink && ackst == 0) {   // macflow

        clock_t t;

        DosDevIOCtl(NULL,NULL,0x47,1,modems[cp]->mh);
        t = timerset(10000L);
        tbuf.err = "Macflow pause";
        tbuf.type = TB_ERR;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        do {
            c = get_modem_byte(cp,1000L);
            if(c == 0x11)
              break;
            if(c == LOSTCARRIER && checkcarrier(cp)) {
                DosDevIOCtl(NULL,NULL,0x48,1,modems[cp]->mh);
                goto Abort;
            }
        } while(!timeup(t));
        DosDevIOCtl(NULL,NULL,0x48,1,modems[cp]->mh);
      }
      goto XS2;

    default:
      if(!com_online(cp) && checkcarrier(cp))
        goto Abort;
#ifdef DEBUG
      logfunc(2,cp,"ACK/NAK check ignored %d",c);
#endif
      goto XS2;
  }

/* AC8 */

  if(!sealink)
    ackblk++;
  goto XS2;

AC9:

  if(!sealink)
    sendblk = ackblk + 1L;

XS2:

  if(timeup(t1)) {    /* something screwed up */
    logfunc(0,cp,"Fatal timeout -- total err%s = %ld",
            &"s"[(toterr == 1L)],toterr);
    tbuf.misc = "Fatal timeout";
    tbuf.type = TB_ABORT;
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);
    goto Abort;
  }

  if(modems[cp]->maxtranserrs && toterr) {
    if(toterr > (long)modems[cp]->maxtranserrs) {
      tbuf.err = "Too many total errors";
      tbuf.type = TB_ABORT;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      goto Abort;
    }
  }

  if(numnak > 2) {
    if(numnak > 18) {   /* nak til you drop...we did */
      tbuf.err = "Too many errors";
      tbuf.type = TB_ABORT;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      goto Abort;
    }
    else if(sendblk == 0L) {   /* switch from sealink to telink */
      if (header)
        goto XS0T;
      if(numnak > 8) {         /* switch from telink to xmodem */
        numnak = 0;
        ackblk++;
        sendblk++;
        goto XS1;
      }
    }
  }

  if(sendblk > ackblk + (long)window) {
    if(!sendblk && timeup(t2)) {
      tbuf.misc = "Trying hdr again";
      tbuf.type = TB_MISC;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      lastsealink = -1;
      t2 = timerset(5000L);
      goto XS1;
    }
    else {
      peek_at_byte(cp,500L);
      goto XS1; /* gotta have ACK/NAK */
    }
  }

  if(sendblk == lastblk) {    /* in case file grew */

    struct stat st;
    long templast = lastblk;

    if(!stat(filename,&st)) {
      lastblk = (st.st_size + 127L) / 128L;
      if(lastblk < templast)
        lastblk = templast;
    }
  }

  if(sendblk >= lastblk + 1L) {
    if(sendblk == lastblk + 1L) {   /* done for now */
      DosSleep(125L);
      com_putc(cp,EOT);
      sendblk++;
      t1 = timerset(30000L);
      tbuf.misc = "EOT";
      tbuf.type = TB_MISC;
      tbuf.bytessent = tbuf.filesize;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      peek_at_byte(cp,500L);
      goto XS1;  /* no more to send right now */
    }
    DosSleep(64L);
    goto XS3;
  }

  if(!sendblk) {                      /* gotta send a header first */
    if(justxmodem) {                  /* unless justxmodem is set */
      ackblk++;
      sendblk++;
      goto XModem;
    }
    if(!header) {           /* telink header send */
      purge_in(cp);
      com_write(cp,(char *)&tl,sizeof(TELBLK));
      tbuf.misc = "Telink hdr";
      tbuf.type = TB_MISC;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      lastsealink = -1;
    }
    else {                  /* sealink header send */
      purge_in(cp);
      com_write(cp,(char *)&sl,sizeof(SEABLK));
      tbuf.misc = "SEAlink hdr";
      tbuf.type = TB_MISC;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      lastsealink = -1;
    }
  }
  else {                      /* else we're sending the file now */
XModem:
    if(sendblk != prevblk - 1L)
      fseek(fp,(sendblk - 1L) * 128L,SEEK_SET);
    if(sendblk >= lastblk)
      memset(&xmblk.data,CTRL_Z,128);  /* fill w/ control Zs */
    fread(xmblk.data,1,128,fp);        /* read data into buffer */
    xmblk.blk = (char)sendblk;
    xmblk.blkcmp = (char)(xmblk.blk ^ 255);
    if(chktec) {                             /* CRC */

      register char   *ptr = xmblk.data;
      register USHORT  crc = 0;
      register char   *end = ptr + 128;

      while(ptr < end)
        crc = (crc << 8) ^ crctab[(crc >> 8) ^ *ptr++];
      crc = ((crc & 255) << 8) | ((crc >> 8) & 255); /* swap bytes */
      xmblk.crc = crc;
    }
    else {

      register char *ptr = xmblk.data;
      register char *end = xmblk.data + 128;
      register char  csum = 0;

      while(ptr < end)
        csum += *ptr++;
      xmblk.crc = csum;
    }

    com_write(cp,(char *)&xmblk,(133 - (chktec == 0)));

    if(sealink != lastsealink || slo != lastslo) {
      if(sealink && slo)
        tbuf.misc = "SEAlink/Overdrive";
      else if(sealink && !slo)
        tbuf.misc = "SEAlink";
      else
        tbuf.misc = "XModem/Telink";
      lastsealink = sealink;
      lastslo = slo;
      tbuf.type = TB_MISC;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
    }
    if(!(sendblk % tester)) {
      tbuf.type = TB_TICK;
      tbuf.bytessent = sendblk * 128L;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
    }
    blksent++;
  }

  prevblk = sendblk;
  if(sealink && slo) {  /* we're in overdrive (ackless) */
    ackblk = sendblk;
    sendblk++;
    t1 = timerset(60000L);
  }
  else {          /* else we're in std. sealink or xmodem/telink */
    sendblk++;
    t1 = timerset(30000L);
  }
  goto XS1;

XS3:    

  if(ackblk < lastblk + 1L) {  /* need ack on EOT to finish */
    if(!firstlast) {
      tbuf.type = TB_TICK;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      firstlast++;
    }
    peek_at_byte(cp,1000L);
    goto XS1;
  }

  if(ackblk >= lastblk + 1L) {            /* finished */
    fclose(fp);
    tbuf.type = TB_FIN;
    tbuf.misc = NULL;
    tbuf.bytessent =  sl.flen;
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);
    DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
    return sl.flen;
  }

Abort:

  if(checkcarrier(cp)) {
    tbuf.type = TB_ABORT;
    tbuf.misc = "Lost carrier, send aborted";
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);
  }

  fclose(fp);
  DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
  Clear_UD();
  return 0L;
}


long _fastcall get_resync (USHORT cp) {

  /* receive a resync packet */

  char resyncpkt[81] = "",*p;
  int len = 0,crc,hiscrc,temp;
  clock_t t1;
  long res;

  p = resyncpkt;
  t1 = timerset(60000L);

  do {
    temp = get_modem_byte(cp,1000L);
    switch(temp) {
      case TIMEOUT:
        return 0;

      case LOSTCARRIER:
        if(checkcarrier(cp))
          return 0;
        break;

      case ETX:
        *p = 0;
        goto GotIt;

      default:
        *p = (char)temp;
        p++;
        len++;
        break;
    }
  } while(len < 80 && !timeup(t1));

  return 0L;   /* timeout or overrun; bad packet */

GotIt:

  hiscrc = (get_modem_byte(cp,250L) << 8) | get_modem_byte(cp,250L);

  /* check packet to see if it's valid */

  crc = figurecrc(resyncpkt,len,0);
  if(crc != hiscrc)
    return 0L;       /* bad packet crc */

  /* good packet */

  DosSleep(500L);
  purge_in(cp);
  res = atol(resyncpkt);
  return res;
}


int _fastcall send_cancel (USHORT cp,int howmany) {

  /* Send consecutive CANcel chars */

  int  x;

  DosSleep(100L);
  for(x = 0;x < howmany;x++) {
    com_putc(cp,CAN);
    DosSleep(64L);
  }
  return 0;
}
