#define INCL_WIN

#include "sys/types.h"
#include "sys/stat.h"
#include "io.h"
#include "fcntl.h"
#include "share.h"
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "xbbs.h"
#include "nodelist.h"

    extern ADDR poll;
    extern ADDR *addresses;
    extern HWND xdhwnd;
    extern unsigned long pollnowSEM[MAXINSTANCES];




MRESULT EXPENTRY PollDlgBoxProc (HWND hwndDlg,USHORT msg,
                                 MPARAM mp1,MPARAM mp2) {

    static USHORT   fline = 65535;
    static HPOINTER hwndIcon;


    switch(msg) {
        case WM_INITDLG:
            fline = SHORT1FROMMP(mp2);
            WinPostMsg(hwndDlg, WM_REFRESH, 0L, 0L);
            hwndIcon = (HPOINTER)WinQuerySysPointer(HWND_DESKTOP,SPTR_APPICON,0);
            WinDefDlgProc(hwndDlg, WM_SETICON, (MPARAM)hwndIcon, (MPARAM)0);
            break;

        case WM_REFRESH:
            WinSendDlgItemMsg(hwndDlg, PLL_ADDR, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(80,0), NULL);

            {
                char s[81];

                if(poll.zone && *poll.domain) {
                    DosEnterCritSec();
                     sprintf(s,"%s#%u:%u/%u.%u",poll.domain,poll.zone,
                             poll.net,poll.node,poll.point);
                    DosExitCritSec();
                }
                else {
                    *s = 0;
                }
                WinSetDlgItemText(hwndDlg,PLL_ADDR,s);
            }
            return 0;

        case WM_CONTROL:
            return 0;

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case PLL_DOIT:
                    {
                        char   *p,s[82];
                        USHORT rc;

                        WinSetDlgItemText(hwndDlg,PLL_NAME,"");
                        WinSetDlgItemText(hwndDlg,PLL_SYSTEM,"");
                        WinSetDlgItemText(hwndDlg,PLL_LOCATION,"");
                        WinSetDlgItemText(hwndDlg,PLL_MISC1,"");
                        WinSetDlgItemText(hwndDlg,PLL_MISC2,"");
                        rc = WinQueryDlgItemText(hwndDlg, PLL_ADDR, 80, s);
                        if (rc > 0) {
                            p = lstrip(rstrip(s));
                            DosEnterCritSec();
                            if(parse_addr(&p,&poll,addresses)) {
                                if(!find_in_fidouser(0,(USHORT)-1,lstrip(rstrip(s)),&poll)) {
                                    memset(&poll,0,sizeof(ADDR));
                                    DosExitCritSec();
                                    DosBeep(50,100);
                                    break;
                                }
                                else
                                  guess_rest(&poll,addresses);
                            }
                            if(poll.zone && *poll.domain) {
                                 sprintf(s,"%s#%u:%u/%u.%u",poll.domain,
                                         poll.zone,poll.net,poll.node,
                                         poll.point);
                                if(fline != 65535) {
                                    if(!(USHORT)WinSendDlgItemMsg(hwndDlg,
                                                PLL_INFOONLY,BM_QUERYCHECK,
                                                MPFROMLONG(0L),MPFROMLONG(0L)))
                                      DosSemSet(&pollnowSEM[fline]);
                                    DosExitCritSec();
                                    WinSetDlgItemText(hwndDlg,PLL_ADDR,s);
                                    if(!(USHORT)WinSendDlgItemMsg(hwndDlg,
                                                PLL_INFOONLY,BM_QUERYCHECK,
                                                MPFROMLONG(0L),MPFROMLONG(0L))) {

                                        int handle;
                                        char *fname;

                                        fname = malloc(1050);
                                        if(fname) {
                                          sprintf(fname,"%s/C.%u.%u.%u.%u.%s",
                                                  d_outbound,
                                                  poll.zone,poll.net,poll.node,
                                                  poll.point,poll.domain);
                                          handle = sopen(fname,O_RDWR | O_BINARY | O_CREAT,
                                                         SH_DENYNO,S_IWRITE | S_IREAD);
                                          free(fname);
                                        }
                                        else
                                          handle = -1;
                                        if(handle != -1)
                                          close(handle);
                                        DosBeep(1000,2);
                                    }
                                    else DosBeep(100,100);
                                }
                                else DosExitCritSec();
                            }
                            else DosExitCritSec();
                            if(poll.zone && *poll.domain) {

                              NODEINFO nif;

                              nif.net = poll.net;
                              nif.node = poll.node;
                              if(!get_node_from_list(&nif,poll.zone,
                                 poll.point,poll.domain)) {
                                WinSetDlgItemText(hwndDlg,PLL_SYSTEM,"Unknown System");
                              }
                              else {

                                char s[132];

                                WinSetDlgItemText(hwndDlg,PLL_SYSTEM,nif.name);
                                WinSetDlgItemText(hwndDlg,PLL_LOCATION,nif.city);
                                sprintf(s,"%s   Pword: \"%s\"",
                                        nif.phone,nif.password);
                                WinSetDlgItemText(hwndDlg,PLL_MISC1,s);
                                sprintf(s,"Hub: %u   Cost: %u   Baud: %u   Flags: %u",
                                        nif.hubnode,nif.realcost,
                                        nif.rate * 300,nif.flags);
                                WinSetDlgItemText(hwndDlg,PLL_MISC2,s);
                              }
                            }
                        }
                    }
                    break;

                case DID_CANCEL:
                case PLL_DISMISS:
                    WinDismissDlg(hwndDlg, 0);
                    break;

                case PLL_CLEAR:
                    DosEnterCritSec();
                     memset(&poll,0,sizeof(ADDR));
                    DosExitCritSec();
                    WinSetDlgItemText(hwndDlg,PLL_ADDR,"");
                    WinSetDlgItemText(hwndDlg,PLL_NAME,"");
                    WinSetDlgItemText(hwndDlg,PLL_SYSTEM,"");
                    WinSetDlgItemText(hwndDlg,PLL_LOCATION,"");
                    WinSetDlgItemText(hwndDlg,PLL_MISC1,"");
                    WinSetDlgItemText(hwndDlg,PLL_MISC2,"");
                    break;

                default:
                    break;
            }
            return 0;
    }

    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
