#define INCL_WIN

#include "sys/types.h"
#include "sys/stat.h"
#include "io.h"
#include "fcntl.h"
#include "share.h"
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "nodelist.h"
#include "xbbs.h"


    OUTBOUND             *outdlgout;

    extern unsigned long ScanningSEM;
    extern ADDR          poll;
    extern unsigned long pollnowSEM[MAXINSTANCES];
    extern USHORT        focusline;
    extern HWND          xdhwnd;


MRESULT EXPENTRY OutDlgBoxProc (HWND hwndDlg,USHORT msg,
                                MPARAM mp1,MPARAM mp2) {

    int             x;
    static char     currentItem[290];
    static char     currentFile[1050];
    static USHORT   currentType = 0,numfiles = 0,flavorchange = 0;

    switch(msg) {
        case WM_INITDLG:
            for(x = 0;x < 8;x++) {
              if(outdlgout->types & (1 << x)) {
                WinSendDlgItemMsg(hwndDlg,OUT_CRASH + x,BM_SETCHECK,
                                  MPFROM2SHORT(1,0),NULL);
                break;
              }
            }
            WinSendDlgItemMsg(hwndDlg,OUT_ILISTBOX,LM_DELETEALL,
                              MPFROM2SHORT(0,0),MPFROM2SHORT(0,0));
            if(x >= 0 && x <= OUT_PKT - OUT_CRASH) {
              sprintf(currentFile,"%s/%c.%u.%u.%u.%u.%s",d_outbound,
                      "CDNHMR"[x],
                      outdlgout->zone,outdlgout->net,
                      outdlgout->node,outdlgout->point,outdlgout->domain);
              WinSetWindowText(WinWindowFromID(hwndDlg,OUT_FNAME),&currentFile[11]);
              currentType = (1 << x);
            }
            numfiles = 0;
            if(x >= 0 && x <= OUT_REQ - OUT_CRASH) {

              int  handle;
              char s[290];

              handle = sopen(currentFile,O_RDONLY | O_BINARY,SH_DENYNO);
              if(handle != -1) {
                while(!eof(handle)) {
                  if(!fgetsx(s,289,handle)) break;
                  stripcr(s);
                  if(*s)
                    WinSendDlgItemMsg(hwndDlg, OUT_ILISTBOX,LM_INSERTITEM,
                                      MPFROM2SHORT(LIT_END, 0),s);
                    numfiles++;
                }
                close(handle);
                sprintf(s,"%u",numfiles);
                WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMFILES),s);
              }
            }
            {
              char s[81];

              sprintf(s,"%s#%u:%u/%u.%u",outdlgout->domain,outdlgout->zone,
                      outdlgout->net,outdlgout->node,outdlgout->point);
              WinSetWindowText(WinWindowFromID(hwndDlg,OUT_ADDR),s);
            }
            if(!(outdlgout->types & O_LOCKED))
              WinSetWindowText(WinWindowFromID(hwndDlg,OUT_LOCK),"Lock");
            else
              WinSetWindowText(WinWindowFromID(hwndDlg,OUT_LOCK),"Unlock");            return MRFROMSHORT(0);
            break;

        case WM_CONTROL:
            switch(SHORT1FROMMP(mp1)) {
                case OUT_ILISTBOX:
                  if(SHORT2FROMMP(mp1) == LN_SELECT) {
                    SHORT sSelect;

                    sSelect = (USHORT)WinSendDlgItemMsg(hwndDlg,
                                                        SHORT1FROMMP(mp1),
                                                        LM_QUERYSELECTION,
                                                        MPFROMLONG(0L),
                                                        MPFROMLONG(0L));
                    if (sSelect >= 0) {

                      SHORT len;

                      len = (SHORT)WinSendDlgItemMsg(hwndDlg,SHORT1FROMMP(mp1),
                                                     LM_QUERYITEMTEXT,
                                                     MPFROM2SHORT(sSelect,289),
                                                     MPFROMP(currentItem));
                      if(len <= 0) {
                        *currentItem = 0;
                      }
                      else {

                        struct stat st;
                        char *p,t;

                        WinSetWindowText(WinWindowFromID(hwndDlg,OUT_KILL),"Del");
                        p = strchr(currentItem,' ');
                        if(p) {
                          t = *p;
                          *p = 0;
                        }
                        if(!stat(currentItem,&st)) {

                          char s[81];

                          sprintf(s,"%ld bytes",st.st_size);
                          WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMBYTES),s);
                        }
                        if(p) {
                          *p = t;
                        }
                      }
                    }
                  }
                  return 0;

                case OUT_CRASH:
                case OUT_HOLD:
                case OUT_REQ:
                case OUT_NORMAL:
                case OUT_DIRECT:
                case OUT_MANUAL:
                  if(flavorchange) {

                    char   *s;

                    s = malloc(1050);
                    if(s) {
                      sprintf(s,"%s/%c.%u.%u.%u.%u.%s",d_outbound,
                              "CDNHMR"[SHORT1FROMMP(mp1) - OUT_CRASH],
                              outdlgout->zone,outdlgout->net,
                              outdlgout->node,outdlgout->point,
                              outdlgout->domain);
                      if(!DosCopy(currentFile,s,DCPY_APPEND,0L))
                        unlink(currentFile);
                      WinSetWindowText(WinWindowFromID(hwndDlg,OUT_FLAVOR),"Flavor");
                      flavorchange = 0;
                      free(s);
                    }
                    else
                      DosBeep(25,100);
                  }
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_KILL),"Kill");
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMBYTES),"");
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMFILES),"");
                  WinSendDlgItemMsg(hwndDlg,OUT_ILISTBOX,LM_DELETEALL,
                                    MPFROM2SHORT(0,0),MPFROM2SHORT(0,0));
                  currentType = (1 << (SHORT1FROMMP(mp1) - OUT_CRASH));
                  numfiles = 0;
                  {
                    int handle;
                    char s[290];

                    sprintf(currentFile,"%s/%c.%u.%u.%u.%u.%s",d_outbound,
                            "CDNHMR"[SHORT1FROMMP(mp1) - OUT_CRASH],
                            outdlgout->zone,outdlgout->net,
                            outdlgout->node,outdlgout->point,
                            outdlgout->domain);
                    WinSetWindowText(WinWindowFromID(hwndDlg,OUT_FNAME),&currentFile[11]);
                    WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMFILES),"");
                    WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMBYTES),"");
                    handle = sopen(currentFile,O_RDONLY | O_BINARY,SH_DENYNO);
                    if(handle != -1) {
                      while(!eof(handle)) {
                        if(!fgetsx(s,289,handle)) break;
                        stripcr(s);
                        if(*s)
                          WinSendDlgItemMsg(hwndDlg, OUT_ILISTBOX,LM_INSERTITEM,
                                            MPFROM2SHORT(LIT_END, 0),s);
                          numfiles++;
                      }
                      close(handle);
                      sprintf(s,"%u",numfiles);
                      WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMFILES),s);
                    }
                  }
                  return 0;

                case OUT_PKT:
                case OUT_ARC:
                  if(flavorchange) {
                    DosBeep(100,100);
                    return 0;
                  }
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_KILL),"Kill");
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMBYTES),"");
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMFILES),"");
                  sprintf(currentFile,"%s/%c.%u.%u.%u.%u.%s",d_outbound,
                          "AP"[SHORT1FROMMP(mp1) - OUT_ARC],
                          outdlgout->zone,outdlgout->net,
                          outdlgout->node,outdlgout->point,
                          outdlgout->domain);
                  WinSetWindowText(WinWindowFromID(hwndDlg,OUT_FNAME),&currentFile[11]);
                  WinSendDlgItemMsg(hwndDlg,OUT_ILISTBOX,LM_DELETEALL,
                                    MPFROM2SHORT(0,0),MPFROM2SHORT(0,0));
                  currentType = (1 << (SHORT1FROMMP(mp1) - OUT_CRASH));
                  {
                    struct stat st;
                    char s[81];

                    if(!stat(currentFile,&st)) {
                      sprintf(s,"%ld bytes",st.st_size);
                      WinSetWindowText(WinWindowFromID(hwndDlg,OUT_NUMBYTES),s);
                    }
                  }
                  return 0;
              }

        case WM_COMMAND:
            if(flavorchange) {
              WinSetWindowText(WinWindowFromID(hwndDlg,OUT_FLAVOR),"Flavor");
              flavorchange = 0;
              return MRFROMSHORT(0);
            }

            switch(SHORT1FROMMP(mp1)) {
                case OUT_EDIT:
                  if(currentType >= O_CRASH && currentType <= O_REQUEST) {
                    sessionf(D_LOCAL,focusline,0,"%s /C EDIT.CMD %s",
                          getenv("COMSPEC"),currentFile);
                    DosSemClear(&ScanningSEM);
                    WinDismissDlg(hwndDlg,0);
                  }
                  else if(currentType == O_ARCHIVE) {
                    forkf(D_LOCAL,focusline,1,"AV.EXE %s",currentFile);
                    DosSemClear(&ScanningSEM);
                    WinDismissDlg(hwndDlg,0);
                  }
                  else if(currentType == O_PACKET) {
                    forkf(D_LOCAL,focusline,1,"PKTHDR.EXE %s",currentFile);
                    DosSemClear(&ScanningSEM);
                    WinDismissDlg(hwndDlg,0);
                  }
                  else {
                    DosBeep(100,100);
                  }
                  break;

                case OUT_CALL:
                    DosEnterCritSec();
                      if(outdlgout->domain) strcpy(poll.domain,outdlgout->domain);
                      poll.zone = outdlgout->zone;
                      poll.net = outdlgout->net;
                      poll.node = outdlgout->node;
                      poll.point = outdlgout->point;
                      DosSemSet(&pollnowSEM[focusline]);
                    DosExitCritSec();
                    DosSemClear(&ScanningSEM);
                    WinDismissDlg(hwndDlg,0);
                    break;

                case OUT_INFO:
                    {
                      NODEINFO nif;

                      nif.net = outdlgout->net;
                      nif.node = outdlgout->node;
                      if(!get_node_from_list(&nif,outdlgout->zone,
                         outdlgout->point,outdlgout->domain)) {
                        WinMessageBox(HWND_DESKTOP, hwndDlg,
                                      "Can't find him",
                                       "XBBS",0,MB_CANCEL | MB_APPLMODAL);
                      }
                      else {
                        char s[256];

                        sprintf(s,"%s\r%s\r%s\rPword: \"%s\"",nif.name,nif.city,
                                nif.phone,nif.password);
                        WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,s,
                                      "Node Info",0,MB_OK | MB_MOVEABLE);
                      }
                    }
                    DosSemClear(&ScanningSEM);
                    WinDismissDlg(hwndDlg,0);
                    break;

                case OUT_FLAVOR:
                    flavorchange = 1;
                    WinSetWindowText(WinWindowFromID(hwndDlg,OUT_FLAVOR),"Flavor!");
                    break;

                case OUT_KILL:
                    if(*currentItem) {

                      int ihandle,ohandle,killedit = 0;

                      ihandle = sopen(currentFile,O_RDONLY | O_BINARY,SH_DENYRW);
                      if(ihandle != -1) {
                        ohandle = sopen("./OUTMNGR.TMP",O_WRONLY |
                                        O_BINARY | O_CREAT | O_TRUNC,
                                        SH_DENYRW,S_IWRITE | S_IREAD);
                        if(ohandle != -1) {

                          char  s[290];
                          SHORT sSelect;

                          while(!eof(ihandle)) {
                            if(!fgetsx(s,289,ihandle))
                              break;
                            stripcr(s);
                            if(*s && stricmp(s,currentItem))
                              ffprintf(ohandle,"%s\r\n",s);
                            else {
                              logfmain("OM: Removed %s from %s",currentItem,currentFile);
                              killedit++;
                            }
                          }
                          close(ohandle);
                          close(ihandle);
                          unlink(currentFile);
                          rename("./OUTMNGR.TMP",currentFile);
                          sSelect = (SHORT)WinSendDlgItemMsg(hwndDlg,
                                                      OUT_ILISTBOX,
                                                      LM_SEARCHSTRING,
                                                      MPFROM2SHORT(0,LIT_FIRST),
                                                      MPFROMP(currentItem));
                          if(sSelect >= 0) {
                            WinSendDlgItemMsg(hwndDlg,OUT_ILISTBOX,
                                              LM_DELETEITEM,
                                              MPFROMSHORT(sSelect),
                                              MPFROMSHORT(0));
                          }
                        }
                        else {
                          close(ihandle);
                          DosBeep(100,100);
                        }
                      }
                      else {
                        DosBeep(100,50);
                        DosBeep(100,50);
                      }

                      WinSetWindowText(WinWindowFromID(hwndDlg,OUT_KILL),"Kill");

                      if(*currentItem && killedit && currentType >= O_CRASH &&
                         currentType <= O_MANUAL) {

                        char s[300],*p;

                        p = strchr(currentItem,' ');
                        if(p) *p = 0;
                        sprintf(s,"Unlink \"%s\"?",currentItem);
                        if(WinMessageBox(HWND_DESKTOP,hwndDlg,s,
                                         "Rabid Dog Killer",
                                         0,MB_YESNO |
                                         MB_MOVEABLE) == MBID_YES) {
                          unlink(currentItem);
                        }
                      }
                      *currentItem = 0;
                    }
                    else if(*currentFile) {
                      unlink(currentFile);
                      outdlgout->types &= (~currentType);
                      WinSendDlgItemMsg(hwndDlg,OUT_ILISTBOX,LM_DELETEALL,
                                        MPFROM2SHORT(0,0),MPFROM2SHORT(0,0));
                      logfmain("OM: Unlinked %s",currentFile);
                    }
                    else
                      DosBeep(100,100);
                    break;

                case DID_CANCEL:
                case OUT_QUIT:
                    DosSemClear(&ScanningSEM);
                    WinPostMsg(xdhwnd,WM_DONESCAN,0L,0L);
                    WinDismissDlg(hwndDlg, 0);
                    break;

                case OUT_LOCK:
                    if(outdlgout->types & O_LOCKED)
                      outdlgout->types &= (~O_LOCKED);
                    else outdlgout->types |= O_LOCKED;
                    if(!(outdlgout->types & O_LOCKED)) {
                      outdlgout->calls = 0;
                      outdlgout->bad = 0;
                      WinSetWindowText(WinWindowFromID(hwndDlg,OUT_LOCK),"Lock");
                    }
                    else WinSetWindowText(WinWindowFromID(hwndDlg,OUT_LOCK),"Unlock");
                    break;

                default:
                  DosBeep(100,50);
                  break;
            }
            return MRFROMSHORT(1);

        case WM_QUIT:
        case WM_CLOSE:
            DosSemClear(&ScanningSEM);
            WinPostMsg(xdhwnd,WM_DONESCAN,0L,0L);
            WinDismissDlg(hwndDlg, 0);
            break;
    }

    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
