#define INCL_WIN
#define INCL_DOS

#include "mailer.h"
#include "xmisc.h"
#include "xbbs.h"

  extern OUTBOUND *maSelected;
  extern OUTBOUND *outdlgout;
  extern ULONG     scannowSEM[MAXINSTANCES];
  extern ULONG     ScanningSEM;
  extern USHORT    focusline;
  extern OUTBOUND *outs;
  extern HWND      hwndOutbound;
  extern MDM      *modems[MAXINSTANCES];

  extern MRESULT EXPENTRY ChildFrameProc (HWND,USHORT,MPARAM,MPARAM);
  extern MRESULT EXPENTRY OutDlgBoxProc (HWND hwndDlg,USHORT msg,
                                         MPARAM mp1,MPARAM mp2);


MRESULT EXPENTRY OutboundBoxProc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  SHORT frameup;
  HWND  hwndSysmenu,hwndTitlebar,hwndMinmax;

  switch(msg) {
    case WM_CREATE:
      WinCreateWindow(hwnd,WC_LISTBOX,(PSZ)NULL,WS_VISIBLE | LS_HORZSCROLL |
                      LS_NOADJUSTPOS,
                      0,0,0,0,hwnd,HWND_TOP,IDM_OUTLISTBOX,NULL,NULL);
      WinSetPresParam(hwnd,PP_FONTNAMESIZE,
                      (ULONG)strlen("10.System Monospaced") + 1L,
                      (PVOID)"10.System Monospaced");
      hwndSysmenu = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                    FID_SYSMENU);
      hwndTitlebar = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                     FID_TITLEBAR);
      hwndMinmax = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                   FID_MINMAX);
      WinSetWindowULong(hwnd,8,(ULONG)hwndSysmenu);
      WinSetWindowULong(hwnd,12,(ULONG)hwndTitlebar);
      WinSetWindowULong(hwnd,16,(ULONG)hwndMinmax);
      WinSetWindowUShort(hwnd,2,1);
      WinDefWindowProc(hwnd,msg,mp1,mp2);
      {
        PFNWP oldproc;

        oldproc = WinSubclassWindow(ParentOf(hwnd),(PFNWP)ChildFrameProc);
        WinSendMsg(ParentOf(hwnd),WM_SETCP,MPFROMP(oldproc),MPVOID);
      }
      if(!set_saved_position(hwnd,"OutSizePos"))
        WinSendMsg(hwnd,WM_TILE,MPVOID,MPVOID);
      WinPostMsg(hwnd,WM_DONESCAN,MPVOID,MPVOID);
      return 0;

    case WM_BUTTON2DBLCLK:
      WinPostMsg(hwnd,WM_HIDEME,MPVOID,MPVOID);
      break;

    case WM_HIDEME:
      frameup = WinQueryWindowUShort(hwnd,2);
      frameup = (frameup) ? 0 : 1;
      WinSetWindowUShort(hwnd,2,frameup);
      hwndSysmenu = (HWND)WinQueryWindowULong(hwnd,8);
      hwndTitlebar = (HWND)WinQueryWindowULong(hwnd,12);
      hwndMinmax = (HWND)WinQueryWindowULong(hwnd,16);
      if(!frameup) {
        WinSetParent(hwndSysmenu,HWND_OBJECT,FALSE);
        WinSetParent(hwndTitlebar,HWND_OBJECT,FALSE);
        WinSetParent(hwndMinmax,HWND_OBJECT,FALSE);
      }
      else {
        WinSetParent(hwndSysmenu,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndTitlebar,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndMinmax,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
      }
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_UPDATEFRAME,
                 MPFROMSHORT(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINBUTTON),0L) ;
      return 0;

    case WM_SETFOCUS:
      if(SHORT1FROMMP(mp1))
        WinPostMsg(hwnd,WM_FOCUSME,MPVOID,MPVOID);
      break;

    case WM_FOCUSME:
      WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwnd,IDM_OUTLISTBOX));
      return 0;

    case WM_TILE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        swp.cx / 2,24,swp.cx / 2,(swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_CASCADE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        72,24,swp.cx - 72,swp.cy - 96,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_SIZE:
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_OUTLISTBOX),HWND_TOP,
                      0,0,SHORT1FROMMP(mp2),SHORT2FROMMP(mp2),
                      SWP_MOVE | SWP_SIZE);
      break;

    case WM_PAINT:
      {
        RECTL rclUpdate;
        HPS hps;

        hps = WinBeginPaint(hwnd,0L,(PRECTL)&rclUpdate);
        WinFillRect(hps,(PRECTL)&rclUpdate,SYSCLR_DIALOGBACKGROUND);
        WinEndPaint(hps);
      }
      break;

    case WM_AMSCANNING:
        if(!outs && focusline) {
          DosSemSet(&scannowSEM[focusline]);
          WinSendDlgItemMsg(hwnd,IDM_OUTLISTBOX,LM_DELETEALL,MPVOID,
                            MPVOID);
          WinSendDlgItemMsg(hwnd, IDM_OUTLISTBOX, LM_INSERTITEM,
                            MPFROM2SHORT(LIT_END, 0),
                            MPFROMP("[Scanning]"));
        }
        return 0;

    case WM_DONESCAN:
        {
          register int  x,once = 0;
          char          szBuffer[82];
          OUTBOUND     *maCur;

          if(DosSemRequest(&ScanningSEM,0L))      /* not available now */
            return 0;
          else {
            WinSendDlgItemMsg(hwnd,IDM_OUTLISTBOX,LM_DELETEALL,MPVOID,
                              MPFROM2SHORT(LIT_END,0));
            maCur = outs;             /* start at beginning of list */
            while(maCur) {
              if(!once) {
                WinSendDlgItemMsg(hwnd,IDM_OUTLISTBOX,LM_SELECTITEM,
                                  MPFROM2SHORT(0,0),MPVOID);
                once++;
              }
              if(maCur->types & O_CRASH)
                strcpy(szBuffer,"C");
              else
                strcpy(szBuffer,"-");
              if(maCur->types & O_DIRECT)
                strcat(szBuffer,"D");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_NORMAL)
                strcat(szBuffer,"N");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_HOLD)
                strcat(szBuffer,"H");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_MANUAL)
                strcat(szBuffer,"M");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_REQUEST)
                strcat(szBuffer,"R");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_ARCHIVE)
                strcat(szBuffer,"A");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_PACKET)
                strcat(szBuffer,"P");
              else
                strcat(szBuffer,"-");
              if(maCur->types & O_LOCKED)
                strcat(szBuffer,"L");
              else
                strcat(szBuffer,"-");
              sprintf(&szBuffer[strlen(szBuffer) - 1]," %s#%u:%u/%u.%u",
                      maCur->domain,maCur->zone,maCur->net,
                      maCur->node,maCur->point);
              x = strlen(szBuffer);
              for(;x < 45;x++)
               szBuffer[x] = ' ';
              szBuffer[x++] = ' ';
              szBuffer[x] = 0;
              sprintf(&szBuffer[strlen(szBuffer) - 1],"%-5u %-5u %-4u %-3u",
                      maCur->cost,maCur->baud,maCur->calls,maCur->bad);
              WinSendDlgItemMsg(hwnd, IDM_OUTLISTBOX, LM_INSERTITEM,
                                MPFROM2SHORT(LIT_END, 0),
                                MPFROMP(szBuffer));
              maCur = maCur->next;
           }
           maSelected = NULL;
           DosSemClear(&ScanningSEM);
         }
       }
       return 0;

    case WM_CONTROL :
      switch(SHORT1FROMMP(mp1)) {
        case IDM_OUTLISTBOX:
          if (SHORT2FROMMP(mp1) == LN_ENTER && outs) {

             register SHORT  sSelect,sCount;
             OUTBOUND       *maSelected;

              sSelect = (USHORT)WinSendDlgItemMsg(hwnd,SHORT1FROMMP(mp1),
                                                  LM_QUERYSELECTION,
                                                  MPVOID,MPVOID);
              if (sSelect >= 0) {
                 DosSemRequest(&ScanningSEM,-1L);
                 sCount = 0;
                 maSelected = outs;
                 while (sCount < sSelect && maSelected) {
                    maSelected = maSelected->next;
                    sCount++;
                 }
                 if(maSelected) {
                    outdlgout = maSelected;
                    sCount = 1;
                 }
                 else
                   sCount = 0;
                 if(sCount) {
                   WinDlgBox(HWND_DESKTOP,hwnd,OutDlgBoxProc,
                             0,OUT_BOX,NULL);
                 }
                 else {
                  DosBeep(100,50);
                  DosSemClear(&ScanningSEM);
                }
              }
              else
                DosBeep(250,50);
          }
          break;
      }
      return 0;

    case WM_CLOSE:
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_SYSCOMMAND,
                 MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
      return 0;
  }

  return WinDefWindowProc(hwnd,msg,mp1,mp2);
}
