#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "modem.h"
#include "xmisc.h"


    extern struct _msgarea   *msgareas;
    extern struct _filearea  *fileareas;
    extern MDM               *modems[MAXINSTANCES];
    extern USER              *user[MAXINSTANCES];
    extern BBS               *bbs;


 #define isleap(year) ((((year % 4) == 0) && ((year % 100) != 0)) || ((year % 400) == 0))
// #define ANSICHECK





unsigned int _pascal new_user (int mode,USHORT cp,char *name,
                               unsigned int usenumber) {

  char         yorn[6];
  unsigned int cntr;


    user[cp]->width = 80;
    user[cp]->length = 23;
    user[cp]->attribs |= U_DELETED;

    if((mode & D_REMOTE) && modems[cp]->curbaud) {
        dputs(D_REMOTE,cp,"\x1b[6n");
        DosSleep(750L);
        if(inkey(mode,cp) == '\x1b' && inkey(mode,cp) == '[')
          user[cp]->attribs |= U_ANSI;
        else
          user[cp]->attribs &= (~U_ANSI);
        purge_in(cp);
    }
    else
      user[cp]->attribs |= U_ANSI;

    cls(mode,cp);

    readansi(mode,cp,"NEWUSER.ASC",NULL,3);
    sayp(mode,cp,194,NULL,0);

    readansi(mode,cp,"BEFORENEW.ASC",NULL,3);
    sayp(mode,cp,21,NULL,0);

    purge_in(cp);

#ifndef ANSICHECK
    if(!(user[cp]->attribs & U_ANSI) && !(bbs->attribs2 & B2_ANSI))
                                     chg_ANSI(mode,cp);
#endif
    if(!(bbs->attribs & B_COLOR) && (user[cp]->attribs & U_COLOR))
                                      chg_color(mode,cp);
    if(!(bbs->attribs & B_HIGHASCII)) chg_high(mode,cp);
    if(!(bbs->attribs & B_PAUSE))     chg_pause(mode,cp);
    if(!(bbs->attribs & B_CLEAR))     chg_clear(mode,cp);
    if(!(bbs->attribs & B_COLD))      chg_cold(mode,cp);
    if(!(bbs->attribs & B_WIDTH))     chg_width(mode,cp);
    if(!(bbs->attribs & B_LENGTH))    chg_length(mode,cp);
    if(!(bbs->attribs & B_SHOW))      chg_show(mode,cp);
    if(!(bbs->attribs & B_PHONE))     chg_phone(mode,cp);
    if(!(bbs->attribs & B_ADDRESS))   chg_address(mode,cp);
    if(!(bbs->attribs & B_HANDLE))    chg_handle(mode,cp);
    if(!(bbs->attribs & B_PASSWORD))  chg_password(mode,cp);
    if(!(bbs->attribs & B_COMPUTERS)) chg_computer(mode,cp);

  {
      struct tm t;
      time_t    tt;
      char days[] = {31,28,31,30,31,30,31,31,30,31,30,31};

      readansi(mode,cp,"NEWBIRTH.ASC",NULL,3);
      sayp(mode,cp,195,NULL,0);

BirthDateAgain:

      dputs(mode,cp,"\r\n");

      tt = time(NULL);
      DosEnterCritSec();
        memcpy(&t,localtime(&tt),sizeof(struct tm));
      DosExitCritSec();

      strset(yorn,0);
      pinput_string(mode,cp,yorn,4,4,22,
                   STRT_NUMERIC,STRF_REQUIRED,
                   "User Birthyear",NULL);
      user[cp]->birthyear = atoi(yorn);

      for(;;) {
          strset(yorn,0);
          pinput_string(mode,cp,yorn,2,1,23,
                       STRT_NUMERIC,STRF_REQUIRED,
                       "User Birthmonth",NULL);
          user[cp]->birthmonth = (unsigned char)atoi(yorn);
          if(user[cp]->birthmonth < 1 || user[cp]->birthmonth > 12) continue;
          break;
      }

      for(;;) {

          if(isleap(user[cp]->birthyear)) days[1] = 29;
          else days[1] = 28;

          strset(yorn,0);
          pinput_string(mode,cp,yorn,2,1,24,
                       STRT_NUMERIC,STRF_REQUIRED,
                       "User Birthday",NULL);
          user[cp]->birthday=(unsigned char)atoi(yorn);
          if(user[cp]->birthday < 1 || user[cp]->birthday > days[user[cp]->birthmonth - 1]) continue;
          break;
      }

      dprintf(mode,cp,"\r\n%04hd/%02hu/%02hu",user[cp]->birthyear,
              user[cp]->birthmonth,user[cp]->birthday);
      strset(yorn,0);
      if(*pinput_string(mode,cp,yorn,1,1,25,
                       STRT_YN,STRF_HOT,"Confirm Birthday",NULL) != modems[cp]->YES)
        goto BirthDateAgain;
      user[cp]->age = (t.tm_year + 1900) - user[cp]->birthyear;
      if(user[cp]->birthmonth > (char)(t.tm_mon + 1)) user[cp]->age--;
      else if(user[cp]->birthmonth == (char)(t.tm_mon + 1) && \
        user[cp]->birthday >= (char)t.tm_mday) {
          user[cp]->age--;
      }

      if(bbs->minage != 0 || bbs->maxage != 0) {
          if(user[cp]->age < bbs->minage || user[cp]->age > bbs->maxage) {
              readansi(mode,cp,"BADAGE.ASC",NULL,3);
              sayp(mode,cp,26,NULL,0);
              flushout(cp);
              DosSleep(1000L);
              DosSemClear(&modems[cp]->bbsrunningSEM);
              _endthread();
          }
      }
    }

    user[cp]->initial_logon = time(NULL);
    user[cp]->expires = time(NULL) + ((long)bbs->expiredays * 86400L);
    user[cp]->last_logon = 0;
    user[cp]->logon_today = time(NULL);
    user[cp]->credit = bbs->credit;
    user[cp]->minlimit = bbs->expiremins;
    user[cp]->time_today = 0;
    user[cp]->time_per_day = bbs->time_per_day;
    user[cp]->numcalls = 0L;
    user[cp]->ulk = 0L;
    user[cp]->dlk = 0L;
    user[cp]->uktoday = 0L;
    user[cp]->dktoday = 0L;
    user[cp]->ukperday = bbs->ukperday;
    user[cp]->dkperday = bbs->dkperday;
    user[cp]->time_per_call = bbs->time_per_call;
    user[cp]->numposts = 0L;
    user[cp]->security1 = bbs->security1;
    user[cp]->security2 = bbs->security2;
    user[cp]->flags1 = bbs->flags1;
    user[cp]->flags2 = bbs->flags2;
    user[cp]->lastmsgarea = 0L;
    user[cp]->lastfilearea = 0L;
    strset(user[cp]->bbsmsg,0);
    strset(user[cp]->bbsfile,0);
    strset(user[cp]->usermsg,0);
    strset(user[cp]->userfile,0);
    DosEnterCritSec();
      bbs->last_userid++;
      while(!bbs->last_userid) bbs->last_userid++;
      user[cp]->userid = bbs->last_userid;
    DosExitCritSec();
    save_bbs(1);
    user[cp]->pointid = 0;
    memcpy(user[cp]->bbsmsg,bbs->msgflags,64);    /* set to sysop-defined */
    memcpy(user[cp]->bbsfile,bbs->fileflags,64);  /* defaults to start */
    memcpy(user[cp]->userfile,bbs->fileflags,64);
    memcpy(user[cp]->usermsg,bbs->msgflags,64);

    if(user[cp]->time_per_call) {
        user[cp]->offline = user[cp]->online + ((long)min((user[cp]->time_per_call * 60L),(user[cp]->time_per_day - user[cp]->time_today) * 60L));
    }
    else {
        user[cp]->offline = user[cp]->online + ((long)(user[cp]->time_per_day - user[cp]->time_today) * 60L);
    }

    if(!(bbs->attribs & B_NOHAPPY)) {

        char phz[81];

        sayp(mode,cp,27,NULL,0);
        print_amonth(mode,cp,user[cp]->birthyear,(int)user[cp]->birthmonth);
        sayp(mode,cp,28,NULL,0);
        dputs(mode,cp,moontxt(cp,phz,user[cp]->birthyear,
                (int)user[cp]->birthmonth,(int)user[cp]->birthday));
        dputs(mode,cp,"\r\n");
    }
    DosSleep(1000L);

    if(!(bbs->attribs & B_INTERESTS)) chg_interests(mode,cp);

// Other new user stuff

    if(!(bbs->attribs & B_NO_NEW_EDIT)) {
        readansi(mode,cp,"FIXUSER.ASC",NULL,3);
        sayp(mode,cp,29,NULL,0);
        edit_yourself(mode,cp);
    }

    /* Set up default msg/file areas */

    /* NOTE:  user[cp]->bbs* flags are used by system when determining if
       user has access to a given area.  user[cp]->user* flags are used
       to save a "permanent" record of what the user's preferences are.
       bbs->* flags are used to determine what is initially turned on. */

    for(cntr = 0;cntr < 512;cntr++) {

        char busy[] = "\\|/-";
        int  counter = 0;

        if(!(cntr % 50)) {
            dprintf(mode,cp,"%c\b",busy[counter++]);
            if(!busy[counter]) counter = 0;
        }

        if(!IsBit(bbs->bbsmsg,cntr)) {
            BitOff(user[cp]->usermsg,cntr);
        }

        if(!IsBit(bbs->bbsfile,cntr)) {
            BitOff(user[cp]->userfile,cntr);
        }

    }
    dputs(mode,cp," \b");

    if(bbs->attribs & B_FIRSTLOGMSG) {

        MSGAREA *info;

        info = next_msg_area(msgareas,cp,0);
        while(info) {
            if(!stricmp(info->name,"FEEDBACK")) break;
            info = next_msg_area(info,cp,1);
        }
        if(!info) {
            info = find_msg_area(NULL,cp,1);
        }
        if(info) {
            readansi(mode,cp,"LOGONMSG.ASC",NULL,3);
            sayp(mode,cp,30,NULL,0);
            do {
                sayp(mode,cp,31,NULL,0);
            } while(write_msg(mode,cp,info,NULL,NULL,3) && user[cp]->offline > time(NULL));
            if(user[cp]->offline <= time(NULL)) user[cp]->number = 0;
        }
    }

    user[cp]->attribs &= (~U_DELETED);
    user[cp]->number = save_user(usenumber,cp,user[cp]);

    user[cp]->lastread = make_new_lastread(cp);
    save_lastread(cp,user[cp]->lastread,user[cp]->number);

    if(user[cp]->number) {
        sayp(mode,cp,32,NULL,0);
    }
    else {
        sayp(mode,cp,33,NULL,0);
    }

    return user[cp]->number;
}
