/*
 * API for MSGID DLL (16-bit, also callable from 32-bit)
 *
 * Link to MSGID.LIB when compiling your program.
 * The API listed below will then be available.
 */

/*
 * call to get returned serial number for next MSGID
 * if -1L is returned, an error was encountered, and
 * a valid serial number couldn't be obtained.  this
 * would probably indicate something major wrong with
 * the system.
 */
#ifndef __32BIT__
ULONG _export EXPENTRY NextMsgidSerial(VOID);
#else
ULONG APIENTRY16 NextMsgidSerial(VOID);
#endif


/*
 * call anytime to flush "next" serial number to disk
 * this is done automatically at DLL termination.
 * you might want to do this after each message entered
 * if a user is entering messages, or after a group of
 * messages when automatically processing, thereby
 * reducing overhead.  It's probably a good idea to
 * call this on WM_SAVEAPPLICATION messages, too (for PM apps).
 */

#ifndef __32BIT__
VOID  _export EXPENTRY RefreshMsgidDLL(VOID);
#else
VOID APIENTRY16 RefreshMsgidDLL(VOID);
#endif
