/* Simple Menu Driver */

#include <ctype.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "xmsg.h"
#include "keys.h"

    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern BBS      *bbs;
    extern MSGAREA  *msgareas;
    extern FILEAREA *fileareas;
    extern int      helpkey;

void _fastcall bbsfree_strarray (USHORT cp,char **array,int numitems);


/* menuflags definitions */

#define QUOTEEVERY 1
#define QUOTEONCE  2



int _pascal menu_drvr (int mode,USHORT cp,char *fname,int amsub,
                       unsigned int flags) {

    /*
     * amsub should always be 0 when calling this function for the first
     * time; it's used internally to indicate the depth of gosub recursion
     *
     */

    #define MAXCMDS 81

    char *s,**menuitem,**menudata,color[24],misc[32],*prompt,*p,*pp,*showfile,
         *menukey,newfname[133];
    int  numitems,c,com,*menucolor,*menucommand,handle,promptcolor,ti,
         command,wassub,nextexec = 0,lastcolor,once = 0;
    unsigned long tl,menuflags;

    /* bitmapped flags:
        1:  return after one command selected
        2:  auto-execute each command in menu
    */


ReStart:

    command = 0;
    cls(mode,cp);

    {
        char *ldit;

        ldit = malloc(1050);
        if(ldit) {
          sprintf(ldit,"%s/%s",d_menu,fname);
          if(user[cp]->attribs & U_COLOR) {
              p = strstr(ldit,".MNU");
              if(p) {

                  struct stat st;

                  p++;
                  *p = 'G';
                  if(stat(ldit,&st) || st.st_size == 0L) *p = 'M';
              }
          }
          handle = bbs_sopen(cp,ldit,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYWR);
          free(ldit);
        }
        else
          handle = -1;
    }
    if(handle == -1)
      return -2;

    /* dynamically allocate storage for menu data */

    menuitem = (char **)bbs_malloc(cp,MAXCMDS * sizeof(char *));
    if(!menuitem) {
        bbs_close(cp,handle);
        return -3;
    }
    memset(menuitem,0,MAXCMDS * sizeof(char *));

    menudata = (char **)bbs_malloc(cp,MAXCMDS * sizeof(char *));
    if(!menudata) {
        bbs_free(cp,menuitem);
        bbs_close(cp,handle);
        return -3;
    }
    memset(menudata,0,MAXCMDS * sizeof(char *));

    menucolor = (int *)bbs_malloc(cp,MAXCMDS * sizeof(int));
    if(!menucolor) {
      bbs_free(cp,menuitem);
      bbs_free(cp,menudata);
      bbs_close(cp,handle);
      return -3;
    }
    memset(menucolor,0,MAXCMDS * sizeof(int));

    menucommand = (int *)bbs_malloc(cp,MAXCMDS * sizeof(int));
    if(!menucommand) {
      bbs_free(cp,menuitem);
      bbs_free(cp,menudata);
      bbs_free(cp,menucolor);
      bbs_close(cp,handle);
      return -3;
    }
    memset(menucommand,0,MAXCMDS * sizeof(int));

    menukey = (char *)bbs_malloc(cp,(MAXCMDS + 1) * sizeof(char));
    if(!menucommand) {
      bbs_free(cp,menuitem);
      bbs_free(cp,menudata);
      bbs_free(cp,menucolor);
      bbs_free(cp,menucommand);
      bbs_close(cp,handle);
      return -3;
    }
    memset(menukey,0,(MAXCMDS + 1) * sizeof(char));

    s = (char *)bbs_malloc(cp,513);
    if(!s) {
      bbs_free(cp,menuitem);
      bbs_free(cp,menudata);
      bbs_free(cp,menucolor);
      bbs_free(cp,menucommand);
      bbs_free(cp,menukey);
      bbs_close(cp,handle);
      return -3;
    }

    /* load menu prompt definition */

    if(!fgetsx(s,513,handle)) {
      bbs_free(cp,menuitem);
      bbs_free(cp,menudata);
      bbs_free(cp,menucolor);
      bbs_free(cp,menucommand);
      bbs_free(cp,menukey);
      bbs_free(cp,s);
      bbs_close(cp,handle);
      return -4;
    }

    stripcr(s);
    p = to_delim(s,",");
    if(*p) {
      *p = 0;
      p++;
    }

    prompt = bbs_strdup(cp,s);
    showfile = NULL;
    if(*p) {
      promptcolor = atoi(p);
      p = to_delim(p,",");
      if(*p) {
        p++;
        if(*p != ',') {
          pp = to_delim(p,",");
          if(*pp) {
            *pp = 0;
            pp++;
          }
          showfile = bbs_strdup(cp,p);
        }
        else
          pp = p + 1;
        if(*pp)
          menuflags = atol(pp);
      }
    }
    else
      promptcolor = 0;

    /* load individual menu items */

    numitems = 0;
    while(!eof(handle) && numitems < MAXCMDS) {
        menukey[numitems] = 255;
        menucommand[numitems] = 0;
        menuitem[numitems] = NULL;
        menudata[numitems] = NULL;
        menucolor[numitems] = 0;
        menukey[numitems + 1] = 0;

        if(!fgetsx(s,512,handle)) break;
        if(*s == ';') continue;
        stripcr(s);
        if(*s != ',') menukey[numitems] = *s;
        p = to_delim(s,",");
        if(!*p) continue;
        p++;
        menucommand[numitems] = atoi(p);
        p = to_delim(p,",");
        if(*p) {
            *p = 0;
            p++;
            pp = to_delim(p,",");
            if(*pp) {
                *pp = 0;
                pp++;
            }
            menuitem[numitems] = bbs_strdup(cp,p);
            if(*pp) {
                p = to_delim(pp,",");
                if(*p) {
                    *p = 0;
                    p++;
                }
                menudata[numitems] = bbs_strdup(cp,pp);
                if(*p) {
                    menucolor[numitems] = (char)atoi(p);
                    p = to_delim(p,",");    /* age and security checks */
                    if(*p) {
                        p++;
                        ti = atoi(p);
                        if(ti) {
                            if(ti > 0 && user[cp]->age < ti) goto FreeOne;
                            else if(user[cp]->age > ti) goto FreeOne;
                        }
                        p = to_delim(p,",");
                        if(*p) {
                            p++;
                            tl = atol(p);
                            if(user[cp]->security1 < tl) goto FreeOne;
                            p = to_delim(p,",");
                            if(*p) {
                                p++;
                                tl = atol(p);
                                if(user[cp]->security2 < tl) goto FreeOne;
                                p = to_delim(p,",");
                                if(*p) {
                                    p++;
                                    tl = atol(p);
																		if(user[cp]->flags1 & (~tl))
																			goto FreeOne;
                                    p = to_delim(p,",");
                                    if(*p) {
                                        p++;
                                        if(user[cp]->flags2 & (~tl)) {

FreeOne:

                                            if(menuitem[numitems]) bbs_free(cp,menuitem[numitems]);
                                            if(menudata[numitems]) bbs_free(cp,menudata[numitems]);
                                            continue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        numitems++;
    }

    bbs_close(cp,handle);

    /* process menu */

ProcessMenu:

    while(user[cp]->offline > time(NULL)) {
        lastcolor = 0;
        if(checkcarrier(cp)) {
          amsub = -1;
          goto EndIt;
        }
        if((flags & 1) && command)
          goto EndIt;

        if(flags & 2) {
          if(nextexec > numitems)
            goto EndIt;
          com = nextexec++;
          goto ProcessCommand;
        }

        com = 0;
        if((menuflags & QUOTEEVERY) || ((menuflags & QUOTEONCE) && !once)) {
          if((rand() % 100) > bbs->quoteodds) {
            once++;
            if(user[cp]->attribs & U_COLOR) {
              MAKE_ANSI(promptcolor,color);
              lastcolor = promptcolor;
              dputs(mode,cp,color);
            }
            dputs(mode,cp,"\r\n");
            say_quote(mode,cp);
          }
        }
        if(showfile) {
          if(!(user[cp]->attribs & U_NOCLEAR))
            cls(mode,cp);
          else
            dputs(mode,cp,"\r\n");
          com = readansi(mode,cp,showfile,menukey,2);
          if(com) {
            if(com == 255 || menucommand[com - 1] == 32767) {
              com = 0;
            }
            else goto ProcessCommand;
          }
        }
        else {
          dputs(mode,cp,"\r\n\r\n");
          for(c = 0;c < numitems;c++) {
            if(menuitem[c] && *menuitem[c]) {
              if((user[cp]->attribs & U_COLOR) && menucolor[c] &&
                 lastcolor != menucolor[c]) {
                dputs(mode,cp,MAKE_ANSI(menucolor[c],color));
                lastcolor = menucolor[c];
              }
              p = bbs_convert_string(cp,menuitem[c]);
              if(p) {
                dputs(mode,cp,p);
                bbs_free(cp,p);
              }
              else dputs(mode,cp,menuitem[c]);
            }
            if((com = check_hot(mode,cp,menukey,0)) != 0) {
              if(!com || com == 255 || menucommand[com - 1] == 32767) {
                com = 0;
              }
              else {
                if(prompt && *prompt) {
                  if((user[cp]->attribs & U_COLOR) && promptcolor &&
                     promptcolor != lastcolor) {
                    dputs(mode,cp,MAKE_ANSI(promptcolor,color));
                  }
                }
                goto ProcessCommand;
              }
            }
          }
        }

        if(user[cp]->offline < time(NULL)) goto EndIt;

        if(prompt && *prompt) {
          if((user[cp]->attribs & U_COLOR) && promptcolor &&
             promptcolor != lastcolor) {
            dputs(mode,cp,MAKE_ANSI(promptcolor,color));
          }
          p = bbs_convert_string(cp,prompt);
          if(p) {
            dputs(mode,cp,p);
            bbs_free(cp,p);
          }
          else dputs(mode,cp,prompt);
        }

        lastcolor = 0;
        while(!com) {
          if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
            amsub = 0;
            goto EndIt;
          }
          handle = toupper(wait_inkey(mode,cp));
          if(handle == '\r' || handle == -1) {
            DosSleep(1L);
            goto ProcessMenu;
          }
          if(handle == helpkey) {
            strncpy(color,fname,23);
            color[23] = 0;
            p = strchr(color,'.');
            if(p)
              *p = 0;
            strcpy(misc,color);
            strcat(misc,".HLP");
            dputs(mode,cp,"\r\n");
            send_help(mode,cp,color,misc);
            DosSleep(1000L);
            goto ProcessMenu;
          }
          com = check_hot(mode,cp,menukey,handle);
          if(!com || com == 255 || menucommand[com - 1] == 32767) {
            com = 0;
            continue;
          }
          if(isprint(handle)) dputc(mode,cp,(char)handle);
          dputs(mode,cp,"\r\n");
        }

ProcessCommand:

        if(!com || com == 255 || menucommand[com - 1] == 32767 ||
           com > numitems)
          continue;

        command = menucommand[com - 1];
        switch(command) {
            case 0:                         /* GOTO a different menu */
GOTO:
                p = bbs_convert_string(cp,menudata[com - 1]);
                if(p) {
                  strncpy(newfname,p,132);
                  newfname[132] = 0;
                  bbs_free(cp,p);
                }
                else {
                  strncpy(newfname,menudata[com - 1],132);
                  newfname[132] = 0;
                }
                {
                  struct stat st;
                  char *s;

                  s = malloc(1050);
                  if(s) {
                    sprintf(s,"%s/%s",d_menu,newfname);
                    if(stat(s,&st) || st.st_size == 0L) {
                      logfunc(0,cp,"Missing or null menu %s",newfname);
                      break;
                    }
                    free(s);
                  }
                  else
                    break;
                }
                fname = newfname;
                bbsfree_strarray(cp,menuitem,numitems);
                bbs_free(cp,menuitem);
                bbsfree_strarray(cp,menudata,numitems);
                bbs_free(cp,menucolor);
                bbs_free(cp,menucommand);
                bbs_free(cp,menukey);
                bbs_free(cp,s);
                if(showfile)
                  bbs_free(cp,showfile);
                if(prompt)
                  bbs_free(cp,prompt);
                flags &= (~2);
                goto ReStart;

            case 7:                         /* GOSUB an auto-execute menu */
            case 6:                         /* GOSUB a forced-return menu */
            case 1:                         /* GOSUB a different menu */
GOSUB:
                if(amsub < 9) {
                  p = bbs_convert_string(cp,menudata[com - 1]);
                  if(p) {
                    wassub = menu_drvr(mode,cp,p,amsub + 1,(command == 6) | ((command == 7) * 2));
                    bbs_free(cp,p);
                    if(wassub < 1) {
                      if(wassub < -1) break;
                      if(wassub == -1 || amsub) {
                        amsub = wassub;
                        goto EndIt;
                      }
                    }
                  }
                  else {
                    wassub = menu_drvr(mode,cp,menudata[com - 1],amsub + 1,(command == 6) | ((command == 7) * 2));
                    if(wassub < 1) {
                      if(wassub < -1) break;
                      if(wassub == -1 || amsub) {     /* clear all gosubs */
                         amsub = wassub;
                         goto EndIt;
                      }
                    }
                  }
                }
                else {
                  dputs(D_LOCAL,cp,"\r\n\04Gosubs nested too deep\r\n");
                  DosSleep(1000L);
                }
                break;

            case 2:                         /* return from a gosub */
                if(amsub) {
                  goto EndIt;
                }
                break;

            case 3:                         /* clear all gosubs */
                if(amsub) {
                  amsub = 0;
                  goto EndIt;
                }
                break;

            case 4:                         /* goto w/ password */
            case 5:                         /* gosub w/ password */
                p = to_delim(menudata[com - 1],";");
                if(!*p) {
                  if(command == 5) goto GOSUB;
                  goto GOTO;
                }
                p++;
                {
                    char pword[13];

                    strset(pword,0);
                    pinput_string(mode,cp,pword,12,0,46,
                                 STRT_ALL,STRF_REQUIRED | STRF_ENCRYPT,
                                 "Menu Password",NULL);
                    if(strcmp(pword,p)) {
                        if(user[cp]->badattempts == bbs->maxattempts) {
                            user[cp]->badattempts++;
                            sayp(mode,cp,115,NULL,0);
                        }
                        else if(user[cp]->badattempts > bbs->maxattempts) {
                            sayp(mode,cp,116,NULL,0);
                            DosSemClear(&modems[cp]->bbsrunningSEM);
                            _endthread();
                        }
                        else {
                            sayp(mode,cp,117,NULL,0);
                            user[cp]->badattempts++;
                        }
                        break;
                    }
                }
                p--;
                *p = 0;
                if(command == 5) goto GOSUB;
                goto GOTO;

            case 10:        /* read msg stuff */
            case 11:
            case 12:
            case 13:
            case 14:
                if(!how_many_msgs(user[cp]->currmsgarea)) {
                    sayp(mode,cp,118,NULL,0);
                    DosSleep(1500L);
                }
                else do_msgread1(mode,cp,(command - 10) | 8,0);
                break;

            case 15:
                if(_beginthread(TXT_export,NULL,16384,&cp) == -1) {
                    sayp(mode,cp,72,NULL,0);
                    break;
                }
                sayp(mode,cp,74,NULL,0);
                DosSleep(1500L);
                break;

            case 16:
                if(_beginthread(FIDO_export,NULL,16384,&cp) == -1) {
                    sayp(mode,cp,73,NULL,0);
                    break;
                }
                sayp(mode,cp,74,NULL,0);
                DosSleep(1500L);
                break;

            case 20:
            case 21:
                do_globalmsgread1(mode,cp,(command - 20) | 8);
                break;

            case 30:        /* miscellaneous junk */
                give_status1(mode,cp,user[cp]);
                break;

            case 31:
                who_is_online(mode,cp);
                break;

            case 32:
                ask_list_users(mode,cp);
                break;

            case 33:
                edit_yourself(mode,cp);
                break;

            case 34:
                print_calendar(mode,cp);
                hitreturn(mode,cp);
                break;

            case 40:        /* text file junk */
                library(mode,cp);
                break;

            case 41:
                p = to_delim(menudata[com - 1],";");
                if(*p) {
                    *p = 0;
                    p++;
                }
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    readtext(mode,cp,pp);
                    bbs_free(cp,pp);
                }
                else readtext(mode,cp,menudata[com - 1]);
                if(*p) {
                    p--;
                    *p = ';';
                }
                break;

            case 42:
                p = to_delim(menudata[com - 1],";");
                if(*p) {
                    *p = 0;
                    p++;
                }
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    readansi(mode,cp,pp,NULL,atoi(p));
                    bbs_free(cp,pp);
                }
                else readansi(mode,cp,menudata[com - 1],NULL,atoi(p));
                if(*p) {
                    p--;
                    *p = ';';
                }
                break;

            case 43:
                p = to_delim(menudata[com - 1],";");
                if(*p) {
                    *p = 0;
                    p++;
                }
                else p = NULL;
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    create_text_file(mode,cp,pp,p);
                    bbs_free(cp,pp);
                }
                else create_text_file(mode,cp,menudata[com - 1],p);
                if(p) {
                    p--;
                    *p = ';';
                }
                break;

            case 44:
            case 45:
            case 46:
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    readany(mode,cp,pp,command - 44);
                    bbs_free(cp,pp);
                }
                else readany(mode,cp,menudata[com - 1],command - 44);
                break;

            case 50:        /* select area junk */
                select_msg_area(mode,cp);
                break;

            case 51:
                select_file_area(mode,cp);
                break;

            case 52:
                {
                    MSGAREA *info;

                    p = to_delim(menudata[com - 1],";");
                    if(*p) {
                        *p = 0;
                        p++;
                    }
                    pp = bbs_convert_string(cp,menudata[com - 1]);
                    if(pp) {
                        info = find_msg_area(pp,cp,0);
                        bbs_free(cp,pp);
                    }
                    else info = find_msg_area(menudata[com - 1],cp,0);
                    if(info) user[cp]->currmsgarea = info;
                    if(*p) {
                        p--;
                        *p = ';';
                    }
                }
                break;

            case 53:
                {
                    FILEAREA *info;

                    p = to_delim(menudata[com - 1],";");
                    if(*p) {
                        *p = 0;
                        p++;
                    }
                    pp = bbs_convert_string(cp,menudata[com - 1]);
                    if(pp) {
                        info = find_file_area(pp,cp,0,0);
                        bbs_free(cp,pp);
                    }
                    else info = find_file_area(menudata[com - 1],cp,0,0);
                    if(info) user[cp]->currfilearea = info;
                    if(*p) {
                        p--;
                        *p = ';';
                    }
                }
                break;

            case 54:
                {
                    LIBAREA *info;

                    p = to_delim(menudata[com - 1],";");
                    if(*p) {
                        *p = 0;
                        p++;
                    }
                    pp = bbs_convert_string(cp,menudata[com - 1]);
                    if(pp) {
                        info = find_lib_area(pp,cp,0);
                        bbs_free(cp,pp);
                    }
                    else info = find_lib_area(menudata[com - 1],cp,0);
                    if(info) user[cp]->currlibarea = info;
                    if(*p) {
                        p--;
                        *p = ';';
                    }
                }
                break;

            case 55:
              {
                MSGAREA *info;
                int     x = 0;

                if(menudata[com - 1]) x = atoi(menudata[com - 1]);
                if(x != 1 && x != -1) x = 1;
                info = next_msg_area(user[cp]->currmsgarea,cp,x);
                if(info) user[cp]->currmsgarea = info;
              }
              break;

            case 56:
              {
                FILEAREA *info;
                int     x = 0;

                if(menudata[com - 1]) x = atoi(menudata[com - 1]);
                if(x != 1 && x != -1) x = 1;
                info = next_file_area(user[cp]->currfilearea,cp,x,0);
                if(info) user[cp]->currfilearea = info;
              }
              break;

            case 57:
              {
                LIBAREA *info;
                int     x = 0;

                if(menudata[com - 1]) x = atoi(menudata[com - 1]);
                if(x != 1 && x != -1) x = 1;
                info = next_lib_area(user[cp]->currlibarea,cp,x);
                if(info) user[cp]->currlibarea = info;
              }
              break;


            case 60:        /* file list junk */
            case 66:
            case 67:
            case 68:
                if(user[cp]->currfilearea) {

                    long dummy;
                    char *s;

                    s = bbs_malloc(cp,strlen(user[cp]->currfilearea->dpath) + 13);
                    if(s) {
                        int         err;
                        char        input[33] = "";
                        time_t      date = 0L;

                        strset(input,0);
                        if(command == 67 || command == 68) date = user[cp]->last_logon;
                        if(command == 66 || command == 67) {
                            pinput_string(mode,cp,input,32,0,45,
                                         STRT_ALL,STRF_UCASE,
                                         "File Matchstring",NULL);
                        }
                        dputs(mode,cp,"\r\n");
                        sayp(mode,cp,86,NULL,0);
                        if(menudata[com - 1] && !stricmp(menudata[com - 1],"ALL")) {
                            if(list_all_fbbs(mode,cp,input,&dummy,date,0,&err) > 0L) {
                                dputs(mode,cp,"\r\n");
                                hitreturn(mode,cp);
                            }
                            else dputs(mode,cp,"\r\n");
                        }
                        else {
                            if(list_fbbs(mode,cp,input,&dummy,NULL,
                              user[cp]->currfilearea->dpath,date,
                              (((user[cp]->currfilearea->areaflags & F_NODIR) != 0) * 2) |
                              (((user[cp]->currfilearea->areaflags & F_NOFBBS) != 0) * 4) |
                              (((user[cp]->currfilearea->areaflags & F_NOCOMMON) != 0) * 8) |
                              (((user[cp]->currfilearea->areaflags & F_COMMONONLY) != 0) * 16),
                              &err) > 0L) {
                                dputs(mode,cp,"\r\n");
                                hitreturn(mode,cp);
                            }
                            else dputs(mode,cp,"\r\n");
                        }
                        bbs_free(cp,s);
                    }
                }
                else {
                    sayp(mode,cp,87,NULL,0);
                    DosSleep(2000L);
                }
                break;

            case 61:
            case 62:
            case 63:
            case 64:
                if(com > 62 || user[cp]->currfilearea) {

                    long numfiles;
                    char *p;
                    int  error;
                    int  flags = 0;

                    if(com > 62)
                      p = menudata[com - 1];
                    else {
                      p = user[cp]->currfilearea->dpath;
                      if(user[cp]->currfilearea->areaflags & 32)
                        flags = 2;
                    }

                    if(command == 62 || command == 64) {

                        char mask[13] = "*.*";

                        pinput_string(mode,cp,mask,12,0,119,
                                     STRT_FILENAME,STRF_UCASE,
                                     "File Mask",NULL);
                        dputs(mode,cp,"\r\n");
                        if(!*mask)
                          strcpy(mask,"*.*");
                        sprintf(s,"%s/%s",p,mask);
                    }
                    else
                      sprintf(s,"%s/*.*",p);
                    list_files(mode,cp,s,&numfiles,0L,flags,&error);
                }
                else {
                    sayp(mode,cp,87,NULL,0);
                    DosSleep(2000L);
                }
                break;

            case 65:
                {
                    long dummy;

                    find_file(mode,cp,&dummy,0L,0);
                }
                break;

            case 69:
              view_arc_shell(mode,cp);
              break;

            case 70:        /* download junk */
                if(user[cp]->currfilearea && stricmp(user[cp]->currfilearea->dpath,"NUL")) {

                    char input[75];
                    long tk;

                    if(user[cp]->dktoday > user[cp]->dkperday) {
                        sayp(mode,cp,88,NULL,0);
                        DosSleep(2000L);
                        break;
                    }

                    strset(input,0);
                    pinput_string(mode,cp,input,74,1,89,
                                 STRT_MULTFILES,STRF_PRETTY,
                                 "Download1",NULL);
                    dputs(mode,cp,"\r\n");
                    if(!*input) break;
                    tk = download_files(mode,cp,input,NULL,
                                        &user[cp]->dlnum,0) / 1024L;
                    user[cp]->dlk += tk;
                    user[cp]->dktoday += tk;
                    if(modems[cp]->curbaud) {
                        DosSleep(2000L);
                    }
                    if(!tk) sayp(mode,cp,90,NULL,0);
                    DosSleep(1L);
                    break;
                }
                else {
                    sayp(mode,cp,87,NULL,0);
                    DosSleep(2000L);
                }
                break;

            case 71:
                {
                    long tk;

                    pp = bbs_convert_string(cp,menudata[com - 1]);
                    if(pp) {
                        tk = download_files(mode,cp,pp,NULL,
                                            &user[cp]->dlnum,0) / 1024L;
                    }
                    else {
                        tk = download_files(mode,cp,menudata[com - 1],NULL,
                                            &user[cp]->dlnum,0) / 1024L;
                    }
                    user[cp]->dlk += tk;
                    user[cp]->dktoday += tk;
                    if(modems[cp]->curbaud) {
                        DosSleep(2000L);
                    }
                    if(!tk)
                      sayp(mode,cp,90,NULL,0);
                    DosSleep(1L);
                }
                break;

            case 72:
                {
                    long         tk,nfiles;
                    unsigned int flags;

                    flags = atoi(bbs_convert_string(cp,menudata[com - 1]));
                    tk = download_list(mode,cp,&nfiles,flags);
                    user[cp]->dlk += tk;
                    user[cp]->dktoday += tk;
                    if(modems[cp]->curbaud)
                      DosSleep(2000L);
                    if(!tk && !nfiles)
                      sayp(mode,cp,90,NULL,0);
                    DosSleep(1L);
                }
                break;

            case 80:            /* upload junk */
                if(!user[cp]->currfilearea) {
                    sayp(mode,cp,87,NULL,0);
                    DosSleep(2000L);
                }
                else if(file_write_ok(user[cp],user[cp]->currfilearea) || !stricmp(user[cp]->currfilearea->upath,"NUL")) {
                    sayp(mode,cp,91,NULL,0);
                    DosSleep(2000L);
                }
                else {

                    char input[75];
                    long tk;

                    strset(input,0);
                    pinput_string(mode,cp,input,74,1,92,
                                 STRT_FILENAME,STRF_PRETTY,
                                 "Upload1",NULL);
                    dputs(mode,cp,"\r\n");
                    if(!*input) break;
                    tk = upload_files(mode,cp,input,user[cp]->currfilearea->upath,user[cp]->currfilearea->name,&user[cp]->ulnum,0) / 1024L;
                    user[cp]->ulk += tk;
                    user[cp]->uktoday += tk;
                    if(!tk) sayp(mode,cp,93,NULL,0);
                }
                break;

            case 81:
                {
                    long tk;

                    p = to_delim(menudata[com - 1],";");
                    if(*p) {
                        *p = 0;
                        p++;
                    }
                    if(!*p) p = user[cp]->currfilearea->upath;
                    pp = bbs_convert_string(cp,menudata[com - 1]);
                    if(pp) {
                        tk = upload_files(mode,cp,pp,p,user[cp]->currfilearea->name,&user[cp]->ulnum,0) / 1024L;
                    }
                    else {
                        tk = upload_files(mode,cp,menudata[com - 1],p,user[cp]->currfilearea->name,&user[cp]->ulnum,0) / 1024L;
                    }
                    user[cp]->ulk += tk;
                    user[cp]->uktoday += tk;
                    if(!tk) sayp(mode,cp,93,NULL,0);
                    if(*p) {
                        p--;
                        *p = ';';
                    }
                }
                DosSleep(1L);
                break;

            case 90:    /* miscellaneous toggles */
                user[cp]->attribs |= atol(menudata[com - 1]);
                break;

            case 91:
                user[cp]->attribs &= atol(menudata[com - 1]);
                break;

            case 92:
                user[cp]->attribs2 |= atol(menudata[com - 1]);
                break;

            case 93:
                user[cp]->attribs2 &= atol(menudata[com - 1]);
                break;

            case 94:
                user[cp]->flags1 |= atol(menudata[com - 1]);
                break;

            case 95:
                user[cp]->flags1 &= atol(menudata[com - 1]);
                break;

            case 96:
                user[cp]->flags2 |= atol(menudata[com - 1]);
                break;

            case 97:
                user[cp]->flags2 &= atol(menudata[com - 1]);
                break;

            case 98:
                user[cp]->lastprotocol = *menudata[com - 1];
                break;

            case 99:
                user[cp]->computer_type = atoi(menudata[com - 1]);
                break;

            case 100:   /* adjust file areas */
                adjust_fileareas(mode,cp);
                break;

            case 101:   /* adjust msg areas */
                adjust_msgareas(mode,cp);
                break;

            case 102:   /* page sysop */
                chat_request(mode,cp);
                DosSleep(1000L);
                break;

            case 103:   /* help */
                p = to_delim(menudata[com - 1],";");
                if(*p) {
                    *p = 0;
                    p++;
                }
                else
                  p = NULL;
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    send_help(mode,cp,pp,p);
                }
                else {
                    send_help(mode,cp,menudata[com - 1],p);
                }
                if(p && *p) {
                    p--;
                    *p = ';';
                }
                break;

            case 104:   /* set interface */
                user[cp]->interface = (char)atoi(menudata[com - 1]);
                break;

            case 105:   /* run a REXX command file */
                RexxScriptFile(mode,cp,menudata[com - 1]);
                break;

            case 107:
            case 108:   /* run a separate session */
            case 109:   /* run a Door */
            case 110:   /* spawn; leave commport active */
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    if(command == 109)
                      runemf(mode,cp,0,pp);
                    else if(command == 107)
                      runemf(mode,cp,1,pp);
                    else if(command == 108)
                      wait_sessionf(mode,cp,0,pp);
                    else
                      forkf(mode,cp,command - 110,pp);
                    bbs_free(cp,pp);
                }
                else {
                  if(command == 109)
                    runemf(mode,cp,0,menudata[com - 1]);
                  else if(command == 107)
                    runemf(mode,cp,1,menudata[com - 1]);
                  else if(command == 108)
                    wait_sessionf(mode,cp,0,pp);
                  else
                    forkf(mode,cp,command - 110,menudata[com - 1]);
                }
                break;

            case 116:   /* spawn; deactivate/reactivate commport */
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
                if(modems[cp]->mh != -1) {
                  hold_comthread(cp);
                }
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                  forkf(mode,cp,command - 116,pp);
                  bbs_free(cp,pp);
                }
                else forkf(mode,cp,command - 116,menudata[com - 1]);
                if(modems[cp]->mh != -1) {
                  restart_comthread(cp);
                }
                break;

            case 122:   /* start session; leave commport active */
            case 123:
            case 124:
            case 125:
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                    sessionf(mode,cp,command - 122,pp);
                    bbs_free(cp,pp);
                }
                else sessionf(mode,cp,command - 122,menudata[com - 1]);
                break;

            case 126:   /* start session; deactivate/reactivate commport */
            case 127:
            case 128:
            case 129:
                if(modems[cp]->mh != -1) {
                  hold_comthread(cp);
                }
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                  sessionf(mode,cp,command - 126,pp);
                  bbs_free(cp,pp);
                }
                else sessionf(mode,cp,command - 126,menudata[com - 1]);
                if(modems[cp]->mh != -1) {
                  restart_comthread(cp);
                }
                break;

            case 130:       chg_address(mode,cp);
                            break;

            case 131:       chg_color(mode,cp);
                            break;

            case 132:       chg_high(mode,cp);
                            break;

            case 133:       chg_cold(mode,cp);
                            break;

            case 134:       chg_length(mode,cp);
                            break;

            case 135:       chg_pause(mode,cp);
                            break;

            case 136:       chg_handle(mode,cp);
                            break;

            case 137:       chg_password(mode,cp);
                            break;

            case 138:       chg_width(mode,cp);
                            break;

            case 139:       chg_phone(mode,cp);
                            break;

            case 140:       chg_interests(mode,cp);
                            break;

            case 141:       chg_show(mode,cp);
                            break;

            case 142:       chg_expert(mode,cp);
                            break;

            case 143:       chg_roll(mode,cp);
                            break;

            case 144:       chg_ANSI(mode,cp);
                            break;

            case 145:       chg_misc(mode,cp);
                            break;

            case 146:       chg_protocol(mode,cp);
                            break;

            case 147:       chg_newmsgs(mode,cp);
                            break;

            case 148:       chg_newfiles(mode,cp);
                            break;

            case 149:       chg_limitflist(mode,cp);
                            break;

            case 150:       chg_seenews(mode,cp);
                            break;

            case 151:       chg_askdl(mode,cp);
                            break;

            case 152:       chg_uavail(mode,cp);
                            break;

            case 153:       chg_EBCDIC(mode,cp);
                            break;

            case 160:    /* miscellaneous toggles */
            case 161:
            case 162:
            case 163:
                {
                  int attrib = atoi(menudata[com - 1]);

                  if(attrib > 32 || attrib < 1) {
                    dprintf(D_LOCAL,cp,"\n\04Error in command #%d:  attrib = %d\n",
                            command,attrib);
                    break;
                  }
                  else
                    attrib--;

                  switch(command) {
                    case 160:
                      user[cp]->attribs = ((user[cp]->attribs & (1 << attrib)) != 0) ?
                                           (user[cp]->attribs & ~(1 << attrib)) :
                                           (user[cp]->attribs | (1 << attrib));
                      break;

                    case 161:
                      user[cp]->attribs2 = ((user[cp]->attribs2 & (1 << attrib)) != 0) ?
                                           (user[cp]->attribs2 & ~(1 << attrib)) :
                                           (user[cp]->attribs2 | (1 << attrib));
                      break;

                    case 162:
                      user[cp]->flags1 = ((user[cp]->flags1 & (1 << attrib)) != 0) ?
                                           (user[cp]->flags1 & ~(1 << attrib)) :
                                           (user[cp]->flags1 | (1 << attrib));
                      break;

                    case 163:
                      user[cp]->flags2 = ((user[cp]->flags2 & (1 << attrib)) != 0) ?
                                           (user[cp]->flags2 & ~(1 << attrib)) :
                                           (user[cp]->flags2 | (1 << attrib));
                      break;
                  }
                }
                break;

            case 190:   chat_request(mode,cp);
                        break;

            case 200:   /* write msg */
                if(!write_msg(mode,cp,user[cp]->currmsgarea,NULL,NULL,0)) {
                    user[cp]->numposts++;
                }
                DosSleep(500L);
                break;

            case 201:   /* write forced msg */
                if(!write_msg(mode,cp,user[cp]->currmsgarea,NULL,NULL,3)) {
                    user[cp]->numposts++;
                }
                DosSleep(500L);
                break;

            case 300:   /* simple get string input */
                {
                  strset(modems[cp]->laststring,0);
                  pp = bbs_convert_string(cp,menudata[com - 1]);
                  if(pp) {
                    input_string(mode,cp,modems[cp]->laststring,79,1,pp,
                                 STRT_FILENAME,STRF_PRETTY,
                                 NULL,NULL);
                    bbs_free(cp,pp);
                  }
                  else {
                    input_string(mode,cp,modems[cp]->laststring,79,1,
                                 menudata[com - 1],
                                 STRT_FILENAME,STRF_PRETTY,
                                 NULL,NULL);
                  }
                  dputs(mode,cp,"\r\n");
                }
                break;

            case 301:   /* copy string input to user string */
                {
                  int which;

                  which = atoi(menudata[com - 1]);
                  if(which > 0 && which < 9) {
                    strcpy(user[cp]->svar[which - 1],modems[cp]->laststring);
                  }
                }
                break;

            case 302:   /* copy user string to string input */
                {
                  int which;

                  which = atoi(menudata[com - 1]);
                  if(which > 0 && which < 9) {
                    strcpy(modems[cp]->laststring,user[cp]->svar[which - 1]);
                  }
                }
                break;

            case 303:   /* copy converted menudata to "last input" string */
                pp = bbs_convert_string(cp,menudata[com - 1]);
                if(pp) {
                  strncpy(modems[cp]->laststring,pp,79);
                  modems[cp]->laststring[79] = 0;
                  bbs_free(cp,pp);
                }
                break;

            case 999:           /* logoff w/ goodbye msg */
                if(bbs->attribs & B_LOGOFFMSG) {

                    MSGAREA *info;
                    char    input[4];

                    info = next_msg_area(msgareas,cp,0);
                    while(info) {
                        if(!stricmp(info->name,"FEEDBACK")) break;
                        info = info->next;
                    }
                    if(!info) {
                        find_msg_area(NULL,cp,1);
                    }
                    if(info) {
                        strset(input,0);
                        pinput_string(mode,cp,input,1,1,76,
                                     STRT_YN,STRF_UCASE | STRF_HOT,
                                     "I1_Logoff Msg",NULL);
                        if(*input == modems[cp]->YES) {
                            write_msg(mode,cp,info,NULL,NULL,3);
                        }
                    }
                }

            case 1000:  /* logoff no goodbye msg */
                readansi(mode,cp,"GOODBYE.ASC",NULL,2);
                sayp(mode,cp,202,NULL,0);

            case 1001:  /* logoff no nothin */
                sayp(mode,cp,77,NULL,0);
                flushout(cp);
                amsub = -1;
                goto EndIt;

            default:
                dprintf(D_LOCAL,cp,"\r\n\04Sysop: Your menu definition file lists an unknown command %d\r\n",com);
                logfunc(0,cp,"Menu definition file \"%s\" lists unknown command %u",fname,com);
                break;
        }
    }

EndIt:

    bbsfree_strarray(cp,menuitem,numitems);
    bbs_free(cp,menuitem);
    bbsfree_strarray(cp,menudata,numitems);
    bbs_free(cp,menudata);
    bbs_free(cp,menucolor);
    bbs_free(cp,menucommand);
    bbs_free(cp,menukey);
    bbs_free(cp,s);
    if(prompt) bbs_free(cp,prompt);
    if(showfile) bbs_free(cp,showfile);
    return amsub;
}


void _fastcall bbsfree_strarray (USHORT cp,char **array,int numitems) {

  int  c;

  for(c = 0;c < numitems;c++) {
    if(array[c]) {
      bbs_free(cp,array[c]);
      array[c] = NULL;
    }
  }
}
