/**************************************************************************
 * Bare-bones "all-files" creator                                         *
 **************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <stdarg.h>
#include <conio.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

extern FILEAREA *fileareas;

#define VERMAJ 0
#define VERMIN 7

BOOL graphic = FALSE;
BOOL ipf = FALSE;
BOOL wcost = FALSE;
BOOL bdown = TRUE;
BOOL adoptorphans = FALSE;
BOOL killmissing = FALSE;
BOOL reportmissing = FALSE;
BOOL lonecomments = FALSE;
BOOL diddir = FALSE;
FILE *makeclean = NULL;

typedef struct __filelist__ {
  char *filename;
  struct __filelist__ *next;
} FILELIST;

FILELIST *listoffiles = NULL,*lastoflist = NULL;

int (*print_func)(const char *string,...);


char * commafmt(char   *buf,            /* Buffer for formatted string  */
                int     bufsize,        /* Size of buffer               */
                long    N)              /* Number to convert            */
{
        int len = 1, posn = 1, sign = 1;
        char *ptr = buf + bufsize - 1;

        if (2 > bufsize)
        {
ABORT:          *buf = 0;
                return buf;
        }

        *ptr-- = 0;
        --bufsize;
        if (0L > N)
        {
                sign = -1;
                N = -N;
        }

        for ( ; len <= bufsize; ++len, ++posn)
        {
                *ptr-- = (char)((N % 10L) + '0');
                if (0L == (N /= 10L))
                        break;
                if (0 == (posn % 3))
                {
                        *ptr-- = ',';
                        ++len;
                }
                if (len >= bufsize)
                        goto ABORT;
        }

        if (0 > sign)
        {
                if (0 == bufsize)
                        goto ABORT;
                *ptr-- = '-';
                ++len;
        }

        strcpy(buf, ++ptr);
        return buf;
}


char * nospaces (char *a) {

  register char *p;
  char *hold = NULL;

  if(a) {

    hold = strdup(a);
    if(hold) {
      p = hold;
      while(*p) {
        if(*p == ' ')
          *p = '_';
        p++;
      }
    }
  }
  return hold;
}

int ipfprintf (const char *formatstring,...) {

  va_list ap;
  static char buffer[4096];
  register char *p;

  va_start(ap,formatstring);
  vsprintf(buffer,formatstring,ap);
  va_end(ap);

  p = buffer;
  while(*p) {
    switch(*p) {
      case '^':
        printf("&caret.");
        break;

      case '\'':
        printf("&apos.");
        break;

      case '*':
        printf("&asterisk.");
        break;

      case '@':
        printf("&atsign.");
        break;

      case '\\':
        printf("&bslash.");
        break;

      case ',':
        printf("&comma.");
        break;

      case ':':
        printf("&colon.");
        break;

      case '-':
        printf("&dash.");
        break;

      case '$':
        printf("&dollar.");
        break;

      case '!':
        printf("&xclm.");
        break;

      case '>':
        printf("&gtsym.");
        break;

      case '{':
        printf("&lbrace.");
        break;

      case '[':
        printf("&lbracket.");
        break;

      case '(':
        printf("&lpar.");
        break;

      case '#':
        printf("&numsign.");
        break;

      case '\"':
        printf("&odq.");
        break;

      case '+':
        printf("&plus.");
        break;

      case '%':
        printf("&percent.");
        break;

      case '.':
        printf("&per.");
        break;

      case '}':
        printf("&rbrace.");
        break;

      case ']':
        printf("&rbracket.");
        break;

      case ')':
        printf("&rpar.");
        break;

      case ';':
        printf("&semi.");
        break;

      case '/':
        printf("&slash.");
        break;

      case '|':
        printf("&splitvbar");
        break;

      case '~':
        printf("&tilde");
        break;

      case '_':
        printf("&us.");
        break;

      case '&':
        printf("&amp.");
        break;

      default:
        fputc(*p,stdout);
        break;
    }
    p++;
  }
  return (int)(p - buffer);
}

void echo_file (char *filename) {

  FILE        *fp;
  static char fbuf[1027];
  char        s[135],*p;

  if(!filename || !*filename)
    return;
  p = searchpath(filename,fbuf,1026);
  if(!p)
    return;
  fp = fopen(filename,"rt");
  if(fp) {
    while(!feof(fp)) {
      if(!fgets(s,135,fp))
        break;
      fputs(s,stdout);
    }
    fclose(fp);
  }
}


char * sl2bksl (char *a) {

  register char *p = a;

  while(*p++) if(*p == '/') *p = '\\';
  return a;
}

void clear_listoffiles (void) {

  FILELIST *info,*next;

  info = listoffiles;
  while(info) {
    next = info->next;
    if(info->filename)
      free(info->filename);
    free(info);
    info = next;
  }
  if(listoffiles)
    free(listoffiles);
  listoffiles = NULL;
  lastoflist = NULL;
}


long _fastcall list_directory (char *mask,long *numfiles,time_t date,
                               unsigned int flags, int *error,
                               char *areaname) {

  FILEFINDBUF f;
  int         search_handle,num_matches;
  long        numbytes = 0L;
  char        fordate[33],forsize[33];

  search_handle = -1;
  num_matches = 1;
  if(!DosFindFirst(mask,&search_handle,FILE_NORMAL,&f,sizeof(FILEFINDBUF),
      &num_matches,0L /* FIL_STANDARD */)) {
    diddir = TRUE;
    if(ipf) {
      if(graphic)
        printf(":color fc=blue.");
      printf(":xmp.");
    }
    while(num_matches == 1) {
      if(!date || dosfile_2_unix((struct _ftime *)&f.ftimeLastWrite,(struct _fdate *)&f.fdateLastWrite) >= date) {
        print_func("%-13s",f.achName);
        if(makeclean && !(flags & 4) && !(flags & 8))
          fprintf(makeclean,"%-13s    %s\n\n",f.achName,areaname);
        print_func("  %s  %s\n",say_filedate(fordate,&f),
                   commafmt(forsize,sizeof(forsize),f.cbFile));
        (*numfiles)++;
        numbytes += f.cbFile;
      }
      if(DosFindNext(search_handle,&f,sizeof(FILEFINDBUF),&num_matches))
        break;
      DosSleep(1L);   /* breather for other stuff */
    }
    DosFindClose(search_handle);
  }
  if(numbytes && ipf) {
    printf(":exmp.");
    if(graphic)
      printf(":color fc=default.");
  }
  return numbytes;
}



void _fastcall skip_comments (int handle) { /* skip extended FILES.BBS comments */

    char s[257];
    long pos;


    while(!eof(handle)) {
        pos = tell(handle);
        if(!fgetsx(s,256,handle))
          break;
        stripcr(s);
        if(*s != ' ' && *s != '\t') {
            lseek(handle,pos,SEEK_SET);
            break;
        }
    }
}


long _fastcall list_all (char *fstr,long *numfiles,char *fbbs,
                         char *path,time_t date,unsigned int flags,
                         int *error,FILEAREA *currarea,long sec1,
                         long sec2, long flags1, long flags2) {

    /* error = 1:   out of memory
             = 2:   bad path
             = 3:   can't open file

       flags:
        2:  no raw directory
        4:  no files.bbs directory
        8:  no common files.bbs
        16: only common files.bbs
        passed through to list_directories if no FILES.BBS
    */

    long        numbytes = 0L,pos;
    int         handle,lines = 0,wasmatch,cntr = 0,common = 0;
    char        s[257],f[257],*p,*area,*ul,fordate[33],forsize[33];
    struct stat st;
    FILEAREA    *info;
    FILELIST    *lofinfo;


    diddir = FALSE;
    *numfiles = 0L;
    *error = 0;
    if(!path || !*path) {
      *error = 2;
      return 0L;
    }

    if(flags & 4)
      goto NoFilesBBS;

    if(!fbbs || !*fbbs) {
      if(!(flags & 16)) {
        sprintf(s,"%s/FILES.BBS",path);
        if(stat(s,&st) && !(flags & 8))
          strcpy(s,"FILES.BBS");
      }
      else
        strcpy(s,"FILES.BBS");
    }
    else
      strcpy(s,fbbs);

    if(stat(s,&st) && !(flags & 8)) {
      strcpy(s,"FILES.BBS");
      common = 1;
    }

    /* got the filename to display, now open it */

    handle = sopen(s,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYWR);
    if(handle == -1) {

NoFilesBBS:

      *error = 3;
      if(!fstr || !*fstr)
        sprintf(f,"%s/*.*",path);
      else {
        if(!strchr(fstr,'.'))
          sprintf(f,"%s/%s*.*",path,fstr);
        else
          sprintf(f,"%s/%s*",path,fstr);
      }

      /* file not available; do raw directory */

      if(!reportmissing && !(flags & 2))
        numbytes = list_directory(f,numfiles,date,flags,error,currarea->name);
      return numbytes;
    }

    /* file's open, display it */

    while(!eof(handle)) {

Continuing:

        if(!fgetsx(s,256,handle))
          break;
        if((p = strchr(s,';')) != NULL)
          *p = 0; /* strip 'private' stuff */
        if(!*s)   /* just 'private'? */
          continue;
        stripcr(s);
        rstrip(s);
        if(!*s && !lonecomments)
          continue; /* blank line */
        if(!*s || *s == ' ' || *s == '\t') {   /* comment */
          if(common && !lonecomments)
            continue;
          if(fstr && *fstr) {
            if(!stristr(s,fstr))
              continue;  /* no match */
          }
          if(date)
            continue;                /* not a file, can't be new */
          if(!reportmissing) {
            if(ipf)
              printf(":hp4.");
            print_func("%s\n",s);
            if(ipf)
              printf(":ehp4.\n.br\n",s);
          }
          if(!lonecomments)
            continue;
          else {
            printf("%s\n",s);
            if(makeclean && !(flags & 8))
              fprintf(makeclean,"%s\n",s);
          }
        }

        /* better be a file... */

        if(fstr && *fstr) {
            if(stristr(s,fstr))
              wasmatch = 1;
            else
              wasmatch = 0;
        }

        area = to_delim(s," ");
        if(*area) {
            *area = 0;
            area++;
            area = skip_white(area);
        }

        ul = "";
        p = path;
        if(*area) {                     /* check for good area */
            ul = to_delim(area," ");
            if(*ul) {
                *ul = 0;
                ul++;
                ul = skip_white(ul);
            }
            if(stricmp(area,currarea->name)) {
                skip_comments(handle);
                continue;
            }
            info = fileareas;
            while(info && ((info->areaflags & F_HIDDEN) ||
                  (info->password && *info->password) ||
                  (info->r_security1 > sec1 || info->r_security2 > sec2) ||
                  ((info->r_flags1 & (~flags1)) || (info->r_flags2 & (~flags2))))) {
                info = info->next;
            }

            while(info) {
                if(!stricmp(area,info->name))
                  break;
                info = info->next;
                while(info && ((info->areaflags & F_HIDDEN) ||
                      (info->password && *info->password) ||
                      (info->r_security1 > sec1 || info->r_security2 > sec2) ||
                      ((info->r_flags1 & (~flags1)) || (info->r_flags2 & (~flags2))))) {
                    info = info->next;
                }
            }
            if(info)
              p = info->dpath;
            else {            /* not an accessible area */
                skip_comments(handle);
                continue;
            }
        }

        sprintf(f,"%s/%s",p,s);

        if(adoptorphans) {
          lofinfo = malloc(sizeof(FILELIST));
          if(lofinfo) {
            memset(lofinfo,0,sizeof(FILELIST));
            lofinfo->filename = strdup(s);
            if(lofinfo->filename) {
              if(!listoffiles) {
                listoffiles = lofinfo;
              }
              else {
                lastoflist->next = lofinfo;
              }
              lastoflist = lofinfo;
              lofinfo->next = NULL;
            }
          }
        }

        if(stat(f,&st)) {               /* missing file */
            if(reportmissing) {
              if(ipf)
                printf(":hp4.");
              print_func("%s\n",sl2bksl(f));
              if(ipf)
                printf(":ehp4.\n.br\n");
            }
            skip_comments(handle);
            continue;
        }

        if(reportmissing) {
          skip_comments(handle);
          continue;
        }

        if(st.st_mtime < date) {        /* file older than date */
            skip_comments(handle);
            continue;
        }

        if(fstr && *fstr && !wasmatch) {

            long pos2;

            pos2 = tell(handle);
            if(!stristr(s,fstr) && !stristr(area,fstr) && !stristr(ul,fstr)) {
                if(eof(handle)) goto Continuing;
                while(!eof(handle)) {
                    pos = tell(handle);
                    if(!fgetsx(f,133,handle)) {
                        lseek(handle,pos,SEEK_SET);
                        goto Continuing;
                    }
                    if((p = strchr(f,';')) != NULL)
                      *p = 0; /* strip 'private' stuff */
                    stripcr(f);
                    rstrip(f);
                    if(*f != ' ' && *f != '\t') {
                        lseek(handle,pos,SEEK_SET);
                        goto Continuing;
                    }
                    if(stristr(f,fstr)) {
                        lseek(handle,pos2,SEEK_SET);
                        break;
                    }
                    if(eof(handle))
                      goto Continuing;
                }
            }
        }

        /* update how many files & bytes */

        (*numfiles)++;
        numbytes += st.st_size;

        /* display file info */

        if(ipf) {
          if(graphic)
            printf(":color fc=blue.");
          printf(":xmp.");
        }
        print_func("%-13s",s);
        if(makeclean && !(flags & 8))
          fprintf(makeclean,"%-13s    %s\n",s,currarea->name);
        print_func("  %s  %s",say_date(fordate,st.st_mtime),
                   commafmt(forsize,sizeof(forsize),st.st_size));
        if(ipf) {
          printf("\n:exmp.");
          if(graphic)
            printf(":color fc=default.");
        }
        else
          printf("\n");

        while(!eof(handle)) {   /* display comments */
            pos = tell(handle);
            if(!fgetsx(s,133,handle))
              break;
            if((p = strchr(s,';')) != NULL)
              *p = 0; /* strip 'private' stuff */
            stripcr(s);
            rstrip(s);
            if(*s != ' ' && *s != '\t') {
                lseek(handle,pos,SEEK_SET);
                break;
            }
            if(ipf) {
              printf(":hp1.");
              print_func("%s\n",lstrip(s));
              printf(":ehp1.\n");
            }
            else {
              printf("%s\n",s);
              if(makeclean && !(flags & 8))
                fprintf(makeclean,"%s\n",s);
            }
        }

        DosSleep(1L);   /* breather for other stuff */
    }
    close(handle);
    if(!numbytes && !*numfiles) {
      if(!fstr || !*fstr)
        sprintf(f,"%s/*.*",path);
      else {
        if(!strchr(fstr,'.'))
          sprintf(f,"%s/%s*.*",path,fstr);
        else
          sprintf(f,"%s/%s*",path,fstr);
      }
      if(!reportmissing && !(flags & 2))
        numbytes = list_directory(f,numfiles,date,flags,error,currarea->name);
    }
    return numbytes;
}



long _fastcall list_all_filesbbs (char *fstr,long *numfiles,long *numareas,
                                  time_t date,unsigned int flags,
                                  int *error,long sec1,long sec2,
                                  long flags1, long flags2) {

    /* step through all "accessible" files.bbs files */

    FILEAREA *info;
    long     numbytes = 0L,thesefiles,thesebytes;

    /* list all files.bbs files in all accessible directories sequentially */

    *numfiles = 0L;
    *numareas = 0L;

    info = fileareas;
    while(info) {
      info->s_security1 = info->s_security2 =
      info->s_flags1 = info->s_flags2 = 0L; /* used for area totals */
      info = info->next;
    }

    info = fileareas;
    while(info && (!info->cost_per_k || wcost) &&
          ((info->areaflags & F_HIDDEN) ||
           (info->password && *info->password) ||
           (info->r_security1 > sec1 || info->r_security2 > sec2) ||
           ((info->r_flags1 & (~flags1)) || (info->r_flags2 & (~flags2))))) {
        info = info->next;
    }
    while(info) {

        char filename[14];

        if(makeclean && !(flags & 8))
          fprintf(makeclean,";\n;AREA: %s\n;\n",info->name);

        (*numareas)++;
        if(!reportmissing) {
          echo_file("MAKEFLST.HDR");
          sprintf(filename,"MAKEFLS%s.%d",(ipf) ? "I" : "T",info->number);
          echo_file(filename);
          if(ipf) {

            char *a;

            a = nospaces(info->name);
            printf("\n:h1 name=AREA_%s.%s\n:i1 id=%d_%s.%s\n:color fc=red.:xmp.",
                   a,info->name,info->number,a,info->name);
            if(a)
              free(a);
          }
          if(!graphic)
            printf("\n+-----------------------------------------------------------------------------+");
          else
            printf("\nͻ");
          if(!graphic)
            printf("\n| Area #%-5u %-63s |\n",info->number,info->name);
          else
            printf("\n Area #%-5u %-63s \n",info->number,info->name);
          if(info->descr && *info->descr) {
            if(!graphic) {
              printf("+-----------------------------------------------------------------------------+\n");
              printf("|  %-74s |\n",info->descr);
            }
            else {
              printf("͹\n");
              printf("  %-74s \n",info->descr);
            }
          }
          if(!graphic)
            printf("+-----------------------------------------------------------------------------+\n");
          else
            printf("ͼ\n");
          if(ipf) {
            printf(":exmp.");
            if(graphic)
              printf(":color fc=default.");
          }
          else
            printf("\n");
        }
        thesefiles = 0L;
        thesebytes = list_all(fstr,&thesefiles,NULL,
                              info->dpath,date,
                              flags |
                              (((info->areaflags & F_NODIR) != 0) * 2) |
                              (((info->areaflags & F_NOFBBS) != 0) * 4) |
                              (((info->areaflags & F_NOCOMMON) != 0) * 8) |
                              (((info->areaflags & F_COMMONONLY) != 0) * 16),
                              error,info,sec1,sec2,flags1,flags2);

        if(adoptorphans && !(info->areaflags & F_NOFBBS)) {

          FILE               *fhandle = NULL;
          FILELIST           *flinfo;
          static FILEFINDBUF f;
          HDIR               search_handle;
          UINT               num_matches;
          static char        s[1027];
          struct stat        st;

          sprintf(s,"%s/FILES.BBS",info->dpath);
          if(stat(s,&st) && !(info->areaflags & F_NOCOMMON))
            strcpy(s,"FILES.BBS");
          if(!(info->areaflags & F_NOFBBS))
            fhandle = fopen(s,"at");
          if(fhandle != NULL) {
            search_handle = -1;
            num_matches = 1;
            sprintf(s,"%s/*",info->dpath);
            if(!DosFindFirst(s,&search_handle,FILE_NORMAL,&f,sizeof(FILEFINDBUF),
                &num_matches,0L /* FIL_STANDARD */)) {
              while(num_matches == 1) {
                flinfo = listoffiles;
                while(flinfo) {
                  if(!stricmp(flinfo->filename,f.achName)) break;
                  flinfo = flinfo->next;
                }
                if(!flinfo) {
                  if(!(info->areaflags & F_NOFBBS)) {
                    fprintf(fhandle,"%-13s    %s\n\n",f.achName,info->name);
                    fprintf(stderr," ##Adopting %s in area %s\n",f.achName,info->name);
                    if(makeclean && !diddir)
                      fprintf(makeclean,"%-13s    %s\n\n",f.achName,info->name);
                  }
                }
                if(DosFindNext(search_handle,&f,sizeof(FILEFINDBUF),&num_matches))
                  break;
                DosSleep(1L);   /* breather for other stuff */
              }
              DosFindClose(search_handle);
            }
            fclose(fhandle);
          }
          clear_listoffiles();
        }

        if(!reportmissing) {
          if(thesefiles) {
            echo_file("MAKEFLST.FTR");
            if(ipf) {
              printf(":p.");
              if(graphic)
                printf(":color fc=red.");
            }
            if(!graphic)
              printf("\n===============================================================\n");
            else
              printf("\n\n");
            if(ipf)
              printf(".br\n:hp2.");
            {
              char num1[33],num2[33];

              commafmt(num1,sizeof(num1),thesefiles);
              commafmt(num2,sizeof(num2),thesebytes);
              print_func("  Listed %s file%s in area for a total of %s byte%s.\n",
                     num1,&"s"[thesefiles == 1L],num2,&"s"[thesebytes == 1L]);
            }
            if(ipf)
              printf(":ehp2.\n.br\n");
            if(!graphic)
              printf("===============================================================\n\n");
            else
              printf("\n\n");
          }
          if(ipf && graphic)
            printf(":color fc=default.");
        }

        numbytes += thesebytes;
        *numfiles += thesefiles;
        info->s_security1 = thesebytes;
        info->s_security2 = thesefiles;

        if(*error == -1)
          break;

        info = info->next;
        while(info && (!info->cost_per_k || wcost) &&
              ((info->areaflags & F_HIDDEN) ||
               (info->password && *info->password) ||
               (info->r_security1 > sec1 || info->r_security2 > sec2) ||
               ((info->r_flags1 & (~flags1)) || (info->r_flags2 & (~flags2))))) {
            info = info->next;
        }
        DosSleep(1L); /* breather for other stuff */
    }

    return numbytes;
}


void send_mfhelp (void) {

  fprintf(stderr,"\n  Command line arguments:"
                 "\n-D<#>       days-old cutoff (default 0, none)\n-M<string>  string to match (default none)"
                 "\n-S1<#>      user read sec #1 (default 6)\n-S2<#>      user read sec #2 (default 0)"
                 "\n-F1<#>      user read flag #1 (default 0)\n-F2<#>      user read flag #2 (default 0)"
                 "\n-G          use PC graphics characters\n-B          no breakdown"
                 "\n-$          include areas w/ cost\n-A          adopt orphans"
                 "\n-N          report missing files\n-I          IPFC output"
                 "\n-C          create clean FILES.BB2\n-L          include lone comments");
  fprintf(stderr,"\n  Output goes to stdout; redirect to file as desired (i.e. \"MAKEFLST > FILES\").\n");
  {
    USHORT info,devhead;

    DosQHandType(fileno(stderr),&info,&devhead);
    if(((info & 255) == 1) && (devhead & 2)) {
      fprintf(stderr,"\x1b[K\r [Any key for more] ");
      getch();
      fprintf(stderr,"\r\x1b[K\r");
    }
  }
  fprintf(stderr,"  Optional special files inserted into output (? = I if IPF, else T):"
                 "\nMAKEFLST.STR (at start)                MAKEFLST.HDR (header file, ea. area)"
                 "\nMAKEFLST.FTR (footer file, ea. area)   MAKEFLST.BFE (before breakdown)"
                 "\nMAKEFLST.END (at end)                  MAKEFLST.IPS (IPFC file at start)"
                 "\nMAKEFLST.IPB (IPFC hdr file, ea. area) MAKEFLST.IPT (IPFC ftr file, ea. area)"
                 "\nMAKEFLST.IPE (IPFC file at end)        MAKEFLS?.###[#...] (unique for section)\n");
}


void show_flags (int which,long flags) {

  int x;

  fprintf(stderr,"Flags #%d:  [",which);
  for(x = 0;x < 32;x++) {
    if(flags & (1L << x))
      fprintf(stderr,"+");
    else
      fprintf(stderr,"-");
  }
  fprintf(stderr,"]\n");
}


int main (int argc,char *argv[]) {

  long   numfiles = 0L,numareas = 0L,numbytes;
  int    error = 0,flags = 0,once = 0;
  long   sec1 = 6L,sec2 = 0L,flags1 = 0L,flags2 = 0L;
  time_t date = 0L;
  char   *match = NULL;
  FILEAREA *info;

  print_func = printf;

  {
    USHORT info,devhead;

    DosQHandType(fileno(stderr),&info,&devhead);
    if(((info & 255) == 1) && (devhead & 2)) {
      fprintf(stderr,"\n\x1b[2J\r    \n");
    }
  }
  fprintf(stderr,"MAKEFLST.EXE copyright (c) 1992/93 by M. Kimes -- all rights reserved\n");
  fprintf(stderr,"version #%d.%02d  "__TIME__"  "__DATE__"\n",VERMAJ,VERMIN);

  while(argc > 1) {
    switch(toupper(*argv[argc - 1])) {
      case '-':
      case '/':
        switch(toupper(argv[argc - 1][1])) {
          case '?':
          case 'H':
            send_mfhelp();
            return 0;

          case 'A':
            adoptorphans = TRUE;
            break;

          case 'K':             // not yet implemented
            killmissing = TRUE;
            break;

          case 'N':
            reportmissing = TRUE;
            break;

          case 'S':
            if(argv[argc - 1][2] != '1' && argv[argc - 1][2] != '2') {
              fprintf(stderr,"\07\n **Error in -S arg: \"%s\"\n",argv[argc - 1]);
            }
            else {
              if(argv[argc - 1][2] == '1') {
                sec1 = atol(&argv[argc - 1][3]);
                fprintf(stderr,"Security level #1 = %ld\n",sec1);
              }
              else {
                sec2 = atol(&argv[argc - 1][3]);
                fprintf(stderr,"Security level #2 = %ld\n",sec2);
              }
            }
            break;

          case 'F':
            if(argv[argc - 1][2] != '1' && argv[argc - 1][2] != '2') {
              fprintf(stderr,"\07\n **Error in -F arg: \"%s\"\n",argv[argc - 1]);
            }
            else {
              if(argv[argc - 1][2] == '1') {
                flags1 = atol(&argv[argc - 1][3]);
                show_flags(1,flags1);
              }
              else {
                flags2 = atol(&argv[argc - 1][3]);
                show_flags(2,flags2);
              }
            }
            break;

          case 'M':
            match = &argv[argc - 1][2];
            break;

          case 'D':
            date = time(NULL) - (atol(&argv[argc - 1][2]) * 86400L);
            break;

          case 'G':
            graphic = TRUE;
            break;

          case 'B':
            bdown = FALSE;
            break;

          case '$':
            wcost = TRUE;
            break;

          case 'I':
            ipf = TRUE;
            break;

          case 'C':
            makeclean = fopen("FILES.BB2","wt");
            if(!makeclean)
              fprintf(stderr,"\07\n **Error:  can't create FILES.BB2\n");
            break;

          case 'L':
            lonecomments = TRUE;
            break;

          default:
            fprintf(stderr,"\07\n **Unknown switch: \"%s\"\n",argv[argc - 1]);
            break;
        }
    }
    argc--;
  }

  fprintf(stderr,"Makeflst -? for help\n");

  if(load_fileareas() || !fileareas)
    return 1;

  if(reportmissing)
    fprintf(stderr,"Reporting missing files (files listed in FILES.BBS but not present)\n");

  {
    USHORT info,devhead;

    DosQHandType(fileno(stdout),&info,&devhead);
    if(((info & 255) == 1) && (devhead & 2)) {
      setvbuf(stdout,NULL,8192,_IOFBF);
    }
    else {
      fprintf(stderr,"\nMakeflst working...");
    }
  }

  if(ipf)
    print_func = ipfprintf;

  if(!reportmissing && !ipf) {

    char s[40];

    printf("File list created %s\n",_strdate(s));
    echo_file("MAKEFLST.STR");
  }
  else if(ipf) {

    char s[40];

    printf(":userdoc.\n:title.File List %s\n:body.\n",_strdate(s));
    echo_file("MAKEFLST.IPS");
  }

  numbytes = list_all_filesbbs(match,&numfiles,&numareas,date,flags,&error,
                               sec1,sec2,flags1,flags2);

  if(bdown && !reportmissing) {

    char num1[33],num2[33],num3[33];

    if(!ipf)
      echo_file("MAKEFLST.BFE");
    else
      echo_file("MAKEFLST.IPB");
    info = fileareas;
    while(info) {
      if(info->s_security1 && info->s_security2) {
        if(!once) { /* open box */
          once++;
          if(ipf) {
            printf("\n:h1 name=BREAKDOWN. Breakdown\n:i1 id=Breakdown. Breakdown\n");
            if(graphic)
              printf(":color fc=blue.");
            printf(":xmp.");
          }
          else
            printf("\n");
          if(graphic)
            printf("\nķ");
          else
            printf("\n+----------------------------------------------------------------------------+");
          if(graphic)
            printf("\n                                 Breakdown                                  ");
          else
            printf("\n|                                 Breakdown                                  |");
          if(graphic)
            printf("\nĶ");
          else
            printf("\n+-------------------------------------+------------------+-------------------+");
          if(!graphic)
            printf("\n| Area                                | # file(s)        | # byte(s)         |");
          else
            printf("\n Area                                 # file(s)         # byte(s)         ");
          if(graphic)
            printf("\nĶ");
          else
            printf("\n+-------------------------------------+------------------+-------------------+");
        }
        commafmt(num1,sizeof(num1),info->s_security2);
        commafmt(num2,sizeof(num2),info->s_security1);
        if(graphic)
          printf("\n %-35s  %-16.16s  %-17.17s ",info->name,num1,num2);
        else
          printf("\n| %-35s | %-16.16s | %-17.17s |",info->name,num1,num2);
      }
      info = info->next;
    }
    if(once) {  /* close box */
      if(numareas > 1) {
        if(graphic)
          printf("\nĶ");
        else
          printf("\n+-------------------------------------+------------------+-------------------+");
        commafmt(num1,sizeof(num1),numareas);
        commafmt(num2,sizeof(num2),numfiles);
        commafmt(num3,sizeof(num3),numbytes);
        if(graphic)
          printf("\n Totals:  %-26.26s  %-16.16s  %-17.17s ",num1,num2,num3);
        else
          printf("\n| Totals:  %-26.26s | %-16.16s  %-17.17s |",num1,num2,num3);
      }
      if(graphic)
        printf("\nĽ\n");
      else
        printf("\n+-------------------------------------+------------------+-------------------+\n");
      if(ipf) {
        printf(":exmp.");
        if(graphic)
          printf(":color fc=default.");
      }
      else
        printf("\n");
    }
  }

  if(!reportmissing && !ipf)
    echo_file("MAKEFLST.END");
  else if(ipf) {
    echo_file("MAKEFLST.IPE");
    printf("\n:index.\n:euserdoc.\n");
  }

  if(makeclean)
    fclose(makeclean);

  fprintf(stderr,"\n");
  return 0;
}



void logfmain (char *szFormat,...) {

  char         chBuffer[1027];
  unsigned int sLength;
  va_list      pArguments;

  va_start(pArguments,szFormat);
  sLength = vsprintf(chBuffer,szFormat,pArguments);
  va_end(pArguments);
  fprintf(stderr,"%s\n",chBuffer);
}
