#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "transfer.h"
#include "bbs.h"
#include "xmisc.h"
#include "modem.h"
#include "keys.h"



    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern FILEAREA *fileareas;


char * _fastcall get_mask (int mode,USHORT cp,char *mask,
                           int masklen,unsigned int flags,
                           char *help) {

    char         *p;
    unsigned int ifl = STRT_FILENAME;


    if(!mask)
      return NULL;
    if(!masklen)
      masklen = 12;

    if(flags & 8)
      ifl = STRT_MULTFILES;
    else if(flags & 16)
      ifl = STRT_JUSTFILE;
    else if(flags & 32)
      ifl = STRT_MULTJUST;

    input_string(mode,cp,mask,masklen,0,"\r\nMask: ",
                 STRT_FILENAME,STRF_UCASE,
                 help,NULL);

    if(flags & 1) {
        p = strchr(mask,'.');
        if(p)
          *p = 0;
    }

    if(flags & 2) {
        if(!*mask)
          strcpy(mask,"*.*");
    }

    dputs(mode,cp,"\r\n");
    return mask;
}



long _fastcall prompted_dir (int mode,USHORT cp,long *numfiles,char *path,
                             time_t date,unsigned int flags) {

    char mask[13],*s;
    long numbytes = 0L;
    int  error;


    if(!path || !*path)
      path = user[cp]->currfilearea->dpath;
    if(!path || !*path)
      return 0L;

    strset(mask,0);
    get_mask(mode,cp,mask,12,0,"Listfile Mask");
    if(!*mask)
      strcpy(mask,"*.*");

    s = bbs_malloc(cp,strlen(path) + strlen(mask) + 4);
    if(s) {
      sprintf(s,"%s/%s.*",path,mask);
      numbytes = list_files(mode,cp,s,numfiles,date,flags,&error);
      bbs_free(cp,s);
    }
    return numbytes;
}



long _fastcall find_file (int mode,USHORT cp,long *numfiles,
                          time_t date,unsigned int flags) {

    /* bitmapped flags:  32 = always allow listing of any area */

    char     mask[13] = "",*s;
    FILEAREA *info;
    long     numbytes = 0L,tl,lastfiles = 0L;
    int      error;


    *numfiles = 0;
    get_mask(mode,cp,mask,8,32 + 1,"Findfile Mask");
    if(!*mask)
      return 0L;

    info = next_file_area(fileareas,cp,0,0);
    while(info && info->password && *info->password &&
          (!(info->areaflags & F_NODIR) || (flags & 32))) {
        info = next_file_area(info,cp,1,0);
    }
    while(info) {
        s = bbs_malloc(cp,strlen(info->dpath) + strlen(mask) + 4);
        if(s) {
            sprintf(s,"%s/%s.*",info->dpath,mask);
            tl = list_files(mode,cp,s,numfiles,date,flags,&error);
            bbs_free(cp,s);
            if(tl > 0L) {
                numbytes += tl;
                dprintf(mode,cp,"  (Above in area #%u \"%s\")\r\n",info->number,info->name);
            }
        }

        info = next_file_area(info,cp,1,0);
        while(info && info->password && *info->password &&
              (!(info->areaflags & F_NODIR) || (flags & 32))) {
            info = next_file_area(info,cp,1,0);
        }
        if(info && *numfiles > 12L)
          hitreturn(mode,cp);
        lastfiles += *numfiles;
    }

    *numfiles = lastfiles;
    return numbytes;
}




long _fastcall list_files (int mode,USHORT cp,char *filestr,
                           long *numfiles,time_t date,unsigned int flags,
                           int *error) {

    /* bitmapped flags:
        4:  Okay to ask to d/l
        8:  Use date field (newer)
        16: Use date field (older)

       *error = 1:   out of memory
              = 2:   no files
              = -1:  aborted by user
    */

    HDIR          search_handle = HDIR_CREATE;
    USHORT        num_matches = 1;
    unsigned long reservd = 0L;
    unsigned long num_bytes = 0L;
    long          tbaud;
    struct _file_buffer *fb;
    unsigned int  lines = 1;
    char          quitask = 0;
    char          fordate[33];


    *numfiles = 0L;
    *error = 0;

    fb = (struct _file_buffer *)bbs_malloc(cp,sizeof(struct _file_buffer));
    if(!fb) {
        *error = 1;
        return 0L;
    }

    tbaud = (long)modems[cp]->curbaud;
    if(!tbaud)
      tbaud = 2400L;

    if(bbs_findfirst(cp,filestr,&search_handle,0,(FILEFINDBUF *)fb,
        sizeof(struct _file_buffer),&num_matches,reservd)) {
           bbs_free(cp,fb);
           *error = 2;
           return 0L;
    }

    do {
        if(flags & 8) {
            if(dosfile_2_unix(&fb->ct.ft,&fb->cd.fd) < date) goto Continuing;
        }
        else if(flags & 16) {
          if(dosfile_2_unix(&fb->ct.ft,&fb->cd.fd) > date)
            goto Continuing;
        }
        if(user[cp]->offline < time(NULL) || checkcarrier(cp))
          break;
        if(user[cp]->length <= (lines + 1)) {
          lines = 1;
          if(do_more(mode,cp)) {
            *error = -1;
            break;
          }
        }

        (*numfiles)++;
        num_bytes += fb->size;

        if(user[cp]->attribs & U_COLOR) {
            dprintf(
                    mode,cp,"\x1b[0;1;33m%-13s  \x1b[34m%s  \x1b[0;2;36m%9lu bytes  %5lu min\x1b[0m\r\n",
                    fb->filename,say_filedate(fordate,fb),fb->size,
                    (long)max(1L,(((((fb->size * 10L) / tbaud) / 60L) * 100L) / 80L))
            );
        }
        else {
            dprintf(
                    mode,cp,"%-13s  %s  %9lu  %5lu min\r\n",
                    fb->filename,say_filedate(fordate,fb),fb->size,
                    (long)max(1L,(((((fb->size * 10L) / tbaud) / 60L) * 100L) / 80L))
            );
        }
        if(flags & 4) {
            if((user[cp]->attribs & U_ASKDL) && !quitask) {

                char yorn[6],*s,*p,temp;

                strset(yorn,0);
                temp = *input_string(mode,cp,yorn,1,1,"Download? (y/N/s/q) ",
                                 STRT_YNQS,STRF_HOT,"Autodownload",NULL);
                if(temp == 'Y') {
                    while((p = strchr(filestr,'\\')) != NULL) *p = '/';
                    p = strrchr(filestr,'/');
                    if(!p) p = strrchr(filestr,':');
                    if(p) {
                        temp = *p;
                        *p = 0;
                    }
                    s = bbs_malloc(cp,strlen(filestr) + strlen(fb->filename) + 2);
                    if(s) {

                        long tk = 0L;

                        if(p)
                          sprintf(s,"%s/%s",filestr,fb->filename);
                        else
                          strcpy(s,fb->filename);
                        tk += download_files(mode,cp,s,NULL,
                                             &user[cp]->dlnum,0) / 1024L;
                        user[cp]->dlk += tk;
                        user[cp]->dktoday += tk;
                        if(modems[cp]->curbaud) {
                            dputs(mode,cp,"\xb\x18\x18\x18\x18\x18\x18");
                            DosSleep(2000L);
                        }
                        bbs_free(cp,s);
                    }
                    if(p) {
                        *p = temp;
                    }
                }
                else if(temp == 'Q') {
                    *error = -1;
                    break;
                }
                else if(temp == 'S')
                  quitask = 1;
                dputs(mode,cp,"\r\n");
            }
            else lines++;
        }
        else lines++;

Continuing:

        num_matches = 1;
    } while (!DosFindNext(search_handle,(FILEFINDBUF *)fb,
                          sizeof(struct _file_buffer),
                          &num_matches));

    bbs_closefind(cp,search_handle);
    bbs_free(cp,fb);
    return num_bytes;
}




long _fastcall file_info (int mode,USHORT cp,char *path,char *filename,
                          int sayit) {

    char    *s,*p;
    struct  stat sb;


    s = (char *)bbs_malloc(cp,MAX_FILENAME_LEN);
    if(!s) {
        DosSemClear(&modems[cp]->bbsrunningSEM);
        dputs(mode,cp,"\r\nOut of memory...crashing now...\r\n");
        _endthread();
    }

    do {
        p = &path[strlen(path) - 1];
        if(*p == '\\' || *p == '/') *p = 0;
    } while(!*p && *path);

    sprintf(s,"%s/%s",path,filename);

    if(stat(s,&sb)) {
        bbs_free(cp,s);
        return 0L;
    }
    if(!(sb.st_mode & S_IFREG)) {
        bbs_free(cp,s);
        return 0L;
    }

    if(sayit) {

        long tbaud;
        char fordate[33];

        tbaud = modems[cp]->curbaud;
        if(!tbaud) tbaud = 2400L;
        if(user[cp]->attribs & U_COLOR) {
            dprintf(
                    mode,cp,"\x1b[0;1;33m%-13s  \x1b[34m%s  \x1b[0;2;36m%9lu bytes  %5lu min\x1b[0m\r\n",
                    filename,say_date(fordate,sb.st_mtime),sb.st_size,
                    (long)max(1L,(((((sb.st_size*10L)/tbaud)/60L)*100L)/80L))
            );
        }
        else {
            dprintf(
                    mode,cp,"%-13s  %s  %9lu bytes  %5lu min\r\n",
                    filename,say_date(fordate,sb.st_mtime),sb.st_size,
                    (long)max(1L,(((((sb.st_size*10L)/tbaud)/60L)*100L)/80L))
            );
        }
    }

    bbs_free(cp,s);

    return sb.st_size;
}
