/*
 * simple utility to list contents of matching filenames to stdout
 *
 * 93/01/28 - added ability to extract from archive and view member of
 * archive without needing to know specific archiver commands, or even
 * what type of archive it is...
 */

#include "mailer.h"
#include <signal.h>
#include <share.h>
#include <direct.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <conio.h>
#include "bbs.h"
#include "xmisc.h"


extern int  _fastcall load_archivers (void);

#define TEMPFILE "LA.$$$"
#define TEMPDIR ".\\Z$.LA"
int  amswitched = 0;



void break_handler (int sigl) {

  fcloseall();
  if(amswitched) {
    amswitched = 0;
    chdir("..");
    unlink_all(TEMPDIR"\\*");
  }
  rmdir(TEMPDIR);
  unlink(TEMPFILE);
  signal(SIGINT,SIG_DFL);
  exit(2);
}


void whenexitting (void) {

  fcloseall();
  if(amswitched) {
    amswitched = 0;
    chdir("..");
    unlink_all(TEMPDIR"\\*");
  }
  rmdir(TEMPDIR);
  unlink(TEMPFILE);
}


/* save current drive & directory */

int save_dir (char *curdir) {

  int   ret;
  int   curdirlen,curdrive;
  long  drivemap;

  ret = (int)DosQCurDisk (&curdrive, &drivemap);
  curdirlen = 1023;   /* NOTE!!!!!!!!! */
  ret += (int)DosQCurDir (curdrive, &curdir[3], &curdirlen);
  *curdir = (char)('@' + toupper((int)curdrive));
  curdir[1] = ':';
  curdir[2] = '\\';
  return ret;
}


int main (int argc,char *argv[]) {

  FILEFINDBUF f;
  FILE        *fp;
  int         search_handle,num_matches,startlist,endlist,once,
              archives,arg = 1,redirected = 0,extracting = 0,
              viewing = 0,debug = 0,wdirs = 0;
  char        *path;
  static char buffer[1050],dosbuffer[3096],finder[1061],ourpath[1027];
  static struct stat st;
  long        numbytes = 0L;
  ARC_TYPE    *info;


  if(argc > 1) {
    if(load_archivers()) {
      fprintf(stderr,"\n **FATAL ERROR:  Can't find ARCHIVER.BB2\n");
      return 1;
    }
  }
  else {
    fprintf(stderr,"\n\x1b[2J\r"
                   "LISTARCS copyright (c) 1993 by M. Kimes  Compiled:  "__DATE__"  "__TIME__"\n"
                   "\n Usage:\nLA <d:path> [<d:path>...]\n"
                   "\n Purpose:\nList contents of all archives found in <d:path>.\n"
                   "\n Requirements:\nProperly configured ARCHIVER.BB2 on your PATH, DPATH or XPATH.\n"
                   "OS/2 archivers on your PATH.\n"
                   "\n Examples:\nLA h:\\xbbs    ;(implied \\* added)\nLA h:\\os2\\*.zip h:\\xbbs\\*.lzh\n"
                   "\n Miscellaneous:"
                   "\nOutput goes to stdout; redirect as required.\nUses temporary file "TEMPFILE"\n"
                   "  [Any key for more...] ");
    getch();
    fprintf(stderr,"\r\x1b[K\r"
                   "\nTo extract from an archive, LA /ext <arcfile> [<mask>]"
                   "\nTo extract with paths, LA /extw <arcfile> [<mask>]\n"
                   "\nTo view archive member, LA /view <arcfile> <filename> (uses temp dir "TEMPDIR")"
                   "\nTo view through MORE filter, LA /view <arcfile> <filename> | MORE"
                   "\nTo redirect to file, LA /view <arcfile> <filename> 1> <file>\n\n");
    fprintf(stderr,"    Bare Bones Software        _______\n"
                   "   Ŀ     --      --\n"
                   "    Whuzzat? Saywhut?     /    /`~    \\\n"
                   "    Voodoo?  Cult?        |\\         /|\n"
                   "                   !! ._ /|       |\\\n"
                   "    N  N  OOO  TTT !! '  | (@)   (@) |        Who says I forgot\n"
                   "    NN N  O O   T  !!     \\           /        you command line\n"
                   "    N NN  O O   T          |¿  ^  |         junkies?\n"
                   "    N  N  OOO   T  !!      \\     /\n"
                   "                            |Ŵ|\n"
                   "      (Gitabrayin.)         \\_______/\n"
                   "   \n");
    return 0;
  }

  signal(SIGINT,break_handler);
  signal(SIGILL,break_handler);
  signal(SIGSEGV,break_handler);
  signal(SIGTERM,break_handler);
  signal(SIGBREAK,break_handler);
  signal(SIGABRT,break_handler);
  atexit(whenexitting);

  {
    USHORT info,devhead;

    DosQHandType(fileno(stdout),&info,&devhead);
    if(((info & 255) == 1) && (devhead & 2)) {
      setvbuf(stdout,NULL,8192,_IOFBF);
    }
    else {
      fprintf(stderr,"\nLA working...\n");
      redirected++;
    }
  }

  if(!stricmp(argv[arg],"/debug")) {
    debug++;
    arg++;
  }

  if(!stricmp(argv[arg],"/ext") || !stricmp(argv[arg],"/extw")) { /* extract file in archive */
    extracting++;
    if(!stricmp(argv[arg],"/extw"))
      wdirs++;
    arg++;
    if(arg == argc) {
      fprintf(stderr,"\n **Error:  need archive name from which to extract.\n");
      return 1;
    }
  }

  if(!stricmp(argv[arg],"/view")) { /* view file in archive */
    viewing++;
    arg++;
    if(argc < arg + 1) {
      fprintf(stderr,"\n **Error:  need archive name and file to view.\n");
      return 1;
    }
  }

  while(arg < argc) {
    archives = 0;
    if(!strchr(argv[arg],'*') && !strchr(argv[arg],'?') &&
       argv[arg][strlen(argv[arg]) - 1] != '.') {
      if(argv[arg][strlen(argv[arg]) - 1] == '\\' ||
         argv[arg][strlen(argv[arg]) - 1] == '/')
        argv[arg][strlen(argv[arg]) - 1] = 0;
      if(stat(argv[arg],&st) || (st.st_mode & S_IFREG))
        sprintf(finder,"%s*",argv[arg]);
      else
        sprintf(finder,"%s\\*",argv[arg]);
    }
    else {
      strcpy(finder,argv[arg]);
      while((path = strchr(argv[arg],'/')) != NULL)
        *path = '\\';
      path = strrchr(argv[arg],'\\');
      if(path)
        *path = 0;
    }
    if(strchr(argv[arg],'\\') || strchr(argv[arg],'/') ||
       strchr(argv[arg],':')) {
      strcpy(ourpath,finder);
      path = strrchr(ourpath,'\\');
      if(path)
        *path = 0;
      else {
        path = strrchr(ourpath,':');
        if(path) {
          path++;
          *path = 0;
        }
      }
    }
    else
      save_dir(ourpath);
    path = ourpath;
    if(path[strlen(path) - 1] == '\\' ||
       path[strlen(path) - 1] == '/')
      path[strlen(path) - 1] = 0;

    search_handle = HDIR_SYSTEM;
    num_matches = 1;
    if(!DosFindFirst(finder,&search_handle,FILE_NORMAL,(FILEFINDBUF *)&f,
                     sizeof(FILEFINDBUF),&num_matches,0L)) {
      do {
        sprintf(buffer,"%s\\%s",path,f.achName);
        info = find_type(buffer);
        if(info) {
          unlink(TEMPFILE);
          if(viewing) {
            if(!info->extract || !*info->extract) {
              fprintf(stderr,"\n **Error:  no extraction method for archive type.\n");
              return 1;
            }
            arg++;
            if(!mkdir(TEMPDIR)) {
              if(!chdir(TEMPDIR)) {
                amswitched = 1;
                while(arg < argc) {
                  sprintf(dosbuffer,"%s %s %s 1>NUL 2>NUL",info->extract,
                          buffer,argv[arg]);
if(debug)
fprintf(stderr,"\n(%s)\n",dosbuffer);
                  if(!system(dosbuffer)) {

                    ARC_TYPE *tinfo;

                    tinfo = find_type(argv[arg]);
                    if(tinfo) {
                      sprintf(dosbuffer,"LA %s",argv[arg]);
if(debug)
fprintf(stderr,"\n(%s)\n",dosbuffer);
                      system(dosbuffer);
                    }
                    else {
                      fp = _fsopen(argv[arg],"rt",SH_DENYNO);
                      if(fp) {
                        while(!feof(fp)) {
                          if(!fgets(dosbuffer,133,fp))
                            break;
                          printf("%s",dosbuffer);
                        }
                        fclose(fp);
                      }
                    }
                    unlink(argv[arg]);
                  }
                  arg++;
                }
                if(chdir(".."))
                  fprintf(stderr,"\n **Error:  Couldn't switch back from temporary directory "TEMPDIR"\n");
                else
                  amswitched = 0;
              }
              else
                fprintf(stderr,"\n **Error:  Couldn't switch to temporary directory "TEMPDIR"\n");
              if(rmdir(TEMPDIR))
                fprintf(stderr,"\n **Error:  Couldn't remove temporary directory "TEMPDIR"\n");
            }
            else
              fprintf(stderr,"\n **Error:  Couldn't create temporary directory "TEMPDIR"\n");
          }
          else if(extracting) {
            if(!wdirs) {
              if(!info->extract || !*info->extract) {
                fprintf(stderr,"\n **Error:  no extraction method for archive type.\n");
                return 1;
              }
            }
            else {
              if(!info->exwdirs || !*info->exwdirs) {
                fprintf(stderr,"\n **Note:  no extract with paths method for archive type."
                               "\n   Falling back to plain extraction.\n");
                if(!info->extract || !*info->extract) {
                  fprintf(stderr,"\n **Error:  no extraction method for archive type.\n");
                  return 1;
                }
              }
            }
            arg++;
            sprintf(dosbuffer,"%s %s ",(!wdirs) ?
                    info->extract : (info->exwdirs && *info->exwdirs) ?
                    info->exwdirs : info->extract,buffer);
            if(arg < argc) {
              do {
                strcat(dosbuffer,argv[arg]);
                strcat(dosbuffer," ");
                arg++;
              } while(arg < argc);
            }
            else
              strcat(dosbuffer,"*.*");
if(debug)
fprintf(stderr,"\n(%s)\n",dosbuffer);
            system(dosbuffer);
          }
          else {  /* listing */
            sprintf(dosbuffer,"%s %s 1>%s 2>NUL",info->list,buffer,TEMPFILE);
if(debug)
fprintf(stderr,"\n(%s)\n",dosbuffer);
            if(!system(dosbuffer)) {
              once = startlist = endlist = 0;
              fp = _fsopen(TEMPFILE,"rt",SH_DENYNO);
              if(fp) {
                while(!feof(fp) && !endlist) {
                  if(!fgets(buffer,256,fp))
                    break;
                  stripcr(buffer);
                  if(startlist) {
                    if(!stricmp(buffer,info->endlist)) {
                      endlist++;
                      continue;
                    }
                    if(!once) {
                      once++;
                      numbytes += f.cbFile;
                      if(redirected) {
                        if(archives)
                          printf("\n");
                        printf("%-79.79s\n","================================================================================");
                      }
                      else
                        printf("\n");
                      printf("%-13s  %-9lu  %s  Type: %s\n",f.achName,f.cbFile,
                             say_filedate(finder,&f),info->id);
                      if(redirected)
                        fprintf(stderr,"%-13s  %-9lu  %s  Type: %s\n",f.achName,f.cbFile,
                                finder,info->id);
                      if(redirected)
                        printf("%-79.79s\n","--------------------------------------------------------------------------------");
                      archives++;
                    }
                    printf("%s\n",buffer);
                  }
                  else if(!stricmp(buffer,info->startlist))
                    startlist++;
                }
                fclose(fp);
                if(!once)
                  fprintf(stderr,"\n **ERROR:  No archive files found in \"%s\"\n",
                          f.achName);
                if(!startlist)
                  fprintf(stderr,"\n ** ERROR:  No start-of-list string found in \"%s\":\n\"%s\"\n",
                          f.achName,info->startlist);
                if(!endlist)
                  fprintf(stderr,"\n **ERROR:  End-of-list string not found in \"%s\"\n",
                          f.achName);
              }
              else
                fprintf(stderr,"\n **ERROR:  Couldn't open \"%s\"\n",
                        TEMPFILE);
              unlink(TEMPFILE);
            }
            else
              fprintf(stderr,"\n **ERROR:  List attempt failed -=> \"%s\"\n",dosbuffer);
          }
        }
        else
          fprintf(stderr,"\n **Skipping non-archive \"%s\"\n",buffer);
        num_matches = 1;
      } while(!DosFindNext(search_handle,(FILEFINDBUF *)&f,
              sizeof(FILEFINDBUF),&num_matches));
      DosFindClose(search_handle);
      if(!viewing && !extracting) {
        if(!archives)
          fprintf(stderr,"\n **NOTE:  No archives found matching:\n\"%s\"\n",finder);
        else {
          if(redirected) {
            printf("\n\n +-------------------------------------------------------------------+\n");
            printf(" |                                                                   |\n | ");
          }
          else
            printf("\n");
          endlist = printf("Listed %u archive%s totalling %lu bytes.",archives,&"s"[archives == 1],numbytes);
          if(redirected) {
            if(endlist < 66) {
              while(endlist < 66) {
                printf(" ");
                endlist++;
              }
              printf("|");
            }
            printf("\n |                                                                   |\n");
            printf(" +-------------------------------------------------------------------+");
          }
          else
            printf("\n");
        }
      }
    }
    else
      fprintf(stderr,"\n **NOTE:  No files found matching:\n\"%s\"\n",finder);
    arg++;
  }

  return 0;
}

