#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

    #define MAXFILEHANDLES 255
    #define MAXMEMHANDLES 1027
    #define MAXFINDHANDLES 255

    extern unsigned long ScanningSEM;
    extern MDM           *modems[MAXINSTANCES];

    USER          *user[MAXINSTANCES];
    BBS           *bbs;

    int            hydraok = 0;

    extern int  _fastcall   load_addresses (void);
    extern int  _fastcall   load_archivers (void);



int _fastcall init_all (void) {

    USHORT x;
    SEL    temp;

    {
      struct stat st;

      if(!stat(".\\HYDRA.EXE",&st))
        hydraok = 1;
      else
        hydraok = 0;
    }

    DosSemClear(&ScanningSEM);
    for(x = 0;x < MAXINSTANCES;x++)
      modems[x] = NULL;

    DosSetMaxFH(255);

    if(load_addresses()) {
      WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                     "Couldn't load address(es)",
                     "XBBS",0,MB_CANCEL | MB_ICONHAND);
      logfmain("Couldn't load address(es)");
      return -1;
    }

    load_archivers();

    if(!DosAllocShrSeg(sizeof(BBS),"\\SHAREMEM\\XBBS\\BBS.0",&temp))
      bbs = (BBS *)MAKEP(temp,0);
    else {
      WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                     "Couldn't allocate bbs structure in shared memory",
                     "XBBS",0,MB_CANCEL | MB_ICONHAND);
      logfmain("Can't allocate bbs structure");
      return -1;
    }

    for(x = 0;x < MAXINSTANCES;x++)
      user[x] = NULL;

    memset(bbs,0,sizeof(BBS));

    load_msgareas();
    load_fileareas();
    load_libareas();
    load_computers();

    return 0;
}
