#include "doorskel.h"
#include "hydra.h"


#define NAMELEN  13
#define LINELEN  64


static char xfer_log[HYDRAPATHLEN];
static boolean xfer_logged;
static char xfer_pathname[HYDRAPATHLEN];
static char xfer_real[NAMELEN],
            xfer_temp[NAMELEN];
static long xfer_fsize,
            xfer_ftime;


void Hydraunique_name (char *pathname)
{
  static char *suffix = ".000";
  register char *p;
  register int   n;

  if (Hydrafexist(pathname)) {
     p = pathname;
     while (*p && *p!='.') p++;
     for (n=0; n<4; n++) {
         if (!*p) {
            *p     = suffix[n];
            *(++p) = '\0';
         }
         else
            p++;
     }

     while (Hydrafexist(pathname)) {
           p = pathname + ((int) strlen(pathname)) - 1;
           if (!isdigit(*p))
              *p = '0';
           else {
              for (n=3; n--;) {
                  if (!isdigit(*p)) *p = '0';
                  if (++(*p) <= '9') break;
                  else               *p-- = '0';
              }/*for*/
           }
     }/*while(exist)*/
  }/*if(exist)*/
}/*Hydraunique_name()*/


char *Hydraxfer_init (char *fname, long fsize, long ftime)
{
  char  linebuf[LINELEN + 1];
  char  bad_real[NAMELEN],
        bad_temp[NAMELEN];
  long  bad_fsize,
        bad_ftime;
  char *p;
  FILE *fp;

  if (Hydrasingle_done)
     return (NULL);

  strcpy(xfer_real,fname);
  xfer_fsize = fsize;
  xfer_ftime = ftime;

  Hydramergepath(xfer_pathname,Hydradownload,xfer_real);
  if (Hydrafexist(xfer_pathname)) {
     struct stat f;

     stat(xfer_pathname,&f);
     if (xfer_fsize == f.st_size && xfer_ftime == f.st_mtime)
        return (NULL);                            /* already have file */
  }

  Hydramergepath(xfer_log,Hydradownload,"BAD-XFER.LOG");

  if ((fp = DoorFsopen(xfer_log,"rt",SH_DENYWR)) != NULL) {
     while (fgets(linebuf,LINELEN,fp)) {
           sscanf(linebuf,"%s %s %ld %lo",
                          bad_real, bad_temp, &bad_fsize, &bad_ftime);
           if (!strcmp(xfer_real,bad_real) &&
               xfer_fsize == bad_fsize && xfer_ftime == bad_ftime) {
              Hydramergepath(xfer_pathname,Hydradownload,bad_temp);
              if (Hydrafexist(xfer_pathname)) {
                 fclose(fp);
                 strcpy(xfer_temp,bad_temp);

                 xfer_logged = true;
                 return (xfer_pathname);
              }
           }
     }

     fclose(fp);
  }

  strcpy(xfer_pathname,Hydradownload);
  p = xfer_pathname + ((int) strlen(xfer_pathname));
  strcat(xfer_pathname,"BAD-XFER.000");
  Hydraunique_name(xfer_pathname);
  strcpy(xfer_temp,p);

  xfer_logged = false;
  return (xfer_pathname);
}/*Hydraxfer_init()*/


boolean Hydraxfer_bad (void)
{
        struct stat f;
        FILE *fp;
        int n;

        if (Hydrasingle_file[0])
           Hydrasingle_done = true;

        if (xfer_logged)                        /* Already a logged bad-xfer */
           return (true);

        n = ((int) strlen(xfer_real)) - 1;
        if (n > 3 &&
            (!strcmp(&xfer_real[n-3],".PKT") || !strcmp(&xfer_real[n-3],".REQ"))) {
           Hydraxfer_del();
           return (false);                      /* don't recover .PKT / .REQ */
        }

        stat(xfer_pathname,&f);
        if (Hydranoresume || f.st_size < 1024L) {     /* not allowed/worth saving */
           Hydraxfer_del();
           return (false);
        }

        if ((fp = DoorFsopen(xfer_log,"at",SH_DENYWR)) != NULL) {
           fprintf(fp,"%s %s %ld %lo\n",
                     xfer_real, xfer_temp, xfer_fsize, xfer_ftime);
           fclose(fp);

           return (true);                             /* bad-xfer logged now */
        }

        Hydraxfer_del();
        return (false);                             /* Couldn't log bad-xfer */
}/*Hydraxfer_bad()*/


char *Hydraxfer_okay (void)
{
        static char new_pathname[HYDRAPATHLEN];
        char *p;

        strcpy(new_pathname,Hydradownload);
        p = new_pathname + ((int) strlen(new_pathname));   /* start of fname */
        if (Hydrasingle_file[0]) {
           strcat(new_pathname,Hydrasingle_file);           /* add override fname */
           Hydrasingle_done = true;
        }
        else {
           strcat(new_pathname,xfer_real);                 /* add real fname */
           Hydraunique_name(new_pathname);                      /* make it unique */
        }
        rename(xfer_pathname,new_pathname);           /* rename temp to real */
        if (!Hydranostamp && xfer_ftime)
           DoorSetFDate(new_pathname,xfer_ftime);               /* set timestamp */
        if (xfer_logged)                         /* delete from bad-xfer log */
           Hydraxfer_del();

        return (strcmp(p,xfer_real) ? p : NULL);              /* dup rename? */
}


void Hydraxfer_del (void)
{
        char  new_log[HYDRAPATHLEN];
        char  linebuf[LINELEN + 1];
        char  bad_real[NAMELEN],
              bad_temp[NAMELEN];
        long  bad_fsize,
              bad_ftime;
        FILE *fp, *new_fp;
        boolean left;

        if (Hydrafexist(xfer_pathname))
           unlink(xfer_pathname);

        if ((fp = DoorFsopen(xfer_log, "rt", SH_DENYWR)) != NULL) {
           Hydramergepath(new_log,Hydradownload,"BAD-XFER.$$$");
           if ((new_fp = DoorFsopen(new_log, "wt", SH_DENYRW)) != NULL) {
              left = false;
              while (fgets(linebuf,LINELEN,fp)) {
                    sscanf(linebuf,"%s %s %ld %lo",
                                   bad_real, bad_temp, &bad_fsize, &bad_ftime);
                    if (strcmp(xfer_real,bad_real) ||
                        strcmp(xfer_temp,bad_temp) ||
                        xfer_fsize != bad_fsize || xfer_ftime != bad_ftime) {
                       fputs(linebuf,new_fp);
                       left = true;
                    }
              }
              fclose(fp);
              fclose(new_fp);
              unlink(xfer_log);
              if (left) rename(new_log,xfer_log);
              else      unlink(new_log);
           }
           else
              fclose(fp);
        }
}/*Hydraxfer_del()*/

/* end of fmisc.c */
