#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"

extern MDM                  *modems[MAXINSTANCES];
extern USER                 *user[MAXINSTANCES];
extern BBS                  *bbs;
extern MSGAREA              *msgareas;
extern FILEAREA             *fileareas;
extern LIBAREA              *libareas;
extern MSGAREA              *msgareatail;
extern FILEAREA             *fileareatail;
extern LIBAREA              *libareatail;
extern ADDR                 *addresses;



MSGAREA * _fastcall next_msg_area (MSGAREA *ma, USHORT cp,
                                   int dir) {

    /* Also finds first accessible area if called with ma==msgareas */
    /* and dir==0 */

  MSGAREA *info;
  char temp = 0;


    if(!msgareas || !ma) return NULL;

  info = ma;
    while(info) {
        if(dir || temp) {
      if(dir < 0) info = info->prior;
      else info = info->next;
        }
        else temp++;
        if(!info) break;
    if(info->r_security1 > user[cp]->security1) continue;
    if(info->r_security2 > user[cp]->security2) continue;
    if(info->r_flags1 & (~user[cp]->flags1)) continue;
    if(info->r_flags2 & (~user[cp]->flags2)) continue;
    if(info->age) {
      if(info->age < 0) {
        if(user[cp]->age > abs(info->age)) continue;
      }
      else {
        if(user[cp]->age < info->age) continue;
      }
    }
    if((info->areaflags & M_ANSI) && !(user[cp]->attribs & U_COLOR)) continue;
    if(!IsBit(user[cp]->bbsmsg,info->number - 1)) continue;
    break;
  }
    return info;
}




FILEAREA * _fastcall next_file_area (FILEAREA *fa,USHORT cp,int dir,
                                     int hiddenok) {

    // Also finds first accessible area if called with fa==fileareas
    // and dir==0

    FILEAREA *info;
    char temp = 0;

    if(!fileareas || !fa)
      return NULL;

    info = fa;
    while(info) {
        if(dir || temp) {
            if(dir < 0)
              info = info->prior;
            else
              info = info->next;
        }
        else
          temp++;
        if(!info || (!hiddenok && (info->areaflags & F_HIDDEN))) {
          info = NULL;
          break;
        }
        if(info->r_security1>user[cp]->security1)
          continue;
        if(info->r_security2>user[cp]->security2)
          continue;
        if(info->r_flags1 & (~user[cp]->flags1))
          continue;
        if(info->r_flags2 & (~user[cp]->flags2))
          continue;
        if(info->age) {
          if(info->age < 0) {
            if(user[cp]->age > abs(info->age))
              continue;
          }
          else if(user[cp]->age < info->age)
            continue;
        }
        if(!IsBit(user[cp]->bbsfile,info->number - 1))
          continue;
        break;
    }
    return info;
}





LIBAREA * _fastcall next_lib_area (LIBAREA *ma, USHORT cp,
                                   int dir) {

    /* Also finds first accessible area if called with ma==libareas */
    /* and dir==0 */

    LIBAREA *info;
    char temp = 0;


    if(!libareas || !ma) return NULL;

    info = ma;
    while(info) {
        if(dir || temp) {
            if(dir < 0) info = info->prior;
            else info = info->next;
        }
        else temp++;
        if(!info) break;
        if(info->r_security1 > user[cp]->security1) continue;
        if(info->r_security2 > user[cp]->security2) continue;
        if(info->r_flags1 & (~user[cp]->flags1)) continue;
        if(info->r_flags2 & (~user[cp]->flags2)) continue;
        if(info->age) {
            if(info->age < 0) {
                if(user[cp]->age > abs(info->age)) continue;
            }
            else {
                if(user[cp]->age < info->age) continue;
            }
        }
        if((info->areaflags & L_ANSIONLY) && !(user[cp]->attribs & U_COLOR)) continue;
        break;
    }
    return info;
}




MSGAREA * _fastcall find_msg_area (char *areaname,USHORT cp,
                                   unsigned int areanum) {

    MSGAREA *info;


    if(!msgareas)
      return NULL;

    info = msgareas;
    while(info) {
        if((info->number == areanum) ||
          (areaname && !stricmp(info->name,areaname))) {
            if(info->r_security1 > user[cp]->security1) return NULL;
            if(info->r_security2 > user[cp]->security2) return NULL;
            if(info->r_flags1 & (~user[cp]->flags1)) return NULL;
            if(info->r_flags2 & (~user[cp]->flags2)) return NULL;
            if(info->age) {
                if(info->age < 0) {
                    if(user[cp]->age > abs(info->age)) return NULL;
                }
                else {
                    if(user[cp]->age < info->age) return NULL;
                }
            }
            if((info->areaflags & M_ANSI) && !(user[cp]->attribs & U_COLOR))
              return NULL;
            if(!IsBit(user[cp]->bbsmsg,info->number - 1)) return NULL;
            break;
        }
        info = info->next;
    }

    return info;
}




FILEAREA * _fastcall find_file_area (char *areaname,USHORT cp,
                                     unsigned int areanum,
                                     int hiddenok) {

    FILEAREA *info;


    if(!fileareas)
      return NULL;

    info = fileareas;
    while(info) {
        if((info->number == areanum) ||
          (areaname && !stricmp(info->name,areaname))) {
            if(!hiddenok && (info->areaflags & F_HIDDEN))
              return NULL;
            if(info->r_security1 > user[cp]->security1) return NULL;
            if(info->r_security2 > user[cp]->security2) return NULL;
            if(info->r_flags1 & (~user[cp]->flags1)) return NULL;
            if(info->r_flags2 & (~user[cp]->flags2)) return NULL;
            if(info->age) {
                if(info->age < 0) {
                    if(user[cp]->age > abs(info->age)) return NULL;
                }
                else {
                    if(user[cp]->age < info->age) return NULL;
                }
            }
            if(!IsBit(user[cp]->bbsfile,info->number-1)) return NULL;
            break;
        }
        info = info->next;
    }

    return info;
}




LIBAREA * _fastcall find_lib_area (char *areaname,USHORT cp,
                                   unsigned int areanum) {

    LIBAREA *info;


    if(!libareas) return NULL;

    info = libareas;
    while(info) {
        if((info->number == areanum) ||
          (areaname && !stricmp(info->name,areaname))) {
            if(info->r_security1 > user[cp]->security1) return NULL;
            if(info->r_security2 > user[cp]->security2) return NULL;
            if(info->r_flags1 & (~user[cp]->flags1)) return NULL;
            if(info->r_flags2 & (~user[cp]->flags2)) return NULL;
            if(info->age) {
                if(info->age < 0) {
                    if(user[cp]->age > abs(info->age)) return NULL;
                }
                else {
                    if(user[cp]->age < info->age) return NULL;
                }
            }
            if((info->areaflags & L_ANSIONLY) && !(user[cp]->attribs & U_COLOR))
              return NULL;
            break;
        }
        info = info->next;
    }

    return info;
}




ADDR * _fastcall find_address (ADDR *addr,ADDR *top) {

    ADDR *info;


    if(!top) {
        return NULL;
    }
    if(!addr) {
        return top;
    }

    info = top;
    while(info) {
        if(info->node == addr->node && info->net == addr->net && \
            info->point == addr->point && info->zone == addr->zone && \
            !stricmp(info->domain,addr->domain)) {
                return info;
        }
        info = info->next;
    }
    return top;
}




int _fastcall msg_write_ok (USER *u,MSGAREA *info) {

    if(!info || (info->w_security1 > u->security1 ||
       info->w_security2 > u->security2 ||
       (info->w_flags1 & (~u->flags1)) ||
       (info->w_flags2 & (~u->flags2)))) return -1;
    return 0;
}




int _fastcall msg_sysop_ok (USER *u, MSGAREA *info) {

    if(!info || (info->s_security1 > u->security1 ||
       info->s_security2 > u->security2 ||
       (info->s_flags1 & (~u->flags1)) ||
       (info->s_flags2 & (~u->flags2)))) return -1;
    return 0;
}




int _fastcall file_write_ok (USER *u, FILEAREA *info) {

    if(!info || (info->w_security1 > u->security1 ||
       info->w_security2 > u->security2 ||
       (info->w_flags1 & (~u->flags1)) ||
       (info->w_flags2 & (~u->flags2)))) return -1;
    return 0;
}




int _fastcall file_sysop_ok (USER *u,FILEAREA *info) {

    if(!info || (info->s_security1 > u->security1 ||
       info->s_security2 > u->security2 ||
       (info->s_flags1 & (~u->flags1)) ||
       (info->s_flags2 & (~u->flags2)))) return -1;
    return 0;
}




int _fastcall lib_write_ok (USER *u,LIBAREA *info) {

    if(!info || (info->w_security1 > u->security1 ||
       info->w_security2 > u->security2 ||
       (info->w_flags1 & (~u->flags1)) ||
       (info->w_flags2 & (~u->flags2)))) return -1;
    return 0;
}




int _fastcall lib_sysop_ok (USER *u, LIBAREA *info) {

    if(!info || (info->s_security1 > u->security1 ||
       info->s_security2 > u->security2 ||
       (info->s_flags1 & (~u->flags1)) ||
       (info->s_flags2 & (~u->flags2)))) return -1;
    return 0;
}
