/* Download module handles user downloads from BBS.  Normally you'd call */
/* download_files() to do all the work, but lower level calls are available */
/* for specialized things. */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "window.h"
#include "transfer.h"
#include "modem.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"

    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern USHORT   focusline;


void _fastcall end_batch (int mode,USHORT cp) {

  int  x,ch;

  if(mode & D_REMOTE) {
    purge_in(cp);
    for(x = 0;x < 5;x++) {
      dputc(D_REMOTE,cp,EOT);
      ch = get_modem_byte(cp,1000L);
      if(ch == ACK) {
        logfunc(0,cp,"Remote acknowledged end of batch");
        return;
      }
      purge_in(cp);
    }
    logfunc(0,cp,"Remote refused to acknowledge end of batch");
  }
}


long _fastcall download_list (int mode,USHORT cp,long *numfiles,
                              unsigned int flags) {

  char s[261];
  int  handlei,handleo;
  long numbytes = 0L,temp,where;

  *numfiles = 0;
  sprintf(s,".\\FILESEND.%03u",cp);
  handlei = bbs_sopen(cp,s,O_RDWR | O_BINARY,SH_DENYWR);
  if(handlei == -1)
    return 0L;
  sprintf(s,".\\FILESENT.%03u",cp);
  unlink(s);
  handleo = bbs_sopen(cp,s,O_WRONLY | O_BINARY | O_CREAT,SH_DENYWR,
                      S_IREAD | S_IWRITE);
  if(handleo == -1) {
    bbs_close(cp,handlei);
    return 0L;
  }
  while(!eof(handlei)) {
    where = tell(handlei);
    if(!fgetsx(s,260,handlei))
      break;
    stripcr(s);
    temp = download_file(mode,cp,s,flags);
    if(temp) {
      (*numfiles)++;
      numbytes += temp;
      ffprintf(handleo,"%s\r\n",s);
    }
  }
  if(numfiles && (user[cp]->lastprotocol == 'S' ||
     user[cp]->lastprotocol == '\0' ||
     user[cp]->lastprotocol == 'Y' ||
     user[cp]->lastprotocol == 'T' ||
     user[cp]->lastprotocol == 'G' ||
     user[cp]->lastprotocol == 'Z')) {
    end_batch(mode,cp);
    dputs(D_REMOTE,cp,"\b\b\b\b\b\b\b\b\b\b          \b\b\b\b\b\b\b\b\b\b");
  }
  bbs_close(cp,handlei);
  bbs_close(cp,handleo);
  return numbytes;
}


long _fastcall download_file (int mode,USHORT cp,char *filename,
                              unsigned int flags) {

    /* flags bitmapped values:
       1:   Don't do time verification
       2:   Don't do leech check
       4:   Silence
       8:   Never be silent
       16:  Don't check all dpaths
       32:  Use the external protocol indicated by user[cp]->lastprotocol
       64:  Don't return file's length (free file)
    */

    struct stat st;
    long        secs;
    char        *rootname;
    int         error;

    if(!filename || !*filename)
      return 0L;

    while((rootname = strchr(filename,'/')) != NULL)
      *rootname = '\\';
    rootname = strrchr(filename,'\\');
    if(!rootname)
      rootname = strrchr(filename,':');
    if(rootname)
      rootname++;
    else
      rootname = filename;

    memset(&st,0,sizeof(struct stat));
    if(stat(filename,&st) || (st.st_mode & S_IFCHR) || (st.st_mode & S_IFDIR)) {
      if(!(flags & 4)) {
        dprintf(mode,cp,"\r\n\"%s\" is bogus.\r\n",rootname);
      }
      if(st.st_mode & S_IFCHR)
        return -1L;    /* wise-ass entered a device name */
      return 0L; /* Bogus filename */
    }

    if(!modems[cp]->curbaud) {
      dprintf(mode,cp,"File found: %s  %ld bytes\r\n",filename,st.st_size);
      return 0L;
    }

    secs = (long)max(1L,(((st.st_size + (st.st_size * 8L)) * 10L) / (long)(modems[cp]->curbaud) / 10L));
    secs = secs + (secs / 6L);  /* adjust for inefficiency */

    if(!(flags & 1)) {  /* Time check */
      if(secs >= user[cp]->offline - time(NULL)) {
        if(!(flags & 4)) {
          dprintf(mode,cp,"\r\nNot enough time to download \"%s\"\r\n(%ld bytes, apx. %lu min %lu sec)\r\n",
                  rootname,st.st_size,secs / 60L,secs % 60L);
        }
        return -1L;
      }
    }

    if(!(flags & 2)) {  /* Leech &c check */
      if(user[cp]->dktoday + (st.st_size / 1024L) > user[cp]->dkperday) {
        dprintf(mode,cp,"\r\n\"%s\" (%ld bytes) not sent.\r\nWould exceed download limit.\r\n",
                rootname,st.st_size);
        return 0L;
      }
    }

    dprintf(D_LOCAL,cp,"\r\n%s (%s) is downloading %s\r\n",
            user[cp]->name,user[cp]->handle,rootname);

    if(!(flags & 4)) {
      dputs(mode,cp,"\r\nEngage ");
      switch(user[cp]->lastprotocol) {
        case 'T':
            dputs(mode,cp,"Telink");
            break;

/*
        case 'K':
            dputs(mode,cp,"Kermit");
            break;
*/

        case 'Z':
            dputs(mode,cp,"ZModem");
            break;

        case 'X':
            dputs(mode,cp,"XModem");
            break;

        case 'S':
            dputs(mode,cp,"SEAlink(/Overdrive)");
            break;

        case 'Y':
            dputs(mode,cp,"YModem");
            break;

        case 'G':
            dputs(mode,cp,"YModem-G");
            break;

        case '1':
            dputs(mode,cp,"XModem-1K");
            break;

        default:
            dputs(mode,cp,"SEAlink/fallback to XModem");
            break;
      }
      dprintf(mode,cp," RECEIVE mode now for\r\n \"%s\" (%ld bytes, apx. %lu min %lu sec)\r\n",
              rootname,st.st_size,secs / 60L,secs % 60L);
      if(user[cp]->lastprotocol != 'K')
        dputs(mode,cp,"or send several CTRL-Xs to abort...");
      else
        dputs(mode,cp,"or send several CTRL-Ks to abort...");
    }

    switch(user[cp]->lastprotocol) {
/*
      case 'K':  // Kermit
          one_kermit(mode,cp,&secs,1,filename,0L);
          break;
*/

      case 'Z':  // ZModem
          secs = wait_sessionf(mode,cp,0,
                        "ZSX2.EXE handle %u speed %u line %u f Z sz %s",
                        modems[cp]->mh,(modems[cp]->locked) ?
                        modems[cp]->maxbaud : modems[cp]->curbaud,
                        modems[cp]->curbaud,filename);
          if(!secs)
            secs = st.st_size;
          break;

      case 'X':  /* XModem */
          secs = send_xfile(cp,filename,1,&error);
          break;

      case 'G':  /* YModem-G */
          secs = wait_sessionf(mode,cp,0,
                        "ZSX2.EXE handle %u speed %u line %u f sg %s",
                        modems[cp]->mh,(modems[cp]->locked) ?
                        modems[cp]->maxbaud : modems[cp]->curbaud,
                        modems[cp]->curbaud,filename);
          if(!secs)
            secs = st.st_size;
//          secs = send_xfile(cp,filename,4 | 2 | 8 | 1,&error);
          break;

      case 'Y':  /* YModem */
          secs = send_xfile(cp,filename,4 | 2 | 1,&error);
          break;

      case '1':  /* XModem 1k */
          secs = send_xfile(cp,filename,2 | 1,&error);
          break;

      case 'T':  /* Telink */
          secs = send_file(cp,filename,1,1,0,0,NULL);
          break;

      case 'S':  /* sealink overdrive */
          secs = send_file(cp,filename,0,1,0,1,NULL);
          break;

      case 'N': /* YModem, no 1k */
          secs = send_xfile(cp,filename,4 | 1,&error);
          break;

      case 'E': /* YModem-G, no 1k */
          secs = send_xfile(cp,filename,4 | 8 | 1,&error);
          break;

      default:   /* sealink w/xmodem fallback, no overdrive */
          secs = send_file(cp,filename,0,1,0,0,NULL);
          break;
    }

    if(secs > 0L)
      logfunc(0,cp,"Downloaded \"%s\"",filename);
    else
      logfunc(0,cp,"Download of \"%s\" failed",filename);

    DosSleep(250L);

    if(flags & 64)
      return 0L;
    return secs;
}


long _fastcall download_wild (int mode,USHORT cp,char *filename,
                              unsigned int *error,unsigned long *numfiles,
                              unsigned int *flags) {

    HDIR                search_handle = HDIR_CREATE;
    USHORT              num_matches = 1;
    unsigned long       reservd = 0L;
    long                tl,num_bytes = 0L;
    FILEFINDBUF         *fb;
    char                *rootname,temp,*s,*p,*ff;
    FILEAREA            *start = user[cp]->currfilearea;


    if(*flags & 16)
      start = NULL;
    *error = 0;
    if(!filename || !*filename)
      return 0L;
    fb = (FILEFINDBUF *)bbs_malloc(cp,sizeof(struct _file_buffer));
    if(!fb)
      return 0L;

    while((rootname = strchr(filename,'\\')) != NULL)
      *rootname = '/';
    rootname = strrchr(filename,'/');
    if(!rootname)
      rootname = strrchr(filename,':');
    if(rootname) {
        temp = *(rootname + 1);
        *rootname = 0;
        rootname++;
        p = filename;
        start = NULL;
    }
    else {
        p = find_download_filepath(mode,cp,filename,&start);
    }

    do {
        if(!p)
          break;
        if(rootname) {
            ff = bbs_malloc(cp,strlen(p) + strlen(rootname) + 2);
            if(!ff)
              break;
            sprintf(ff,"%s/%s",p,rootname);
        }
        else if(p != filename) {
            ff = bbs_malloc(cp,strlen(p) + strlen(filename) + 2);
            if(!ff)
              break;
            sprintf(ff,"%s/%s",p,filename);
        }
        else {
            ff = bbs_strdup(cp,p);
            if(!ff)
              break;
        }

        if(!bbs_findfirst(cp,ff,&search_handle,0,fb,
            sizeof(FILEFINDBUF),&num_matches,reservd)) {
            do {

                if(user[cp]->offline < time(NULL))
                  goto Terminate;

                s = bbs_malloc(cp,strlen(p) + strlen(fb->achName) + 2);
                if(!s)
                  break;
                sprintf(s,"%s/%s",p,fb->achName);
                if(num_bytes && (user[cp]->lastprotocol == 'Y' ||
                   user[cp]->lastprotocol == 'S' ||
                   user[cp]->lastprotocol == 'T'))
                  *flags |= 4;
                tl = download_file(mode,cp,s,*flags);
                if(tl > 0L) {
                    (*numfiles)++;
                    num_bytes += tl;
                    if(!(*flags & 8))
                      *flags |= 4;
                }
                bbs_free(cp,s);
                if(tl == -1L) {
                    *error = 1;
                    tl = 0;
                    break;
                }
                if(modems[cp]->curbaud && checkcarrier(cp))
                  break;
                num_matches = 1;
            } while (!DosFindNext(search_handle,fb,
                                  sizeof(FILEFINDBUF),
                                  &num_matches));
            bbs_closefind(cp,search_handle);
        }

        bbs_free(cp,ff);
        if(*error)
          break;

        start = next_file_area(start,cp,1,1);
    } while((p = find_download_filepath(mode,cp,filename,&start)) != NULL);

Terminate:

    if(rootname) {
        *rootname = temp;
    }
    bbs_free(cp,fb);
    return num_bytes;
}


long _fastcall download_files (int mode,USHORT cp,char *str,char *path,
                               unsigned long *numfiles,unsigned int flags) {

    char         *p,*pp,*s;
    long         numbytes = 0L,lastbytes = 0L,tl;
    unsigned int error;


    if(!str || !*str || (!path && !user[cp]->currfilearea))
      return 0L;
    s = bbs_strdup(cp,str);
    if(!s)
      return 0L;

    p = skip_white(s);
    pp = skip_nonwhite(p);
    if(*pp) {
        *pp = 0;
        pp++;
    }
    while(*p) {
        if(path) {

            char *fs;

            fs = bbs_malloc(cp,strlen(path) + strlen(p) + 2);
            if(!fs)
              break;
            sprintf(fs,"%s/%s",path,p);
            tl = download_wild(mode,cp,fs,&error,numfiles,&flags);
            bbs_free(cp,fs);
        }
        else
          tl = download_wild(mode,cp,p,&error,numfiles,&flags);
        if(tl == -1L)
          break;
        numbytes += tl;
        if(!*pp || error)
          break;
        if(modems[cp]->curbaud && checkcarrier(cp))
          break;
        p = skip_white(pp);
        pp = skip_nonwhite(p);
        if(*pp) {
            *pp = 0;
            pp++;
        }
        if(user[cp]->offline < time(NULL))
          break;
    }

    if(numbytes && (user[cp]->lastprotocol == 'S' ||
       user[cp]->lastprotocol == '\0' ||
       user[cp]->lastprotocol == 'Y' ||
       user[cp]->lastprotocol == 'T' ||
       user[cp]->lastprotocol == 'G')) {
      end_batch(mode,cp);
      dputs(D_REMOTE,cp,"\b\b\b\b\b\b\b\b\b\b          \b\b\b\b\b\b\b\b\b\b");
    }

    bbs_free(cp,s);
    DosSleep(64L);
    purge_in(cp);
    return numbytes;
}


char * _fastcall find_download_filepath (int mode,USHORT cp,char *filename,
                                         FILEAREA **start) {

    char                *s;
    FILEAREA            *info;
    HDIR                search_handle;
    USHORT              num_matches;
    unsigned long       reservd = 0L,num_bytes = 0L;
    FILEFINDBUF         fb;

    info = *start;
    while(info) {
        s = bbs_malloc(cp,strlen(filename) + strlen(info->dpath) + 2);
        if(!s)
          break;
        sprintf(s,"%s/%s",info->dpath,filename);
        search_handle = HDIR_CREATE;
        num_matches = 1;
        if(((info->areaflags & F_HIDDEN) &&
            (strchr(filename,'*') || strchr(filename,'?'))) ||
           bbs_findfirst(cp,s,&search_handle,0,&fb,
           sizeof(FILEFINDBUF),&num_matches,reservd)) {
             bbs_free(cp,s);
             *start = next_file_area(info,cp,1,1);
             info = *start;
             continue;
        }
        bbs_closefind(cp,search_handle);
        bbs_free(cp,s);
        return info->dpath;
    }

    return NULL;
}
