See license.txt for license.

See various.dir for information on directories used by XBBS.


Formats for miscellaneous data files used by XBBS-OS/2:
======================================================
Note that only ASCII data files are listed; reference
mailer.h and bbs.h for binary data file layouts.


-=-
Format for a record in MSGAREAS.BB2 (all on one line):

Name,Age,RSec1,RSec2,RFlags1,RFlags2,WSec1,WSec2,WFlags1,WFlags2,
SSec1,SSec2,SFlags1,SFlags2,AreaFlags,FTNAddress,Number,Description,
ForceTo,Password,Name-to-use

AreaFlags:
---------
#define M_NOORIG   0x00000001  /* No Origin or tear     */
#define M_ANSI     0x00000002
#define M_PRIVATE  0x00000004
#define M_PUBLIC   0x00000008
#define M_ECHO     0x00000010
#define M_NET      0x00000020
#define M_MCI      0x00000040
#define M_ANON     0x00000080
#define M_REAL     0x00000100  /*                       */
#define M_ASSOC    0x00000200  /* Msg area allows assoc */
#define M_FORCE    0x00000400  /* Always force          */
#define M_COMPRESS 0x00000800  /* Allow LZSS comp here  */

Security is rather simply handled; if a user's security fields meet or
exceed what's shown in RSec1 and RSec2 *and* the user's age is >= Age
(or, if Age is negative, <= abs(Age)), *and* the user has all bits on in
his flags1 field that are on in the RFlags1 field *and* the user has all
bits on in his flags2 field that are on in RFlags2, the user has read
access to the area.  WSec#/Flags# serve the same purpose for write
access, and SSec#/SFlags# serve the same purpose for sysop access.

Note Name-to-use is only for HeadEdit (and that HeadEdit will ignore most
of the security oriented data).

See LOADMSGA.C for sample code.


-=-
Format for a record in FILEAREA.BB2 (all on one line):

Name,Age,RSec1,RSec2,RFlags1,RFlags2,WSec1,WSec2,WFlags1,WFlags2,
SSec1,SSec2,SFlags1,SFlags2,Cost/K,AreaFlags,Number,U/L Path,D/L Path,
Description,Password

AreaFlags:
---------
#define F_FREE        0x00000001
#define F_NOUP        0x00000002
#define F_NODOWN      0x00000004
#define F_LEECH       0x00000008
#define F_DOWNBACK    0x00000010
#define F_UPBACK      0x00000020
#define F_CHARGE      0x00000040

See LOADFILA.C for sample code.  Use NUL for path if you want to
disallow either uploading or downloading to an area.



-=-
Format for a record in LIBAREAS.BB2 (all on one line):

Name,Age,RSec1,RSec2,RFlags1,RFlags2,WSec1,WSec2,WFlags1,WFlags2,
SSec1,SSec2,SFlags1,SFlags2,AreaFlags,Number,Path,Description,Password

AreaFlags:
---------
#define L_ANSIONLY   0x00000001

See LOADLIBA.C for sample code.



-=-
Format for a record in ADDRESS.BB2 (all on one line):

Zone:Net/Node.Point@Domain

This is a "standard" 5-D FTN address.  XBBS uses this list of addresses
to guess who it should be when writing to another address or talking to
a remote mailer, as well as filling in missing fields from braindead
remote mailers.  XBBS will insist that this file exists before it
starts.

See LOADADDR.C and PRSEADDR.C for sample code.



-=-
Format for a record in COMPUTER.BB2 (all on one line):

Computer Name

This is just a text string presented to the user.

See LOADCOMP.C for sample code.



-=-
Format for a record (line) in AUTOCHK.BB2:
Msgarea name



-=-
Format for outbound directory filenames:

type.zone.net.node.point.domain

 NOTES:  Requires HPFS.  Is human readable!

Types:
-----
 Attaches:
 --------
M...Manual poll or his nickel only
H...His nickel only
C...Crash
N...Normal
D...Direct

 Attaches contain filenames (may be empty for a "null" attach) one per
 line.  A second field (space-separated) may appear for a different
 filename to pass to the remote mailer.  For example:
   MYFILEWITHALONG.OS2.FILENAME MYFILE.OS2
 ...would send MYFILEWITHALONG.OS2.FILENAME to the remote as MYFILE.OS2
 You can't use spaces in filenames, sorry.


 Packets:
 -------
T...Packet not normally processed into ARCmail
P...Packet, will probably be compressed

 Packets are standard FTN type 2.2 packets.  They are renamed OTF as
 sent.  Don't create empty packets to generate a poll; use a "null"
 attach instead (i.e. ECHO. >> E:\XBBS2\OUTBOUND\C.1.380.25.0.FIDONET).


 Requests:
 --------
R...List of requested files

 Request files contain lists of filenames to request.  Internally, they
 follow the Wazoo style of request (including password and update
 information).  They are converted to Bark requests OTF for FTS-0001
 sessions.  When sent as Wazoo requests they are renamed OTF as sent.
 See GS utility or XBBS menu.



 -=-
 Format for FILES.BBS:

XBBS-OS/2's FILES.BBS have a slightly modified format:

 Filename AREA Uploader Datestring
  Description line #1
  ...
  Description line #n

Everything but the filename is optional.  The AREA name is used to
determine what directory the file is in (assumed to be in user's default
file area d/l path if not present).  Uploader is whoever uploaded the
file.  Datestring is the *nix-style date it was sent (as produced by
asctime()).  Description lines should not contain semi-colons;
semi-colons indicate private data that will not be transmitted.

Note that this arrangement lets you have one master FILES.BBS with files
in many directories.  With this setup a user can list only files in
areas the user has on in the bbsfile bitmapped array.  Fewer open/closes
means faster listing through multiple areas.  Ijit-mode assumes you use
this format, though it'll hobble along if you don't.

See MAKEFLST utility.


-=-
Format for OKFILE.LST:

An OKFILE.LST format file is used to determine what may be requested by
a remote mailer.  An entry (one per line) gives a path and filename mask
of allowed files.  For an example, an OKFILE.LST containing:

 F:\*.*
 F:\SPEC\SPECFILE.EXE

...would allow a remote mailer to request SPECFILE.EXE and/or anything
in the root directory of drive F:

In addition, "magic" filenames and function requests can be set up.  A
"magic" filename entry has the format:

 @MAGICNAME D:\DIR\MASK

...and a function request has the format:

 #FUNCNAME COMMAND

...where COMMAND is a program to execute (through CMD.EXE).  XBBS
attempts to process function requests while the remote is still online,
and waits if possible for the requested function to complete.  A
function is passed the following arguments:

 CMD.EXE /C CMD <request name> <args from requestor> <address of requestor>

You can add a password to an OKFILE.LST entry by adding an exclamation
point and then a password.  An example:

 F:\SECURE\*.* !MYPASS

Note that there are three different OKFILE.LST possibilities stored in
the BBS *bbs structure, corresponding to the three different inbound
directories and types of connects (listed and passworded, listed,
unlisted).


-=-
Format for messages exported as text:

XBBS builds the messages in a manner similar (but not identical) to
RFC-0822.  Header information is separated from the text body by a blank
line (CR/LF).  The text body is separated from the next header by a
blank line (CR/LF).  All header lines begin with a keyword.  "Blank"
lines in the text body are "folded" as <space><CR/LF>.  FTN "kludge"
lines are preserved as keyword/data combinations.  Note that all kludge
lines are moved into the header.

The filenames XBBS uses begin with the user's userid in hex 0-padded to
8 digits.  Text files are created as <userid-as-8-hex-digits>.TXT, then
archived.  Exporting is done in the background, and users are notified
when the export is complete.  Files are written into the ./XPORT
directory.


Messages exported as FTN type 2.2 packets are written to <userid>.PKT and
archived into <userid>.MO0.

OS/2 PKZip is currently the only archiver used.  It must be on your Path.


-=-

User attributes (attribs; there are 32 bit flags in this long):

#define U_ANSI            0x00000001
#define U_COLOR           0x00000002
#define U_HIGHASCII       0x00000004
#define U_NOMORE          0x00000008
#define U_NOCLEAR         0x00000010
#define U_COLD            0x00000020
#define U_NOSHOWADDRESS   0x00000040
#define U_NOSHOWPHONE     0x00000080
#define U_NOSHOWREAL      0x00000100
#define U_NOKILL          0x00000200
#define U_DELETED         0x00000400
#define U_EXPERT          0x00000800
#define U_TWIT            0x00001000
#define U_NEWFILES        0x00002000
#define U_NEWMSGS         0x00004000
#define U_DLNEWMSGS       0x00008000
#define U_DLNEWFILELIST   0x00010000
#define U_SEENEWS         0x00020000
#define U_ASKDL           0x00040000
#define U_NOVICE          0x00080000
#define U_NOROLL          0x00100000
#define U_POINTONLY       0x00200000
#define U_LOCKEDOUT       0x00400000
#define U_AVAILABLE       0x00800000
#define U_LISTPROTECTED   0x01000000
#define U_MISCNEWSOK      0x02000000
#define U_LIMITFLIST      0x04000000
#define U_EBCDIC          0x08000000


-=-
Format for .MNU files:

Prompt string,color,displayfilename,flags
Key,Command#,Output string,<data string>,color<,age,sec1,sec2,flags1,flags2>
...

Menu files must be in directory ./MENU.  In order for menu files to be
used instead of the default interface (Ijit mode), put a file in the
./MENU directory called MAIN.MNU (or MAIN#.MNU where # is the number of
the line that you want to use menu files).  Although menu files don't
have to end with .MNU, it's a strongly suggested convention.  XBBS will
check for a .GNU file of the same root name if the given filename
contains ".MNU" in it, allowing customized ANSI menus for ANSI color
users.  Specify a color of 0 to deactivate automagic coloring.

Current flags definitions:
 1 = Spit quote every time menu is displayed, based on set quote odds.
 2 = Spit quote once per menu entry, based on set quote odds (in other
     words, quote might not be output on initial menu display).

The prompt string, output string and data string fields are run through
an escape sequence interpreter that follows C conventions, so you can,
for example, add a cr/lf with \r\n.  They are also run through a
metacommand converter; see convert.c for now ([53] would expand to the
number of minutes left as an example).

Commands (max 80 per menu):
========
        Menu control
0.....goto another menu file (name of menu in data field)
1.....gosub to another menu file (name of menu in data field, 9 gosubs max)
      beware excessive recursion.
2.....return from a gosub
3.....clear all gosubs
4.....goto another menu w/ password (data = menuname;password)
5.....gosub another menu w/ password (data = menuname;password)
      beware excessive recursion.
6.....gosub a forced-return menu (returns after any command selected)
      beware excessive recursion.
7.....gosub an auto-execute menu (perform all commands then return)
      beware excessive recursion.
        Message reading
10-14
  ....read msgs in current msg area
15....export new msgs as text for download
16....export new msgs as FTN pkt for download
20-21
  ....globally scan msgs from current msg area up
        Displays
30....display user's status
31....display online users
32....list users
        Miscellaneous
33....allow user to edit his/her account
34....display a calendar
        Reading files
40....enter text file library
41....read text file paged (data = name of file)
42....read text file continuous (data = name of file;flags)
43....allow user to post a text file (data = directory for file;extension)
44....allow user to read any text file w/ paging (data = directory for files)
45....allow user to read any text file w/ pausing (data = directory for files)
46....allow user to read any text file no pausing (data = directory for files)
        Selecting/finding areas
50....select msg area
51....select file area
52....find msg area (name of area in data field)
53....find file area (name of area in data field)
54....find library area (name of area in data field)
55....next/prev msg area (1 or -1 in data field for direction)
56....next/prev file area (1 or -1 in data field for direction)
57....next/prev library area (1 or -1 in data field for direction)
        Listing files
60....list FILES.BBS for current file area (put "ALL" in datafield to
      list FILES.BBS in all areas.  Note this isn't necessary if you
      keep all files listed in FILES.BBS in default directory with areas
      after filenames.)
61....list directory for current file area
62....list directory for current file area, allow user to input mask
63....list directory (dir in datafield)
64....list directory (dir in datafield), allow user to input mask
65....find a particular file in any area, allow user to input mask
66....list FILES.BBS for current file area, prompt for search string
      (put "ALL" in datafield to list FILES.BBS in all areas)
67....list FILES.BBS (new files) for current area, prompt for search
      string (put "ALL" in datafield to list FILES.BBS in all areas)
68....list FILES.BBS (new files) for current area (put "ALL" in
      datafield to list FILES.BBS in all areas)
        Downloading
70....download files
71....download specific file(s) (files in datafield)
        Uploading
72....download specific file(s) contained in a file list.  datafield
      contains bitmapped flags integer:
       bit: meaning if set:
       ---  --------------
       1:   Don't do time verification
       2:   Don't do leech check
       4:   Silence
       8:   Never be silent
       16:  (reserved)
       32:  (reserved)
       64:  Don't return file's length (free file)
      on entry, FILESEND.### (where ### is the line number, 000 for
      local (a useless usage :-), 001 for line 1, etc.) should contain
      a list of pathnames, one per line, to send to the user.  on exit
      this file will still exist, and FILESENT.### will contain the
      names of any files successfully sent.
80....upload files
81....upload specific file(s) (data = files;path)
        Change user attribs directly
90....OR user's attribs w/ data field
91....AND user's attribs w/ data field
92....OR user's attribs2 w/ data field
93....AND user's attribs2 w/ data field
94....OR user's flags1 w/ data field
95....AND user's flags1 w/ data field
96....OR user's flags2 w/ data field
97....AND user's flags2 w/ data field
98....set user's last protocol to *data
99....set user's computer type to data (number from 1-65535)
        Miscellaneous revisited
100...adjust file areas
101...adjust msg areas
102...page sysop
103...read a topic from a help file (data = topic;helpfile)
104...set user's interface variable to number in data field
        Run another process
105...run a REXX script (data = name of script)
			XBBS passes the line number (cp) to the REXX script as the first
			argument. This line number must be the first argument to each XBBS
			function.

			XBBS adds the following functions to REXX:

        XBBSLOG(cp,flags,str,str,...)
          flags:  0  = output to log and listbox
                  1  = output to log only
                  2  = output to listbox only

        XBBSPRINT(cp,str,str,...)

				XBBSINPUT(cp[[[[[,minlen,maxlen,type,flags],prompt],
									help,helpfile],default])
					type:  see STRT_* constants in BBS.H (one only)
					flags: see STRF_* constants in BBS.H (may be ORd together)

				XBBSCLS(cp)

				XBBSTIMELEFT(cp[,secstoset])

				XBBSCONVERT(cp,str)

        XBBSCALL(cp,type,flags,str,str,...)
					type: 1 = separate synchronous session (same as menu type 108)
						flags (bitmapped):	1 = background
					type: 2 = run as stdin/stdout Door (same as menu type 109)
          type: 3 = run as stdin/stdout Door (same as menu type 107)
						flags:	unused

				XBBSSEND(cp,flags,path,files,files,...)
					flags (bitmapped):	1 	= no time verification
															2 	= no leech check
															4 	= silence
															8 	= never be silent
															16	= don't check all download paths
															64	= don't return file's length (free file)
					if path is blank, use current file area upload path

				XBBSRECV(cp,flags,path,area,files,files,...)
					flags (bitmapped):	1 	= no time verification
															4 	= silence
															8 	= never be silent
															16	= don't ask for description
															64	= don't return file's size (no credit upload)
															128 = accept as private file

				XBBSMENU(cp,flags,menuname)
					flags (bitmapped):	1 	= return after one command selected
															2 	= auto-execute each command in menu
          beware excessive recursion.

        XBBSREAD(cp,type,flags,startat,keys)
          type: 1 = read msgs in current area
            flags (bitmapped):  1 =
            startat = # of message at which to begin reading
            keys is unused
          type: 2 = globally read msgs
            flags (bitmapped):  1 =
            startat is unused
            keys is unused
          type: 3 = return # msgs in current area
            flags, startat and keys are unused
          type: 4 = return name of current msg area
            flags, startat and keys are unused
          type: 5 = return number of current msg area
            flags, startat and keys are unused
          type: 6 = set msg area # (return area #)
            startat = area # to set
            flags and keys are unused
            area # is unchanged if startat is invalid
          type: 7 = set msg area to name (return area name)
            keys = area name
            flags and startat are unused
            area name is unchanged if keys is invalid
          type: 8 = next msg area (return area name)
            flags, startat and keys are unused
          type: 9 = prev msg area (return area name)
            flags, startat and keys are unused
          type: 10 = type text file
            flags (bitmapped):  1 = pause if normal text file (no keys!)
                                2 = convert strings as displayed
                                4 = allow aborting (when flags & 1)
            startat = name of file
            keys = keys to stop and return if pressed
          type: 11 = page-read text file
            flags and startat are unused
            keys = name of file
          type: 12 = read new files
            flags (bitmapped):  anything non-zero invokes type 10 read
                                instead of type 11 read
                                2 =  disallow pause/abort if(!(flags (4 | 16)))
                                4 =  allow more? pausing
                                8 =  allow converting strings
                                16 = allow aborting w/ flags & 4
            keys = directory path
            startat is unused
          type: 13 = read any file
            flags (bitmapped):  1 = read as type 10 w/ pausing
                                2 = read as type 10 w/out pausing
            keys = directory path
            startat is unused
          type: 14 = filesize
            flags = say it (if non-zero)
            startat = filename
            keys = directory path
          type: 15 = list directory
            flags (bitmapped):  4 =  okay to ask to d/l
            keys = mask (user will be prompted if none)
            startat is unused
          type: 16 = find file
            flags (bitmapped):  32 = always allow listing of any area
            keys and startat are unused
          type: 17 = list file area
            flags (bitmapped):  1 = don't display non-matching
                                2 = don't drop through to directory list
                                4 = do directory list instead of files.bbs
                                8 = don't do common files.bbs
            startat = find string
            keys = directory path
          type: 18 = list all file areas
            flags (bitmapped):  1 = don't display non-matching
                                2 = don't drop through to directory list
                                4 = do directory list instead of files.bbs
                                8 = don't do common files.bbs
            startat = find string
            keys is unused
          type: 19 = return name of current file area
            flags, startat and keys are unused
          type: 20 = return number of current file area
            flags, startat and keys are unused
          type: 21 = set file area # (return area #)
            startat = area # to set
            flags and keys are unused
            area # is unchanged if startat is invalid
          type: 22 = set file area to name (return area name)
            keys = area name
            flags and startat are unused
            area name is unchanged if keys is invalid
          type: 23 = next file area (return area name)
            flags, startat and keys are unused
          type: 24 = prev file area (return area name)
            flags, startat and keys are unused
          type: 25 = return file area download path
            flags, startat and keys are unused
          type: 26 = return file area upload path
            flags, startat and keys are unused
          type: 27 = return name of current library area
            flags, startat and keys are unused
          type: 28 = return number of current library area
            flags, startat and keys are unused
          type: 29 = set library area # (return area #)
            startat = area # to set
            flags and keys are unused
            area # is unchanged if startat is invalid
          type: 30 = set library area to name (return area name)
            keys = area name
            flags and startat are unused
            area name is unchanged if keys is invalid
          type: 31 = next library area (return area name)
            flags, startat and keys are unused
          type: 32 = prev library area (return area name)
            flags, startat and keys are unused
          type: 33 = return library area path
            flags, startat and keys are unused

        XBBSWRITE(cp,type,flags,fname)
          type: 1 = write message
            flags (bitmapped):  1 = force to force-to-name
                                2 = force private
                                4 = force public
                                8 = use existing MSGTMP.# file
            fname is unused
          type: 2 = edit file using internal line editor
            flags are unused
            fname = name of file to edit

107...run an OS/2 Door (as for 109, better for some 'dumb' programs)
      note:  you can run CMD.EXE with this, but beware running a DOS
             program from there without START!  Lockups will happen!
             Probably better to use a simple REXX script to filter out
             dangerous commands (like CD, D:, MEM (a DOS prg), etc.).
108...run a separate 'synchronous' session (deactivate/reactivate commport)
109...run an OS/2 Door (must use stdin/stdout, allow itself to be killed).
      see sample TYPE109.C source.
110...spawn synchronous process (leave commport active)
111...spawn asynchronous process, no wait (leave commport active)
112...spawn asynchronous process, wait (leave commport active)
113...spawn traceable process (don't use) (leave commport active)
114...spawn asynchronous detached process (orphan) (leave commport active)
115...spawn frozen process (don't use) (leave commport active)
116...spawn synchronous process (deactivate/reactivate commport)
117...spawn asynchronous process, no wait (deactivate/reactivate commport)
118...spawn asynchronous process, wait (deactivate/reactivate commport)
119...spawn traceable process (don't use) (deactivate/reactivate commport)
120...spawn asynchronous detached process (orphan) (deactiv./reactiv. commport)
121...spawn frozen process (don't use) (deactivate/reactivate commport)
        Start new session
122...start new session, foreground (leave comm active)
123...start new session, background (leave comm active)
124...
125...
126...start new session, foreground (deac/reac comm)
127...start new session, background (deac/reac comm)
128...
129...
    (note:  deac/reac comm and leave comm active are currently meaningless
     but might make some anal-retentive types feel more comfortable.)
        User self-editing
130...change address
131...change color
132...change high ASCII
133...change input
134...change length
135...change more?
136...change handle
137...change password
138...change width
139...change phone
140...change interests
141...change show address, phone #, real name
142...change expert mode
143...change rolling prompts mode
144...change ANSI
145...change miscellaneous
146...change protocol (note: some xmodem receivers choke on sealink)
147...change new message scan
148...change new file scan
149...change limit filelists to current area
150...change see misc. news
151...change ask to dl at file lists
152...change user available
153...change EBCDIC required
        Toggle user attribs and flags
160...toggle a bit in user attribs (data = bit #, 1 - 32)
161...toggle a bit in user attribs2 (data = bit #, 1 - 32)
162...toggle a bit in user flags1 (data = bit #, 1 - 32)
163...toggle a bit in user flags2 (data = bit #, 1 - 32)
        Message writing
200...write a message
201...write forced message
        Logoff
        String input
300...get simple user input into "last input" string (prompt in datafield)
301...copy "last input" string to user var (var # in datafield)
302...copy user var to "last input" string (var # in datafield)
        Logoff
999...log off, allow goodbye msg to sysop
1000..log off, no goodbye msg
1001..quick logoff
        NOP
32767.no operation

Example menu:

================cut here=================
\r\n  ([53] mins) Test Menu: ,12
Q,999,Quit(LOGOFF)       ,,13
S,30,Status report      ,,13
R,10,Read msgs\r\n,,13
G,20,Global read msgs   ,,13
C,34,Calendars          ,,13
M,50,Message area change\r\n,,13
L,32,List users         ,,13
T,40,Text file library  ,,13
F,51,File area change\r\n,,13
================cut here=================


-=-
Format for help files:

Help files are stored in the ./HELP directory.  XBBS' default help file
is called XBBS.HLP.  You may have several help files with different
names.  .MNU files have their own help files titled <rootname>.HLP and
display topic <rootname> when the help key is pressed.  For example,
MAIN.MNU's help file is ./HELP/MAIN.HLP, and topic MAIN is displayed
when the user requests help.  You can use related topics from there
to explain each command in depth.

Help files contain two types of special lines:  topic lines and action
lines.  Topic lines begin with ">>", action lines begin with "..".

Here's a brief sample:

================cut here=================
>>A Topic

Here's some help text for Joe User.

..pause
..related Another Topic
..comment Just a comment, never seen


>>Another Topic

Some more help text for good ol' Joe.
================cut here=================

Topics can be up to 80 characters long.  Action lines can be up to 128
characters in length.

Actions:
=======
comment......following text is ignored in all cases
pause........user must press [Enter] to continue
related......topic following is related to current topic
newtopic.....switches to topic following
abort........stops display of help
sleep........pauses following number of milliseconds (..sleep 1000 sleeps
             1 second)
yesorabort...displays following text with "(Y/n)" as prompt, pauses for
             input, stops display of help if "Y" or [Enter] not received
yesorstop....as yesorabort, except an answer other than "Y" or [Enter]
             ends only the current topic; related topics can be selected
display......reads following file to user



Keyboard interaction with the main window:
=========================================

Special keys:
  TAB             toggle active child window
  CTRL-SPACE      activate main pulldown menu
  SHIFT-SPACE     toggle frame controls on active child window


Keyboard interaction with the BBS window:
========================================

Special keys:
  F1-F10              display text files FUNKEY01.ASC - FUNKEY10.ASC
  SHIFT-F1-SHIFT-F10  display text files FUNKEY11.ASC - FUNKEY20.ASC
                      hang up after showing file
  CTRL-F1-CTRL-F10    display text files FUNKEY21.ASC - FUNKEY30.ASC
                      lock out user and hang up after showing file


Standard command files used by XBBS:
===================================

BBSRUN.CMD      locate in PATH, used to run completely disconnected
                processes (allowing you to set their current drive and
                directory to your BBS drive/directory).
READARC.CMD     locate in BBS directory, used to run archivers for
                viewing archive contents.
EXTRACT.CMD     locate in BBS directory, used to run archivers for
                viewing an archive member.
LISTLOG.CMD     locate in BBS directory, used to read log file.
PROCLOG.CMD     locate in BBS directory, used to process log file.
EVNTEDIT.CMD    locate in BBS directory, no use unless you think of one.



Command line arguments (optional):
=================================
XBBS <#linestocrankup> <#linestoskip>

Default is the same as XBBS 1 0
To kick up one line on COM2, XBBS 2 1



Other utilties:
===============

MSGEDIT     Edit MSGAREAS.BB2 file                                  PM*
FILEDIT     Edit FILEAREA.BB2 file                                  PM*
LIBEDIT     Edit LIBAREA.BB2 file                                   PM*
XUSERPM     Edit USERS.BB2 file                                     PM*
XSENDPM     Attach files to remote systems                          PM
GS          Send/get/poll (command line)                            FS/WIN
HEAD2       HeadEdit-OS/2                                           FS/WIN
LISTDIRS    Lists all directories on a CD suitable for OKFILE       FS/WIN
XGROUP      Import/export Fidonet type 2 mail                       FS/WIN
XMSG        Message base maintenance                                FS/WIN
MAKECFG     Create text config files from current configs           FS/WIN
MAKEFLST    Create "all files" lists                                FS/WIN

* Thanks to Mike Berry for the excellent XBBS-OS/2 PM file editors and
  other work and testing.  See those archives for license details for
  those programs.
