#define INCL_WIN
#define INCL_AVIO

#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "keys.h"
#include "xbbs.h"
#include "modem.h"

typedef struct {
  USHORT size;
  USHORT cp;
  HWND   hwnd;
  HVPS   hvps;
  HDC    hdc;
  HPS    hps;
  USHORT usVideoLength;
  ULONG  ulVideoBuffer;
  int    waitingtoread;
} VIOWINDATA;

  extern HAB   hab;
  extern MDM  *modems[MAXINSTANCES];
  extern USER *user[MAXINSTANCES];
  extern long  userread[MAXINSTANCES];
  extern HWND  xdhwnd;
  extern int   focusline;
  extern BBS  *bbs;


MRESULT EXPENTRY BbsFrameProc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  PFNWP oldproc;

  if(msg != WM_SETCP)
    oldproc = (PFNWP)WinQueryWindowPtr(ClientOf(hwnd),4);
  else
    oldproc = NULL;

  switch(msg) {
    case WM_SETCP:
      oldproc = (PFNWP)mp1;
      WinSetWindowPtr(ClientOf(hwnd),4,(PVOID)oldproc);
      return 0;

    case WM_ADJUSTWINDOWPOS:
      if (((PSWP)mp1)->fs & SWP_RESTORE) {
        WinSetParent(hwnd,HWND_DESKTOP,TRUE);
        WinSetOwner(hwnd,HWND_DESKTOP);
        WinShowWindow(ClientOf(hwnd),TRUE);
        WinShowWindow(WinWindowFromID(hwnd,BBM_USERNAME),TRUE);
        WinShowWindow(WinWindowFromID(hwnd,BBM_USERTIME),TRUE);
        WinShowWindow(WinWindowFromID(hwnd,BBM_MESSAGE),TRUE);
        WinPostMsg(ClientOf(hwnd),WM_SIZEME,MPVOID,MPVOID);
      }
      else if (((PSWP)mp1)->fs & SWP_MINIMIZE) {
        WinSetParent(hwnd,xdhwnd,TRUE);
        WinSetOwner(hwnd,xdhwnd);
        WinShowWindow(ClientOf(hwnd),FALSE);
        WinShowWindow(WinWindowFromID(hwnd,BBM_USERNAME),FALSE);
        WinShowWindow(WinWindowFromID(hwnd,BBM_USERTIME),FALSE);
        WinShowWindow(WinWindowFromID(hwnd,BBM_MESSAGE),FALSE);
      }
      break;
  }

  if(oldproc)
    return oldproc(hwnd,msg,mp1,mp2);
  else
    return 0;
}


MRESULT EXPENTRY bbsclientproc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  VIOWINDATA *vd;
  static int  cxConstant = 0,cyConstant = 0;
  static long lSmallHt, lSmallWd, lLargeHt, lLargeWd;

  if(msg != WM_CREATE)
    vd = WinQueryWindowPtr(hwnd,0);

  switch(msg) {
    case WM_CREATE:
      vd = malloc(sizeof(VIOWINDATA));
      WinSetWindowPtr(hwnd,0,(PVOID)vd);
      if(!vd) {
        WinDestroyWindow(ParentOf(hwnd));
        break;
      }
      memset(vd,0,sizeof(VIOWINDATA));
      vd->size = sizeof(VIOWINDATA);
      break;

    case WM_SETCP:
      {
        HWND focushwnd;

        vd->cp = SHORT1FROMMP(mp1);
        vd->hwnd = hwnd;
        vd->hdc = WinOpenWindowDC(hwnd);
        {
          SIZEL sizl;

          sizl.cx = sizl.cy = 0;
          vd->hps = GpiCreatePS(hab,vd->hdc,&sizl,PU_PELS | GPIF_DEFAULT |
                                GPIT_MICRO | GPIA_ASSOC);
        }
        VioCreatePS(&vd->hvps,25,80,0,1,0);
        VioAssociate(vd->hdc,vd->hvps);
        if(!cyConstant) {
          cxConstant = (int)Value(SV_CXBORDER) * 2;
          cyConstant = (int)(Value(SV_CYTITLEBAR) + Value(SV_CYMENU) +
                            (Value(SV_CYBORDER) * 4));
          DevQueryCaps(vd->hdc, CAPS_CHAR_HEIGHT,       1L, &lLargeHt);
          DevQueryCaps(vd->hdc, CAPS_CHAR_WIDTH,        1L, &lLargeWd);
          DevQueryCaps(vd->hdc, CAPS_SMALL_CHAR_HEIGHT, 1L, &lSmallHt);
          DevQueryCaps(vd->hdc, CAPS_SMALL_CHAR_WIDTH,  1L, &lSmallWd);
        }
        VioSetDeviceCellSize((bbs->attribs2 & B2_SMALLFONT) ?
                             lSmallHt : lLargeHt,
                             (bbs->attribs2 & B2_SMALLFONT) ?
                             lSmallWd : lLargeWd,vd->hvps);
        VioGetBuf(&vd->ulVideoBuffer,&vd->usVideoLength,vd->hvps);
        if(!modems[vd->cp])
          DosSleep(100L);
        modems[vd->cp]->VidHandle = vd->hvps;
        {
          USHORT cyChar,cxChar,cxFrame,cyFrame;
          USHORT cyStart,cxStart;
          SWP    swp;
          ULONG  size;
          char   s[41];

          VioGetDeviceCellSize(&cyChar,&cxChar,vd->hvps);
          cxFrame  = (80 * cxChar) + (SHORT) cxConstant;
          cyFrame  = ((25 * cyChar) + (SHORT) cyConstant) + 17;
          cxStart = cyStart = 8 + (8 * vd->cp);
          sprintf(s,"BBSSizepos%03d",vd->cp);
          size = sizeof(SWP);
          if(PrfQueryProfileData(HINI_USERPROFILE,"XBBS",s,
             &swp,&size) == TRUE) {
            cxStart = swp.x;
            cyStart = swp.y;
          }
          if(cyStart + cyFrame > Value(SV_CYSCREEN))
            cyStart = Value(SV_CYSCREEN) - cyFrame;
          WinSetWindowPos(ParentOf(hwnd),
                          (vd->cp) ? WinQueryWindow(xdhwnd,QW_PARENT,0) :
                          HWND_TOP,cxStart,cyStart,
                          cxFrame,cyFrame,
                          (vd->cp) ? SWP_SIZE | SWP_MOVE | SWP_ZORDER :
                          SWP_ZORDER | SWP_ACTIVATE | SWP_SIZE | SWP_MOVE);
          WinSetWindowPos(hwnd,HWND_TOP,0,0,cxFrame - (SHORT)cxConstant,
                          (cyFrame - (SHORT)cyConstant) - 17,
                          SWP_SIZE);
          WinSetActiveWindow(HWND_DESKTOP,focushwnd);
          WinCreateWindow(ParentOf(hwnd),WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                          DT_LEFT | DT_VCENTER,
                          0,(cyFrame - cyConstant) - 16,38 * cxChar,
                          17,hwnd,HWND_TOP,BBM_USERNAME,NULL,NULL);
          WinSetPresParam(WinWindowFromID(ParentOf(hwnd),BBM_USERNAME),
                          PP_FONTNAMESIZE,
                          (ULONG)strlen("8.Helv") + 1L,
                          (PVOID)"8.Helv");
          WinCreateWindow(ParentOf(hwnd),WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                          DT_LEFT | DT_VCENTER,
                          38 * cxChar,(cyFrame - cyConstant) - 16,
                          8 * cxChar,17,hwnd,HWND_TOP,
                          BBM_USERTIME,NULL,NULL);
          WinSetPresParam(WinWindowFromID(ParentOf(hwnd),BBM_USERTIME),
                          PP_FONTNAMESIZE,
                          (ULONG)strlen("8.Helv") + 1L,
                          (PVOID)"8.Helv");
          WinCreateWindow(ParentOf(hwnd),WC_STATIC,(PSZ)NULL,WS_VISIBLE | SS_TEXT |
                          DT_LEFT | DT_VCENTER,
                          46 * cxChar,(cyFrame - cyConstant) - 16,
                          34 * cxChar,17,hwnd,HWND_TOP,
                          BBM_MESSAGE,NULL,NULL);
          WinSetPresParam(WinWindowFromID(ParentOf(hwnd),BBM_MESSAGE),
                          PP_FONTNAMESIZE,
                          (ULONG)strlen("8.Helv") + 1L,
                          (PVOID)"8.Helv");
        }
        VioSetOrg(0,0,vd->hvps);
        SetScreensize(vd->cp,0);
      }
      DosEnterCritSec();
       if(user[vd->cp]) {
         WinStartTimer(hab,hwnd,ID_TIMERS + vd->cp,15000L);
         DosExitCritSec();
       }
      else
        DosExitCritSec();
      return 0;

    case WM_TIMER:
      if(vd && SHORT1FROMMP(mp1) == ID_TIMERS + vd->cp) {
        DosEnterCritSec();
         if(user[vd->cp] && modems[vd->cp] && !modems[vd->cp]->inchat) {

           char   s[41];
           time_t t;

           t = time(NULL);
           sprintf(s,"%ld:%02ld",(user[vd->cp]->offline - t) / 60L,
                   (user[vd->cp]->offline - t) % 60L);
           DosExitCritSec();
           WinSetDlgItemText(ParentOf(hwnd),BBM_USERTIME,s);
         }
         else
           DosExitCritSec();
      }
      break;

    case WM_LASTUSERNAME:
      if((char *)mp2)
        WinSetDlgItemText(ParentOf(hwnd),BBM_USERNAME,(char *)mp2);
      return 0;

    case WM_CHAR:
      if(vd) {
        if(!(SHORT1FROMMP(mp1) & KC_KEYUP)) {
          if(SHORT1FROMMP(mp1) & KC_CHAR)
            put_key(vd->cp,SHORT1FROMMP(mp2));
          else if(SHORT1FROMMP(mp1) & KC_VIRTUALKEY) {

            int key = 0;

            switch(SHORT2FROMMP(mp2)) {
              case VK_LEFT:
                key = LEFT;
                if(SHORT1FROMMP(mp1) & KC_CTRL)
                  key = CTRL_LEFT;
                break;
              case VK_RIGHT:
                key = RIGHT;
                if(SHORT1FROMMP(mp1) & KC_CTRL)
                  key = CTRL_RIGHT;
                break;
              case VK_UP:
                key = UP;
                if(SHORT1FROMMP(mp1) & KC_CTRL)
                  key = CTRL_UP;
                break;
              case VK_DOWN:
                key = DN;
                if(SHORT1FROMMP(mp1) & KC_CTRL)
                  key = CTRL_DN;
                break;
              case VK_HOME:
                key = HOME;
                if(SHORT1FROMMP(mp1) & KC_CTRL)
                  key = CTRL_HOME;
                break;
              case VK_END:
                key = END;
                if(SHORT1FROMMP(mp1) & KC_CTRL)
                  key = CTRL_END;
                break;
              case VK_INSERT:
                key = INS;
                break;
              case VK_DELETE:
                key = DEL;
                break;
              default:
                break;
            }
            if(key)
              put_key(vd->cp,key);
          }
          else if(SHORT1FROMMP(mp1) & KC_CTRL)
             put_key(vd->cp,SHORT1FROMMP(mp2) & 0x1f);
        }
      }
      break;

    case WM_PRINTME:
      if((char *)mp2)
        ANSIPuts(vd->cp,(char *)mp2);
      return 0;

    case WM_BBSMESSAGE:
      if((char *)mp2)
        WinSetWindowText(WinWindowFromID(ParentOf(hwnd),BBM_MESSAGE),
                         (char *)mp2);
      return 0;

    case WM_SIZE:
      WinDefAVioWindowProc(hwnd,msg,mp1,mp2);
      break;

    case WM_SIZEME:
      {
        USHORT cyChar,cxChar,cxFrame,cyFrame;
        SWP    swp;

        VioGetDeviceCellSize(&cyChar,&cxChar,vd->hvps);
        cxFrame  = (80 * cxChar) + (SHORT) cxConstant;
        cyFrame  = (25 * cyChar) + (SHORT) cyConstant + 17;
        WinQueryWindowPos(ParentOf(hwnd),&swp);
        if(swp.y + cyFrame > Value(SV_CYSCREEN))
          swp.y = Value(SV_CYSCREEN) - cyFrame;
        WinSetWindowPos(ParentOf(hwnd),
                        (vd->cp) ? WinQueryWindow(xdhwnd,QW_PARENT,0) :
                        HWND_TOP,swp.x,swp.y,cxFrame,cyFrame,
                        SWP_SIZE | SWP_MOVE);
        WinSetWindowPos(hwnd,HWND_TOP,0,0,cxFrame - (SHORT)cxConstant,
                        (cyFrame - (SHORT)cyConstant) - 17,
                        SWP_SIZE);
        WinSetWindowPos(WinWindowFromID(ParentOf(hwnd),BBM_USERNAME),
                        HWND_TOP,
                        0,(cyFrame - cyConstant) - 16,
                        cxChar * 38,17,SWP_SIZE | SWP_MOVE);
        WinSetWindowPos(WinWindowFromID(ParentOf(hwnd),BBM_USERTIME),
                        HWND_TOP,
                        cxChar * 38,(cyFrame - cyConstant) - 16,
                        cxChar * 8,17, SWP_SIZE | SWP_MOVE);
        WinSetWindowPos(WinWindowFromID(ParentOf(hwnd),BBM_MESSAGE),
                        HWND_TOP,
                        cxChar * 46,(cyFrame - cyConstant) - 16,
                        cxChar * 34,17, SWP_SIZE | SWP_MOVE);
      }
      VioSetOrg(0,0,vd->hvps);
      WinInvalidateRect(hwnd,NULL,TRUE);
      return 0;

    case WM_PAINT:
      {
        RECTL rcl;
        char  color;
        int   paintcolor;

        WinBeginPaint(hwnd,vd->hps,NULL);
        WinQueryWindowRect(hwnd,&rcl);
        rcl.yBottom += 16;
        paintcolor = CLR_BLACK;
        if(vd && modems[vd->cp] && modems[vd->cp]->VidHandle != -1) {
          color = GetAttr(vd->cp);
          switch((color >> 4) & 7) {
            case 1:
              paintcolor = CLR_BLUE;
              break;
            case 2:
              paintcolor = CLR_GREEN;
              break;
            case 3:
              paintcolor = CLR_CYAN;
              break;
            case 4:
              paintcolor = CLR_RED;
              break;
            case 5:
              paintcolor = CLR_PINK;
              break;
            case 6:
              paintcolor = CLR_BROWN;
              break;
            case 7:
              paintcolor = CLR_NEUTRAL;
              break;
          }
        }
        WinFillRect(vd->hps,&rcl,paintcolor);
        VioShowBuf(0,vd->usVideoLength,vd->hvps);
        {
          int x,y;

          GetXY(vd->cp,&x,&y);
          VioSetCurPos(y,x,vd->hvps);
        }
        WinEndPaint(vd->hps);
      }
      break;

    case WM_COMMAND:
      if(SHORT1FROMMP(mp1) < BBM_TOGGLEFONT)
        WinPostMsg(xdhwnd,msg,mp1,MPFROM2SHORT(vd->cp,0));
      else {
        switch(SHORT1FROMMP(mp1)) {
          case BBM_TOGGLEFONT:
            if(bbs->attribs2 & B2_SMALLFONT)
              bbs->attribs2 &= (~B2_SMALLFONT);
            else
              bbs->attribs2 |= B2_SMALLFONT;
            VioSetDeviceCellSize((bbs->attribs2 & B2_SMALLFONT) ?
                                 lSmallHt : lLargeHt,
                                 (bbs->attribs2 & B2_SMALLFONT) ?
                                 lSmallWd : lLargeWd,vd->hvps);
            WinSendMsg(hwnd,WM_SIZEME,MPVOID,MPVOID);
            break;

          case BBM_SAVEPOS:
            {
              SWP  swp;
              char s[41];

              WinQueryWindowPos(ParentOf(hwnd),&swp);
              sprintf(s,"BBSSizepos%03d",vd->cp);
              PrfWriteProfileData(HINI_USERPROFILE,"XBBS",s,
                                  &swp,(ULONG)sizeof(SWP));
            }
            break;

          case BBM_HELP:
            break;

          default:
            if(vd && SHORT1FROMMP(mp1) > BBM_F1 - 1 &&
               SHORT1FROMMP(mp1) < BBM_CF10 + 1) {
              if(vd->waitingtoread && SHORT1FROMMP(mp2))
                break;
              if(SHORT1FROMMP(mp2) &&
                 !(userread[vd->cp] & (1 << (SHORT1FROMMP(mp1) - BBM_F1)))) {
                vd->waitingtoread = 1;
                userread[vd->cp] |= (1 << (SHORT1FROMMP(mp1) - BBM_F1));
              }
              else {
                vd->waitingtoread = 0;
                if(SHORT1FROMMP(mp1) > BBM_F10 &&
                   SHORT1FROMMP(mp1) < BBM_CF1) {
                  if(modems[vd->cp] && modems[vd->cp]->curbaud)
                    flushout(vd->cp);
                  DosSleep(1000L);
                  WinPostMsg(xdhwnd,WM_COMMAND,MPFROM2SHORT(IDM_HANGUP,0),
                             MPFROMLONG(0L));
                }
                else if(SHORT1FROMMP(mp1) > BBM_SF10) {
                  if(modems[vd->cp] && modems[vd->cp]->curbaud)
                    flushout(vd->cp);
                  DosSleep(1000L);
                  WinPostMsg(xdhwnd,WM_COMMAND,MPFROM2SHORT(IDM_LOCKOUT,0),
                             MPFROMLONG(0L));
                }
              }
            }
            break;
        }
      }
      return 0;

    case WM_CLOSE:
      WinSendMsg(ParentOf(hwnd),WM_SYSCOMMAND,
                 MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
      return 0;

    case WM_DESTROY:
      if(vd) {
        WinStopTimer(hab,hwnd,ID_TIMERS + vd->cp);
        DosSleep(128L);
        VioAssociate(NULL,vd->hvps);
        VioDestroyPS(vd->hvps);
        GpiDestroyPS(vd->hps);
        if(modems[vd->cp])
          modems[vd->cp]->VidHandle = -1;
        free(vd);
      }
      return 0;
  }
  return WinDefWindowProc(hwnd,msg,mp1,mp2);
}
