#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "bitfuncs.h"
#include "xmisc.h"

#pragma optimize("",off)

    extern MDM       *modems[MAXINSTANCES];
    extern USER      *user[MAXINSTANCES];
    extern MSGAREA   *msgareas;
    extern FILEAREA  *fileareas;
    extern BBS       *bbs;




void _fastcall adjust_msgareas (int mode,USHORT cp) {

    /* Set up msg areas */
    /* NOTE:  user[cp]->bbsmsg flags are used by system when determining if
       user has access to a given area.  user[cp]->usermsg flags are used
       to save a "permanent" record of what the user's preferences are.
       bbs->bbsmsg flags are used to determine what can be turned on. */

    #define NUMSELECTS 8

    char         prompt[54],color[13];
    int          com,changed = 0;
    MSGAREA      *info;


    *prompt = 0;
    dputs(mode,cp,"\r\n");

    do {
        if(!clear_toplines(mode,cp,2)) dputs(mode,cp,"\r\n");
        com = pselect_one(mode,cp,203,NUMSELECTS,204,NULL,"Setup Msg",set_iflg(cp));
        com++;

        switch(com) {
            case 1: {   /* List areas */

                if(!clear_toplines(mode,cp,2)) dputs(mode,cp,"\r\n");
                com = pselect_one(mode,cp,205,3,206,NULL,"List MsgAreas",set_iflg(cp));
                com++;
                switch(com) {
                    case 1:     /* Current Areas */
                        list_msgareas(mode,cp);
                        break;

                    case 2: {    /* Off Areas */
                                int    count = 0,lines = 0;
                                USHORT nomess;

                                info = msgareas;
                                while(info) {
                                    if(!IsBit(user[cp]->bbsmsg,info->number - 1)) {
                                        if(find_any_msgarea(mode,cp,info->name)) {
                                            count++;
                                            lines++;
                                            nomess = how_many_msgs(info);
                                            if(
                                            dprintf(mode,cp,"\r\n%-5u %0.51s (%u",
                                                    info->number,info->name,
                                                    nomess)
                                            );
                                            sayp(mode,cp,224,NULL,0);
                                            if(info->descr) {
                                                dprintf(mode,cp,"\r\n %0.78s",
                                                        info->descr);
                                                lines++;
                                            }
                                            info = info->next;
                                            if(info) {
                                                if(lines >= user[cp]->length - 2) {
                                                    dputs(mode,cp,"\r\n");
                                                    if(do_more(mode,cp)) break;
                                                    lines = 0;
                                                }
                                            }
                                        }
                                        else info = info->next;
                                    }
                                    else info = info->next;
                                    if(checkcarrier(cp)) break;
                                }
                            }
                            break;

                    case 3: {           /* all areas */
                                int    count = 0,lines = 0;
                                USHORT nomess;
                                char   offoron;

                                info = msgareas;
                                while(info) {
                                    if(find_any_msgarea(mode,cp,info->name)) {
                                        if(!IsBit(user[cp]->bbsmsg,info->number - 1)) {
                                            offoron = '-';
                                        }
                                        else offoron = '+';
                                        count++;
                                        lines++;
                                        nomess = how_many_msgs(info);
                                        if(
                                        dprintf(mode,cp,"\r\n%c%-5u %0.51s (%u",
                                                offoron,info->number,info->name,
                                                nomess)
                                        );
                                        sayp(mode,cp,224,NULL,0);
                                        if(info->descr) {
                                            dprintf(mode,cp,"\r\n %0.78s",
                                                    info->descr);
                                            lines++;
                                        }
                                        info = info->next;
                                        if(info) {
                                            if(lines >= user[cp]->length - 2) {
                                                dputs(mode,cp,"\r\n");
                                                if(do_more(mode,cp)) break;
                                                lines = 0;
                                            }
                                        }
                                    }
                                    else info = info->next;
                                    if(checkcarrier(cp)) break;
                                }
                            }
                            break;

                    case 0:
                    default:
                        break;
                }
                break;
            }

            case 2:     /* Inquire area */
                inquire_msgarea(mode,cp);
                break;

            case 0:
            case NUMSELECTS:     /* Quit */
                if(changed) {
                    sayp(mode,cp,207,NULL,0);
                    DosSleep(1500L);
                }
                com = 0;
                break;

            case 3:     /* Permanent */
                memcpy(user[cp]->usermsg,user[cp]->bbsmsg,64);
                sayp(mode,cp,208,NULL,0);
                changed = 0;
                break;

            case 4:     /* Toggle Area */
                info = get_any_msgarea(mode,cp);
                if(info) {
                    if(IsBit(user[cp]->bbsmsg,info->number - 1)) {
                        BitOff(user[cp]->bbsmsg,info->number - 1);
                        sayp(mode,cp,209,NULL,0);
                    }
                    else {
                        BitOn(user[cp]->bbsmsg,info->number - 1);
                        sayp(mode,cp,210,NULL,0);
                    }
                    changed = 1;
                }
                else {
                    sayp(mode,cp,211,NULL,0);
                }
                break;

            case 6: {     /* All Areas */

                        if(!clear_toplines(mode,cp,2)) dputs(mode,cp,"\r\n");
                        com = pselect_one(mode,cp,212,2,213,NULL,"All MsgAreas",set_iflg(cp));
                        com++;
                        switch(com) {
                            case 1:
                                memcpy(user[cp]->bbsmsg,bbs->msgflags,64);
                                sayp(mode,cp,214,NULL,0);
                                changed = 1;
                                break;

                            case 2:
                                memset(user[cp]->bbsmsg,0,64);
                                sayp(mode,cp,215,NULL,0);
                                changed = 1;
                                break;

                            default:
                                sayp(mode,cp,216,NULL,0);
                                break;
                        }
                    }
                    break;

            case 7:     /* Prompt */
                info = next_msg_area(msgareas,cp,0);
                while(info) {

                    char input[2];

                    dprintf(mode,cp,"\r\n#%u: %s",info->number,info->name);
                    strset(input,0);
                    pinput_string(mode,cp,input,1,1,221,
                                 STRT_YNQ,STRF_UCASE | STRF_HOT,
                                 "MsgSetup Prompted",NULL);
                    if(*input == modems[cp]->NO) {
                        BitOff(user[cp]->bbsmsg,info->number - 1);
                        changed = 1;
                    }
                    else if(*input == modems[cp]->QUIT) {
                        break;
                    }
                    info = next_msg_area(info,cp,1);
                }
                dputs(mode,cp,"\r\n");
                break;

            case 5: {    /* Range */
                        char    input[49];
                        MSGAREA *hi,*lo;

                        strset(input,0);
                        pinput_string(mode,cp,input,48,1,219,
                                     STRT_ALL,STRF_NEAT,
                                     "MsgSetup Lorange",NULL);
                        if(!*input) break;
                        lo = find_any_msgarea(mode,cp,input);
                        if(!lo) break;
                        strset(input,0);
                        pinput_string(mode,cp,input,48,1,220,
                                     STRT_ALL,STRF_NEAT,
                                     "MsgSetup Hirange",NULL);
                        if(!*input) break;
                        hi = find_any_msgarea(mode,cp,input);
                        if(!hi) break;

                        if(lo->number > hi->number) {
                            info = hi;
                            hi = lo;
                            lo = info;
                        }

                        if(!clear_toplines(mode,cp,2)) dputs(mode,cp,"\r\n");
                        com = pselect_one(mode,cp,217,3,218,NULL,"MsgSetup RangePick",set_iflg(cp));
                        com++;
                        switch(com) {
                            case 1: info = lo;
                                    while(info && info->number <= hi->number && info->number >= lo->number) {
                                        BitOn(user[cp]->bbsmsg,info->number - 1);
                                        changed = 1;
                                        do {
                                            info = info->next;
                                        } while(info && !find_any_msgarea(mode,cp,info->name));
                                    }

                            case 2: info = lo;
                                    while(info && info->number <= hi->number && info->number >= lo->number) {
                                        BitOff(user[cp]->bbsmsg,info->number - 1);
                                        changed = 1;
                                        do {
                                            info = info->next;
                                        } while(info && !find_any_msgarea(mode,cp,info->name));
                                    }

                            case 3: info = lo;
                                    while(info && info->number <= hi->number && info->number >= lo->number) {
                                        if(IsBit(user[cp]->bbsmsg,info->number - 1)) {
                                            BitOff(user[cp]->bbsmsg,info->number - 1);
                                        }
                                        else {
                                            BitOn(user[cp]->bbsmsg,info->number - 1);
                                        }
                                        changed = 1;
                                        do {
                                            info = info->next;
                                        } while(info && !find_any_msgarea(mode,cp,info->name));
                                    }

                            default: break;
                        }
                    }
                    break;

            default:    sayp(mode,cp,94,NULL,0);
                        DosSleep(2000L);
                        break;
        }

        dputs(mode,cp,"\r\n");

        if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
            break;
        }

    } while(com);
}





MSGAREA * _fastcall get_any_msgarea (int mode,USHORT cp) {

    char temp[65];


    strset(temp,0);
    pinput_string(mode,cp,temp,64,1,222,
                 STRT_ALL,STRF_NEAT,"MsgArea Inquire",NULL);
    rstrip(temp);
    if(!*temp) {
        return NULL;
    }

    return find_any_msgarea(mode,cp,temp);
}




MSGAREA * _fastcall find_any_msgarea (int mode,USHORT cp,char *name) {

    MSGAREA      *info;
    unsigned int x;


    x = atoi(name);

    info = msgareas;
    while(info) {
        if(x == info->number || !stricmp(name,info->name)) {
            if(!IsBit(bbs->bbsmsg,info->number - 1)) return NULL;
            if(info->r_security1 > user[cp]->security1) return NULL;
            if(info->r_security2 > user[cp]->security2) return NULL;
            if(info->r_flags1 & (~user[cp]->flags1)) return NULL;
            if(info->r_flags2 & (~user[cp]->flags2)) return NULL;
            if(info->age) {
                if(info->age < 0) {
                    if(user[cp]->age > abs(info->age)) return NULL;
                }
                else {
                    if(user[cp]->age < info->age) return NULL;
                }
            }
            if((info->areaflags & M_ANSI) && !(user[cp]->attribs & U_COLOR))
              return NULL;
            break;
        }
        info = info->next;
    }

    return info;
}




MSGAREA * _fastcall inquire_msgarea (int mode,USHORT cp) {

    MSGAREA      *info;
    unsigned int x;


    info = get_any_msgarea(mode,cp);
    if(info) {
        dprintf(mode,cp,"\r\n#%u:  \"%s\"\r\n",info->number,info->name);
        dprintf(mode,cp," %s",info->descr);
        x = how_many_msgs(info);
        dprintf(mode,cp,"\r\n%u\r\n",x);
        sayp(mode,cp,224,NULL,0);
        dputs(mode,cp,"\r\n");
    }
    else {
        sayp(mode,cp,223,NULL,0);
    }

    return info;
}

#pragma optimize("",on)

