/*
 * this code lifted sorta sideways from Bink -- original author Vince
 * Perriello (he'll note below where he stole it :-).
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "mailer.h"
#include "bbs.h"
#include "nodelist.h"
#include "xmisc.h"

extern ADDR *addresses;

typedef struct _OADDRESS
{
   word  Zone;
   word  Net;
   word  Node;
   word  Point;
   char  *Domain;
} OADDR, *OADDRP;

/*--------------------------------------------------------------------------*/
/* nodex.ndx                                                                */
/*                                                                          */
/* Version 7 Nodelist Index structure.  This is a 512-byte record, which    */
/* is defined by three structures:  Record 0 is the Control Record, then    */
/* some number of Leaf Node (LNode) Records, then the Index Node (INode)    */
/* Records.  This defines an unbalanced binary tree.                        */
/*                                                                          */
/* This description is based on Scott Samet's CBTREE.PAS program.           */
/*                                                                          */
/*--------------------------------------------------------------------------*/

struct _ndx {
    union
    {
        struct _CtlBlk {
            word    CtlBlkSize; /* Blocksize of Index Blocks   */
            long    CtlRoot;    /* Block number of Root        */
            long    CtlHiBlk;   /* Block number of last block  */
            long    CtlLoLeaf;  /* Block number of first leaf  */
            long    CtlHiLeaf;  /* Block number of last leaf   */
            long    CtlFree;    /* Head of freelist            */
            word    CtlLvls;    /* Number of index levels      */
            word    CtlParity;  /* XOR of above fields         */
        } CtlBlk;

        struct _INodeBlk {
            long    IndxFirst;  /* Pointer to next lower level */
            long    IndxBLink;  /* Pointer to previous link    */
            long    IndxFLink;  /* Pointer to next link        */
            int     IndxCnt;    /* Count of Items in block     */
            word    IndxStr;    /* Offset in block of 1st str  */
            /* If IndxFirst is NOT -1, this is INode:          */
            struct _IndxRef {
                word   IndxOfs; /* Offset of string into block */
                word   IndxLen; /* Length of string            */
                long   IndxData;/* Record number of string     */
                long   IndxPtr; /* Block number of lower index */
            } IndxRef[20];
        } INodeBlk;

        struct _LNodeBlk {
                                /* IndxFirst is -1 in LNodes   */
            long    IndxFirst;  /* Pointer to next lower level */
            long    IndxBLink;  /* Pointer to previous link    */
            long    IndxFLink;  /* Pointer to next link        */
            int     IndxCnt;    /* Count of Items in block     */
            word    IndxStr;    /* Offset in block of 1st str  */
            struct _LeafRef {
                word   KeyOfs;  /* Offset of string into block */
                word   KeyLen;  /* Length of string            */
                long   KeyVal;  /* Pointer to data block       */
            } LeafRef[30];
        } LNodeBlk;

        char RawNdx[512];

    } ndx;
};

/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.20 Version 7 Nodelist structure. Copyright 1991 Wynn Wagner III   */
/* and Doug Boone. Used without permission.                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/

struct _vers7 {
        int    Zone;
        int    Net;
        int    Node;
        int    HubNode;        /* If node is a point, this is point number. */
        word CallCost;         /* phone company's charge */
        word MsgFee;           /* Amount charged to user for a message */
        word NodeFlags;        /* set of flags (see below) */
        char ModemType;        /* RESERVED for modem type */
        char Phone_len;
        char Password_len;
        char Bname_len;
        char Sname_len;
        char Cname_len;
        char pack_len;
        char BaudRate;         /* baud rate divided by 300 */
};

/* This table has been modified to minimize searches */
char unwrk[] = " EANROSTILCHBDMUGPKYWFVJXZQ-'0123456789";

long btree (char *, void *, int (*)(void *, void *, int, int), int);
int get_ver7_info (unsigned long, OADDRP,NODEINFO *,char *);
struct _ndx *get7node(int, unsigned long, struct _ndx *);
void unpk(char *instr,char *outp,int many);
int addr_compare (void *, void *, int, int);
int name_compare (void *, void *, int, int);



NODEINFO * _fastcall ver7find (NODEINFO *nif,unsigned int zone,
                               unsigned int point,char *domain) {

    OADDR         opus_addr;
    long          record;
    OADDR         found_addr;
    char         *idxname,*which;

    opus_addr.Zone = zone;
    opus_addr.Net = nif->net;
    opus_addr.Node = nif->node;
    opus_addr.Point = point;
    opus_addr.Domain = domain;

    idxname = malloc(1050);
    if(!idxname)
      return NULL;

    if(domain && *domain && stricmp(domain,addresses->domain))
      which = domain;
    else
      which = "NODEX";

    sprintf(idxname,"%s/%s.NDX",d_nodelist,which);

    record = btree (idxname, (void *)&opus_addr, addr_compare,0);

    if (record == -1L) {
      if(try_for_points(nif,zone,point,domain,idxname)) {
        free(idxname);
        return nif;
      }
      free(idxname);
      return NULL;
    }
    else
       get_ver7_info((unsigned long)record, &found_addr, nif, domain);

    free(idxname);
    return nif;
}

int addr_compare (void *key, void *desired, int len, int unused) {

   int k;

   k = ((OADDRP)key)->Zone - ((OADDRP)desired)->Zone;
   if (k)
      return (k);

   k = ((OADDRP)key)->Net - ((OADDRP)desired)->Net;
   if (k)
      return (k);

   k = ((OADDRP)key)->Node - ((OADDRP)desired)->Node;
   if (k)
      return (k);
/*
 * Node matches.
 *
 * The rule for points:
 *  1) If len == 6, treat key value for Point as Zero.
 *  2) Return comparison of key Point and desired Point.
 */
   if (len == 6)
      ((OADDRP)key)->Point = 0;

   return ((OADDRP)key)->Point - ((OADDRP)desired)->Point;
} 


ADDR * _fastcall find_in_sysopndx (int mode, USHORT cp, char *name,
                                   ADDR *addr) {

   NODEINFO     nif;
   OADDR        faddr;
   char         last_name_first[80];
   char         midname[80];
   char        *c, *p, *m;
   long         record;
   int          name_len;
   char         *idxname;


   if(!name || !*name)
     return NULL;
   faddr.Zone = faddr.Net = faddr.Node = faddr.Point = (unsigned int) -1;
   faddr.Domain = NULL;
   c = midname;                           /* Start of temp name buff   */
   p = name;                              /* Point to start of name    */
   m = NULL;                              /* Init pointer to space     */

   *c = *p++;
   while (*c) {                           /* Go entire length of name  */
      if (*c == ' ')                      /* Look for space            */
         m = c;                           /* Save location             */
      c++;
      *c = *p++;
   }

   if (m != NULL) {                       /* If we have a pointer,     */
      *m++ = '\0';                        /* Terminate the first half  */
      strcpy (last_name_first, m);        /* Now copy the last name    */
      strcat (last_name_first, ", ");     /* Insert a comma and space  */
      strcat (last_name_first, midname);  /* Finally copy first half   */
   }
   else
     strcpy (last_name_first, midname);       /* Use whole name otherwise */

   capitalize_name (last_name_first);           /* Get caps in where needed  */
   name_len = (int) strlen (last_name_first);    /* Calc length now */

   idxname = malloc(1050);
   if(!idxname)
     return NULL;
   sprintf(idxname,"%s/SYSOP.NDX",d_nodelist);

   record = btree (idxname, (void *)last_name_first, name_compare, name_len);

   if (record == -1) {
      free(idxname);
      return NULL;
   }

   get_ver7_info((unsigned long)record, &faddr, &nif, NULL);
   addr->zone = faddr.Zone;
   addr->net = faddr.Net;
   addr->node = faddr.Node;
   addr->point = faddr.Point;
   if(faddr.Domain) {

     char *p;

     strncpy(addr->domain,faddr.Domain,8);
     addr->domain[8] = 0;
     if((p = strchr(addr->domain,'.')) != NULL)
       *p = 0;
   }
   else
     *addr->domain = 0;

   free(idxname);
   return addr;
}


int name_compare (void *key, void *desired, int len, int name_len) {

   return (strnicmp ((char *)key, (char *)desired,
                     (unsigned int) min (name_len,len)));
}


/*
 * General V7 nodelist engine. Used by both the by-node and by-sysop
 * lookups.
 *
 * Thanks to Phil Becker for showing me how nice it looks in assembler.
 * It helped me see how nice it could be in C.
 *
 * (I know, Phil, it's still nicer in assembler!)
 *
 */

long btree (char *filename, void *desired, int (*compare)(void *key,
            void *desired, int len, int nlen), int name_len) {

    int j, k, l;
    struct _IndxRef *ip = NULL;
    struct _LeafRef *lp = NULL;
    char aline[160];
    char *tp;
    char *np;
    struct _ndx *node_index;         /* index file             */
    struct _ndx *nodeidx;            /* index file             */
    struct _ndx *noderef;            /* index file             */
    long record, foundrec = -1L;
    int count;
    int stream;

    if ((stream = sopen(filename, O_RDONLY | O_BINARY, SH_DENYWR)) == -1)
        return (-1L);                        /* no file, no work to do */

    node_index = malloc ( sizeof (struct _ndx));
    nodeidx = malloc ( sizeof (struct _ndx));
    noderef = malloc ( sizeof (struct _ndx));

    if (node_index == NULL || nodeidx == NULL || noderef == NULL) {
        if(node_index) free(node_index);
        if(nodeidx) free(nodeidx);
        if(noderef) free(noderef);
        close (stream);
        return (-1L);
    }

    /* Get CtlRec */
    if (get7node (stream, 0L, noderef) != noderef) {
        close (stream);
        free(node_index);
        free(nodeidx);
        free(noderef);
        return (-1L);
    }

    /* The guts of the matter -- walk from CtlRec to Leaf */

    record = noderef->ndx.CtlBlk.CtlRoot;

/*
 * Read the first Index node.
 */
    if (get7node(stream, (unsigned long) (record * noderef->ndx.CtlBlk.CtlBlkSize), nodeidx) != nodeidx) {
        close (stream);
        free(node_index);
        free(nodeidx);
        free(noderef);
        return (-1L);
    }
/*
 * Follow the node tree until we either match a key right in the index
 * node, or locate the leaf node which must contain the entry.
 */
    while (nodeidx->ndx.INodeBlk.IndxFirst != -1) {
       if ((count = nodeidx->ndx.INodeBlk.IndxCnt) == 0) {
          close (stream);
          free(node_index);
          free(nodeidx);
          free(noderef);
          return (-1L);
       }

       for (j = 0; j < count; j++) { /* check 20 or less */
          ip = &(nodeidx->ndx.INodeBlk.IndxRef[j]);
          tp = (char *) nodeidx + ip->IndxOfs;

          k = l = ip->IndxLen;

          for (np = aline; k > 0; k--)
              *np++ = *tp++;

          k = (*compare) ((void *)aline, desired, l, name_len);

          if (k > 0)
             break;

          if (k == 0) {

/* Key matches in the index node. Since we're just doing lookup, we
 * can assume its pointer is valid. If we were doing updates, that
 * assumption would not work, because leaf nodes update first. So in
 * an update environment, the entire code segment relating to k == 0
 * should not execute, and we should walk the tree all the way down.
 */
             close (stream);
             free(node_index);
             free(nodeidx);
             free(noderef);
             return (nodeidx->ndx.INodeBlk.IndxRef[j].IndxData);
          }
       }

       if (j == 0)
          record = nodeidx->ndx.INodeBlk.IndxFirst;
       else
          record = (nodeidx->ndx.INodeBlk.IndxRef[--j]).IndxPtr;

       if (get7node(stream, (unsigned long) (record * noderef->ndx.CtlBlk.CtlBlkSize), nodeidx) != nodeidx) {
          close (stream);
          free(node_index);
          free(nodeidx);
          free(noderef);
          return (-1L);
       }

    }
/*
 * We can only get here if we've found the leafnode which must
 * contain our entry.
 *
 * Find our guy here or die trying.
 */

    if ((count = nodeidx->ndx.LNodeBlk.IndxCnt) != 0) {

       /* Search for a higher key */

       for (j = 0; j < count; j++) {      /* check 30 or less */
          lp = &(nodeidx->ndx.LNodeBlk.LeafRef[j]);
          tp = (char *) nodeidx + lp->KeyOfs;

          k = l = lp->KeyLen;

          for (np = aline; k > 0; k--)
              *np++ = *tp++;

          k = (*compare) ((void *)aline, desired, l,name_len);

          if (k > 0)
             break;
          if (k == 0) {
             foundrec = (nodeidx->ndx.LNodeBlk.LeafRef[j]).KeyVal;
             break;
          }
       }
    }

    close (stream);
    free(node_index);
    free(nodeidx);
    free(noderef);
    return (foundrec);
}


int get_ver7_info (unsigned long pos, OADDRP faddr,NODEINFO *nif,char *domain) {

    struct _vers7 vers7;
    char my_phone[40];
    char my_pwd[9];
    char aline[160];
    char aline2[160];
    char *fst,*which;
    char *temp;    /* we build filenames here*/
    int stream;


    if(domain && *domain && stricmp(domain,addresses->domain))
      which = domain;
    else
      which = "NODEX";

    temp = malloc(1050);
    if(!temp)
      return 0;

    sprintf(temp,"%s/%s.DAT",d_nodelist,which);
    if ((stream = sopen (temp, O_BINARY | O_RDONLY, SH_DENYWR)) == -1) { /* open it*/
        free(temp);
        return (0);
    }

    if (lseek (stream,(long int) pos, SEEK_SET) == -1L) {   /* point at record */
        close (stream);
        free(temp);
        return (0);
    }

    if (read (stream, &vers7,sizeof (struct _vers7)) == -1) {
        close (stream);
        free(temp);
        return (0);
    }

    memset(my_phone,'\0',40);
    read (stream,my_phone, vers7.Phone_len);

    memset(my_pwd,'\0',9);
    read (stream,my_pwd, vers7.Password_len);

    memset(aline,'\0',160);
    memset(aline2,'\0',160);
    if (read (stream,aline2, vers7.pack_len) == -1) {
        close (stream);
        free(temp);
        return (0);
    }

    close (stream);

    unpk(aline2,aline,vers7.pack_len);

    memset (nif, 0, sizeof (NODEINFO));

    nif->net = vers7.Net;
    nif->node = vers7.Node;
    nif->cost = nif->realcost = vers7.CallCost;
    memcpy (nif->name, aline, min(33, vers7.Bname_len));
    nif->name[min(33, vers7.Bname_len)] = '\0';
    capitalize_name (nif->name);

    fst = &aline[0] + vers7.Bname_len + vers7.Sname_len;
    memcpy (nif->phone, my_phone, min(39,vers7.Phone_len));
    nif->phone[min(39,vers7.Phone_len)] = '\0';
    memcpy (nif->city, fst, min(29, vers7.Cname_len));
    nif->city[min(29, vers7.Cname_len)] = '\0';
    capitalize_name( nif->city );

    memcpy (nif->password, my_pwd, min(8, vers7.Password_len));
    nif->password[min(8,vers7.Password_len)] = 0;
    nif->hubnode = vers7.HubNode;
    nif->rate = vers7.BaudRate;
    nif->modem = vers7.ModemType;
    nif->flags = vers7.NodeFlags;

    faddr->Zone  = vers7.Zone;
    faddr->Net   = vers7.Net;
    faddr->Node  = vers7.Node;
    if (vers7.NodeFlags & B_point)
        faddr->Point = vers7.HubNode;
    else faddr->Point = 0;
    faddr->Domain = NULL;

    free(temp);
    return (1);
}


struct _ndx *get7node (int stream, unsigned long pos, struct _ndx *ndx) {

    lseek (stream, (long) pos, SEEK_SET);

    if (read (stream, ndx,(unsigned int) sizeof (struct _ndx)) == -1) {
        close (stream);
        return (NULL);
    }
    return (ndx);
}


/* ====================================================================
 * unpack a dense version of a symbol (base 40 polynomial)
 * ====================================================================
 */
void unpk (char *instr,char *outp,int count) {

    struct chars {
           unsigned char c1;
           unsigned char c2;
    };

    union {
          unsigned w1;
          struct chars d;
    } u;

   register int i, j;
   char obuf[4];

   outp[0] = '\0';

   while (count) {
       u.d.c1 = *instr++;
       u.d.c2 = *instr++;
       count -= 2;
       for(j=2;j>=0;j--) {
           i = u.w1 % 40;
           u.w1 /= 40;
            obuf[j] = unwrk[i];
       }
       obuf[3] = '\0';
       strcat (outp, obuf);
   }
}
