#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"


    extern MDM * modems[MAXINSTANCES];

/* search all files matching mask in directory dir for text */


int _fastcall scan_for_text (int mode, USHORT cp, char *dir, char *mask,
                             char *text, long *numinstances) {

    char         string[257];
    char         *start,*end,*buff = NULL,*p;
    FILEFINDBUF  f;
    USHORT       num_matches = 0;
    int          handle,status,foundone,numfiles,tkey;
    HDIR         search_handle;


    *numinstances = 0;
    sprintf(string,"%s/%s",dir,mask);

    search_handle = HDIR_CREATE;
    num_matches = 1;
    if(!bbs_findfirst(cp,string,&search_handle,0,(FILEFINDBUF *)&f,
     sizeof(FILEFINDBUF),&num_matches,0L)) {
      buff = bbs_malloc(cp,4098);
      if(!buff) {
        sayp(mode,cp,159,NULL,0);
        return 0;
      }
      dputs(mode,cp,"\r\n");
      do {
        sprintf(string,"%s/%s",dir,f.achName);
        handle = bbs_sopen(cp,string,O_RDONLY | O_BINARY, SH_DENYNO);
        if(handle != -1) {
          foundone = 0;
          while(!eof(handle)) {
            tkey = inkey(mode,cp);
            if(tkey == (int)modems[cp]->STOP) {
              bbs_close(cp,handle);
              bbs_closefind(cp,search_handle);
              goto BreakOut;
            }
            if(tell(handle) > 80L && tell(handle) < filelength(handle))
             lseek(handle,tell(handle) - 80L,SEEK_SET);
            status = read(handle,buff,4096);
            if(status == -1 || status == 0) {
              break;
            }
            buff[status] = 0;
            start = stristr(buff,text);
            if(start) {
              while(start > buff && *start != '\r' && *start != '\n') {
                start--;
              }
              while(*start == '\r' || *start == '\n') start++;
              end = start;
              while(*end && *end != '\r' && *end != '\n') {
                end++;
              }
              if(*end) *end = 0;
              p = start;
              while(*p && p < end) {
                if(*p == '\x1b') *p = ' ';
                p++;
              }
              dprintf(mode,cp," \"%s\":\n%0.79s\n",f.achName,start);
              foundone++;
            }
          }
          if(foundone) {
            numfiles++;
            *numinstances += (long)foundone;
          }
          bbs_close(cp,handle);
        }
        num_matches = 1;
      } while(!DosFindNext(search_handle,(FILEFINDBUF *)&f,sizeof(FILEFINDBUF),
                          &num_matches));
      bbs_closefind(cp,search_handle);
    }

BreakOut:

    if(buff) bbs_free(cp,buff);
    return numfiles;
}
