#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

    extern USER *user[MAXINSTANCES];

#define MAXPICK 1000

/* allow "picking" a filename from a list.  list is constructed from all
   files matching mask in directory dir.  return is in caller-provided
   variable string. */


char * _fastcall file_select (int mode, USHORT cp, char *dir,char *mask,
                              char *string) {

    char        *files[MAXPICK + 1];
    int          numfiles = 0,select = -1,x;
    HDIR         search_handle;
    USHORT       num_matches;
    FILEFINDBUF  f;


    sprintf(string,"%s/%s",dir,mask);
    search_handle = HDIR_CREATE;
    num_matches = 1;
    if(!bbs_findfirst(cp,string,&search_handle,0,(FILEFINDBUF *)&f,
     sizeof(FILEFINDBUF),&num_matches,0L)) {
      do {
        files[numfiles] = bbs_strdup(cp,f.achName);
        if(!files[numfiles]) {
          if(numfiles) sayp(mode,cp,280,NULL,0);
          break;
        }
        numfiles++;
        if(numfiles > MAXPICK) {
          sayp(mode,cp,280,NULL,0);
          break;
        }
        num_matches = 1;
      } while(!DosFindNext(search_handle,(FILEFINDBUF *)&f,sizeof(FILEFINDBUF),
              &num_matches));
      bbs_closefind(cp,search_handle);
    }

    dputs(mode,cp,"\r\n");
    *string = 0;

    if(numfiles) {
        if(user[cp]->attribs & U_COLOR) {
            select = top_menu(mode,cp,files,numfiles,"Pickfile",NULL);
        }
        else {

            char prompt[80];

            sayp(mode,cp,279,prompt,79);
            select = select_one(mode,cp,files,numfiles,prompt,NULL,
                                "Pickfile",set_iflg(cp));
        }
        if(select > -1 && select < numfiles) strcpy(string,files[select]);
    }

    for(x = 0;x < numfiles;x++) {
      if(files[x]) bbs_free(cp,files[x]);
    }

    return string;
}
