#include <stdlib.h>
#include <string.h>


char * _fastcall make_ansi (int fore, int back,char *scratch) {

    /* construct an ANSI escape sequence to yield foreground and background
       colors as passed in fore and back.  scratch array should be at least
       13 bytes long.  Valid colors:        Foreground  Background(0=none)
                       -------------------- ----------- ----------
                             BLACK          1           1
                             DARK BLUE      2           2
                             DARK GREEN     3           3
                             DARK CYAN      4           4
                             DARK RED       5           5
                             DARK MAGENTA   6           6
                             BROWN          7           7
                             LIGHT GREY     8           8
                             DARK GREY      9
                             LIGHT BLUE     10
                             LIGHT GREEN    11
                             LIGHT CYAN     12
                             LIGHT RED      13
                             LIGHT MAGENTA  14
                             YELLOW         15
                             WHITE          16
    */

    static char *fa[] = {"2;30","2;34","2;32","2;36","2;31","2;35","2;33",
                         "2;37","1;30","1;34","1;32","1;36","1;31","1;35",
                         "1;33","1;37"
                        };
    static char *ba[] = {"40","44","42","45","41","46","43","47"
                        };
    char        *p,*pp;


    if(!scratch) return "";
    if((fore < 1 || fore > 16) || (back < 0 || back > 8)) {  /* Error checking */
        fore = 15;  /* white */
        back = 0;   /* black */
    }
    else {
        fore--;
        back--;
    }

    strcpy(scratch,"\x1b[0;");  /* make foreground string */
    p = scratch + 4;
    pp = fa[fore];
    while(*pp) {
        *p = *pp;
        p++;
        pp++;
    }

    if(back != -1) {    /* add background string if back wasn't 0 */
        *p = ';';
        p++;
        pp = ba[back];
        while(*pp) {
            *p = *pp;
            p++;
            pp++;
        }
    }

    *p = 'm';
    p++;
    *p = 0;
    return scratch;
}
