#include <io.h>
#include <share.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "mailer.h"
#include "xmisc.h"

    ADDR *addresses;

int _fastcall load_addresses (void) {

  int  handle;
  char ln[257];
  char *p,*lastdomain;
  ADDR *info,*last;

  handle = sopen(searchpath("ADDRESS.BB2",ln,256),
                 O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
  if(handle == -1)
    return -1;

  while(!eof(handle)) {
    if(!fgetsx(ln,256,handle))
      break;
    lstrip(ln);
    if(*ln == ';')
      continue;
    stripcr(ln);
    rstrip(ln);
    if(!*ln)
      continue;
    p = ln;

    info = (ADDR *)malloc(sizeof(ADDR));
    if(!info)
      return -1;
    *info->domain = 0;

    if(parse_addr(&p,info,addresses)) {
      free(info);
      continue;
    }

    if(!addresses) {
      if(!*info->domain) {
        free(info);
        return -1;
      }
      lastdomain = info->domain;
      addresses = info;
      last = info;
    }
    else {
      if(!*info->domain) {
        strncpy(info->domain,lastdomain,8);
        info->domain[8] = 0;
      }
      else lastdomain = info->domain;
      last->next = info;
      last = info;
    }
    info->next = NULL;
  }

  close(handle);
  if(!addresses)
    return -1;
  return 0;
}
