#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "xmisc.h"

    extern MDM  *modems[MAXINSTANCES];
    extern USER *user[MAXINSTANCES];




unsigned int _pascal find_user (int mode,USHORT cp,USER *auser,
                                char *name,unsigned int *usenumber) {

    /* finds user by name, loads into user, returns user number */

    int          handle;
    unsigned int numusers,counter,wasdeleted = 0;
    struct _justnames {
        char name[36];
        char handle[36];
    }            jn;
    long         pos;


    *usenumber = 0;
    handle = bbs_sopen(cp,"USERS.BB2",O_NOINHERIT | O_RDONLY | O_CREAT | O_BINARY,
                     SH_DENYNO,S_IREAD | S_IWRITE);
    if(handle == -1 && user[cp] == auser) {
        sayp(mode,cp,246,NULL,0);
        flushout(cp);
        DosSemClear(&modems[cp]->bbsrunningSEM);
        _endthread();
    }

    numusers = (unsigned int) (filelength(handle) / (long)(sizeof(USER) - USERSUB));

    if(!numusers) {
        bbs_close(cp,handle);
        unlink("USERS.BB2");
        return 0;
    }

    lseek(handle,0L,SEEK_SET);
    counter = 0;

    while(!eof(handle)) {
        pos = tell(handle);
        if(read(handle,&jn,sizeof(struct _justnames)) < sizeof(struct _justnames)) break;
        if(!stricmp(jn.name,name) || !stricmp(jn.handle,name)) {
            lseek(handle,pos,SEEK_SET);
            if(read(handle,auser,sizeof(USER) - USERSUB) < (long)(sizeof(USER) - USERSUB)) break;
            if(auser->attribs & U_DELETED) {
                wasdeleted = counter;
                continue;
            }
            if(auser->attribs & U_LOCKEDOUT && auser == user[cp]) {
                readansi(mode,cp,"LOCKOUT.ASC",NULL,3);
                sayp(mode,cp,191,NULL,0);
                flushout(cp);
                DosSemClear(&modems[cp]->bbsrunningSEM);
                _endthread();
            }
            bbs_close(cp,handle);
            return counter + 1;
        }
        lseek(handle,pos + (long)(sizeof(USER) - USERSUB),SEEK_SET);
        counter++;
        DosSleep(0L);
    }

    bbs_close(cp,handle);
    if(wasdeleted) *usenumber = wasdeleted;
    return 0;
}
