/* background msg-to-FTNpkt export thread */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "xmsg.h"

    extern MDM     *modems[MAXINSTANCES];
    extern USER    *user[MAXINSTANCES];
    extern BBS     *bbs;
    extern MSGAREA *msgareas;
    extern int     *_threadid;
    extern ADDR    *addresses;



void FIDO_export (void *ccp) {

    /* exports msgs into FTN packet format in background */

    USHORT  cp = *((USHORT *)ccp),messno,c;
    USER    u;
    MSGAREA *info;
    XMSG    msg;
    PKTHDR  pkt;
    ADDR    pointaddr;
    char    *hold,line[133],*area;
    int     temp,handle;
    int     mode = (((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL);
    struct  stat st;
    long    pos,cntr = 0L;


    DosEnterCritSec();
      if(!user[cp]) {
        DosExitCritSec();
        _endthread();
      }
      if(DosSemRequest(&modems[cp]->amexportingSEM,0L)) {
          dputs(mode,cp,"\r\nAn export is already in progress; try again after it finishes.\r\n");
          DosExitCritSec();
          _endthread();
      }
      sprintf(line,"%s/%08lx.MO0",d_xport,user[cp]->userid);
      if(!stat(line,&st)) {
        if(st.st_size) {
            dputs(mode,cp,"\r\nYou already have a packet waiting; download it first\r\n");
            DosSemSet(&modems[cp]->amdonexportingSEM); /* let BBS thread know it's done */
            DosSemClear(&modems[cp]->amexportingSEM);
            DosExitCritSec();
            _endthread();
        }
        else unlink(line);
      }
      memcpy(&u,user[cp],sizeof(USER));
      if(!u.pointid && !(bbs->attribs2 & B2_FTNTOALL)) {
        dputs(mode,cp,"\r\nYou must have a point address assigned by the sysop to use this function.\r\n");
        DosSemClear(&modems[cp]->amexportingSEM);
        DosExitCritSec();
        _endthread();
      }
      /*
       * if B2_FTNTOALL then everyone without a specific point address
       * is point .65535
       */
      if(!u.pointid) u.pointid = 65535U;
      u.lastread = (unsigned int *)malloc(LASTREADSIZE * sizeof(unsigned int));
      if(!u.lastread) {
        dputs(mode,cp,"\r\nExport aborted; I'm out of memory\r\n");
        DosSemClear(&modems[cp]->amexportingSEM);
        DosExitCritSec();
        _endthread();
      }
      memcpy(u.lastread,user[cp]->lastread,LASTREADSIZE * sizeof(unsigned int));
    DosExitCritSec();

    /* find first available area */

    info = next_xport_area(msgareas,&u,0);
    if(!info) {
        free(u.lastread);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }

    /* open export file */

    sprintf(line,"%s/%08lx.PKT",d_xport,u.userid);
    unlink(line);
    handle = sopen(line,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYWR,S_IWRITE);
    if(handle == -1) {
        free(u.lastread);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }

    /* make & write packet header */

    memcpy(&pointaddr,addresses,sizeof(ADDR));
    pointaddr.point = u.pointid;
    fill_in_pkt_hdr(&pkt,addresses,&pointaddr,"");
    write(handle,&pkt,sizeof(PKTHDR));
    pos = tell(handle);
    if(pos) lseek(handle,pos - 2L,SEEK_SET);

    /* set priority before beginning actual work */

    logfunc(0,cp,"FTN 2.2 export thread working");
    DosSetPrty(2,modems[cp]->export[0],modems[cp]->export[1],*_threadid);

    /* do the export */

    while(info) {
        if(stricmp(info->name,"Netmail")) area = info->name;
        else area = NULL;
        messno = how_many_msgs(info);
        if(u.lastread[info->number - 1] > messno) {
           if(messno)
             u.lastread[info->number - 1] = messno;
        }

        for(c = u.lastread[info->number - 1] + 1;c < messno + 1;c++) {

            /* get header */

            memset(&msg,0,sizeof(XMSG));
            temp = get_mess((USHORT)-1,&msg,info->number,c);
            if(temp != MSG_NOERR) continue;
            if(msg.fflags & MSGPRIVATE) {
                if(mymsg(&u,&msg) && msg_sysop_ok(&u,info)) continue;
            }
            if(msg.xflags & MSGDELETED && msg_sysop_ok(&u,info)) continue;

            /* get text */

            temp = get_text((USHORT)-1,&hold,&msg,info->number,c);
            if(temp != MSG_NOERR && temp != MSG_REDUCED) {
                if(hold) free(hold);
                continue;
            }
            strip_seenbys(hold);

            /* write msg */

            write(handle,"\02\0",2);                      /* SOM */
            write(handle,&info->addr->node,2);            /* our node */
            write(handle,&pkt.dnode,2);                   /* dest node */
            write(handle,&info->addr->net,2);             /* our net */
            write(handle,&pkt.dnet,2);                    /* dest net */
            write(handle,&msg.fflags,2);                  /* attrib */
            write(handle,&msg.cost,2);                    /* cost */
            ffprintf(handle,"%19.19s",msg.date);          /* date */
            write(handle,"\0",1);
            write(handle,msg.to,strlen(msg.to) + 1);      /* to */
            write(handle,msg.from,strlen(msg.from) + 1);  /* from */
            write(handle,msg.subj,strlen(msg.subj) + 1);  /* subj */
            if(area) ffprintf(handle,"AREA:%s\r",area);   /* area tag */
            write(handle,hold,strlen(hold));              /* msg text */
            ffprintf(handle,"\rSEEN-BY: %u/%u\r",pkt.dnet,pkt.dnode);  /* tack on fake seenby */
            write(handle,"\0\0",3);                       /* EOM */
            pos = tell(handle);
            if(pos) lseek(handle,pos - 2L,SEEK_SET);  /* Position to next msg spot */
            if(hold) free(hold);
            cntr++;

            if(c == messno) messno = how_many_msgs(info);
            DosSleep(1L);
            if(bbs->maxuserpkt && tell(handle) > bbs->maxuserpkt)
              break;
        }
        if(messno)
          u.lastread[info->number - 1] = messno;
        DosSleep(1L);
        DosBufReset(handle);
        if(bbs->maxuserpkt && tell(handle) > bbs->maxuserpkt)
          break;
        info = next_xport_area(info,&u,1);
    }

    close(handle);

    if(!cntr) {
        sprintf(line,"%s/%08lx.PKT",d_xport,u.userid);
        unlink(line);
    }
    else {

        /* update lastread */

        DosEnterCritSec();
          if(user[cp] && user[cp]->number == u.number) {
            memcpy(user[cp]->lastread,u.lastread,LASTREADSIZE * sizeof(unsigned int));
          }
          save_lastread((USHORT)-1,u.lastread,u.number);
        DosExitCritSec();

        /* archive file */

        forkf(D_LOCAL,-1,0,"%s /C PKZIP.EXE -m %s/%08lx.MO0 ./XPORT/%08lx.PKT 1>NUL 2>NUL",
                getenv("COMSPEC"),d_xport,u.userid,d_xport,u.userid);
    }

    free(u.lastread);

    DosEnterCritSec();
     if(user[cp] && user[cp]->number == u.number)
       DosSemSet(&modems[cp]->amdonexportingSEM); /* let BBS thread know it's done */
    DosExitCritSec();
    DosSemClear(&modems[cp]->amexportingSEM);
}
