/************************************************/
/* This module makes outgoing mail calls        */
/************************************************/

#define USE_TIME_MACROS

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "transfer.h"
#include "nodelist.h"
#include "modem.h"
#include "timers.h"
#include "xmisc.h"
#include "window.h"

    extern HWND  hwndDlg;
    extern MDM   *modems[MAXINSTANCES];
    extern ADDR  *addresses;


int _fastcall dial_out (USHORT cp,ADDR *addr,ADDR **myaddr,
                        int polling,int *DoingYooHoo) {

    /* calls the requested node and initiates session if connected.
       returns 0 (connect but no session or bad session), 1 (good
       session through send stages), or -1 (no connect) */

    clock_t                t1;
    int                    temp;
    char                   s[82];
    NODEINFO               nif;
    ADDR                   wasaddr;


    memcpy(&wasaddr,addr,sizeof(ADDR));
    nif.net = addr->net;
    nif.node = addr->node;
    if(!get_node_from_list(&nif,addr->zone,addr->point,addr->domain) || !*nif.phone) {
        logfunc(2,cp,"Can't find a number for %s#%u:%u/%u.%u",
                addr->domain,addr->zone,addr->net,addr->node,addr->point);
        return 0;
    }

    if((USHORT)(nif.rate * 300) < modems[cp]->mincallbaud) {
        logfunc(0,cp,"Not dialing %s--too slow @ %u baud",nif.name,nif.rate * 300);
        return 0;
    }

    if((USHORT)(nif.rate * 300) > modems[cp]->maxcallbaud) {
        logfunc(0,cp,"Not dialing %s--too fast @ %u baud",nif.name,nif.rate * 300);
        return 0;
    }

    if(!nif.modem) {
        logfunc(0,cp,"Dialing %s%s%s (%s [%s#%u:%u/%u.%u])",modems[cp]->dpre,
                nif.phone,modems[cp]->dsuf,nif.name,addr->domain,addr->zone,
                addr->net,addr->node,addr->point);
    }
    else {
        for(temp = 0;temp < 8;temp++) {
            if(nif.modem & (1 << temp)) {
                logfunc(0,cp,"Dialing %s%s%s (%s [%s#%u:%u/%u.%u])",
                        modems[cp]->dprevar[temp],nif.phone,
                        modems[cp]->dsufvar[temp],nif.name,addr->domain,
                        addr->zone,addr->net,addr->node,addr->point);
                break;
            }
        }
    }

    Change_Status("Dialing");

    modems[cp]->checkcd = 0;

    if(!nif.modem)
      dial_phone(cp,modems[cp]->dpre,nif.phone,modems[cp]->dsuf);
    else {
      for(temp = 0;temp < 8;temp++) {
        if(nif.modem & (1 << temp)) {
          dial_phone(cp,modems[cp]->dprevar[temp],nif.phone,
                     modems[cp]->dsufvar[temp]);
          break;
        }
      }
    }

    *s = 0;
    modems[cp]->curbaud = detect_baud(cp,60001L + ((modems[cp]->curbaud > 2400) * 10001L),s);
    if(!modems[cp]->curbaud) {
        logfunc(0,cp,"No connect (%s)",s);
        if(!stricmp(s,"BUSY")) {
            inc_calls(addr,0);
            return -1;
        }
        else if(!stricmp(s,"NO DIALTONE")) {
          Say_General("No dialtone; attempting to answer...");
          return -2;
        }
        inc_calls(addr,1);
        return 0;
    }
    logfunc(0,cp,s);

    Change_Baud(modems[cp]->curbaud);
    if(!modems[cp]->locked)
      set_baud(cp,modems[cp]->curbaud,'N',8,1);

    Change_Status("Connect");

    modems[cp]->checkcd = 1;
    modems[cp]->wasbbs = 0;

    DosSleep(2500L);
    purge_in(cp);

    t1 = timerset(30000L);
    while(!timeup(t1)) {
        temp = get_modem_str(cp,s,81,'\r',0,2500L);
        if(temp == LOSTCARRIER) {
            sayn(D_LOCAL,cp,243,NULL,0);
            inc_calls(addr,1);
            return 0;
        }
        if(strchr(s,'\r')) {
          if(*s == '\r')
            get_modem_str(cp,s,81,'\r',0,1L);
          if(*s != '\r') {

            char *p;

            stripcr(s);
            p = s;
            while(*p == '\n' || *p == '\r')
              p++;
            lstrip(rstrip(p));
            if(*p)
              logfunc(0,cp,"Intro: \"%s\"",p);
          }
          break;
        }
        com_write(cp,"\r \r ",4);
    }

    if(timeup(t1)) {
        sayn(D_LOCAL,cp,244,NULL,0);
        inc_calls(addr,1);
        return 0;
    }

    purge_in(cp);
    DosSleep(500L);

    t1 = timerset(60000L);
    do {
        temp = get_modem_byte(cp,500L);
        switch(temp) {
            case LOSTCARRIER:   sayn(D_LOCAL,cp,243,NULL,0);
                                return 0;
            case TIMEOUT:       goto CommenceSession;
        }
    } while(!timeup(t1));
    sayn(D_LOCAL,cp,245,NULL,0);
    inc_calls(addr,1);
    return 0;

CommenceSession:

    Change_Status("Negotiating");
    temp = send_yoohoo(cp,addr,myaddr,nif.password);
    switch(temp) {
        case LOSTCARRIER:   sayn(D_LOCAL,cp,243,NULL,0);
                            inc_calls(addr,1);
                            return 0;

        case TSYNCH:        Change_Status("FTS-0001");
                            logfunc(1,cp,"********FTS-0001");
                            *DoingYooHoo = 0;
                            break;

        case YOOHOO:        if(!modems[cp]->sea1k) {
                                Change_Status("dietIFNA");
                                logfunc(1,cp,"********dietIFNA");
                            }
                            else {
                                Change_Status("dietIFNA-1K");
                                logfunc(1,cp,"********dietIFNA-1K");
                            }
                            *DoingYooHoo = 1;
                            break;

        default:            inc_calls(addr,1);
                            return 0;
    }

    inc_calls(addr,0);

    if(addr->zone != wasaddr.zone || addr->net != wasaddr.net ||
      wasaddr.node != addr->node || wasaddr.point != addr->point
      && stricmp(wasaddr.domain,addr->domain)) {
        logfunc(0,cp,"Called: %s#%u:%u/%u.%u  Got: %s#%u:%u/%u.%u",
                wasaddr.domain,wasaddr.zone,wasaddr.net,wasaddr.node,
                wasaddr.point,addr->domain,addr->zone,addr->net,addr->node,
                addr->point);
    }
    DosSleep(250L);

    temp = send_mail(cp,&wasaddr,*myaddr,nif.password,0,
                     polling,*DoingYooHoo);
    return temp;
}
