#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

extern MDM  *modems[MAXINSTANCES];
extern BBS  *bbs;
extern USER *user[MAXINSTANCES];

char *atbl[] = {
    "\x1b[0m",      /* 32000 */
    "\x1b[1m",      /* 32001 */
    "\x1b[2m",      /* 32002 */
    "\x1b[3m",      /* 32003 */
    "\x1b[4m",      /* 32004 */
    "\x1b[5m",      /* 32005 */
    "\x1b[7m",      /* 32006 */
    "\x1b[30m",     /* 32007 */
    "\x1b[31m",     /* 32008 */
    "\x1b[32m",     /* 32009 */
    "\x1b[33m",     /* 32010 */
    "\x1b[34m",     /* 32011 */
    "\x1b[35m",     /* 32012 */
    "\x1b[36m",     /* 32013 */
    "\x1b[37m",     /* 32014 */
    "\x1b[40m",     /* 32015 */
    "\x1b[41m",     /* 32016 */
    "\x1b[42m",     /* 32017 */
    "\x1b[43m",     /* 32018 */
    "\x1b[44m",     /* 32019 */
    "\x1b[45m",     /* 32020 */
    "\x1b[46m",     /* 32021 */
    "\x1b[47m",     /* 32022 */
    "\x1b[K",       /* 32023 */
    "\x1b[A",       /* 32024 */
    "\x1b[B",       /* 32025 */
    "\x1b[C",       /* 32026 */
    "\x1b[D",       /* 32027 */
    "\x1b[2J",      /* 32028 */
    "\x1b[s",       /* 32029 */
    "\x1b[u"        /* 32030 */
};


#define MAXSTRG 1028


char * _pascal bbs_convert_string (USHORT cp,char *string) {

    /* NOTE: caller must bbs_free() returned string! */

    char *work,*p,*w,*instring;
    int  c;


    if(!string || !*string || !user[cp])
      return NULL;

    instring = strdup(string);
    literal(instring);

    work = bbs_malloc(cp,MAXSTRG + 1);
    if(!work) {
      free(instring);
      return NULL;
    }
    memset(work,0,MAXSTRG);

    p = instring;
    w = work;

    while(*p) {
        if(*p == '\x1b' && *(p + 1) == '[') {   /* ANSI sequence */
          *w++ = *p++;
          *w++ = *p++;
          continue;
        }
        else if(*p == '\\' && *(p + 1) == '[') {     /* escaped left brkt */
            p++;
            *w = *p;
            w++;
            p++;
            continue;
        }
        if(*p == '[' && atoi(p + 1)) {
            c = atoi(p + 1);
            while(*p && *p != ']') p++;
            if(*p == ']') p++;
            if(c >= 32000 && !(user[cp]->attribs & U_COLOR)) continue;
            switch(c) {
                case 1:
                    sprintf(w,"%lu",bbs->numcalls);
                    break;

                case 2:
                    sprintf(w,"%d",bbs->minage);
                    break;

                case 3:
                    sprintf(w,"%d",bbs->maxage);
                    break;

                case 4:
                    sprintf(w,"%u",bbs->maxusers);
                    break;

                case 5:
                    sprintf(w,"%d",bbs->maxattempts);
                    break;

                case 6:
                    sprintf(w,"%d",bbs->maxpage);
                    break;

                case 7:
                    strcat(w,bbs->bbs_name);
                    break;

                case 8:
                    strcat(w,bbs->sysop);
                    break;

                case 9:
                    strcat(w,user[cp]->name);
                    break;

                case 10:
                    strcat(w,user[cp]->handle);
                    break;

                case 11:
                    strcat(w,user[cp]->address);
                    break;

                case 12:
                    strcat(w,user[cp]->phone_number);
                    break;

                case 13:
                    strcat(w,user[cp]->interests);
                    break;

                case 14:
                    sprintf(w,"%u",user[cp]->computer_type);
                    break;

                case 15:
                    strcat(w,find_computer(user[cp]->computer_type));
                    break;

                case 16:
                    sprintf(w,"%lu",user[cp]->userid);
                    break;

                case 17:
                    sprintf(w,"%u",user[cp]->pointid);
                    break;

                case 18:
                    sprintf(w,"%04u/%02hu/%02hu",user[cp]->birthyear,user[cp]->birthmonth,user[cp]->birthday);
                    break;

                case 19:
                    sprintf(w,"%ld",user[cp]->credit);
                    break;

                case 20:
                    sprintf(w,"%ld",user[cp]->minlimit);
                    break;

                case 21:
                    sprintf(w,"%u",user[cp]->time_today);
                    break;

                case 22:
                    sprintf(w,"%u",user[cp]->time_per_day);
                    break;

                case 23:
                    sprintf(w,"%lu",user[cp]->numcalls);
                    break;

                case 24:
                    sprintf(w,"%lu",user[cp]->ulnum);
                    break;

                case 25:
                    sprintf(w,"%lu",user[cp]->dlnum);
                    break;

                case 26:
                    sprintf(w,"%lu",user[cp]->ulk);
                    break;

                case 27:
                    sprintf(w,"%lu",user[cp]->dlk);
                    break;

                case 28:
                    sprintf(w,"%lu",user[cp]->uktoday);
                    break;

                case 29:
                    sprintf(w,"%lu",user[cp]->dktoday);
                    break;

                case 30:
                    sprintf(w,"%lu",user[cp]->ukperday);
                    break;

                case 31:
                    sprintf(w,"%lu",user[cp]->dkperday);
                    break;

                case 32:
                    sprintf(w,"%lu",user[cp]->security1);
                    break;

                case 33:
                    sprintf(w,"%lu",user[cp]->security2);
                    break;

                case 34:
                    sprintf(w,"%lu",user[cp]->flags1);
                    break;

                case 35:
                    sprintf(w,"%lu",user[cp]->flags2);
                    break;

                case 36:
                    sprintf(w,"%lu",user[cp]->attribs);
                    break;

                case 37:
                    sprintf(w,"%lu",user[cp]->attribs2);
                    break;

                case 38:
                    sprintf(w,"%u",user[cp]->length);
                    break;

                case 39:
                    sprintf(w,"%u",user[cp]->width);
                    break;

                case 40:
                    sprintf(w,"%u",user[cp]->lastmsgarea);
                    break;

                case 41:
                    sprintf(w,"%u",user[cp]->lastfilearea);
                    break;

                case 42:
                    if(user[cp]->lastprotocol)
                      sprintf(w,"%c",user[cp]->lastprotocol);
                    else
                      sprintf(w,"X");
                    break;

                case 43:
                    if(user[cp]->lastarchiver)
                      sprintf(w,"%c",user[cp]->lastarchiver);
                    else
                      sprintf(w,"A");
                    break;

                case 44:
                    sprintf(w,"%u",user[cp]->time_per_call);
                    break;

                case 45:
                    sprintf(w,"%ld",user[cp]->forsysop);
                    break;

                case 46:
                    sprintf(w,"%hu",user[cp]->interface);
                    break;

                case 47:
                    sprintf(w,"%hu",user[cp]->exp);
                    break;

                case 48:
                    sprintf(w,"%d",user[cp]->age);
                    break;

                case 49:
                    if(user[cp]->currmsgarea) {
                        strcat(w,user[cp]->currmsgarea->name);
                    }
                    else strcat(w,"(None)");
                    break;

                case 50:
                    if(user[cp]->currfilearea) {
                        strcat(w,user[cp]->currfilearea->name);
                    }
                    else strcat(w,"(None)");
                    break;

                case 51:
                    if(user[cp]->currlibarea) {
                        strcat(w,user[cp]->currlibarea->name);
                    }
                    else strcat(w,"(None)");
                    break;

                case 52:
                    sprintf(w,"%u",modems[cp]->curbaud);
                    break;

                case 53:    /* mins left */
                    sprintf(w,"%ld",(user[cp]->offline - time(NULL)) / 60L);
                    break;

                case 54:    /* secs remainder */
                    sprintf(w,"%ld",(user[cp]->offline - time(NULL)) - (user[cp]->offline - time(NULL)) / 60L);
                    break;

                case 55:    /* secs left */
                    sprintf(w,"%ld",user[cp]->offline - time(NULL));
                    break;

                case 56:    /* graphics capability */
                    if(user[cp]->attribs & U_COLOR)
                      strcat(w,"1");
                    else
                      strcat(w,"0");
                    break;

                case 57:    /* numeric variables */
                case 58:
                case 59:
                case 60:
                case 61:
                case 62:
                case 63:
                case 64:
                case 65:
                    sprintf(w,"%ld",user[cp]->nvar[c]);
                    break;

                case 66:    /* string variables */
                case 67:
                case 68:
                case 69:
                case 70:
                case 71:
                case 72:
                case 73:
                case 74:
                    strncat(w,user[cp]->svar[c],80);
                    break;

                case 75:
                    if(user[cp]->currlibarea) {
                        sprintf(w,"%u",user[cp]->currlibarea->number);
                    }
                    break;

                case 76:    /* number of messages in current msg area */
                    if(user[cp]->currmsgarea) {
                        sprintf(w,"%u",how_many_msgs(user[cp]->currmsgarea));
                    }
                    break;

                case 77:    /* lastread for current msg area */
                    if(user[cp]->currmsgarea && user[cp]->lastread) {
                        sprintf(w,"%u",user[cp]->lastread[user[cp]->currmsgarea->number - 1]);
                    }
                    break;

                case 78:    /* current msg area # */
                    if(user[cp]->currmsgarea) {
                        sprintf(w,"%u",user[cp]->currmsgarea->number);
                    }
                    break;

                case 79:    /* current file area # */
                    if(user[cp]->currfilearea) {
                        sprintf(w,"%u",user[cp]->currfilearea->number);
                    }
                    break;

                case 80:    /* lastread for current area + 1 */
                    if(user[cp]->currmsgarea && user[cp]->lastread) {
                        sprintf(w,"%u",user[cp]->lastread[user[cp]->currmsgarea->number - 1] + 1);
                    }
                    break;

                case 81:    /* line # */
                    sprintf(w,"%u",cp);
                    break;

                case 82:    /* various date/time stuff */
                case 83:
                case 84:
                case 85:
                case 86:
                case 87:
                case 88:
                case 89:
                    {
                        time_t t;
                        struct tm *tm;

                        t = time(NULL);
                        tm = localtime(&t);
                        switch(c) {
                            case 82:    /* month (abbr) */
                                strftime(w,18,"%b",tm);
                                break;

                            case 83:    /* day (abbr) */
                                strftime(w,18,"%a",tm);
                                break;

                            case 84:    /* year */
                                strftime(w,18,"%Y",tm);
                                break;

                            case 85:    /* month (numeric) */
                                strftime(w,18,"%m",tm);
                                break;

                            case 86:    /* day (numeric) */
                                strftime(w,18,"%d",tm);
                                break;

                            case 87:    /* month (string) */
                                strftime(w,18,"%B",tm);
                                break;

                            case 88:    /* day (string) */
                                strftime(w,18,"%A",tm);
                                break;

                            case 89:    /* time */
                                strftime(w,18,"%H:%M:%S",tm);
                                break;
                        }
                    }
                    break;

                case 90:    /* clear screen */
                    if(user[cp] && user[cp]->attribs & U_ANSI)
                      strcat(w,"\x1b[2J");
                    else
                      strcat(w,"\xc");
                    break;

                case 91:    /* last user input */
                    if(modems[cp] && *modems[cp]->laststring)
                      strcat(w,modems[cp]->laststring);
                    break;

                case 92:  /* k stuff in bytes instead of k */
                    sprintf(w,"%lu",user[cp]->ulk * 1024L);
                    break;

                case 93:
                    sprintf(w,"%lu",user[cp]->dlk * 1024L);
                    break;

                case 94:
                    sprintf(w,"%lu",user[cp]->uktoday * 1024L);
                    break;

                case 95:
                    sprintf(w,"%lu",user[cp]->dktoday * 1024L);
                    break;

                case 96:
                    sprintf(w,"%lu",user[cp]->ukperday * 1024L);
                    break;

                case 97:
                    sprintf(w,"%lu",user[cp]->dkperday * 1024L);
                    break;

                case 98:
                    sprintf(w,"%lu",(user[cp]->dkperday - user[cp]->dktoday) * 1024L);
                    if(*w == '-')
                      strcpy(w,"0");
                    break;

                case 99:
                    sprintf(w,"%lu",user[cp]->dkperday - user[cp]->dktoday);
                    if(*w == '-')
                      strcpy(w,"0");
                    break;

                case 100: /* next two are in kb */
                    sprintf(w,"%lu",(user[cp]->ukperday - user[cp]->uktoday) * 1024L);
                    if(*w == '-')
                      strcpy(w,"0");
                    break;

                case 101:
                    sprintf(w,"%lu",user[cp]->ukperday - user[cp]->uktoday);
                    if(*w == '-')
                      strcpy(w,"0");
                    break;

                case 10000: /* comhandle */
                    sprintf(w,"%01d",modems[cp]->mh);
                    break;

                default:
                    if(c >= 32000 && c <= 32030) {
                      if(user[cp] && (user[cp]->attribs & U_COLOR)) {
                        strcat(w,atbl[c - 32000]);
                      }
                    }
                    else if(c > 32100 && c <= 32355) {
                      if(user[cp] && (user[cp]->attribs & U_COLOR)) {

                        char scratch[21];

                        strcat(w,ava2ansi(cp,c - 32100,scratch));
                      }
                    }
                    else {
                        dprintf(D_LOCAL,cp,"\r\n\04Unrecognized metacommand %d\r\n",c);
                    }
                    break;
            }
            w += strlen(w);
            continue;
        }
        else {
            *w = *p;
            w++;
            p++;
        }
    }

    free(instring);
    w = bbs_strdup(cp,work);
    if(w) {
        bbs_free(cp,work);
        return w;
    }

    return work;
}


static char *a2atranstable[] = {"0","4","2","6","1","5","3","7"};

#define A_BLINK   128
#define A_BRIGHT  8
#define A_LOMASK  7
#define A_HIMASK  112
#define A_BLACK   0
#define A_BLUE    1
#define A_GREEN   2
#define A_CYAN    3
#define A_RED     4
#define A_MAGENTA 5
#define A_BROWN   6
#define A_GREY    7

char * _fastcall ava2ansi (USHORT cp,int avacode,char *ansioutput) {

  /* construct color ansi escape sequence from avatar-like number */

  int         foreground;
  int         background;

  if(!user[cp] || !(user[cp]->attribs & U_COLOR)) {
    *ansioutput = 0;
    return ansioutput;
  }

  avacode &= 255;    
  strcpy(ansioutput,"\x1b[");
  background = (avacode & A_HIMASK) >> 4;
  foreground = (avacode & A_LOMASK);
  if (avacode & 8) {
      strcat(ansioutput,"0;1;");
  }
  else strcat(ansioutput,"0;");

  if (!background) {
      strcat(ansioutput,"3");
      strcat(ansioutput,a2atranstable[foreground]);
  }
  else {
      strcat(ansioutput,"3");
      strcat(ansioutput,a2atranstable[foreground]);
      strcat(ansioutput,";4");
      strcat(ansioutput,a2atranstable[background]);
  }
  strcat(ansioutput,"m");
  return ansioutput;
}
