/*
 *  bmg.c ->    Boyer-Moore-Gosper search routines
 *
 * Adapted from:
 *   Boyer/Moore/Gosper-assisted 'egrep' search, with delta0 table as in
 *   original paper (CACM, October, 1977).  No delta1 or delta2.  According to
 *   experiment (Horspool, Soft. Prac. Exp., 1982), delta2 is of minimal
 *   practical value.  However, to improve for worst case input, integrating
 *   the improved Galil strategies (Apostolico/Giancarlo, Siam. J. Comput.,
 *   February 1986) deserves consideration.
 *
 *   James A. Woods                 Copyright (c) 1986
 *   NASA Ames Research Center
 *
 * 29 April 1986    Jeff Mogul  Stanford
 *  Adapted as a set of subroutines for use by a program. No
 *  regular-expression support.
 *
 * 29 August 1986   Frank Whaley    Beyond Words
 *  Trimmed for speed and other dirty tricks.
 */
#define INCL_DOS

#include <os2.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "bmg.h"


/*
 *  bmgCompile() -> compile Boyer-Moore delta table
 *
 *  bmgCompile() compiles the delta table for the given search string, and
 *   initializes the search argument structure.  This structure must be
 *   passed to the bmgSearch() function described below.
 */


void _fastcall bmgCompile(char *pat, bmgARG *arg, int ignore)

    {
    int i,          /*  general ctr     */
        patlen;     /*  pattern length  */


    patlen = strlen(pat);

    strcpy(arg->pat, pat);
    if ((arg->ignore = (char) ignore) != 0)
        strlwr(arg->pat);

    memset(arg->delta, patlen, 256);

    for (i = 0; i < patlen; ++i)
        arg->delta[pat[i]] = (char) (patlen - i - 1);

    if (ignore) /*  tweak upper case if ignore on  */
        for (i = 0; i < patlen; ++i)
            arg->delta[toupper(pat[i])] = (char) (patlen - i - 1);
    }


/*
 *  bmgSearch() ->  scan for match
 *
 *  bmgSearch() performs a Boyer-Moore-Gosper search of the given buffer
 *   for the string described by the given search argument structure.  The
 *   match action function "action" will be called for each match found.
 *   This function should return non-zero to continue searching, or 0 to
 *   terminate the search.  bmgSearch() returns the total number of
 *   matches found.  (NOTE: this comment appears to be incorrect)
 */

char * _fastcall bmgSearch(char * buffer, size_t buflen, bmgARG *arg)

    {
    char    *s;     /*  temp ptr for comparisons    */
    int inc,        /*  position increment      */
        patlen;     /*  pattern length      */
    size_t  k;      /*  current buffer index    */


    k = (patlen = strlen(arg->pat)) - 1;

    for (;;)
        {
        while (((inc = arg->delta[buffer[k]]) != 0) &&
            ((k += inc) < buflen))
            ;
        if (k >= buflen)
            break;

        s = buffer + (k++ - (patlen - 1));
        if (!(arg->ignore ? strnicmp(s, arg->pat, patlen) : strncmp(s, arg->pat, patlen)))
            return (s);
        }

    return (NULL);
    }


char * _fastcall stristr (char *t, char *s);


char * _fastcall bmgStrstr (char *find,char *in,int ignore) {

/*

    This shit doesn't work reliably.  Keeping it plugged in in case I
    someday find some FUNCTIONAL code.

    static bmgARG arg;
    static char   last[bmgMAXPAT + 1] = "";
    int           len;
    char          *p;


    DosEnterCritSec();
      if(strcmp(last,find)) {
          memset(&arg,0,sizeof(bmgARG));
          memset(last,0,sizeof(last));
          len = strlen(find);
          strncpy(last,find,min(last,bmgMAXPAT));
          bmgCompile(last,&arg,ignore);
      }
      p = bmgSearch(in,strlen(in),&arg);
    DosExitCritSec();
    return p;
*/

    if(ignore) return stristr(in,find);
    else return strstr(in,find);
}

/*
 *  END of bmg.c
 */
