/*********************************************************************/
/* This module handles memory allocation for the bbs threads in such */
/* a way that it can be freed en masse after the thread ends         */
/* Also affords meager protection against freeing NULL pointers...   */
/*********************************************************************/

#include "mailer.h"
#include "xmisc.h"


    #define MAXMEMHANDLES 1249

    void **bbs_memhandles[MAXINSTANCES]; /* memory handles */



void _fastcall init_memhandles (USHORT cp) {

    /* allocate handles for a line and set all to NULL to initialize */

    int y;


    bbs_memhandles[cp] = (void **)malloc(sizeof(void *) * MAXMEMHANDLES);
    for(y = 0;y < MAXMEMHANDLES;y++) {
        bbs_memhandles[cp][y] = NULL;
    }
}



void * _fastcall bbs_malloc (USHORT cp,size_t size) {

    /* mallocate some memory to a handle if one is available */

    int x;


    if((int)cp == -1) {
        return malloc(size);
    }

    for(x = 0;x < MAXMEMHANDLES;x++) {
        if(bbs_memhandles[cp][x] == NULL) {
            bbs_memhandles[cp][x] = malloc(size);
            return bbs_memhandles[cp][x];
        }
    }
    return NULL;    /* out of memory handles */
}



void * _fastcall bbs_savealloc (USHORT cp,void *ptr) {

    /* insert already allocated memory into the bbs chain */

    int x;


    if((int)cp == -1 || !ptr) {
        return ptr;
    }

    for(x = 0;x < MAXMEMHANDLES;x++) {
        if(bbs_memhandles[cp][x] == NULL) {
            bbs_memhandles[cp][x] = ptr;
            return bbs_memhandles[cp][x];
        }
    }

    free(ptr);
    return NULL;    /* out of memory handles; can't save it */
}



void * _fastcall bbs_realloc (USHORT cp,void *handle,size_t size) {

    /* reallocate some memory for a handle */

    int x;

    if(handle == NULL)
      return bbs_malloc(cp,size);

    if((int)cp == -1) {

        void * h;

        h = realloc(handle,size);
        if(h || size == 0)
          return h;
        return handle;
    }

    for(x = 0;x < MAXMEMHANDLES;x++) {
        if(bbs_memhandles[cp][x] == handle) {
            handle = realloc(bbs_memhandles[cp][x],size);
            if(handle || size == 0)
              bbs_memhandles[cp][x] = handle;
            return handle;
        }
    }
    return NULL;
}






char * _fastcall bbs_strdup (USHORT cp,const char *str) {

    char *s;

    /* strdup that uses bbs_malloc() */


    if((int)cp == -1)
      return strdup(str);

    s = bbs_malloc(cp,strlen(str) + 1);   /* allocate enough memory */
    if(s) {
      strcpy(s,str);  /* transfer the string */
      return s;       /* return the handle */
    }
    return NULL;
}





void _fastcall bbs_free (USHORT cp,void *handle) {

    /* free memory associated with a memory handle and allow handle to be */
    /* reused */

    int x;


    if(handle == NULL) return;

    if((int)cp == -1) {
        free(handle);
        return;
    }

    for(x = 0;x < MAXMEMHANDLES;x++) {
        if(bbs_memhandles[cp][x] == handle) {
            free(bbs_memhandles[cp][x]);
            bbs_memhandles[cp][x] = NULL;
            return;
        }
    }
}





void _fastcall bbs_freeall (USHORT cp) {

    /* free all memory associated with a given bbs thread */

    int x;


    if(bbs_memhandles[cp]) {
        for(x = 0;x < MAXMEMHANDLES;x++) {
            if(bbs_memhandles[cp][x]) {
                free(bbs_memhandles[cp][x]);
            }
        }
        free(bbs_memhandles[cp]);
        bbs_memhandles[cp] = NULL;
    }
}


void * _fastcall memdupe (void *buf,int size) {

  void *abuf = NULL;

  if(size) {
    abuf = malloc(size);
    if(abuf)
      memcpy(abuf,buf,size);
  }
  return abuf;
}


void * _fastcall bbs_memdupe (USHORT cp,void *buf,int size) {

  void *abuf = NULL;

  if(size) {
    abuf = bbs_malloc(cp,size);
    if(abuf)
      memcpy(abuf,buf,size);
  }
  return abuf;
}
