/*
 * procedure to test XBBS' REXX interface
 * some notes:
 * you should not use things in Rexx that use stdin or stdout
 * you should not change the directory or drive
 * you should not execute DOS programs without START or XBBSCALL type 1
 * you should not use external programs that use stdin or stdout
 *   without XBBSCALL type 2 or 3
 */

/* get line #; used in all XBBS-provided functions as first arg */
arg cp

/* clear the screen */
xbbscls(cp)

/* output */
xbbsprint(cp,'\r\nHowdy there, [9].  Type something:\r\n')

/* simple input */
what = xbbsinput(cp)

/* echo it to prove we got it */
xbbsprint(cp,'\r\nYou typed: "',what,'"')

/* check remaining time; could follow cp with seconds to set remaining time */
timeleft = xbbstimeleft(cp)
xbbsprint(cp,'\r\nYou have ',trunc(timeleft / 60),' minutes left.\r\n')

/* convert a string */
astring = xbbsconvert(cp,'\r\n[9] is still your name.\r\n')
xbbsprint(cp,astring)

/*
 *  following is a more complicated example of input.  You could also add
 * a help keyname and help file, and a default after that.
 */

xbbsinput(cp,1,1,8,32 + 64,'Press any key: ')

xbbsprint(cp,'\r                \r\n')  /* that's all, folks */
xbbslog(cp,'You ran rexxtest.cmd')      /* demonstrate logging */
