/* MACROS! */
#ifndef BBSDEF_H_DEF
#define BBSDEF_H_DEF

#define MSGTXT(SZ)      (StartM+((unsigned short)(SZ)*81U))
#define WildStrCmp(P,T) (wstrcmp(P,T)!=TRUE)

#ifdef __MSDOS__
#define GiveTimeSlice(); { _AX=GiveTimeSliceAX; geninterrupt(GiveTimeSliceINT); }
#define SetHighPriority()
#define SetRegularPriority()
#define SetLowPriority()
#endif

#ifdef __BORLANDC__
#define CursorOff()     _setcursortype(_NOCURSOR)
#define CursorOn()      _setcursortype(_NORMALCURSOR)
#define CursorSolid()   _setcursortype(_SOLIDCURSOR)
#define SetUserCursor() _setcursortype(User.Insert ? _NORMALCURSOR : _SOLIDCURSOR)
#define FFBLK ffblk
#define FindFirst       findfirst
#define FindNext        findnext
#define FindClose(a)
#endif


#ifdef __WATCOMC__
#define FFBLK find_t
#define ff_fsize size
#define FindFirst       dos_findfirst
#define FindNext        dos_findnext
#define FindClose(a)
#endif


#ifdef __IBMC__
#define SH_DENYNONE SH_DENYNO
struct FFBLK {
  #ifdef __OS2__
  unsigned char ff_name[256];
  #endif
  #ifdef __DOS__
  unsigned char ff_name[13];
  #endif
  unsigned long ff_fsize;
  unsigned long phDir;
  unsigned long Count;
};
#endif


/* EXIT CODES */
#define EXIT_NORMAL       0
#define EXIT_BADARGS      1
#define EXIT_BADCONFIG    2
#define EXIT_OUTOFMEM     3
#define EXIT_GURU         4
#define EXIT_FILEERROR    5
#define EXIT_COMERROR     6
#define EXIT_UNKNOWNERR  10
#define EXIT_EVENTBASE  100

/* Filearea sorting modes */
#define SORT_NONE         0  /* No any sorting */
#define SORT_ALPHA        1  /* Sort files alphabetically */
#define SORT_UPLOADDATE   2  /* Sort files by upload date */
#define SORT_FILESIZE     3  /* Sort files from smalles to biggest */
#define SORT_EXTENSION    4  /* Sort files using extension */


/* Log WriteModes */
#define LOG_NORMAL      '-'  /* All others */
#define LOG_NOTICE      '+'  /* Notice, new files, messages etc */
#define LOG_WARN        '*'  /* Warning, something odd or newuser */
#define LOG_CRITICAL    '!'  /* Errors */ 

/* File transfer defines */
#define T_UPLOAD        1
#define T_DOWNLOAD      2
#define T_OTHER         3


/* TypeMenu defines */
#define TM_NONE         0x00
#define TM_MORE         0x01
#define TM_COMPLAIN     0x02

/* Offline types */
#define QWK_UPLOAD      1
#define QWK_DOWNLOAD    2
#define OMEN_UPLOAD     3
#define OMEN_DOWNLOAD   4



/* GENERAL DEFINES! */


#define CONFIGREV        8 /* Config revision */
#define SCRIPTREV        1
#define MAXRETRY        10 /* Max times to retry file opening */
#define BBSTXTSIZE     499 /* True size (lines) of bbstext! */
#define MAXLINES       500 /* Maximum lines in messages */
#define MAXCMD          90 /* Max len of command (rarely used) */
#define MAXCONF       4096 /* Maximum number of confs. 000-FFF */
#define MAXDOORS        64 /* Max doors (Config limitation) */
#define MAXFILEAREAS   256 /* Maximum number of fileareas */
#define MAXUMSG       4096 /* Maximum number of unread msgs in conf */
#define DELAYSIZE      500 /* If not in multitasking DelaySize. */

#define NAMELEN         30 /* Maximum User/Group name lenght */
#define PASSLEN         18 /* Maximum lenght of user password */
#define MAXPROTOCOLS    32 /* Max number of protocols */
#define MAXEVENTS       32 /* Max number of events */
#define MAXFLAGS       128 /* Max number of flagged files */
#define MAXAUTOINDENT   40
#define MAXDESCLEN      47 /* Maximum file description line len */
#define MAX_AKA         16 /* Max network addressed. One AKA takes 12 bytes */
#define MAXLINEDELUNDO  24 /* How many deleted lines editor can undo */
#define MAXUSERGROUPS   32 /* Maximum number of user groups */

#define FILENAMELEN     64 /* VBoard datafiles max path len = 40+12+1+3 */

#define ON               1 /* Just generally used defines */
#define OFF              0
#define TRUE             1
#define FALSE            0
#define SAVE             1
#define RESTORE          0
#define FLUSH_DELAY      200
#define CONF_NOT_PRESENT 0xffff
#define OPEN_WITH_RDWR   0xfe   /* Only FastLoadMsgHeader()! */

/* Memory allocation */

#define SWAP_GET       0x80  /* 1000 0000 */
#define SWAP_FREE      0x40  /* 0100 0000 */

#define SWAP_MSGTXT    0x01
#define SWAP_MSGBASE   0x02
#define SWAP_MEMCONF   0x04

#define SWAP_ALL       (SWAP_MSGTXT | SWAP_MSGBASE | SWAP_MEMCONF)

/* Extended return functions */
#define NODEMESSAGE     1
#define SYSOPCHATREQ    2
#define NOCARRIER       3
#define EXTENDEDOK    255

/* SysOp availability */
#define USEINISETS      0
#define FORCED_ON       1
#define FORCED_OFF      2

/* SysOp bits */
#define SYS_CONFERENCES    1
#define SYS_PRIVATEMAIL    2
#define SYS_MODIFYFILES    4
#define SYS_DELETEFILES    8
#define SYS_EXITTODOS     16
#define SYS_KILLUSER      32
#define SYS_EDITUSERS     64
#define SYS_USERGROUPS   128

/* User status bits */
#define US_CHATREQ            0x0001 /* Chat request on */
#define US_HIDED              0x0002 /* User is hided */
#define US_NONAVAIL           0x0004 /* Not available */
#define US_NEWFCHECK          0x0008 /* New files checked */
#define US_CHATTING           0x0010 /* Chatting in group */
#define US_TEMPSYSOP          0x0020 /* User has temporary sysop on */
#define US_LOGINCOMMAND       0x0040 /* User is executing login command */
#define US_INALIAS            0x0080 /* User is executing alias command */
#define US_NOCHAT             0x0100 /* Sys Not wanting to chat... */
#define US_TIMELIMITED        0x0200 /* Time limited by MaxTimeLimit */
#define US_TIMEMODIFIED       0x0400 /* Got timemodify */
#define US_KICKEDBYSYSOP      0x0800 /* Kicked by another node */
#define US_SLEEPDISCONNECTED  0x1000 /* Sleep disconnected */
#define US_TEMPLOCALMODE      0x2000 /* Temp local mode */
#define US_FILELISTPACKED     0x4000 /* FileList has been downloaded */
#define US_CREDITSMODIFIED    0x8000 /* Group credit modify aplied */

#define SHOWMORE (US_CHATREQ | US_TEMPSYSOP | US_TEMPLOCALMODE)

/* Removing user status bits */
#define REMOVE_US_CHATREQ            (0xffff ^ US_CHATREQ)
#define REMOVE_US_HIDED              (0xffff ^ US_HIDED)
#define REMOVE_US_NONAVAIL           (0xffff ^ US_NONAVAIL)
#define REMOVE_US_NEWFCHECK          (0xffff ^ US_NEWFCHECK)
#define REMOVE_US_CHATTING           (0xffff ^ US_CHATTING)
#define REMOVE_US_TEMPSYSOP          (0xffff ^ US_TEMPSYSOP)
#define REMOVE_US_LOGINCOMMAND       (0xffff ^ US_LOGINCOMMAND)
#define REMOVE_US_INALIAS            (0xffff ^ US_INALIAS)
#define REMOVE_US_NOCHAT             (0xffff ^ US_NOCHAT)
#define REMOVE_US_TIMELIMITED        (0xffff ^ US_TIMELIMITED)
#define REMOVE_US_TIMEMODIFIED       (0xffff ^ US_TIMEMODIFIED)
#define REMOVE_US_KICKEDBYSYSOP      (0xffff ^ US_KICKEDBYSYSOP)
#define REMOVE_US_SLEEPDISCONNECTED  (0xffff ^ US_SLEEPDISCONNECTED)
#define REMOVE_US_TEMPLOCALMODE      (0xffff ^ US_TEMPLOCALMODE)

#define MENU_MAIN       1
#define MENU_READ       2
#define MENU_FILE       3
#define MENU_SYSOP      4
#define MENU_QWK        5
#define MENU_OMEN       6
#define MENU_BULLETINS  7

/* GROUP ATTRIBUTES */
#define GRP_SHOWMEMBERS     0x01 /* Members will be shown to nonmembers */
#define GRP_HIDDENGROUP     0x02 /* Group is hidden from nonmembers */
#define GRP_USERMAYJOIN     0x04 /* User may freely join the group */
#define GRP_FILESFREE       0x08 /* Private files are free to members */
#define GRP_FILESPRIVATE    0x10 /* Show files to nonmembers */
#define GRP_MODIFYDLCREDITS 0x20 /* Group modifies download credits */
#define GRP_FILESONLYDLABLE 0x40 /* Show files to all, only members can download */
#define GRP_FILEISTOGROUP   0x80 /* Show File is to group: Xxx line */


/* GROUP FILE CAN-I-SEE-IT RETURN VALUES*/
#define GFILEPRIVATE  1
#define GFILEHIDDEN   2

/* USEREDITOR SEARCH TYPES */
#define SEARCH_NAMEPATTERN     1
#define SEARCH_ADDRESSCITYECT  2
#define SEARCH_NEWUSER         3
#define SEARCH_KILLEDORNOLOGIN 4
#define SEARCH_GROUPMEMBERSHIP 5
#define SEARCH_USERBITSET      6
#define SEARCH_CALLEDSINCE     7
#define SEARCH_NOTCALLEDSINCE  8
#define SEARCH_CALLEDMORE      9
#define SEARCH_UPLOADEDMORE   10
#define SEARCH_DOWNLOADEDMORE 11

/* DIRECTIONS */
#define UP  1
#define DOWN    2
#define RIGHT   3
#define LEFT    4

/* KEYS */
#define NORMALKEYS    1
#define EMACSKEYS     2

#define KEYTAB       'I'-64
#define KEYESC       27
#define KEYBS        'H'-64
#define KEYDEL       127
#define KEYENTER     'M'-64

#define KEYUP        'E'-64
#define KEYDOWN      'X'-64
#define KEYRIGHT     'D'-64
#define KEYLEFT      'S'-64
#define KEYHOME      'G'-64
#define KEYEND       'J'-64
#define KEYPAGEUP    'R'-64
#define KEYPAGEDOWN  'C'-64

#define KEYSAVE      'Z'-64
#define KEYABORT     'Q'-64
#define KEYDELLINE   'Y'-64
#define KEYINSLINE   'O'-64
#define KEYUNDODEL   'B'-64
#define KEYQUOTE     'W'-64
#define KEYHELP      'U'-64
#define KEYREDRAW    'N'-64

#define KEYBACKWORD  'A'-64  /* Word back */
#define KEYFORWORD   'F'-64  /* Word forward */
#define KEYDELWORD   'T'-64
#define KEYMENU      'K'-64
#define KEYTOGLEINS  'V'-64
#define KEYXYTOGLE   'L'-64
#define KEYJUSTIFY   'P'-64

/* COLORS */
#define BLACK    0
#define RED      1
#define GREEN    2
#define YELLOW   3
#define BLUE     4
#define MAGENTA  5
#define CYAN     6
#define WHITE    7
#define BRIGHT   8

/* WHO DEFINES */
#define LOGOFF        0
#define ACTIVE        1
#define NOTAVAIL      2
#define ENTERING      3
#define GRABBING      4
#define DOWNLOAD      5
#define UPLOAD        6
#define SYSCHAT       7
#define INDOOR        8
#define GROUBCHAT     9
#define COMMENTING   10
#define UNUSEDDOING2 11
#define UNUSEDDOING3 12

/* WILDCARDS DEFINES */
#define PARAM_ALL           1
#define PARAM_ASK           2
#define PARAM_UNREAD        4
#define PARAM_LOCAL         8
#define PARAM_NET          16
#define PARAM_YES          32
#define PARAM_NO           64
#define PARAM_NONSTOP     128
#define PARAM_WILD        256
#define PARAM_NUMBER      512
#define PARAM_ONLYONE    1024


#define REMOVE_NONSTOP (0xffff ^ PARAM_NONSTOP)


/* TERMINALS */
#define TERM_TTY      0
#define TERM_ANSI     1
#define TERM_VT100    2
#define TERM_AVATAR   3
#define TERM_RIPTERM  4

/* MSG HEADERS */
#define MSGHFULL      0
#define MSGHMED       1
#define MSGHTINY      2

/* MSG READING DIRECTIONS */
#define FORWARD       0
#define REFERENCE     1


/* USER SETABLE COLORS */
#define BACKGROUND User.Palette01
#define MAINCMD    User.Palette02
#define READCMD    User.Palette03
#define FILECMD    User.Palette04
#define DANGER     User.Palette05 /* Dangerous commands */
#define OFFLINE    User.Palette06 /* Not set. */

#define EDITOR1    User.Palette07 /* Editor text        */
#define EDITOR2    User.Palette08 /* Infos              */
#define MSGTEXT    User.Palette09 /* Message text       */
#define QUOTES     User.Palette10 /* Quote color        */
#define OWNNAME    User.Palette11 /* Own name in messages */
#define OTHERNAMES User.Palette12 /* Others names       */

#define DEFTEXT    User.Palette13
#define CHEADER    User.Palette14
#define NODEMSGS   User.Palette15
#define AREANAME   User.Palette16 /* Confname at messagemenu/filemenu */

#define NAFILE     User.Palette17 /* Unavailable file */
#define FREEFILE   User.Palette18
#define PRIVFILE   User.Palette19
#define FILENAMES  User.Palette20 /* Filenames */
#define DESCS      User.Palette21 /* Descriptions */
#define CMDLINE    User.Palette22
#define ERROR      User.Palette23
#define MSGHEADERC User.Palette24
#define SUBJECT    User.Palette25
#define MSGEDIT    User.Palette26
#define HELPTEXT   User.Palette27
#define HELPKEYW   User.Palette28


#define CL_DEFAULT       (CL_HISTORY | CL_SAVEHISTORY | CL_NEWLINE)
#define CL_FILELISTFLAG  (CL_HISTORY | CL_SAVEHISTORY)

#define CL_NONE          0x00
#define CL_HISTORY       0x01
#define CL_SAVEHISTORY   0x02
#define CL_NEWLINE       0x04  /* Only when field ?? */
#define CL_SPECIALLINE   0x08  /* Added */
#define CL_NUMBERS       0x10
#define CL_NONODEMSG     0x40
#define CL_SHOWAREA      0x80  /* Edit, eh? */


typedef unsigned short MSGNUM;
typedef unsigned short CONFNUM;

typedef unsigned short FILENUM;
typedef unsigned short AREANUM;

typedef unsigned short USERNUM;



typedef struct {            /* Takes only 5 chars */
  unsigned char Day;
  unsigned char Month;
  unsigned char Year;
  unsigned char Min;
  unsigned char Hour;
} DATE;


typedef struct {                /* Takes only 3 chars */
  unsigned char Day;
  unsigned char Month;
  unsigned char Year;
} SDATE;


typedef struct {
  unsigned long  Mystic;            /* VBOARD.DAT */
  unsigned short SerNum;
  unsigned char  Versio[31];
  unsigned char  RegisteredTo[31];
  unsigned char  Reserved[128];
} VBOARDDAT;




typedef struct {              /* CONFIG RECORD * CONFIG RECORD * CONFIG RECORD */
  unsigned char  BBSName[41];
  unsigned char  SysOpName[NAMELEN];

  unsigned char  SystemPass[13];
  unsigned char  NewUserPass[13];

  unsigned char  ShellPass[13];
  unsigned char  UEditPass[13];
  unsigned char  ShellExec[49];

  unsigned char  QWKName[9];
  unsigned char  OmenId[3];

  /* Group settings */
    signed char  GroupTimeModify[32];
  unsigned short GroupMaxCredits[32];
  unsigned short GroupDailyAdd[32];
  unsigned char  GroupDlCreditModify[32];

  unsigned char  ProtNames[120];
  unsigned char  UnUsed_6_Bytes[6];     /* Use with caution, not zero */

  /* Group settings II */
  unsigned char  GroupName[32][NAMELEN];
  unsigned char  GroupType[32];

  unsigned char  Macro[10][51];
  unsigned short DoNotUseMaxNodes;      /* Obsolite */

  unsigned long  RegCode1;
  unsigned long  RegCode2;
  unsigned long  RegCode3;
  unsigned long  RegCode4;
  unsigned char  RegName[NAMELEN];
} GCONFIG;


typedef struct {
  /* General */
  unsigned char  FieldColor;
  unsigned char  PollRate;
  unsigned short WaitingSleep;
  unsigned char  SysOpChatColor;
  unsigned char  UserChatColor;
  unsigned char  AskSotuTimes; /* Times to allow re-enter sotu.. */

  /* NewBie */
  unsigned short NewUserTime;
  unsigned short NewUserCredits;

  /* Modem */
  unsigned char  ModemInit[40];
  unsigned char  ModemBusy[20];
  unsigned char  ExitFree[20];
  unsigned char  ExitBusy[20];
  unsigned long  StartBaud;
  unsigned char  ComPort;

  /* Packers */
  unsigned char  PackCmd[5][40];
  unsigned char  UnPackCmd[5][40];
  unsigned char  TestPackCmd[5][40];

  /* Directories */
  unsigned char  BBSDir[40];
  unsigned char  MainDir[40];
  unsigned char  MenuDir[40];
  unsigned char  PackDir[40]; /* Used for packking messages */
  unsigned char  FileDir[40];
  unsigned char  TempUp[40];
  unsigned char  HoldDir[40]; /* Used ONLY for extracting files */
  unsigned char  NodeDir[40]; /* Directory for who and nodemessages */

  /* CreditSystem */
  unsigned short Credit1Lim;
  unsigned short Credit2Lim;
  unsigned short Credit3Lim;

  unsigned char  Credit1Mul;
  unsigned char  Credit2Mul;
  unsigned char  Credit3Mul;
  unsigned char  Credit4Mul;

  /* Bits */
  unsigned ResetSpeed       : 1;
  unsigned RTSCTS           : 1;
  unsigned HangUp           : 1;  /* Hangup after call */
  unsigned DTRHangUp        : 1;  /* Requires Fossil or OS/2 */

  unsigned DirectVideo      : 1;
  unsigned ShowEmptyNode    : 1;
  unsigned AllowSysKeys     : 1;
  unsigned ShowNewFiles     : 1;

  unsigned NewUserUp        : 1;
  unsigned NewUserDown      : 1;

  unsigned NewUsersToBBS    : 1;
  unsigned UseCredits       : 1;
  unsigned KillEmptyLines   : 1;

  /* Files */
  unsigned DeleteDamaged    : 1;
  unsigned UseFileDiz       : 1;
  unsigned UseVirusScan     : 1;

  struct NewHourRecord {
    unsigned long  MinBps;
    unsigned short MaxDlTime;
    unsigned short MaxTimeLim;
    signed   short TimeModify;
    unsigned AnswerPhone    : 1;
    unsigned AllowChat      : 1;
    unsigned AllowYell      : 1;
    unsigned BeepYell       : 1;
    unsigned UnUsed         : 4;
  } Hour[24];

  /* New things in version 1.00/Beta9 */
  struct ExtendedNewHourRec {
    unsigned short FavMaxTimeLim;
    unsigned short FavTimeModify;
    unsigned short MaxTimeUsage;
    unsigned char  UnUsedSetting[10];
  } EHour[24];

  unsigned char  Extensions[16][4];
  unsigned short ExtensionModify[16];

  unsigned NewUserDoors     : 1;
  unsigned UseFileIdDiz     : 1;

  unsigned NewUserAutoRead  : 1;
  unsigned NewUserReadMode  : 1;
  unsigned NewUserNumPrompt : 1;
  unsigned NewUserCls       : 1;
  unsigned NewUserFullMsgV  : 1;

  unsigned NotUsedYet7bits  : 1;

  unsigned short WarnHDSpace;
  unsigned short DenyUpHDSpace;

  unsigned short FullCreditsMaxDays;
  unsigned short NoCreditsDays;

  unsigned Palette01    : 4;         /* Max 32 definable colors */
  unsigned Palette02    : 4;
  unsigned Palette03    : 4;
  unsigned Palette04    : 4;
  unsigned Palette05    : 4;
  unsigned Palette06    : 4;
  unsigned Palette07    : 4;
  unsigned Palette08    : 4;
  unsigned Palette09    : 4;
  unsigned Palette10    : 4;
  unsigned Palette11    : 4;
  unsigned Palette12    : 4;
  unsigned Palette13    : 4;
  unsigned Palette14    : 4;
  unsigned Palette15    : 4;
  unsigned Palette16    : 4;
  unsigned Palette17    : 4;
  unsigned Palette18    : 4;
  unsigned Palette19    : 4;
  unsigned Palette20    : 4;
  unsigned Palette21    : 4;
  unsigned Palette22    : 4;
  unsigned Palette23    : 4;
  unsigned Palette24    : 4;
  unsigned Palette25    : 4;
  unsigned Palette26    : 4;
  unsigned Palette27    : 4;
  unsigned Palette28    : 4;
  unsigned Palette29    : 4;
  unsigned Palette30    : 4;
  unsigned Palette31    : 4;
  unsigned Palette32    : 4;

  unsigned char  IRQ;
  unsigned char  NotUsedBytes[231];
} NCONFIG;


typedef struct {
  unsigned char Name[NAMELEN];
  unsigned char EventExec[57];
  unsigned char Hour;
  unsigned char Min;
  unsigned Monday        : 1;
  unsigned Tuesday       : 1;
  unsigned Wednesday     : 1;
  unsigned Thursday      : 1;
  unsigned Friday        : 1;
  unsigned Saturday      : 1;
  unsigned Sunday        : 1;
  unsigned ExecAsProcess : 1;
  SDATE    LastRun;
  unsigned ExecuteToday  : 1;
  unsigned ExecuteAsVDM  : 1;
  unsigned ExitAfterStart: 1;
  unsigned UnUsed        : 5;
  unsigned char Reserved[124];
} EVENT;


typedef struct {                /* Version 1.17/Rev A change! */
  unsigned short OwnZone;
  unsigned short OwnNet;
  unsigned short OwnNode;

  unsigned short HubZone;
  unsigned short HubNet;
  unsigned short HubNode;
} AKAREC;


typedef struct {
  unsigned char  Name[20];
  unsigned char  Upload[120];
  unsigned char  Download[120];
  unsigned char  DSZLogName[60];
  unsigned char  FileSeparator;
  unsigned char  GRUpload;
  unsigned char  GRDownload;
  unsigned char  Effiency;
  unsigned char  Reserved[19];
  unsigned AllowUpload      : 1;
  unsigned AllowDownload    : 1;
  unsigned BiDirectional    : 1;
  unsigned AllowBatch       : 1;

  unsigned CloseCOM         : 1;
  unsigned AskForName       : 1;
  unsigned UseListFile      : 1;
  unsigned ExecuteAsVDM     : 1;

  unsigned RemovesFailedUps : 1;
  unsigned CWDToTempUp      : 1;
  unsigned Unused           : 6;
} PROTOCOL;


/* NEW User structure for 1.21 */

typedef struct {
  /* User strings =========================================================*/
  unsigned char  Name[NAMELEN];   /* User name */
  unsigned char  Address[30];     /* User address */
  unsigned char  ZipCode[10];     /* Zip code.. */
  unsigned char  City[30];        /* User City */
  unsigned char  Phone[15];       /* User Phone */
  unsigned char  Occup[30];       /* What the user does */
  unsigned char  Alias[NAMELEN];  /* User AliasName */
  unsigned char  Pass[16];        /* Password max 12 characters */

  /* User limits and stats ================================================*/
  unsigned short TimeLimit;       /* User timelimit */
  unsigned short TimeUsedToday;   /* Time used today, MUCH more useful. */
    signed short SysTimeModify;   /* Extra time given or taken for today */
    signed long  FileCredits;     /* Credits left! */
  unsigned short DailyDlLimit;    /* Reserved for future use, not in use yet */
  unsigned short ResumeNumber;    /* max 64k-1 */

  unsigned short TotalCalled;     /* Total times called */
  unsigned short MessagesLeft;
  unsigned long  MessagesRead;
  unsigned long  MessagesDump;    /* Messages dumped */
  unsigned short FilesUploaded;   /* Number of files uploaded.. */
  unsigned short FilesDownloaded;
  unsigned long  BytesUploaded;
  unsigned long  BytesDownloaded;

  unsigned char  PageLength;      /* Lines per page */
  unsigned short MaxPackMsg;      /* Max messages to pack with QWK/OMEN */
  unsigned char  Language;        /* Language number */
  unsigned char  CharSet;         /* Charset number */
  unsigned char  Protocol;        /* Protocol number */
  unsigned char  Packer;          /* Packer number */
  unsigned char  Reserved_B1;     /* Reserved for future use */
  unsigned char  Reserved_B2;     /* Reserved for future use */
  unsigned char  Reserved_B3;     /* Reserved for future use */
  unsigned char  Reserved_B4;     /* Reserved for future use */

  /* String pointers ======================================================*/
  unsigned long  DoingActive;     /* Pointer User doing when active.. */
  unsigned long  LoginCommand;    /* Commands to be executed when logged in */
  unsigned long  CommandAlias;    /* Pointers to aliases to commands */
  unsigned long  SysNote;         /* Pointer to SysOps yellow sticker */
  unsigned long  Reserved_L1;     /* Plan: User has login node message coming from node X*/
  unsigned long  Reserved_L2;     /* Reserved for future use */
  unsigned long  Reserved_L3;     /* Reserved for future use */
  unsigned long  Reserved_L4;     /* Reserved for future use */

  /* User groups and bits =================================================*/
  unsigned long  UserGroups;      /* Max 32 user groups */
  unsigned short UserBits;        /* 16 SysOp setable bits */

  /* SysOp Access =========================================================*/
  unsigned char  SysOp;

  /* Dates ================================================================*/
  SDATE          Birth;           /* User Birth date */
  DATE           LastCall;        /* Last called     */
  SDATE          LastCheck;       /* Checkked new files */
  SDATE          ExpireDate;      /* UNUSED: Rights expire */

  /* Palette data - Max 32 definable colors ===============================*/
  unsigned Palette01    : 4;
  unsigned Palette02    : 4;
  unsigned Palette03    : 4;
  unsigned Palette04    : 4;
  unsigned Palette05    : 4;
  unsigned Palette06    : 4;
  unsigned Palette07    : 4;
  unsigned Palette08    : 4;
  unsigned Palette09    : 4;
  unsigned Palette10    : 4;
  unsigned Palette11    : 4;
  unsigned Palette12    : 4;
  unsigned Palette13    : 4;
  unsigned Palette14    : 4;
  unsigned Palette15    : 4;
  unsigned Palette16    : 4;
  unsigned Palette17    : 4;
  unsigned Palette18    : 4;
  unsigned Palette19    : 4;
  unsigned Palette20    : 4;
  unsigned Palette21    : 4;
  unsigned Palette22    : 4;
  unsigned Palette23    : 4;
  unsigned Palette24    : 4;
  unsigned Palette25    : 4;
  unsigned Palette26    : 4;
  unsigned Palette27    : 4;
  unsigned Palette28    : 4;
  unsigned Palette29    : 4;
  unsigned Palette30    : 4;
  unsigned Palette31    : 4;
  unsigned Palette32    : 4;

  /* BITS * BITS * BITS * BITS * BITS =====================================*/

  /* User attributes, 8 bits ==============================================*/
  unsigned NoLogin      : 1;  /* User has no acces to the system */
  unsigned Killed       : 1;  /* User is killed and may be removed in next clean */
  unsigned Guest        : 1;  /* Guest user */
  unsigned NoChat       : 1;  /* SysOp doesn't want to chat with you */
  unsigned NewUser      : 1;  /* New user, some extra info ?? */
  unsigned ReRegister   : 1;  /* Address info fuckked up, must refill */
  unsigned PassWarn     : 1;  /* Warn that someone has tried to login as him */
  unsigned UnUsed1      : 1;

  /* User access and favoured, 8 bits =====================================*/
  unsigned Upload       : 1;  /* User may upload files */
  unsigned Download     : 1;  /* User may download files if he has credits */
  unsigned Doors        : 1;  /* User may open doors! */
  unsigned Favoured     : 1;  /* Favoured user */
  unsigned UnUsed2      : 4;

  /* General settings, 8 bits =============================================*/
  unsigned Terminal     : 3; /* None, ANSI, VT102, AVATAR... */
  unsigned AutoHelp     : 1; /* Always type menus... */
  unsigned ConfCheck    : 1; /* Login conference check */
  unsigned LoginStatus  : 1; /* Show user status at login */
  unsigned AutoReadMenu : 1; /* Automatically go to read menu */
  unsigned ShowAInfo    : 1; /* Shows area info when joining */

  /* Node Message settings, 8 bits ========================================*/
  unsigned NodeMsgs     : 1; /* Want to know if other node entered msg? */
  unsigned NodeLogins   : 1; /* Login: Kalevi Kieppo */
  unsigned UnUsed3      : 6;

  /* File settings, 8 bits ================================================*/
  unsigned GRFileProt   : 1; /* if user have G&R */
  unsigned MoreAfterList: 1; /* Download file descs */
  unsigned UnUsed4      : 6;

  /* Colors and Bells, 8 bits =============================================*/
  unsigned ColorCmds    : 1; /* Colors in commands, who, userlist */
  unsigned ColorPrompts : 1; /* Colors in prompts */
  unsigned ColorMenus   : 1; /* Colors in menus */
  unsigned ColorMsgs    : 1; /* Colors in messages */
  unsigned ColorFiles   : 1; /* Colors in filelist */
  unsigned BeepNodeMsg  : 1; /* Beeping nodemessages */
  unsigned BeepOwnMsg   : 1; /* Beep if message is for you */
  unsigned BeepErrors   : 1; /* Beep when error */

  /* Colors and Bell's and whistles, 8 bits ===============================*/
  unsigned AnsiMusic    : 1; /* ANSI music allowed */
  unsigned UnUsed5      : 7;

  /* Message editor, 8 bits ===============================================*/
  unsigned FSE          : 1; /* Use FullScreen editor */
  unsigned Insert       : 1; /* Insert or overwrite */
  unsigned XYPos        : 1; /* Show cursor position ? */
  unsigned Indent       : 1; /* Autoindent ? */
  unsigned TabMovesTxt  : 1; /* Tab moves text in MsgEditor */
  unsigned DefReplySt   : 3; /* Default reply style */

  /* Other message reading etc settings, 8 bits ===========================*/
  unsigned ReadRef      : 1; /* Forward or Reference */
  unsigned FSEReader    : 1; /* Use full screen msg reader */
  unsigned UCaseNames   : 1; /* Upper case names in messages */
  unsigned UCaseOwnName : 1; /* Flash if message is for you */
  unsigned UnUsed6      : 4;

  /* Message reading, 8 bits ==============================================*/
  unsigned ClsBefore    : 1; /* Clear screen before a new message ? */
  unsigned MsgHeader    : 2; /* Full, Medium, Tiny, UnUsed */
  unsigned NbOfUnread   : 1; /* Number of unread messages in conf... */
  unsigned JoinStatus   : 1; /* Join status toggle */
  unsigned OwnMessages  : 1; /* ReRead own messges */
  unsigned UnUsed7      : 2;

  /* Offline settings, 8 bits =============================================*/
  unsigned NewBulletins : 1; /* Download new bulletins with QWK */
  unsigned NewFileList  : 1; /* DownLoad new files list with QWK */
  unsigned UnUsed8      : 6;
} USER;




#define MASK_OFFSET     0x0fffffffL
#define MASK_KILLED     0x80000000L
#define MASK_PRIVATE    0x40000000L
#define MASK_READ       0x20000000L
#define MASK_SENT       0x10000000L

#define MASK_ALL        0xf0000000L

typedef struct {
  unsigned short MsgFromN;      /* Message from user number */
  unsigned short MsgToN;        /* Message to user number */
  unsigned short ReplyTo;
  unsigned long  OffsetAttr;    /* SubMsgHeader record address & Masks */
} MSGHEAD;


typedef struct {
  unsigned char  MsgFrom[NAMELEN];
  unsigned char  MsgTo[NAMELEN];
  unsigned char  Subject[40];
  DATE           MsgDate;
  unsigned short Lines;

  unsigned char  RepliesMade;
  unsigned short FirstReply;

  unsigned short ZoneFrom;
  unsigned short NetFrom;
  unsigned short NodeFrom;

  unsigned MovedFrom     : 12;  /* Max 4096 confs. */
  unsigned MovedMsg      :  1;  /* Message has been moved from conf x. */
  unsigned OffLine       :  1;  /* Message entered offline */
  unsigned UnUsedBits    :  2;  /* Not yet used bits */
} SUBMSGHEAD;


typedef struct {
  unsigned short UserNumber;    /* Message from usernumber n */
  unsigned short MessageArea;   /* Area to write */
  unsigned short ReplyTo;       /* Reply to, FALSE if write */
  unsigned long  MessageCRC;    /* CRC of message ??? */
} OFFLINEDUPE;


#define CA_READ         0x01
#define CA_WRITE        0x02
#define CA_SIGOP        0x04
#define CA_MEMBER       0x08
#define CA_INVITED      0x10
#define CA_OBLIGATORY   0x20

#define CA_GRP_READ     0x40
#define CA_GRP_WRITE    0x80

typedef struct {
  unsigned char  Access;
  unsigned short LastRead;  /* Max messages in area is 2^19-1=M messua */
} CONFACCESS;


typedef struct {
  unsigned char  Name[41];
  unsigned char  EnterMsgText[24]; /* Wholla nkyy: Entering bullshit, Commenting*/
  unsigned char  NetName[20];      /* International Fido etc..*/
  unsigned char  AreaTag[30];
  unsigned char  SigOpName[NAMELEN];
  unsigned char  OriginLine[73];

  unsigned char  NodeNumber;
  unsigned char  Group;
  unsigned char  Scan;          /* New users get XX messages */
  unsigned char  MinRead;       /* Min messages to read */
  unsigned char  MinAge;        /* Minimum age...*/
  unsigned short ReplyConf; /* Replies will be saved to this conf */

  unsigned long  StartMsg;       /* Messages start at number */

  unsigned short ModZone;
  unsigned short ModNet;
  unsigned short ModNode;
  unsigned char  ModPoint;

  unsigned NewUserWrite : 1;
  unsigned Must         : 1;
  unsigned PostArea     : 1;
  unsigned Secret       : 1;

  unsigned NoReply      : 1;
  unsigned NoMark       : 1;
  unsigned Private      : 1;
  unsigned NetArea      : 1;

  unsigned Ascii7Bit    : 1;
  unsigned OffLineOnly  : 1;
  unsigned AliasConf    : 1;
  unsigned PostConf     : 1;
  unsigned ResumeConf   : 1;
  unsigned Convert8Bit  : 1;
  unsigned UnUsed       : 2; /* Reserved bits */

  unsigned char  UnUsed5[30];
  unsigned short HubZone;
  unsigned short HubNet;
  unsigned short HubNode;
  unsigned short HubPoint;
  unsigned short OwnZone;
  unsigned short OwnNet;
  unsigned short OwnNode;
  unsigned short OwnPoint;
  unsigned char  UnUsed2[15];
  unsigned char  NewUserAccess;
  unsigned char  UnUsed3[4];
  unsigned char  MsgDir[60];
  unsigned char  Description[40];
  unsigned char  UnUsed_10_bytes[10];
  unsigned char  GroupAccess[32];
} CONF;


typedef struct {
  unsigned char  Name[41];        /* FileArea name */
  unsigned char  Description[81]; /* FileArea description */
  unsigned char  Directory[41];   /* Directory to put files */
  unsigned char  AreaTags[121];   /* FileEcho area tags */

  unsigned short FHubZone;
  unsigned short FHubNet;
  unsigned short FHubNode;

  unsigned SendNewUploads : 1;    /* Hatch new uploads to echo */
  unsigned CDROMArea      : 1;    /* Exclude area from newfile scan.. */
  unsigned UnUsed         : 6;    /* Again some unused bits */

  unsigned short AreaIDByte;      /* Areas are sorted by filesort */
  unsigned short LastAreaIDByte;  /* Last subdirectory ID byte */
  unsigned short ParentAreaIDByte;/* Parent area ID byte, 0 if root area */

  unsigned long  SId;             /* Index START number */
  unsigned long  EId;             /* Index END number */
  unsigned short FilesInArea;     /* Statistics, updated by filesort only */
} NEW_FILEAREA; /* Version 1.99 */




/* New FileArea record for v1.06 => ... */
typedef struct {
  unsigned char  Name[41];      /* FileArea name */
  unsigned char  Directory[41]; /* Directory to put files */

  unsigned short PrivateTo;
  unsigned char  SortMethod;

  unsigned char  AreaTags[120]; /* FileEcho area tags */
  unsigned short FHubZone;
  unsigned short FHubNet;
  unsigned short FHubNode;

  unsigned SendNewUploads : 1;  /* Hatch new uploads to echo */
  unsigned CDROMArea      : 1;  /* Exclude area from newfile scan.. */
  unsigned UnUsed         : 6;  /* Again some unused bits */

  unsigned short AreaIDByte;    /* Areas are sorted by filesort */
  unsigned long  SId;           /* Index START number */
  unsigned long  EId;           /* Index END number */
  unsigned short FilesInArea;   /* Statistics, updated by filesort only */
} FILEAREA;


/* New FileRecord for version 1.19 */
typedef struct {
  unsigned char  Name[52];    /* File name, max 32 chars */
  unsigned long  DescPointer;  /* Pointer to desc file */
  unsigned char  DescLines;    /* Lines in description */
  unsigned long  Size;         /* Size of the file */
  SDATE          TrueDate;     /* UNUSED: File truly created */
  SDATE          UploadDate;   /* Date uploaded */
  unsigned short AreaIDByte;   /* In filearea number */
  unsigned short FileTo;       /* Receiver.. */
  unsigned short FileFrom;     /* Uploader */
  unsigned short DlTimes;      /* Downloaded n times */
  unsigned short Credits;      /* Credits required */
  unsigned short CredsGiven;   /* Credits given to uploader */

  unsigned Free        : 1;    /* File is free */
  unsigned Linked      : 1;    /* Linked to previous file. */
  unsigned Tested      : 1;    /* Archive is tested */
  unsigned BadCRC      : 1;    /* Archive is damaged */

  unsigned Scanned     : 1;    /* Scanned for viruses */
  unsigned Virus       : 1;    /* Virus in this archive */
  unsigned Deleted     : 1;    /* File is deleted */
  unsigned Spare       : 1;    /* Spare bit */
} FILEREC;

typedef struct {
  unsigned char  NameStartPos; /* Offset of file name start */
  unsigned char  Name[51];     /* File name, max 32 chars */
  unsigned long  DescPointer;  /* Pointer to desc file */
  unsigned char  DescLines;    /* Lines in description */
  unsigned long  Size;         /* Size of the file */
  SDATE          TrueDate;     /* UNUSED: File truly created */
  SDATE          UploadDate;   /* Date uploaded */
  unsigned short AreaIDByte;   /* In filearea number */
  unsigned short FileTo;       /* Receiver.. */
  unsigned short FileFrom;     /* Uploader */
  unsigned short DlTimes;      /* Downloaded n times */
  unsigned short Credits;      /* Credits required */
  unsigned short CredsGiven;   /* Credits given to uploader */

  unsigned Free        : 1;    /* File is free */
  unsigned Linked      : 1;    /* Linked to previous file. */
  unsigned Tested      : 1;    /* Archive is tested */
  unsigned BadCRC      : 1;    /* Archive is damaged */

  unsigned Scanned     : 1;    /* Scanned for viruses */
  unsigned Virus       : 1;    /* Virus in this archive */
  unsigned Deleted     : 1;    /* File is deleted */
  unsigned Spare       : 1;    /* Spare bit */
} OLD_FILEREC;



typedef struct {                    /* sizeof(DOOR) == 512 bytes */
  unsigned char  Name[30];
  unsigned char  Command[40];
  unsigned char  WhoText[24];       /* TARKISTA CONFFIN ASETUKSISTA!!! */

  unsigned char  PassWord[16];      /* Door requires a password */

  unsigned char  WorkingDir[64];
  unsigned char  ExecString[128];

  unsigned char  Reserved[198];
  
  unsigned MainMenu     : 1;    /* Command works in menus */
  unsigned ReadMenu     : 1;
  unsigned FileMenu     : 1;
  unsigned Bulletins    : 1;
  unsigned QWKMenu      : 1;
  unsigned OMENMenu     : 1;
  unsigned SysOpMenu    : 1;
  unsigned UnUsedMenu   : 1;

  unsigned long  ReservedF;     /* Reserved for future developement (AND MASK) */
  unsigned long  UserGroup;     /* Requires membership in any of these usergroups (OR MASK)*/
  unsigned NotNewUser   : 1;    /* Deny this door if newuser flag has not been removed */
  unsigned Doors        : 1;    /* Require doors access */
  unsigned Upload       : 1;    /* Require upload access */
  unsigned Download     : 1;    /* Require download access */
  unsigned Favoured     : 1;    /* Require favoured bit */
  unsigned AnySysOpBit  : 1;    /* Require any sysop bit */
  unsigned ExitToDos    : 1;    /* Require SysOp bit 'Exit To Dos' */
  unsigned AllSysOpBits : 1;    /* Require ALL sysop bits (full sysop) */

  unsigned TimeRuns     : 1;    /* Toggle: Time runs in door */
  unsigned CommandOnly  : 1;
  unsigned UnUsedDoor1  : 5;
  unsigned ExecuteAsVDM : 1;

  unsigned DoorInfoDef  : 1;    /* Toggles: Needs what BBS generated door files */
  unsigned DoorSys      : 1;
  unsigned UnUsedDoor2  : 6;
} DOOR;



typedef struct {
  unsigned char  Hour;         /* Hour of login */
  unsigned char  Min;
  unsigned short UserNumber;   /* Number of user, 1=SysOp */
  unsigned char  DenyNodeMsgs; /* Node message filter */
  unsigned char  NameAddr[46];
  unsigned char  Doing[25];    /* Muuta user recordia!! */
  unsigned short Speed;
  unsigned Status  : 4;        /* 15 */
  unsigned EC      : 1;
  unsigned Hided   : 1;
  unsigned Avail   : 1;        /* Can send nodemessages to.. */
  unsigned NoneYet : 1;
} NODE;



#define NODE_MESSAGE   0x01    /* Normal nodemessage */
#define NODE_LOGIN     0x02    /* Someone just logged in */
#define NODE_LOGOFF    0x04    /* .. and out  */
#define NODE_ENTERED   0x08    /* Someone entered a message */
#define NODE_EJECT     0x10    /* Eject node */

/*  Txt[0] = Message number len in ascii.
    Txt[1] = Area name len.
    Txt[2] = Writer name len.
    Txt[3] = To name len.
    Txt[4...] = MsgNumber|AreaName|WriterName|ToName|NULL       */

typedef struct {
  unsigned short NodeFrom;
  unsigned short MsgType;
  unsigned char  SenderName[NAMELEN];
  unsigned char  Txt[84];
} NODEMSG;


struct CmdLineRec {
  unsigned PFore   : 4;
  unsigned PBack   : 3;
  unsigned PBlink  : 1;
  unsigned Fore    : 4;
  unsigned Back    : 3;
  unsigned Blink   : 1;
};






#ifdef OLD_USER_RECORD
/* OLD User structure for up to version 1.20 */
typedef struct {
  unsigned char  Name[NAMELEN];   /* User name */
  unsigned char  Address[30];     /* User address */
  unsigned char  ZipCode[10];     /* Zip code.. */
  unsigned char  City[30];        /* User City */
  unsigned char  Phone[15];       /* User Phone */
  unsigned char  Occup[30];       /* What the user does */
  unsigned char  Alias[NAMELEN];  /* User AliasName */
  unsigned char  Pass[16];        /* Password max 12 characters */

  /* User limits and stats */
  unsigned short TimeLimit;       /* User timelimit */
  unsigned short TimeUsedToday;   /* Time used today, MUCH more useful. */
    signed short SysTimeModify;   /* Extra time given or taken for today */
    signed long  FileCredits;     /* Credits left! */
  unsigned short ResumeNumber;    /* max 64k-1 */

  unsigned short TotalCalled;     /* Total times called */
  unsigned short MessagesLeft;
  unsigned long  MessagesRead;
  unsigned long  MessagesDump;    /* Messages dumped */
  unsigned short FilesUploaded;   /* Number of files uploaded.. */
  unsigned short FilesDownloaded;
  unsigned long  BytesUploaded;
  unsigned long  BytesDownloaded;

  unsigned char  PageLength;      /* Lines per page */
  unsigned short MaxPackMsg;      /* Max messages to pack with QWK/OMEN */
  unsigned char  Language;        /* Language number */
  unsigned char  CharSet;         /* Charset number */
  unsigned char  Protocol;        /* Protocol number */
  unsigned char  Packer;          /* Packer number */

  /* Dates */
  SDATE          Birth;           /* User Birth date */
  DATE           LastCall;        /* Last called     */
  SDATE          LastCheck;       /* Checkked new files */
  SDATE          ExpireDate;      /* UNUSED: Rights expire */

  /* String pointers */
  unsigned long  DoingActive;     /* Pointer User doing when active.. */
  unsigned long  LoginCommand;    /* Commands to be executed when logged in */
  unsigned long  CommandAlias;    /* Pointers to aliases to commands */
  unsigned long  SysNote;         /* Pointer to SysOps yellow sticker */
  unsigned long  LogInNodeMsg;    /* User has login node message coming from node X*/

  /* User groups and bits */
  unsigned long  UserGroups;      /* Max 32 user groups */
  unsigned short UserBits;        /* 16 SysOp setable bits */

  /* SysOp Access */
  unsigned char  SysOp;

  /* BITS * BITS * BITS * BITS * BITS */

  /* User attributes, 8 bits */
  unsigned NoLogin      : 1;  /* User has no acces to the system */
  unsigned Killed       : 1;  /* User is killed and may be removed in next clean */
  unsigned Guest        : 1;  /* Guest user */
  unsigned NoChat       : 1;  /* SysOp doesn't want to chat with you */
  unsigned NewUser      : 1;  /* New user, some extra info ?? */
  unsigned ReRegister   : 1;  /* Address info fuckked up, must refill */
  unsigned PassWarn     : 1;  /* Warn that someone has tried to login as him */
  unsigned UnUsed1      : 1;

  /* User access and favoured, 8 bits*/
  unsigned Upload       : 1;  /* User may upload files */
  unsigned Download     : 1;  /* User may download files if he has credits */
  unsigned Doors        : 1;  /* User may open doors! */
  unsigned Favoured     : 1;  /* Favoured user */
  unsigned UnUsed2      : 4;

  /* General settings, 8+4 bits*/
  unsigned Terminal     : 3; /* None, ANSI, VT102, AVATAR... */
  unsigned AutoHelp     : 1; /* Always type menus... */
  unsigned ConfCheck    : 1; /* Login conference check */
  unsigned LoginStatus  : 1; /* Show user status at login */
  unsigned AutoReadMenu : 1; /* Automatically go to read menu */
  unsigned ShowAInfo    : 1; /* Shows area info when joining */
  unsigned NodeMsgs     : 1; /* Want to know if other node entered msg? */
  unsigned NodeLogins   : 1; /* Login: Kalevi Kieppo */
  unsigned UnUsed3      : 4;

  /* File settings, 4 bits */
  unsigned GRFileProt   : 1; /* if user have G&R */
  unsigned MoreAfterList: 1; /* Download file descs */
  unsigned UnUsed4      : 2;

  /* Colors and Bell's and whistles, 16 bits */
  unsigned ColorCmds    : 1; /* Colors in commands, who, userlist */
  unsigned ColorPrompts : 1; /* Colors in prompts */
  unsigned ColorMenus   : 1; /* Colors in menus */
  unsigned ColorMsgs    : 1; /* Colors in messages */
  unsigned ColorFiles   : 1; /* Colors in filelist */
  unsigned BeepNodeMsg  : 1; /* Beeping nodemessages */
  unsigned BeepOwnMsg   : 1; /* Beep if message is for you */
  unsigned BeepErrors   : 1; /* Beep when error */
  unsigned AnsiMusic    : 1; /* ANSI music allowed */
  unsigned UnUsed5      : 7;

  /* Message editor, 16 bits  */
  unsigned FSE          : 1; /* Use FullScreen editor */
  unsigned FSEReader    : 1; /* Use full screen msg reader */
  unsigned Insert       : 1; /* Insert or overwrite */
  unsigned XYPos        : 1; /* Show cursor position ? */
  unsigned Indent       : 1; /* Autoindent ? */
  unsigned TabMovesTxt  : 1; /* Tab moves text in MsgEditor */
  unsigned DefReplySt   : 3; /* Default reply style */
  unsigned JoinStatus   : 1; /* Join status toggle */
  unsigned UnUsed6      : 6;

  /* Message reading, 16 bits */
  unsigned ReadRef      : 1; /* Forward or Reference */
  unsigned MsgHeader    : 2; /* Full, Medium, Tiny, UnUsed */
  unsigned ClsBefore    : 1; /* Clear screen before a new message ? */
  unsigned OwnMessages  : 1; /* ReRead own messges */
  unsigned UCaseOwnName : 1; /* Flash if message is for you */
  unsigned UCaseNames   : 1; /* Upper case names in messages */
  unsigned NbOfUnread   : 1; /* Number of unread messages in conf... */
  unsigned UnUsed7      : 8;

  /* Offline settings */
  unsigned NewBulletins : 1; /* Download new bulletins with QWK */
  unsigned NewFileList  : 1; /* DownLoad new files list with QWK */
  unsigned UnUsedBits0  : 6;
  unsigned UnUsedBits1  : 8;
  unsigned UnUsedBits2  : 8;

  unsigned Palette01    : 4;         /* Max 32 definable colors */
  unsigned Palette02    : 4;
  unsigned Palette03    : 4;
  unsigned Palette04    : 4;
  unsigned Palette05    : 4;
  unsigned Palette06    : 4;
  unsigned Palette07    : 4;
  unsigned Palette08    : 4;
  unsigned Palette09    : 4;
  unsigned Palette10    : 4;
  unsigned Palette11    : 4;
  unsigned Palette12    : 4;
  unsigned Palette13    : 4;
  unsigned Palette14    : 4;
  unsigned Palette15    : 4;
  unsigned Palette16    : 4;
  unsigned Palette17    : 4;
  unsigned Palette18    : 4;
  unsigned Palette19    : 4;
  unsigned Palette20    : 4;
  unsigned Palette21    : 4;
  unsigned Palette22    : 4;
  unsigned Palette23    : 4;
  unsigned Palette24    : 4;
  unsigned Palette25    : 4;
  unsigned Palette26    : 4;
  unsigned Palette27    : 4;
  unsigned Palette28    : 4;
  unsigned Palette29    : 4;
  unsigned Palette30    : 4;
  unsigned Palette31    : 4;
  unsigned Palette32    : 4;
} OLD_USER;
#endif

#ifdef __OBSOLITE__

/* Currently unused */

struct DoorRecord {
  unsigned char  Name[20];
  unsigned char  Doing[25];  /* 4example "Playing Imperium!" */
  unsigned short MemReq;     /* Requires n kbs of memory */
  unsigned char  OpenHour;
  unsigned char  OpenMin;
  unsigned char  CloseHour;
  unsigned char  CloseMin;
};

struct VeryOldProtocolRec {       /* Version 1.05/Rev E and older */
  unsigned char  Name[20];
  unsigned char  Upload[60];
  unsigned char  Download[60];
  unsigned char  FileSeparator;
  unsigned char  GRUpload;
  unsigned char  GRDownload;
  unsigned AllowUpload      : 1;
  unsigned AllowDownload    : 1;
  unsigned BiDirectional    : 1;
  unsigned AllowBatch       : 1;
  unsigned CloseCOM         : 1;
  unsigned AskForName       : 1;
  unsigned UseListFile      : 1;
  unsigned ProtUnUsed       : 1;  /* UnUsed bits */
};


struct OldProtocolRec {           /* Up to version 1.10/Rev E and older */
  unsigned char  Name[20];
  unsigned char  Upload[60];
  unsigned char  Download[60];
  unsigned char  DSZLogName[60];
  unsigned char  FileSeparator;
  unsigned char  GRUpload;
  unsigned char  GRDownload;
  unsigned AllowUpload      : 1;
  unsigned AllowDownload    : 1;
  unsigned BiDirectional    : 1;
  unsigned AllowBatch       : 1;
  unsigned CloseCOM         : 1;
  unsigned AskForName       : 1;
  unsigned UseListFile      : 1;
  unsigned ResetSerial      : 1;
  unsigned RemovesFailedUps : 1;
  unsigned CWDToTempUp      : 1;

};



struct OldMsgHeaderRecord { /* DO NOT USE */
  unsigned short MsgFromN;
  unsigned short MsgToN;
  unsigned char  MsgFrom[NAMELEN];
  unsigned char  MsgTo[NAMELEN];
  unsigned char  Subject[40];
  struct   Date  MsgDate;
  unsigned short Lines;
  unsigned short ReplyTo;
  unsigned char  RepliesMade;
  unsigned short FirstReply;

  unsigned short MovedFrom;
  unsigned short MovedTo;   /*  Msg moved from, to conf xxx */

  unsigned short ZoneFrom;
  unsigned short NetFrom;
  unsigned short NodeFrom;

  unsigned long  Offset; /* Zero if message is deleted from base */

  unsigned Read    : 1; /* Message read ? */
  unsigned Private : 1; /* Private message? */
  unsigned ToAll   : 1; /* Msg is for all! */
  unsigned ToYou   : 1; /* Message is for YOU */
  unsigned Sent    : 1; /* Netmail and sent? */
  unsigned Killed  : 1; /* Message is killed */
  unsigned OffLine : 1;
  unsigned Protect : 1; /* Message protected from recovery/kill */
};

#endif

#endif


