#ifndef __USER_H__
#define __USER_H__

#include "stdcode.h"

#define  USR_MAX_IDENT_LEN   16
#define  USR_MAX_STRING_LEN  64

typedef struct {
    char   Ident_AC [ USR_MAX_IDENT_LEN ];
    char*  Ident_PC;
    char   String_AC[ USR_MAX_STRING_LEN ];
    char*  String_PC;
} t_Var;

typedef struct {
    int    VarCount_I;
    t_Var  Var_AS[ 50 ];
    t_Var* Var_PS;
} t_User;

t_RetCode USR_Init  ( void );
t_RetCode USR_Load  ( char* );
t_RetCode USR_Save  ( char* );
t_RetCode USR_GetVar( char*, char** );
t_RetCode USR_SetVar( char*, char* );
t_RetCode USR_NewId ( int* );

#endif


