/****************************************************************************
*
*  Local Includes
*
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include "stdcode.h"
#include "mystring.h"
#include "user.h"

/****************************************************************************
*
*  Local Variables
*
***************************************************************************/

#define  START_NUM_VARS  50
#define	 USR_UIDPATH	"nextuid"

/****************************************************************************
*
*  Local Variables
*
***************************************************************************/

t_User	 usr_User_S;
t_Bool	 usr_Inited_B = FALSE;

/****************************************************************************
*
*  Function:	USR_Init
*  Description: Init the user struct
*
***************************************************************************/

t_RetCode USR_Init( void )
{
    usr_User_S.VarCount_I = 0;
    usr_User_S.Var_PS = usr_User_S.Var_AS;
    usr_Inited_B = TRUE;
    
    return OK;
}

/****************************************************************************
*
*  Function:	USR_Load
*  Description: Load a user file
*
***************************************************************************/

t_RetCode USR_Load( char* Name_PC )
{
    FILE*       File_PS;
    t_Var*      Var_PS = NULL;
    char        Line_AC[1024];
    char*       Ptr_PC;
    char*		Ptr2_PC;
    int         Line_I = 0;
    int         Length_I;
    t_User*		User_PS = &usr_User_S;

    strcpy( Line_AC, "users\\" );
    strcat( Line_AC, Name_PC );

    File_PS = fopen( Line_AC, "r" );
    if ( NOT File_PS )
        return ERROR;

    USR_Init();

    /* init pointer */
    Var_PS = User_PS->Var_PS;

    while ( fgets( Line_AC, 1024, File_PS ) ) {

        /* allow comments */
        if ( NOT isalpha( Line_AC[0] ) )
            continue;

        /* find and copy string */
	Ptr_PC = Line_AC;
	while ( NOT isspace( *Ptr_PC ) )
	    Ptr_PC++;

        Ptr_PC[0] = 0;
	Ptr_PC++;

	Ptr2_PC = strchr( Ptr_PC, '\n' );
	if ( Ptr2_PC )
	    *Ptr2_PC = 0;
		
	USR_SetVar( Line_AC, Ptr_PC );
    }

    fclose( File_PS );

    return OK;
}

/****************************************************************************
*
*  Function:	USR_Save
*  Description: Save a user file
*
***************************************************************************/

t_RetCode USR_Save( char* Name_PC )
{
    FILE*       File_PS;
    int		VarNo_I;
    char	Line_AC[256];
    char	Filename1_AC[128];
    char	Filename2_AC[128];

    sprintf( Line_AC, "users\\%s.new", Name_PC );

    File_PS = fopen( Line_AC, "w" );
    if ( NOT File_PS ) {
	fprintf(stderr, "Can't create '%s'. %s\n", 
		Name_PC, strerror( errno ) );
        return ERROR;
    }

    for ( VarNo_I = 0; VarNo_I < usr_User_S.VarCount_I; VarNo_I++ ) {
	fprintf( File_PS, "%-*s %s\n", USR_MAX_IDENT_LEN,
		usr_User_S.Var_PS[ VarNo_I ].Ident_PC,
		usr_User_S.Var_PS[ VarNo_I ].String_PC );
    }

    fclose( File_PS );

    /* rename new file to real file */
    sprintf( Filename1_AC, "users\\%s.new", Name_PC );
    sprintf( Filename2_AC, "users\\%s",     Name_PC );
    remove( Filename2_AC );
    rename( Filename1_AC, Filename2_AC );

    return OK;
}


/****************************************************************************
*
*  Function:	USR_GetVar
*  Description: Return a user variable
*
******************************************************************************/

t_RetCode USR_GetVar( char* Name_PC, char** Var_PPC )
{
    int     VarNo_I;
    t_User* User_PS;

    *Var_PPC = NULL;
    User_PS = &usr_User_S;

    for ( VarNo_I = 0; VarNo_I < User_PS->VarCount_I; VarNo_I++ ) {
        if ( 0 == stricmp( User_PS->Var_PS[ VarNo_I ].Ident_PC, Name_PC ) ) {
            *Var_PPC = User_PS->Var_PS[ VarNo_I ].String_PC;
            break;
        }
    }

    return OK;
}

/****************************************************************************
*
*  Function:	USR_SetVar
*  Description: Add or modify a user variable
*
******************************************************************************/

t_RetCode USR_SetVar( char* Name_PC, char* Var_PC )
{
    int     VarNo_I;
    char*   Found_PC=NULL;
    t_User* User_PS = &usr_User_S;
    t_Var*  Var_PS  = User_PS->Var_PS;

    if ( !usr_Inited_B )
	RET_ERR( "User not initialized!", 0 );

    Name_PC = stripspace( Name_PC );
    Var_PC  = stripspace( Var_PC );

    /* check contents length */
    if ( strlen( Var_PC ) > USR_MAX_STRING_LEN ) {
	fprintf( stderr, "'%s' does not fit in a user variable!\n", Var_PC );
	return ERROR;
    }

    /* find variable identifier */
    for ( VarNo_I = 0; VarNo_I < User_PS->VarCount_I; VarNo_I++ ) {
        if ( 0 == stricmp( User_PS->Var_PS[ VarNo_I ].Ident_PC, Name_PC ) ) {
            Found_PC = User_PS->Var_PS[ VarNo_I ].String_PC;
            break;
        }
    }

    /* did we find the requested variable? */
    if ( Found_PC ) {
	/* yep, so check and copy it */
	strcpy( Found_PC, Var_PC );
    }
    else {
	/* no, we'll have to create a new one */

	/* is there any space left?  */
	if ( User_PS->VarCount_I >= START_NUM_VARS ) {
	    fprintf( stderr, "Out of variable space!" );
	    return ERROR;
	}	

	/* check identifier length */
	if ( strlen( Name_PC ) > USR_MAX_IDENT_LEN ) {
	    fprintf( stderr, "Identifier '%s' is too long!\n", Name_PC );
	    return ERROR;
	}
		
	/* well, let's get on with it! */
	VarNo_I = User_PS->VarCount_I++;
	Var_PS[ VarNo_I ].Ident_PC  = Var_PS[ VarNo_I ].Ident_AC;
	Var_PS[ VarNo_I ].String_PC = Var_PS[ VarNo_I ].String_AC;
	strcpy( Var_PS[ VarNo_I ].Ident_PC, Name_PC );
	strcpy( Var_PS[ VarNo_I ].String_PC, Var_PC );
    }

    return OK;
}

/****************************************************************************
*
*  Function:	USR_NewId
*  Description: Find a new unused ID
*
******************************************************************************/

t_RetCode USR_NewId( int* UserId_PI )
{
    FILE*	InFile_PS;
    FILE*	OutFile_PS;
	char	Line_AC[80];

	InFile_PS = fopen( USR_UIDPATH, "r" );
	if ( NOT InFile_PS )
		RET_ERR( "Can't open '" USR_UIDPATH "'.", errno );

	OutFile_PS = fopen( USR_UIDPATH ".new", "w" );
	if ( NOT OutFile_PS )
		RET_ERR( "Can't create '" USR_UIDPATH ".new'.", errno );

	/* get first id line */
	fgets( Line_AC, 80, InFile_PS );
	if ( NOT strchr( Line_AC, '\n' ) )
		RET_ERR( "Too long line in '" USR_UIDPATH "'.", 81 );

	*UserId_PI = atoi( Line_AC );

	/* copy rest of file to new file */
	fgets( Line_AC, 80, InFile_PS );

	/* if there are >1 lines in file */
	if ( NOT feof( InFile_PS ) ) {
		do {
			fputs( Line_AC, OutFile_PS );
			fgets( Line_AC, 80, InFile_PS );
		} while ( NOT feof( InFile_PS ) );
	}
	else {
		/* create new "highest" uid */
		sprintf( Line_AC, "%d", *UserId_PI + 1 );
		fputs( Line_AC, OutFile_PS );
	}

	fclose( InFile_PS );
	fclose( OutFile_PS );

	/* back up and replace */
	remove( USR_UIDPATH ".bak" );
	rename( USR_UIDPATH, USR_UIDPATH ".bak" );
	rename( USR_UIDPATH ".new", USR_UIDPATH );

	return OK;
}

	

