#ifndef STDCODE_H
#define STDCODE_H

#define VERSION "1.2"

#ifdef NULL
#undef NULL
#endif
#ifdef FALSE
#undef FALSE
#endif
#ifdef TRUE
#undef TRUE
#endif

#define AND     &&
#define OR      &&
#define NOT     !
#define PRIVATE static

#define CALL( function )		do {if ( OK != function ) return ERROR;} while(0)
#define RET_ERR( string, code )		do {fprintf( stderr, ">> Error: %s (%d) (%s:%d)\n", string, code, __FILE__, __LINE__ ); return ERROR;} while (0)

#define DBG( string, code )	do { if(System_S.Debug_B)fprintf(stderr,"Debug: %s (%d)\n",string,code);}while(0)

typedef enum { FALSE =  0, TRUE = 1 } t_Bool;
typedef enum { ERROR = -1, OK   = 0 } t_RetCode;
typedef unsigned char   uchar;

typedef unsigned long   ulong;
typedef unsigned short  ushort;

typedef unsigned int    uint;
typedef char		t_PartId[16];


#define NULL    ((void*)0)
#define FALSE   (0)
#define TRUE    (1)
#define ERROR   (-1)
#define OK      (0)

#define PING    fprintf( stderr, "\n" );

#endif /* STDCODE_H */

