#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSDEVICES
#include <os2.h>

/***************************************************************************
*
*  PRIVATE #includes
*
***************************************************************************/
#include <stdlib.h>
#include "stdcode.h"
#include "stdio.h"
#include "system.h"
#include "serial.h"

/***************************************************************************
*
*  PRIVATE variables
*
***************************************************************************/

PRIVATE	HFILE ser_Handle_I;

t_RetCode ser_IoCtl( int Func_I, void* Buffer_P, ULONG BufLen_I );

#if 0
/****************************************************************************
*
*  Function:    SER_Init
*  Description: Initialize serial port
*
***************************************************************************/
t_RetCode SER_Init( char* Device_PC )
{
    int Status_I;

    Status_I = ComOpen( Device_PC, &ser_Handle_I, 0, 0 );
    if ( Status_I )
	RET_ERR( "Error opening device!", Status_I );

    return OK;
}
#endif

/****************************************************************************
*
*  Function:    SER_Init
*  Description: Initialize an already open serial port
*
***************************************************************************/
t_RetCode SER_Init( int Handle_I )
{
#if 0
    int Status_I;

    Status_I = ComHRegister( Handle_I, &ser_Handle_I, 0, 0 );
    if ( Status_I )
	RET_ERR( "Error reopening device!", Status_I );
#else
    ser_Handle_I = Handle_I;
    CALL( SER_Online( &System_S.Online_B ) );
    if (!System_S.Online_B) {
	printf( "?No carrier on COM handle %d.\n", Handle_I );
	return ERROR;
    }
    
#endif
    return OK;
}


/****************************************************************************
*
*  Function:    SER_Exit
*  Description: Close serial port
*
***************************************************************************/
t_RetCode SER_Exit( void )
{
#if 0
    ComTxWait( ser_Handle_I, -1 );
    ComClose( ser_Handle_I );
#else
    CALL( SER_Flush() );
#endif
    return OK;
}

/****************************************************************************
*
*  Function:    SER_Flush
*  Description: Wait for output to drain
*
***************************************************************************/
t_RetCode SER_Flush( void )
{ 
    char	TmpStr_AC[128];
    APIRET  rc;             /* Return code */
    unsigned char Cmnd_I = 0;
    unsigned long CmndLen_I = 0;
 
    rc = DosDevIOCtl(ser_Handle_I,	/* handle */
		     11,		/* general device */
		     2,			/* function 2 -- flush */
		     &Cmnd_I,		/* parameter list */
		     1,			/* parlist length */
		     &CmndLen_I,	/* max parlist len */
		     &Cmnd_I,		/* data area */
		     1,			/* dataarea length */
		     &CmndLen_I		/* returned data size */
		     );

    if ( rc ) {
	sprintf(TmpStr_AC,"DosDevIOCtl( 11, 2 ) returned an error.\n");
	RET_ERR(TmpStr_AC,rc);
    }

    return OK;
}

/****************************************************************************
*
*  Function:    SER_Write
*  Description: Write buffer to serial port
*
***************************************************************************/
t_RetCode SER_Write( void* Buf_P, int Size_I )
{
    int		Status_I;
    ULONG	Written_I;

    Status_I = DosWrite( ser_Handle_I, Buf_P, Size_I, &Written_I );
    if ( Status_I )
	RET_ERR( "Error writing to com port!", Status_I );

    return OK;
}

/****************************************************************************
*
*  Function:    SER_Read
*  Description: Read buffer from serial port
*
***************************************************************************/
t_RetCode SER_Read( void* Buf_P, int Size_I, int* Count_PI )
{
    APIRET	rc;
    ULONG	Count_I;

    rc = DosRead( ser_Handle_I, Buf_P, Size_I, &Count_I );
    switch ( rc ) {
      case ERROR_MORE_DATA:
	*Count_PI = 0;
	break;

      case NO_ERROR:
	*Count_PI = Count_I;
	break;
	
      default:
	*Count_PI = 0;
	RET_ERR( "Error reading from com port!", rc );
    }

    return OK;
}

/****************************************************************************
*
*  Function:    SER_ReadC
*  Description: Read one byte from serial port
*
***************************************************************************/
t_RetCode SER_ReadC( int* Char_PI )
{
    unsigned char Char_I;
    ULONG	Count_I;
    APIRET	rc;

    rc = DosRead( ser_Handle_I, &Char_I, 1, &Count_I );
    switch( rc ) {
      case ERROR_MORE_DATA:
	*Char_PI = -1;
	break;

      case NO_ERROR:
	if ( Count_I ) 
	    *Char_PI = Char_I;
	else
	    *Char_PI = -1;
	break;

      default:
	*Char_PI = -1;
	RET_ERR( "Error reading from com port!", rc );
	break;
    }

    return OK;
}
    
/****************************************************************************
*
*  Function:    SER_QSize
*  Description: Returns the number of bytes in the input queue 
*
******************************************************************************/
int SER_QSize( void )
{
    struct buf {
	unsigned short	Bytes_I;
	unsigned short	QSize_I;
    } Data_S;

    CALL( ser_IoCtl( 0x68, &Data_S, sizeof( Data_S ) ) );

    return Data_S.Bytes_I;
}

/****************************************************************************
*
*  Function:    SER_Online
*  Description: Finds out whether the serial port is online or not
*
******************************************************************************/
t_RetCode SER_Online( t_Bool* Online_PB )
{
    unsigned char	Data_I;

    CALL( ser_IoCtl( 0x67, &Data_I, 1 ) );
    if ( Data_I & 128 )
	*Online_PB = TRUE;
    else
	*Online_PB = FALSE;

    return OK;
}
    
/****************************************************************************
*
*  Function:    ser_IoCtl
*  Description: Perform IOCTL command
*
******************************************************************************/
t_RetCode ser_IoCtl( int Func_I, void* Buffer_P, ULONG BufLen_I )
{
    /* DosDevIOCtl performs control
       functions on a device specified
       by an opened device handle. */

    char    TmpStr_AC[128];
    ULONG   ParmInOut_I;
    APIRET  rc;             /* Return code */
 
    rc = DosDevIOCtl(ser_Handle_I,	/* handle */
		     1,			/* serial device */
		     Func_I,		/* function */
		     NULL,		/* parameter list */
		     0,			/* parlist length */
		     &ParmInOut_I,	/* max parlist len */
		     Buffer_P,		/* data area */
		     BufLen_I,		/* dataarea length */
		     &BufLen_I		/* returned data size */
		     );

    switch ( rc ) {
      case NO_ERROR:
	break;

      case ERROR_INVALID_HANDLE:
	printf("Error: Invalid com handle %d.\n",ser_Handle_I);
	exit(1);
	break;

      default:
	sprintf(TmpStr_AC,"DosDevIOCtl( dev:1, func:%d ) returned an error!",
		Func_I);
	RET_ERR(TmpStr_AC,rc);
    }

    return OK;
}
    
