/***************************************************************************
*
*  PRIVATE #includes
*
***************************************************************************/
#include "stdcode.h"
#include "stdio.h"
#include "maxcomm.h"
#include "system.h"

/***************************************************************************
*
*  PRIVATE variables
*
***************************************************************************/

PRIVATE	HCOMM ser_Handle_PS;

/****************************************************************************
*
*  Function:    SER_Init
*  Description: Initialize serial port
*
***************************************************************************/
t_RetCode SER_Init( char* Device_PC )
{
    int Status_I;

    Status_I = ComOpen( Device_PC, &ser_Handle_PS, 0, 0 );
    if ( Status_I )
	RET_ERR( "Error opening device!", Status_I );

    return OK;
}


/****************************************************************************
*
*  Function:    SER_ReInit
*  Description: ReInitialize an already open serial port
*
***************************************************************************/
t_RetCode SER_ReInit( int Handle_I )
{
    int Status_I;

    Status_I = ComHRegister( Handle_I, &ser_Handle_PS, 0, 0 );
    if ( Status_I )
		RET_ERR( "Error reopening device!", Status_I );

    return OK;
}


/****************************************************************************
*
*  Function:    SER_Exit
*  Description: Close serial port
*
***************************************************************************/
t_RetCode SER_Exit( void )
{
    ComTxWait( ser_Handle_PS, -1 );
    ComClose( ser_Handle_PS );

    return OK;
}

/****************************************************************************
*
*  Function:    SER_Flush
*  Description: Wait for output to drain
*
***************************************************************************/
t_RetCode SER_Flush( void )
{
    ComTxWait( ser_Handle_PS, 0 );

    return OK;
}

/****************************************************************************
*
*  Function:    SER_Write
*  Description: Write buffer to serial port
*
***************************************************************************/
t_RetCode SER_Write( void* Buf_P, int Size_I )
{
    int		Status_I;

    Status_I = ComWrite( ser_Handle_PS, Buf_P, Size_I );
    if ( Status_I )
	RET_ERR( "Error writing to comm port!", Status_I );

    return OK;
}

/****************************************************************************
*
*  Function:    SER_Read
*  Description: Read buffer from serial port
*
***************************************************************************/
t_RetCode SER_Read( void* Buf_P, int Size_I, int* Count_PI )
{
    USHORT Status_I;
	USHORT Count_I;

    Status_I = ComRead( ser_Handle_PS, Buf_P, Size_I, &Count_I );
    if ( Status_I )
		RET_ERR( "Error writing to comm port!", Status_I );

	*Count_PI = Count_I;

    return OK;
}

/****************************************************************************
*
*  Function:    SER_ReadC
*  Description: Read one byte from serial port
*
***************************************************************************/
t_RetCode SER_ReadC( int* Char_PI )
{
    USHORT Char_I;

    System_S.Online_B = ComIsOnline( ser_Handle_PS );

    if ( ComInCount( ser_Handle_PS ) ) {
	Char_I = ComGetc( ser_Handle_PS );
	*Char_PI = Char_I;
    }
    else
	*Char_PI = -1;

    return OK;
}
    
/****************************************************************************
*
*  Function:    SER_QSize
*  Description: Returns the number of bytes in the input queue 
*
******************************************************************************/
int SER_QSize( void )
{
    int i = ComInCount( ser_Handle_PS );
    if (i<0)
	return 0;
    else
	return i;
}
    
