/****************************************************************************
*
*  Local Includes
*
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>

#include "stdcode.h"
#include "mystring.h"
#include "fplerr.h"
#include "os.h"

/****************************************************************************
*
*  Local Defines
*
***************************************************************************/

static unsigned char STR_ToUpper_AI[256] = {

0,1,2,3,4,5,6,7,8,9,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
' ','!','"','#','$','%','&','\'','(',')','*','+',',','-','.','/',
'0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?',
'@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']','^','_',
'`','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z','{','|','}','~',0x7f,
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','I','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','',0xff
};

static unsigned char STR_ToLower_AI[256] = {

0,1,2,3,4,5,6,7,8,9,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
' ','!','"','#','$','%','&','\'','(',')','*','+',',','-','.','/',
'0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?',
'@','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z','[','\\',']','^','_',
'`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~',0x7f,
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','','',
'','','','','','','','','','','','','','','',0xff
};


extern int FplErr_I;

/****************************************************************************
*
*  Functions
*
***************************************************************************/
int STR_ToUpper( int c )
{
    if(c<0||c>255)
	return 0;
    return STR_ToUpper_AI[c];
}

int STR_ToLower( int c )
{
    if(c<0||c>255)
	return 0;
    return STR_ToLower_AI[c];
}


char* stristr ( const register char*  haystack,
                const register char*  needle )
{
  register const char *const needle_end = strchr(needle, '\0');
  register const char *const haystack_end = strchr(haystack, '\0');
  register const size_t needle_len = needle_end - needle;
  register const size_t needle_last = needle_len - 1;
  register const char *begin;

  if (needle_len == 0)
    return (char *) haystack_end;
  if ((size_t) (haystack_end - haystack) < needle_len)
    return NULL;

  for (begin = &haystack[needle_last]; begin < haystack_end; ++begin)
    {
      register const char *n = &needle[needle_last];
      register const char *h = begin;

      do
        if (STR_ToUpper(*h) != STR_ToUpper(*n))
          goto loop;            /* continue for loop */
      while (--n >= needle && --h >= haystack);

      return (char *) h;

    loop:;
    }

  return NULL;
}

#if 0
/* not ANSI conformant. simply returns 0 or -1. */

int stricmp( const register char* haystack,
             const register char* needle )
{
    register int Pos_I;
    register int Len_I = strlen( haystack );

    for ( Pos_I = 0; Pos_I < Len_I; Pos_I++ )
        if ( STR_ToUpper( haystack[ Pos_I ] ) - STR_ToUpper( needle[ Pos_I ] ) )
            return -1;

    return 0;
}
#endif

char* stripspace( register char* String_PC )
{
    while ( isspace( *String_PC ) AND *String_PC )
        String_PC++;

    return String_PC;
}

t_Bool samecase( char* String_PC )
{
    int    Len_I = strlen( String_PC );
    int    Pos_I;
    t_Bool Upcase_B = TRUE;
    register char   Char_C = String_PC[0];

    if ( !Len_I )
        return TRUE;

    Upcase_B = ( STR_ToUpper( Char_C ) == Char_C );

    for ( Pos_I = 1; Pos_I < Len_I; Pos_I++ ) {
        Char_C = String_PC[ Pos_I ];
        if ( isalpha( Char_C ) )
            if ( ( STR_ToUpper( Char_C ) == Char_C ) != Upcase_B )
                return FALSE;
    }

    return TRUE;
}


t_RetCode STR_HowMany( char* String_PC, char Char_C, int Length_I, int* Count_PI )
{
    int i;
    char* Pos_PC = String_PC;

    *Count_PI = 0;


#if 1
    for ( i=0;i<Length_I;i++ )
	if ( Char_C == String_PC[i] )
	    (*Count_PI)++;
#else
    while ( ( Pos_PC = memchr( Pos_PC, Char_C, Length_I ) ) AND
            ( 0 < Length_I ) ) {
        (*Count_PI)++;
        Length_I -= (int)(Pos_PC - String_PC);
        Pos_PC   += 1;
    }
#endif

    return OK;
}

t_RetCode STR_FixCase( char* String_PC )
{
    int i;
    int Len_I = strlen( String_PC );

    if ( !samecase( String_PC ) )
        return OK;

    String_PC[0] = STR_ToUpper( String_PC[0] );

    for ( i = 1; i < Len_I; i++ )
        if ( ispunct( String_PC[ i - 1] ) )
            String_PC[i] = STR_ToUpper( String_PC[i] );
        else
            String_PC[i] = STR_ToLower( String_PC[i] );

    String_PC[i] = 0;

    return OK;
}


/* read unlimited line length */

t_RetCode STR_ReadLine(FILE*	File_PS,
		       char**	Buffer_PPC,
		       int* 	Size_PI,
		       t_Bool*	More_PB )
{
    char*	Line_PC = *Buffer_PPC;
    int Offset_I = 0;
    
    while ( fgets( Line_PC + Offset_I, *Size_PI - Offset_I, File_PS ) ) {
	if (feof(File_PS) || (!strlen(Line_PC)))
	    break;
	
	/* did we get the whole line? */
	if (strchr( Line_PC + Offset_I, '\n' ))
	    break;

	/* there's more on the line to be read */
	Offset_I = *Size_PI - 1;

	/* quadraply buffer size */
	*Size_PI *= 4;

	Line_PC = (char*) realloc( Line_PC, *Size_PI );
	if ( !Line_PC )
	    RET_ERR( "Out of memory!", *Size_PI );
    }

    if (feof(File_PS))
	*More_PB = FALSE;
    else
	*More_PB = TRUE;

    *Buffer_PPC = Line_PC;
    
    return OK;
}

	    
/***************************************************************************
*
*  Function:	STR_WhatString
*  Description: find string in string list
*
***************************************************************************/
int STR_WhatString( char* Needle_PC, t_PartId* HayStack_PAC )
{
    int Pos_I = 0;

#if 0
    fprintf(stderr, "Needle: '%s'\n", Needle_PC );
    for ( Pos_I = 0; Pos_I < 3; Pos_I++ )
	fprintf(stderr, "List item %d: '%s'\n", 
		Pos_I, HayStack_PAC[ Pos_I ] );

    Pos_I = 0;
#endif

    while ( HayStack_PAC[ Pos_I ][0] )
	if ( 0 == stricmp( HayStack_PAC[ Pos_I ], Needle_PC ) )
	    return Pos_I;
	else	
	    Pos_I++;

    return -1;
}

/***************************************************************************
*
*  Function:	STR_Index
*  Description: Find character in limited string, -1 if not found
*
***************************************************************************/
int STR_Index( char* String_PC, int Char_I, int Length_I )
{
    int i;
    for ( i=0; i<Length_I; i++ )
	if ( Char_I == String_PC[i] )
	    return i;
    return -1;
}


/***************************************************************************
*
*  Function:	STR_Match
*  Description: Parsecmnd() match routine
*
***************************************************************************/
int STR_Match( char* Cmd_PC, char* String_PC )
{
    int x=0;

    while ( 1 ) { 
	switch ( *String_PC ) {
	    
	  case 0:
	    return x;

	  case ' ':
	    Cmd_PC = strchr( Cmd_PC, ' ' );
	    if ( !Cmd_PC )
		return 1;
	    while ( isspace( *(String_PC+1) ) )
		String_PC++;

	  default:
	    if ( toupper(*Cmd_PC) == toupper(*String_PC) )
		x = 1;
	    else
		return 0;
	}
	String_PC++;
	Cmd_PC++;
    }
    return 0;
}

/***************************************************************************
*
*  Function:	STR_TokStr
*  Description: Tokenize string
*
***************************************************************************/
t_RetCode STR_TokStr( char* Source_PC, int Part_I,
		      char* Separators_PC, char** Result_PPC )
{
    int i;
    char* Str_PC;
    char* Tok_PC;
    char* Result_PC;

    *Result_PPC = NULL;

    /* copy string */
    i = strlen( Source_PC ) + 1;
    if (1==i)
	return OK;

    Str_PC = (char*) malloc(i);
    if(!Str_PC)
	RET_ERR( "Out of memory!", i );
    strcpy( Str_PC, Source_PC );

    Tok_PC = strtok( Str_PC, Separators_PC );
    for ( i=1; i < Part_I; i++ )
	Tok_PC = strtok( NULL, Separators_PC );

    if (Tok_PC) {
	i = strlen( Tok_PC ) + 1;
	if (1==i)
	    return OK;
	
	Result_PC = (char*) malloc(i);
	if(!Result_PC)
	    RET_ERR( "Out of memory!", i );
	strcpy( Result_PC, Tok_PC );

	*Result_PPC = Result_PC;
    }

    free( Str_PC );

    return OK;
}


/***************************************************************************
*
*  Function:	STR_LoadArray
*  Description: Load a file into an array of strings
*
***************************************************************************/
t_RetCode STR_LoadArray( char* Filename_PC, 
			 char*** Buffer_PPPC, 
			 int* Lines_PI )
{
    FILE*	File_PS;
    int		Size_I = 256;
    char**	Lines_PPC = NULL;
    int		Line_I = 0;
    int		Lines_I = 256;
    char*	Line_PC = NULL;
    t_Bool	More_B;

    *Buffer_PPPC = NULL;

    File_PS = fopen( Filename_PC, "r" );
    if ( !File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	return OK;
    }

    Lines_PPC = (char**) malloc( sizeof( char* ) * Lines_I );
    if (!Lines_PPC)
	RET_ERR("Out of memory",Lines_I*sizeof(char*));

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {
	int i = strlen( Line_PC ) + 1;
	char* TmpStr_PC = (char*) malloc( i );
	if (!TmpStr_PC)
	    RET_ERR( "Out of memory!", i );
	strcpy( TmpStr_PC, Line_PC );
	Lines_PPC[ Line_I ] = TmpStr_PC;
	Line_I++;

	if (Line_I>=Lines_I){
	    Lines_I*=4;
	    Lines_PPC = (char**) realloc( Lines_PPC, sizeof(char*)*Lines_I);
	    if(!Lines_PPC)
		RET_ERR("Out of memory!",sizeof(char*)*Lines_I);
	}
    }
    fclose( File_PS );
    free( Line_PC );

    *Buffer_PPPC = Lines_PPC;
    *Lines_PI = Line_I;

    return OK;
}

/***************************************************************************
*
*  Function:	STR_SaveString
*  Description: Save a string to a file
*
***************************************************************************/
t_RetCode STR_SaveString( char* String_PC, char* Filename_PC, int Mode_I )
{
    FILE* File_PS;
    char* Tmp_PC;
    char* Seen_PC;
    int i;

    if ( !strlen( String_PC ) ) {
	remove( Filename_PC );
	return OK;
    }

    File_PS = fopen( Filename_PC, "w" );
    if ( !File_PS ) {
	char tmp[80];
	sprintf(tmp,"Can't create %s!",Filename_PC);
	RET_ERR(tmp,errno );
    }

    if ( !Mode_I )
	fwrite( String_PC, strlen( String_PC ), 1, File_PS );
    else {
	/* phew! Message model write... */

	/* First, strip off all LF chars */
	for ( i = 0; String_PC[i]; i++ )
	    if ( 0x0a == String_PC[i] )
		String_PC[i] = 0x20;

	/* try to find and elmiminate 'SEEN-BY: ' */
	Seen_PC = strstr( String_PC, "SEEN-BY: " );
	if ( Seen_PC ) {
	    Tmp_PC = strstr( String_PC, " * Origin: " );
	    if ( Tmp_PC && ( Tmp_PC < Seen_PC ) )
		*Seen_PC = 0;
	}

	/* then, save each CR terminated line as a paragraph */
	for ( Tmp_PC = strchr( String_PC, '\r' );
	      Tmp_PC;
	      Tmp_PC = strchr( String_PC, '\r' ) ) {
	    *Tmp_PC = 0;
	    fprintf( File_PS, "%s\n", String_PC );
	    String_PC = Tmp_PC + 1;
	}
	fprintf( File_PS, "%s\n", String_PC );
    }

    fclose( File_PS );

    return OK;
}
    
/***************************************************************************
*
*  Function:	STR_LoadString
*  Description: Load a file into a string
*
***************************************************************************/
t_RetCode STR_LoadString( char* Filename_PC, char** Buffer_PPC )
{
    FILE*	File_PS;
    char*	Buf_PC;
    int		Size_I;
    t_FileInfo	Info_S;

    *Buffer_PPC = NULL;

    File_PS = fopen( Filename_PC, "r" );
    if ( !File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	return OK;
    }

    CALL( OS_FileInfo( Filename_PC, &Info_S ) );
    Size_I = Info_S.Size_I;

    Buf_PC = (char*) malloc( Size_I + 5 );
    if (!Buf_PC)
	RET_ERR( "Out of memory!", Size_I );

    memset( Buf_PC, 0, Size_I + 5 );

    fread( Buf_PC, Size_I, 1, File_PS );
    fclose( File_PS );

    *Buffer_PPC = Buf_PC;

    return OK;
}

